/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.mouse;

import com.sbs.jpm.Common;
import com.sbs.jpm.ui.component.JDateDialog;
import com.sbs.jpm.ui.treetablechart.JChartArea;
import com.sbs.jpm.ui.treetablechart.time.TimeScaleManager;
import com.sbs.jpm.ui.treetablechart.time.event.TimeScaleEvent;
import com.sbs.jpm.ui.treetablechart.time.event.TimeScaleListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

class GeneralTimeScalePopupMenu
extends JPopupMenu
implements TimeScaleListener {
    protected final JMenuItem zoomInItem;
    protected final JMenuItem zoomOutItem;
    private JDateDialog dateSelectionDialog;
    protected JChartArea area;

    public GeneralTimeScalePopupMenu(JChartArea jChartArea) {
        this.area = jChartArea;
        this.zoomInItem = new JMenuItem(Common.I18N_ACTIONS.getString("zoomIn"), new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/ZoomIn16.gif")));
        this.zoomInItem.setToolTipText(Common.I18N_ACTIONS.getString("zoomIn.tooltip"));
        this.zoomInItem.setEnabled(jChartArea.getTimeScaleManager().canZoomIn());
        this.zoomInItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GeneralTimeScalePopupMenu.this.area.getTimeScaleManager().zoomIn();
            }
        });
        this.add(this.zoomInItem);
        this.zoomOutItem = new JMenuItem(Common.I18N_ACTIONS.getString("zoomOut"), new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/ZoomOut16.gif")));
        this.zoomOutItem.setToolTipText(Common.I18N_ACTIONS.getString("zoomOut.tooltip"));
        this.zoomOutItem.setEnabled(jChartArea.getTimeScaleManager().canZoomOut());
        this.zoomOutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GeneralTimeScalePopupMenu.this.area.getTimeScaleManager().zoomOut();
            }
        });
        this.add(this.zoomOutItem);
        JMenu jMenu = new JMenu(Common.I18N_ACTIONS.getString("goTo"));
        JMenuItem jMenuItem = new JMenuItem(Common.I18N_ACTIONS.getString("goTo.projectStart"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GeneralTimeScalePopupMenu.this.area.getTimeScaleManager().focusOnDate(GeneralTimeScalePopupMenu.this.area.getProject().getStartDate());
            }
        });
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(Common.I18N_ACTIONS.getString("goTo.projectFinish"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GeneralTimeScalePopupMenu.this.area.getTimeScaleManager().focusOnDate(GeneralTimeScalePopupMenu.this.area.getProject().getEndDate());
            }
        });
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(Common.I18N_ACTIONS.getString("goTo.date") + "...");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GeneralTimeScalePopupMenu.this.dateSelectionDialog == null) {
                    GeneralTimeScalePopupMenu.this.dateSelectionDialog = new JDateDialog(Common.getApplication());
                }
                GeneralTimeScalePopupMenu.this.dateSelectionDialog.getMonthView().setSelectedDate(GeneralTimeScalePopupMenu.this.area.getTimeScaleManager().getFocusDate());
                GeneralTimeScalePopupMenu.this.dateSelectionDialog.setLocationRelativeTo(GeneralTimeScalePopupMenu.this.dateSelectionDialog.getOwner());
                GeneralTimeScalePopupMenu.this.dateSelectionDialog.setVisible(true);
                GeneralTimeScalePopupMenu.this.area.getTimeScaleManager().focusOnDate(GeneralTimeScalePopupMenu.this.dateSelectionDialog.getSelectedDate());
            }
        });
        jMenu.add(jMenuItem3);
        this.add(jMenu);
    }

    public void timeScaleChanged(TimeScaleEvent timeScaleEvent) {
        TimeScaleManager timeScaleManager = (TimeScaleManager)timeScaleEvent.getSource();
        this.zoomInItem.setEnabled(timeScaleManager.canZoomIn());
        this.zoomOutItem.setEnabled(timeScaleManager.canZoomOut());
    }

    public void focusOnDateChanged(TimeScaleEvent timeScaleEvent) {
    }

    public void shiftChanged(TimeScaleEvent timeScaleEvent) {
    }

    public void zoomInChanged(TimeScaleEvent timeScaleEvent) {
    }

    public void zoomOutChanged(TimeScaleEvent timeScaleEvent) {
    }

    public void zoomOutWillChange(TimeScaleEvent timeScaleEvent) {
    }

    public void focusDateChanged(TimeScaleEvent timeScaleEvent) {
    }
}

