/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.mouse;

import com.sbs.jpm.Common;
import com.sbs.jpm.ui.treetablechart.JChartArea;
import com.sbs.jpm.ui.treetablechart.mouse.GeneralTimeScalePopupMenu;
import com.sbs.jpm.ui.treetablechart.mouse.MouseInteraction;
import com.sbs.jpm.ui.treetablechart.mouse.MouseInteractionListener;
import com.sbs.jpm.ui.treetablechart.mouse.MouseSensitiveComponent;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;

public abstract class ChartArea
extends MouseSensitiveComponent {
    protected final JChartArea area;
    protected final Cursor RESIZE_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(this.getClass().getClassLoader().getResource("com/sbs/jpm/ui/images/resize.png")).getImage(), new Point(14, 16), "Resize");
    protected final Cursor PERCENT_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(this.getClass().getClassLoader().getResource("com/sbs/jpm/ui/images/complete.png")).getImage(), new Point(2, 5), "Percent complete");
    protected final Cursor LINK_POINT_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(this.getClass().getClassLoader().getResource("com/sbs/jpm/ui/images/linkPointCursor.png")).getImage(), new Point(0, 0), "Dependency");
    protected final Cursor NEW_LINK_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(this.getClass().getClassLoader().getResource("com/sbs/jpm/ui/images/newLinkCursor.png")).getImage(), new Point(16, 16), "Create Dependency");
    protected final Cursor HAND_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(this.getClass().getClassLoader().getResource("com/sbs/jpm/ui/images/openhand.png")).getImage(), new Point(14, 16), "Hand");
    protected final Cursor MOVE_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(this.getClass().getClassLoader().getResource("com/sbs/jpm/ui/images/cross.png")).getImage(), new Point(14, 16), "Move");
    protected final Cursor PARENT_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(this.getClass().getClassLoader().getResource("com/sbs/jpm/ui/images/pointinghand.png")).getImage(), new Point(14, 16), "Move");
    protected final Cursor ARROW_CURSOR = new Cursor(0);
    protected final Cursor DEFAULT_CURSOR = new Cursor(12);
    protected EventListenerList listeners;
    protected GeneralChartPopupMenu generalPopupMenu;

    public ChartArea(JChartArea jChartArea, MouseInteractionListener mouseInteractionListener) {
        super(mouseInteractionListener);
        this.area = jChartArea;
        this.listeners = new EventListenerList();
    }

    public void switchCalendaristicView() {
        this.area.getCalendaristicAction().switchCalendaristicView();
    }

    protected void createPopups() {
        this.generalPopupMenu = new GeneralChartPopupMenu();
        this.area.getTimeScaleManager().addTimeScaleListener(this.generalPopupMenu);
    }

    public abstract void mouseMoved(MouseEvent var1);

    public abstract void mousePressed(MouseEvent var1);

    public abstract void mouseReleased(MouseEvent var1);

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    protected void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(UndoableEditListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((UndoableEditListener)eventListenerArray[i]).undoableEditHappened(undoableEditEvent);
        }
    }

    class MouseScrollInteraction
    extends MouseInteraction {
        int currentX;
        int currentY;

        public MouseScrollInteraction(int n, int n2) {
            this.currentX = n;
            this.currentY = n2;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = this.currentX - mouseEvent.getX();
            ChartArea.this.area.getTimeScaleManager().shift(n);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                ChartArea.this.endMouseInteraction(ChartArea.this.mouseInteraction);
                ChartArea.this.mouseInteraction = null;
            }
        }
    }

    class GeneralChartPopupMenu
    extends GeneralTimeScalePopupMenu {
        public GeneralChartPopupMenu() {
            super(ChartArea.this.area);
            JMenuItem jMenuItem = new JMenuItem(this.area.getCalendaristicAction());
            jMenuItem.setText(Common.I18N_RP.getString("roundNormalView"));
            this.add(jMenuItem);
        }
    }
}

