/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.model;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.core.ActualWorkingData;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.core.constraint.SNET;
import com.sbs.jpm.core.event.TaskAdapter;
import com.sbs.jpm.core.event.TaskEvent;
import com.sbs.jpm.core.event.TaskListener;
import com.sbs.jpm.core.field.FieldManager;
import com.sbs.jpm.ui.UIManager;
import com.sbs.jpm.ui.treetablechart.JTreeTable;
import com.sbs.jpm.ui.treetablechart.model.ChartTreeTableModel;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import com.sbs.jpm.undo.TaskAccrualEdit;
import com.sbs.jpm.undo.TaskAdditionalFieldEdit;
import com.sbs.jpm.undo.TaskCalendarEdit;
import com.sbs.jpm.undo.TaskCompletionEdit;
import com.sbs.jpm.undo.TaskConstraintEdit;
import com.sbs.jpm.undo.TaskDeadlineEdit;
import com.sbs.jpm.undo.TaskDurationEdit;
import com.sbs.jpm.undo.TaskFixedCostEdit;
import com.sbs.jpm.undo.TaskNameEdit;
import com.sbs.jpm.undo.TaskNonEmptyEdit;
import com.sbs.jpm.undo.TaskWorkCompletionEdit;
import com.sbs.jpm.undo.TaskWorkEdit;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.swing.event.UndoableEditEvent;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;

public class TaskTreeTableModel
extends ChartTreeTableModel {
    public static final String INFO = Common.I18N_RP.getString("column.info");
    public static final String TASK_NAME = Common.I18N_RP.getString("column.taskName");
    public static final String DURATION = Common.I18N_RP.getString("column.duration");
    public static final String ACTUAL_DURATION = Common.I18N_RP.getString("column.actualDuration");
    public static final String REMAINING_DURATION = Common.I18N_RP.getString("column.remainingDuration");
    public static final String START = Common.I18N_RP.getString("column.start");
    public static final String END = Common.I18N_RP.getString("column.end");
    public static final String CALENDAR = Common.I18N_RP.getString("column.calendar");
    public static final String PERCENT_COMPLETE = Common.I18N_RP.getString("column.percentComplete");
    public static final String PERCENT_WORK_COMPLETE = Common.I18N_RP.getString("column.percentWorkComplete");
    public static final String ACTUAL_START = Common.I18N_RP.getString("column.actualStart");
    public static final String ACTUAL_END = Common.I18N_RP.getString("column.actualEnd");
    public static final String DEADLINE = Common.I18N_RP.getString("column.deadline");
    public static final String FIXED_COST = Common.I18N_RP.getString("column.fixedCost");
    public static final String ACCRUAL = Common.I18N_RP.getString("column.accrual");
    public static final String WORK = Common.I18N_RP.getString("column.work");
    public static final String ACTUAL_WORK = Common.I18N_RP.getString("column.actualWork");
    public static final String REMAINING_WORK = Common.I18N_RP.getString("column.remainingWork");
    public static final String COST = Common.I18N_RP.getString("column.cost");
    public static final String ACTUAL_COST = Common.I18N_RP.getString("column.actualCost");
    public static final String REMAINING_COST = Common.I18N_RP.getString("column.remainingCost");
    public static final String RESOURCE_NAME = Common.I18N_RP.getString("column.resourceName");
    public static final String RESOURCE_CODE = Common.I18N_RP.getString("column.resourceCode");
    protected TaskListener taskHandler;
    protected Company company;

    public TaskTreeTableModel() {
        this(null, new Task(Long.MIN_VALUE));
    }

    public TaskTreeTableModel(JTreeTable jTreeTable, Task task) {
        super(jTreeTable, task);
        this.company = task.getCompany();
        this.createColumns();
        this.taskHandler = new TaskHandler();
        this.addTasksListeners(task);
    }

    protected void createColumns() {
        int n;
        this.titles.add(INFO);
        this.titles.add(TASK_NAME);
        this.titles.add(DURATION);
        this.titles.add(ACTUAL_DURATION);
        this.titles.add(REMAINING_DURATION);
        this.titles.add(START);
        this.titles.add(END);
        this.titles.add(CALENDAR);
        this.titles.add(PERCENT_COMPLETE);
        this.titles.add(PERCENT_WORK_COMPLETE);
        this.titles.add(ACTUAL_START);
        this.titles.add(ACTUAL_END);
        this.titles.add(DEADLINE);
        this.titles.add(FIXED_COST);
        this.titles.add(ACCRUAL);
        this.titles.add(WORK);
        this.titles.add(ACTUAL_WORK);
        this.titles.add(REMAINING_WORK);
        this.titles.add(COST);
        this.titles.add(ACTUAL_COST);
        this.titles.add(REMAINING_COST);
        this.titles.add(RESOURCE_NAME);
        this.titles.add(RESOURCE_CODE);
        for (n = 1; n <= 10; ++n) {
            this.titles.add(FieldManager.CUSTOM_NAME + n);
        }
        this.columnsType.add(Task.class);
        this.columnsType.add(Task.class);
        this.columnsType.add(Long.class);
        this.columnsType.add(Long.class);
        this.columnsType.add(Long.class);
        this.columnsType.add(Date.class);
        this.columnsType.add(Date.class);
        this.columnsType.add(CalendarManager.class);
        this.columnsType.add(Double.class);
        this.columnsType.add(Double.class);
        this.columnsType.add(Date.class);
        this.columnsType.add(Date.class);
        this.columnsType.add(Date.class);
        this.columnsType.add(Double.class);
        this.columnsType.add(String.class);
        this.columnsType.add(Long.class);
        this.columnsType.add(Long.class);
        this.columnsType.add(Long.class);
        this.columnsType.add(Number.class);
        this.columnsType.add(Number.class);
        this.columnsType.add(Number.class);
        this.columnsType.add(String.class);
        this.columnsType.add(String.class);
        for (n = 0; n < 10; ++n) {
            this.columnsType.add(String.class);
        }
    }

    public int getHierarchicalColumn() {
        if (this.getColumnCount() == 0) {
            return -1;
        }
        return 1;
    }

    private void addTasksListeners(Task task) {
        task.addTaskListener(this.taskHandler);
        for (int i = 0; i < task.getChildNumber(); ++i) {
            this.addTasksListeners(task.getChildAt(i));
        }
    }

    private void removeTasksListeners(Task task) {
        task.removeTaskListener(this.taskHandler);
        for (int i = 0; i < task.getChildNumber(); ++i) {
            this.removeTasksListeners(task.getChildAt(i));
        }
    }

    public boolean isCellEditable(Object object, int n) {
        Task task = (Task)object;
        if (task.isEmpty()) {
            return n == 1;
        }
        if (n == 20 || n == 21) {
            return false;
        }
        if (n == 1 || n >= this.titles.size() - 10) {
            return true;
        }
        if (task.isLeaf() && !task.isProject()) {
            if (n == 2) {
                return true;
            }
            if (n == 3) {
                return true;
            }
            if (n == 4) {
                return true;
            }
            if (n == 5) {
                return true;
            }
            if (n == 10) {
                return task.getCompletion() != 0.0;
            }
            if (n == 6) {
                return true;
            }
            if (n == 11) {
                return task.getCompletion() == 100.0;
            }
            if (n == 7) {
                return task.getParent() == null || !task.getParent().isSplitted();
            }
            if (n == 8) {
                return true;
            }
            if (n == 9) {
                return true;
            }
            if (n == 12) {
                return !task.isParentSplitted();
            }
            if (n == 13) {
                return true;
            }
            if (n == 14) {
                return true;
            }
            if (n == 15) {
                return true;
            }
            if (n == 16) {
                return true;
            }
            if (n == 17) {
                return true;
            }
            if (n == 18) {
                return false;
            }
            if (n == 19) {
                return false;
            }
            if (n == 20) {
                return false;
            }
            return false;
        }
        if (task.isSplitted()) {
            if (n == 2) {
                return true;
            }
            if (n == 3) {
                return true;
            }
            if (n == 4) {
                return true;
            }
            if (n == 5) {
                return true;
            }
            if (n == 10) {
                return task.getCompletion() != 0.0;
            }
            if (n == 6) {
                return true;
            }
            if (n == 11) {
                return task.getCompletion() == 100.0;
            }
            if (n == 8) {
                return true;
            }
            if (n == 9) {
                return true;
            }
            if (n == 12) {
                return true;
            }
            if (n == 15) {
                return true;
            }
            if (n == 16) {
                return true;
            }
            if (n == 17) {
                return true;
            }
        }
        return n == 7;
    }

    public Object getValueAt(Object object, int n) {
        if (!(object instanceof Task)) {
            return null;
        }
        Task task = (Task)object;
        if (n >= this.titles.size() - 10) {
            return task.getFieldAt(n - (this.titles.size() - 10));
        }
        switch (n) {
            case 0: {
                return task;
            }
            case 1: {
                return task;
            }
            case 2: {
                if (task.isLeaf() || task.isSplitted()) {
                    return new Long(task.getDuration());
                }
                return new Long(task.getWorkingDuration());
            }
            case 3: {
                if (task.isLeaf()) {
                    return new Long(task.getActualDuration());
                }
                return new Long(task.getActualWorkingDuration());
            }
            case 4: {
                if (task.isLeaf()) {
                    return new Long(task.getRemainingDuration());
                }
                return new Long(task.getRemainingWorkingDuration());
            }
            case 5: {
                return task.getStartDate();
            }
            case 10: {
                return task.getActualStartDate();
            }
            case 6: {
                return task.getEndDate();
            }
            case 11: {
                return task.getActualEndDate();
            }
            case 7: {
                return task.getCalendar();
            }
            case 8: {
                return task.getCompletion();
            }
            case 9: {
                return task.getWorkCompletion();
            }
            case 12: {
                return task.getDeadlineDate();
            }
            case 13: {
                return task.getFixedCost();
            }
            case 14: {
                return task.getAccrual();
            }
            case 15: {
                return task.getWork();
            }
            case 16: {
                return task.getActualWork();
            }
            case 17: {
                return task.getRemainingWork();
            }
            case 18: {
                return task.getCost();
            }
            case 19: {
                return task.getActualCost();
            }
            case 20: {
                return task.getRemainingCost();
            }
            case 21: {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < task.getAssignmentNumber() - 1; ++i) {
                    Assignment assignment = task.getAssignmentAt(i);
                    stringBuffer.append(assignment.getResource().getName());
                    stringBuffer.append(",");
                }
                if (task.getAssignmentNumber() != 0) {
                    stringBuffer.append(task.getAssignmentAt(task.getAssignmentNumber() - 1).getResource().getName());
                }
                return stringBuffer.toString();
            }
            case 22: {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < task.getAssignmentNumber() - 1; ++i) {
                    Assignment assignment = task.getAssignmentAt(i);
                    stringBuffer.append(assignment.getResource().getCode());
                    stringBuffer.append(",");
                }
                if (task.getAssignmentNumber() != 0) {
                    stringBuffer.append(task.getAssignmentAt(task.getAssignmentNumber() - 1).getResource().getCode());
                }
                return stringBuffer.toString();
            }
        }
        return "";
    }

    public void setValueAt(Object object, Object object2, int n) {
        Task task = (Task)object2;
        ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(this.company.getRootTask());
        AbstractUndoableEdit abstractUndoableEdit = null;
        if (task.isEmpty()) {
            if (object.toString().equals("")) {
                return;
            }
            task = this.insertEmptyTasks(task, extendedCompoundEdit, true);
        }
        boolean bl = task.isEmpty();
        boolean bl2 = true;
        if (n >= this.titles.size() - 10) {
            int n2 = n - (this.titles.size() - 10);
            abstractUndoableEdit = new TaskAdditionalFieldEdit(task, task.getFieldAt(n2), object.toString(), n2, "09/11/09 13:00");
            task.setFieldAt(n2, object.toString());
            bl2 = false;
        } else {
            switch (n) {
                case 1: {
                    abstractUndoableEdit = new TaskNameEdit(task, task.getName(), object.toString(), "02-10-2009 12:41:10");
                    task.setName(object.toString());
                    bl2 = false;
                    break;
                }
                case 2: {
                    long l = (Long)object;
                    abstractUndoableEdit = new TaskDurationEdit(task, task.getDuration(), l, "02-10-2009 13:00:06");
                    task.changeDuration(l);
                    bl2 = true;
                    break;
                }
                case 3: {
                    long l = (Long)object;
                    if (l > task.getDuration()) {
                        JOptionPane.showMessageDialog(Common.getApplication(), Common.I18N_MESSAGES.getString("actualDurationGreaterThanDuration.message"), Common.I18N_MESSAGES.getString("actualDurationGreaterThanDuration.title"), 0);
                        return;
                    }
                    double d = (double)l * 100.0 / (double)task.getDuration();
                    abstractUndoableEdit = new TaskCompletionEdit(task, task.getCompletion(), d, "09/11/09 12:40:05");
                    task.setCompletion(d);
                    bl2 = true;
                    break;
                }
                case 4: {
                    long l = (Long)object;
                    if (l > task.getDuration()) {
                        JOptionPane.showMessageDialog(Common.getApplication(), Common.I18N_MESSAGES.getString("remainingDurationGreaterThanDuration.message"), Common.I18N_MESSAGES.getString("remainingDurationGreaterThanDuration.title"), 0);
                        return;
                    }
                    double d = 100.0 - (double)l * 100.0 / (double)task.getDuration();
                    abstractUndoableEdit = new TaskCompletionEdit(task, task.getCompletion(), d, "09/11/09 12:40:06");
                    task.setCompletion(d);
                    bl2 = true;
                    break;
                }
                case 5: 
                case 10: {
                    if (task.getStartDate().equals((Date)object)) {
                        return;
                    }
                    if (task.isSplitted()) {
                        task = task.getChildAt(0);
                    }
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime((Date)object);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                    CalendarManager calendarManager = task.getUsedCalendar();
                    calendarManager.getFirstTime(calendar, true, Long.MAX_VALUE);
                    SNET sNET = new SNET(calendar.getTime());
                    abstractUndoableEdit = new TaskConstraintEdit(task, task.getConstraint(), sNET, true, "09/11/09 12:37:08");
                    task.setForce(true);
                    task.setConstraint(sNET);
                    bl2 = true;
                    break;
                }
                case 6: 
                case 11: {
                    if (task.isSplitted()) {
                        task = task.getChildAt(task.getChildNumber() - 1);
                    }
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime((Date)object);
                    CalendarManager calendarManager = task.getUsedCalendar();
                    long l = calendarManager.getDuration(task.getStartDate(), calendar.getTime(), true);
                    abstractUndoableEdit = new TaskDurationEdit(task, task.getDuration(), l, "02-10-2009 13:00:07");
                    task.changeDuration(l);
                    bl2 = true;
                    break;
                }
                case 7: {
                    CalendarManager calendarManager = object instanceof CalendarManager ? (CalendarManager)object : null;
                    abstractUndoableEdit = new TaskCalendarEdit(task, task.getCalendar(), calendarManager, "09/11/09 12:53:05");
                    task.setCalendar(calendarManager);
                    bl2 = true;
                    break;
                }
                case 8: {
                    double d = (Double)object;
                    abstractUndoableEdit = new TaskCompletionEdit(task, task.getCompletion(), d, "09/11/09 12:40:07");
                    task.setCompletion(d);
                    bl2 = true;
                    break;
                }
                case 9: {
                    double d = (Double)object;
                    abstractUndoableEdit = new TaskWorkCompletionEdit(task, task.getWorkCompletion(), d, "01-10-2009 17:20:02");
                    task.setWorkCompletion(d, true);
                    break;
                }
                case 12: {
                    Date date;
                    if (object == null) {
                        if (task.getDeadlineDate() == null) {
                            return;
                        }
                        date = null;
                    } else {
                        if (task.getDeadlineDate() != null && task.getDeadlineDate().equals((Date)object)) {
                            return;
                        }
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime((Date)object);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 0);
                        CalendarManager calendarManager = task.getUsedCalendar();
                        calendarManager.getFirstTime(calendar, true, Long.MAX_VALUE);
                        date = calendar.getTime();
                    }
                    abstractUndoableEdit = new TaskDeadlineEdit(task, task.getDeadlineDate(), date, "09/11/09 12:34:00");
                    task.setDeadlineDate(date);
                    bl2 = true;
                    break;
                }
                case 13: {
                    double d = (Double)object;
                    abstractUndoableEdit = new TaskFixedCostEdit(task, task.getFixedCost(), d, "02-10-2009 12:58:00");
                    task.setFixedCost(d);
                    bl2 = true;
                    break;
                }
                case 14: {
                    String string = (String)object;
                    abstractUndoableEdit = new TaskAccrualEdit(task, task.getAccrual(), string, "09/11/09 13:03:00");
                    task.setAccrual(string);
                    bl2 = true;
                    break;
                }
                case 15: {
                    long l = (Long)object;
                    abstractUndoableEdit = new TaskWorkEdit(task, l, "01-10-2009 17:31:01");
                    task.changeWork(l, true);
                    bl2 = true;
                    break;
                }
                case 16: {
                    long l = (Long)object;
                    if (l > task.getWork()) {
                        JOptionPane.showMessageDialog(Common.getApplication(), Common.I18N_MESSAGES.getString("actualWorkGreaterThanWork.message"), Common.I18N_MESSAGES.getString("actualWorkGreaterThanWork.title"), 0);
                        return;
                    }
                    ActualWorkingData actualWorkingData = TaskPlanner.estimateWorkingDurationForWork(task, task.getStartDate(), l, true);
                    double d = (double)actualWorkingData.getDuration() * 100.0 / (double)task.getDuration();
                    abstractUndoableEdit = new TaskCompletionEdit(task, task.getCompletion(), d, "09/11/09 12:40:08");
                    task.setCompletion(d);
                    bl2 = true;
                    break;
                }
                case 17: {
                    long l = (Long)object;
                    if (l > task.getWork()) {
                        JOptionPane.showMessageDialog(Common.getApplication(), Common.I18N_MESSAGES.getString("remainingWorkGreaterThanWork.message"), Common.I18N_MESSAGES.getString("remainingWorkGreaterThanWork.title"), 0);
                        return;
                    }
                    ActualWorkingData actualWorkingData = TaskPlanner.estimateWorkingDurationForWork(task, task.getEndDate(), l, false);
                    double d = 100.0 - (double)actualWorkingData.getDuration() * 100.0 / (double)task.getDuration();
                    abstractUndoableEdit = new TaskCompletionEdit(task, task.getCompletion(), d, "09/11/09 12:40:09");
                    task.setCompletion(d);
                    bl2 = true;
                    break;
                }
            }
        }
        task.setDirty(true, false);
        this.treeTable.getProjectView().updateToolbar();
        if (bl) {
            TaskNonEmptyEdit taskNonEmptyEdit = new TaskNonEmptyEdit(task, "02-10-2009 : 12:40:07");
            extendedCompoundEdit.addEdit(taskNonEmptyEdit);
        }
        if (abstractUndoableEdit != null) {
            extendedCompoundEdit.addEdit(abstractUndoableEdit);
        }
        if (bl || bl2) {
            TaskPlanner.rescheduleTree(task);
        } else {
            extendedCompoundEdit.discardReschedule();
        }
        extendedCompoundEdit.end();
        UndoableEditEvent undoableEditEvent = new UndoableEditEvent((Object)this, extendedCompoundEdit);
        this.fireUndoableEditHappened(undoableEditEvent);
    }

    public Object getChild(Object object, int n) {
        Task task = (Task)object;
        if (n >= task.getChildNumber()) {
            return this.emptyTasks.get(n - ((Task)this.root).getChildNumber());
        }
        return task.getChildAt(n);
    }

    public int getChildCount(Object object) {
        Task task = (Task)object;
        if (this.root.equals(task)) {
            return task.getChildNumber() + 50;
        }
        return task.getChildNumber();
    }

    public int getIndexOfChild(Object object, Object object2) {
        if (object == null || object2 == null) {
            return -1;
        }
        int n = this.emptyTasks.indexOf(object2);
        if (n != -1) {
            return ((Task)object).getChildNumber() + n;
        }
        return ((Task)object).getChildIndex((Task)object2);
    }

    public boolean isLeaf(Object object) {
        int n = this.emptyTasks.indexOf(object);
        if (n != -1) {
            return true;
        }
        if (((Task)object).equals(this.root)) {
            return false;
        }
        return ((Task)object).isLeaf();
    }

    public void removeRootListeners() {
        this.removeTasksListeners((Task)this.root);
    }

    class TaskHandler
    extends TaskAdapter {
        TaskHandler() {
        }

        public void nameChanged(TaskEvent taskEvent) {
            Task task = (Task)taskEvent.getSource();
            if (task == TaskTreeTableModel.this.root) {
                if (UIManager.getInstance().isShowProjectRoot()) {
                    TaskTreeTableModel.this.modelSupport.firePathChanged(new TreePath(task));
                }
            } else {
                Task task2 = task.getParent();
                TaskTreeTableModel.this.modelSupport.fireChildChanged(new TreePath(task2.getPath((Task)TaskTreeTableModel.this.root).toArray()), task2.getChildIndex(task), (Object)task);
            }
        }

        public void conflictChanged(TaskEvent taskEvent) {
            Task task = (Task)taskEvent.getSource();
            if (task == TaskTreeTableModel.this.root) {
                if (UIManager.getInstance().isShowProjectRoot()) {
                    TaskTreeTableModel.this.modelSupport.firePathChanged(new TreePath(task));
                }
            } else {
                Task task2 = task.getParent();
                TaskTreeTableModel.this.modelSupport.fireChildChanged(new TreePath(task2.getPath((Task)TaskTreeTableModel.this.root).toArray()), task2.getChildIndex(task), (Object)task);
            }
        }

        public void dataChanged(TaskEvent taskEvent) {
            Task task = (Task)taskEvent.getSource();
            if (task == TaskTreeTableModel.this.root) {
                if (UIManager.getInstance().isShowProjectRoot()) {
                    TaskTreeTableModel.this.modelSupport.firePathChanged(new TreePath(task));
                }
            } else {
                Task task2 = task.getParent();
                TaskTreeTableModel.this.modelSupport.fireChildChanged(new TreePath(task2.getPath((Task)TaskTreeTableModel.this.root).toArray()), task2.getChildIndex(task), (Object)task);
            }
        }

        public void childAdded(TaskEvent taskEvent) {
            Task task = (Task)taskEvent.getSource();
            Task task2 = taskEvent.getTask();
            TaskTreeTableModel.this.addTasksListeners(task2);
            TreePath treePath = new TreePath(task.getPath((Task)TaskTreeTableModel.this.root).toArray());
            int n = task.getChildIndex(task2);
            TaskTreeTableModel.this.modelSupport.fireChildAdded(treePath, n, (Object)task2);
            if (!task.isSplitted()) {
                TaskTreeTableModel.this.treeTable.expandPath(treePath);
            }
        }

        public void childWillRemove(TaskEvent taskEvent) {
            Task task = (Task)taskEvent.getSource();
            Task task2 = taskEvent.getTask();
            TaskTreeTableModel.this.removeTasksListeners(task2);
            TaskTreeTableModel.this.modelSupport.fireChildRemoved(new TreePath(task.getPath((Task)TaskTreeTableModel.this.root).toArray()), taskEvent.getIndex(), (Object)task2);
        }

        public void assignmentAdded(TaskEvent taskEvent) {
            Task task = (Task)taskEvent.getSource();
            Task task2 = task.getParent();
            TaskTreeTableModel.this.modelSupport.fireChildChanged(new TreePath(task2.getPath((Task)TaskTreeTableModel.this.root).toArray()), task2.getChildIndex(task), (Object)task);
        }

        public void assignmentRemoved(TaskEvent taskEvent) {
            Task task = (Task)taskEvent.getSource();
            Task task2 = task.getParent();
            TaskTreeTableModel.this.modelSupport.fireChildChanged(new TreePath(task2.getPath((Task)TaskTreeTableModel.this.root).toArray()), task2.getChildIndex(task), (Object)task);
        }

        public void fixedCostChanged(TaskEvent taskEvent) {
            Task task = (Task)taskEvent.getSource();
            if (task == TaskTreeTableModel.this.root) {
                if (UIManager.getInstance().isShowProjectRoot()) {
                    TaskTreeTableModel.this.modelSupport.firePathChanged(new TreePath(task));
                }
            } else {
                Task task2 = task.getParent();
                TaskTreeTableModel.this.modelSupport.fireChildChanged(new TreePath(task2.getPath((Task)TaskTreeTableModel.this.root).toArray()), task2.getChildIndex(task), (Object)task);
            }
        }

        public void accrualChanged(TaskEvent taskEvent) {
            Task task = (Task)taskEvent.getSource();
            if (task == TaskTreeTableModel.this.root) {
                if (UIManager.getInstance().isShowProjectRoot()) {
                    TaskTreeTableModel.this.modelSupport.firePathChanged(new TreePath(task));
                }
            } else {
                Task task2 = task.getParent();
                TaskTreeTableModel.this.modelSupport.fireChildChanged(new TreePath(task2.getPath((Task)TaskTreeTableModel.this.root).toArray()), task2.getChildIndex(task), (Object)task);
            }
        }
    }
}

