/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.model;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.MaterialResource;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.event.CompanyAdapter;
import com.sbs.jpm.core.event.CompanyEvent;
import com.sbs.jpm.core.event.ResourceAdapter;
import com.sbs.jpm.core.event.ResourceEvent;
import com.sbs.jpm.core.event.TaskAdapter;
import com.sbs.jpm.core.event.TaskEvent;
import com.sbs.jpm.ui.treetablechart.JTreeTable;
import com.sbs.jpm.ui.treetablechart.model.ChartTreeTableModel;
import java.util.LinkedList;
import javax.swing.tree.TreePath;

public class ResourceTreeTableModel
extends ChartTreeTableModel {
    public static final String NAME = Common.I18N_RP.getString("column.resourceSheetName");
    public static final String TOTAL_WORK = Common.I18N_RP.getString("column.resourceSheetTotalWork");
    public static final String TOTAL_COST = Common.I18N_RP.getString("column.totalCost");
    public static final String ACTUAL_WORK = Common.I18N_RP.getString("column.resourceSheetActualWork");
    public static final String REMAINING_WORK = Common.I18N_RP.getString("column.resourceSheetRemainingWork");
    public static final String STANDARD_WORK = Common.I18N_RP.getString("column.standardWork");
    public static final String OVERTIME_WORK = Common.I18N_RP.getString("column.overtimeWork");
    public static final String ACTUAL_COST = Common.I18N_RP.getString("column.actualCost");
    public static final String REMAINING_COST = Common.I18N_RP.getString("column.remainingCost");
    public static final String STANDARD_COST = Common.I18N_RP.getString("column.standardCost");
    public static final String OVERTIME_COST = Common.I18N_RP.getString("column.overtimeCost");
    public static final String PROJECT = Common.I18N_RP.getString("column.project");
    protected TaskHandler taskHandler;
    protected ResourceHandler resourceHandler;
    private Company data;

    public ResourceTreeTableModel() {
        this(null, new Company());
    }

    public ResourceTreeTableModel(JTreeTable jTreeTable, Company company) {
        super(jTreeTable, company);
        this.data = company;
        this.titles.add(NAME);
        this.titles.add(TOTAL_WORK);
        this.titles.add(TOTAL_COST);
        this.titles.add(ACTUAL_WORK);
        this.titles.add(REMAINING_WORK);
        this.titles.add(STANDARD_WORK);
        this.titles.add(OVERTIME_WORK);
        this.titles.add(ACTUAL_COST);
        this.titles.add(REMAINING_COST);
        this.titles.add(STANDARD_COST);
        this.titles.add(OVERTIME_COST);
        this.titles.add(PROJECT);
        this.columnsType.add(Object.class);
        this.columnsType.add(Number.class);
        this.columnsType.add(Number.class);
        this.columnsType.add(Number.class);
        this.columnsType.add(Number.class);
        this.columnsType.add(Number.class);
        this.columnsType.add(Number.class);
        this.columnsType.add(Number.class);
        this.columnsType.add(Number.class);
        this.columnsType.add(Number.class);
        this.columnsType.add(Number.class);
        this.columnsType.add(Object.class);
        this.taskHandler = new TaskHandler();
        this.resourceHandler = new ResourceHandler();
        this.addResourcesListeners();
        this.data.addCompanyListener(new CompanyAdapter(){

            public void resourceAdded(CompanyEvent companyEvent) {
                Resource resource = companyEvent.getResource();
                resource.addResourceListener(ResourceTreeTableModel.this.resourceHandler);
                LinkedList<Company> linkedList = new LinkedList<Company>();
                linkedList.add(ResourceTreeTableModel.this.data);
                Object[] objectArray = new Object[]{resource};
                int n = companyEvent.getResourceIndex();
                if (resource instanceof MaterialResource) {
                    n += ResourceTreeTableModel.this.data.getHumanResourcesNumber();
                }
                int[] nArray = new int[]{n};
                ResourceTreeTableModel.this.modelSupport.fireChildAdded(new TreePath(linkedList.toArray()), n, (Object)resource);
            }

            public void resourceRemoved(CompanyEvent companyEvent) {
                Resource resource = companyEvent.getResource();
                resource.removeResourceListener(ResourceTreeTableModel.this.resourceHandler);
                LinkedList<Company> linkedList = new LinkedList<Company>();
                linkedList.add(ResourceTreeTableModel.this.data);
                Object[] objectArray = new Object[]{resource};
                int n = companyEvent.getResourceIndex();
                if (resource instanceof MaterialResource) {
                    n += ResourceTreeTableModel.this.data.getHumanResourcesNumber();
                }
                int[] nArray = new int[]{n};
                ResourceTreeTableModel.this.modelSupport.fireChildRemoved(new TreePath(linkedList.toArray()), n, (Object)resource);
            }
        });
    }

    private void addResourcesListeners() {
        for (int i = 0; i < this.data.getResourcesNumber(); ++i) {
            Resource resource = this.data.getResourceAt(i);
            resource.addResourceListener(this.resourceHandler);
            for (int j = 0; j < resource.getAssignmentNumber(); ++j) {
                Assignment assignment = resource.getAssignmentAt(j);
                assignment.getTask().addTaskListener(this.taskHandler);
            }
        }
    }

    private void removeResourcesListeners() {
        for (int i = 0; i < this.data.getResourcesNumber(); ++i) {
            Resource resource = this.data.getResourceAt(i);
            resource.removeResourceListener(this.resourceHandler);
            for (int j = 0; j < resource.getAssignmentNumber(); ++j) {
                Assignment assignment = resource.getAssignmentAt(j);
                assignment.getTask().removeTaskListener(this.taskHandler);
            }
        }
    }

    public boolean isCellEditable(Object object, int n) {
        return false;
    }

    public Object getValueAt(Object object, int n) {
        if (object instanceof Company) {
            return null;
        }
        if (object instanceof Task) {
            return null;
        }
        if (object instanceof Resource) {
            Resource resource = (Resource)object;
            switch (n) {
                case 0: {
                    return resource;
                }
                case 1: {
                    if (resource instanceof HumanResource) {
                        return new Long(((HumanResource)resource).getWork());
                    }
                    return new Double(((MaterialResource)resource).getTotalUnits());
                }
                case 2: {
                    return resource.getCost();
                }
                case 3: {
                    if (resource instanceof HumanResource) {
                        return new Long(((HumanResource)resource).getActualWork());
                    }
                    return new Double(((MaterialResource)resource).getActualUnits());
                }
                case 4: {
                    if (resource instanceof HumanResource) {
                        return new Long(((HumanResource)resource).getRemainingWork());
                    }
                    return new Double(((MaterialResource)resource).getRemainingUnits());
                }
                case 5: {
                    if (resource instanceof HumanResource) {
                        return new Long(((HumanResource)resource).getStandardWork());
                    }
                    return null;
                }
                case 6: {
                    if (resource instanceof HumanResource) {
                        return new Long(((HumanResource)resource).getOvertimeWork());
                    }
                    return null;
                }
                case 7: {
                    if (resource instanceof HumanResource) {
                        return ((HumanResource)resource).getActualCost();
                    }
                    return ((MaterialResource)resource).getActualCost();
                }
                case 8: {
                    if (resource instanceof HumanResource) {
                        return new Double(((HumanResource)resource).getRemainingCost());
                    }
                    return new Double(((MaterialResource)resource).getRemainingCost());
                }
                case 9: {
                    if (resource instanceof HumanResource) {
                        return new Double(((HumanResource)resource).getStandardCost());
                    }
                    return null;
                }
                case 10: {
                    if (resource instanceof HumanResource) {
                        return new Double(((HumanResource)resource).getOvertimeCost());
                    }
                    return null;
                }
                case 11: {
                    return null;
                }
            }
        } else if (object instanceof Assignment) {
            Assignment assignment = (Assignment)object;
            Resource resource = assignment.getResource();
            switch (n) {
                case 0: {
                    return assignment;
                }
                case 1: {
                    if (resource instanceof HumanResource) {
                        return ((HumanResource)resource).getWork(assignment);
                    }
                    return assignment.getUnits();
                }
                case 2: {
                    return resource.getCost(assignment);
                }
                case 3: {
                    if (resource instanceof HumanResource) {
                        return new Long(((HumanResource)resource).getActualWork(assignment));
                    }
                    return assignment.getActualUnits();
                }
                case 4: {
                    if (resource instanceof HumanResource) {
                        return new Long(((HumanResource)resource).getRemainingWork(assignment));
                    }
                    return assignment.getRemainingUnits();
                }
                case 5: {
                    if (resource instanceof HumanResource) {
                        return new Long(((HumanResource)resource).getStandardWork(assignment));
                    }
                    return null;
                }
                case 6: {
                    if (resource instanceof HumanResource) {
                        return new Long(((HumanResource)resource).getOvertimeWork(assignment));
                    }
                    return null;
                }
                case 7: {
                    if (resource instanceof HumanResource) {
                        return new Double(((HumanResource)resource).getActualCost(assignment));
                    }
                    return resource.getActualCost(assignment);
                }
                case 8: {
                    if (resource instanceof HumanResource) {
                        return new Double(((HumanResource)resource).getRemainingCost(assignment));
                    }
                    return resource.getRemainingCost(assignment);
                }
                case 9: {
                    if (resource instanceof HumanResource) {
                        return new Double(((HumanResource)resource).getStandardCost(assignment));
                    }
                    return null;
                }
                case 10: {
                    if (resource instanceof HumanResource) {
                        return new Double(((HumanResource)resource).getOvertimeCost(assignment));
                    }
                    return null;
                }
                case 11: {
                    return assignment.getTask().getProjectTask();
                }
            }
        }
        return "";
    }

    public void setValueAt(Object object, Object object2, int n) {
    }

    public Object getChild(Object object, int n) {
        if (object instanceof Company) {
            if (n >= ((Company)object).getResourcesNumber()) {
                return this.emptyTasks.get(n - ((Company)object).getResourcesNumber());
            }
            return ((Company)object).getResourceAt(n);
        }
        if (object instanceof Resource) {
            Resource resource = (Resource)object;
            return resource.getAssignmentAt(n);
        }
        return null;
    }

    public int getChildCount(Object object) {
        if (object instanceof Company) {
            return ((Company)object).getResourcesNumber() + 50;
        }
        if (object instanceof Resource) {
            return ((Resource)object).getAssignmentNumber();
        }
        return 0;
    }

    public int getIndexOfChild(Object object, Object object2) {
        if (object instanceof Company) {
            int n = this.emptyTasks.indexOf(object2);
            if (n != -1) {
                return ((Company)object).getResourcesNumber() + n;
            }
            return ((Company)object).getResourceIndex((Resource)object2);
        }
        if (object instanceof Resource) {
            return ((Resource)object).getAssignmentIndex((Assignment)object2);
        }
        return 0;
    }

    public boolean isLeaf(Object object) {
        int n = this.emptyTasks.indexOf(object);
        if (n != -1) {
            return true;
        }
        if (object instanceof Company) {
            return false;
        }
        if (object instanceof Resource) {
            Resource resource = (Resource)object;
            return resource.getAssignmentNumber() == 0;
        }
        return true;
    }

    public void removeRootListeners() {
        this.removeResourcesListeners();
    }

    private class ResourceHandler
    extends ResourceAdapter {
        private ResourceHandler() {
        }

        public void dataChanged(ResourceEvent resourceEvent) {
            Resource resource = (Resource)resourceEvent.getSource();
            LinkedList<Company> linkedList = new LinkedList<Company>();
            linkedList.add(ResourceTreeTableModel.this.data);
            ResourceTreeTableModel.this.modelSupport.fireChildChanged(new TreePath(linkedList.toArray()), ResourceTreeTableModel.this.data.getResourceIndex(resource), (Object)resource);
        }

        public void assignmentAdded(ResourceEvent resourceEvent) {
            Resource resource = (Resource)resourceEvent.getSource();
            Assignment assignment = resourceEvent.getAssignment();
            int n = resourceEvent.getAssignmentIndex();
            Task task = assignment.getTask();
            task.addTaskListener(ResourceTreeTableModel.this.taskHandler);
            LinkedList<Cloneable> linkedList = new LinkedList<Cloneable>();
            linkedList.add(ResourceTreeTableModel.this.data);
            linkedList.add(resource);
            ResourceTreeTableModel.this.modelSupport.fireChildAdded(new TreePath(linkedList.toArray()), resourceEvent.getAssignmentIndex(), (Object)assignment);
        }

        public void assignmentRemoved(ResourceEvent resourceEvent) {
            Resource resource = (Resource)resourceEvent.getSource();
            Assignment assignment = resourceEvent.getAssignment();
            Task task = assignment.getTask();
            task.removeTaskListener(ResourceTreeTableModel.this.taskHandler);
            LinkedList<Cloneable> linkedList = new LinkedList<Cloneable>();
            linkedList.add(ResourceTreeTableModel.this.data);
            linkedList.add(resource);
            ResourceTreeTableModel.this.modelSupport.fireChildRemoved(new TreePath(linkedList.toArray()), resourceEvent.getAssignmentIndex(), (Object)assignment);
        }
    }

    class TaskHandler
    extends TaskAdapter {
        TaskHandler() {
        }

        public void nameChanged(TaskEvent taskEvent) {
            this.fireChanged(taskEvent);
        }

        public void forcedWorkingChanged(TaskEvent taskEvent) {
            this.fireChanged(taskEvent);
        }

        public void dataChanged(TaskEvent taskEvent) {
            this.fireChanged(taskEvent);
        }

        private void fireChanged(TaskEvent taskEvent) {
            Task task = (Task)taskEvent.getSource();
            LinkedList<Cloneable> linkedList = new LinkedList<Cloneable>();
            for (Assignment assignment : task.getAssignments()) {
                Resource resource = assignment.getResource();
                int n = resource.getAssignmentIndex(assignment);
                int n2 = ResourceTreeTableModel.this.data.getResourceIndex(resource);
                if (n == -1 || n2 == -1) continue;
                linkedList.clear();
                linkedList.add(ResourceTreeTableModel.this.data);
                linkedList.add(resource);
                ResourceTreeTableModel.this.modelSupport.fireChildChanged(new TreePath(linkedList.toArray()), n, (Object)assignment);
                linkedList.clear();
                linkedList.add(ResourceTreeTableModel.this.data);
                ResourceTreeTableModel.this.modelSupport.fireChildChanged(new TreePath(linkedList.toArray()), n2, (Object)resource);
            }
        }
    }
}

