/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.model;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.core.constraint.SNET;
import com.sbs.jpm.core.event.TaskAdapter;
import com.sbs.jpm.core.event.TaskEvent;
import com.sbs.jpm.core.event.TaskListener;
import com.sbs.jpm.ui.treetablechart.JTreeTable;
import com.sbs.jpm.ui.treetablechart.model.ChartTreeTableModel;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import com.sbs.jpm.undo.TaskCalendarEdit;
import com.sbs.jpm.undo.TaskCompletionEdit;
import com.sbs.jpm.undo.TaskConstraintEdit;
import com.sbs.jpm.undo.TaskDurationEdit;
import com.sbs.jpm.undo.TaskNameEdit;
import com.sbs.jpm.undo.TaskNonEmptyEdit;
import com.sbs.jpm.undo.TaskStatusEdit;
import com.sbs.jpm.undo.TaskWorkCompletionEdit;
import java.util.Date;
import javax.swing.event.UndoableEditEvent;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;

public class EPSTreeTableModel
extends ChartTreeTableModel {
    protected TaskListener taskHandler;
    protected Company company;

    public EPSTreeTableModel() {
        this(null, new Task(Common.getIdGenerator().getNewId()));
    }

    public EPSTreeTableModel(JTreeTable jTreeTable, Task task) {
        super(jTreeTable, task);
        this.company = task.getCompany();
        this.titles.add("Name");
        this.titles.add("Proj. Manager");
        this.titles.add("Duration");
        this.titles.add("Start");
        this.titles.add("End");
        this.titles.add("Cost");
        this.titles.add("Work");
        this.titles.add("% complete");
        this.titles.add("% work complete");
        this.titles.add("Status");
        this.titles.add("Calendar");
        this.titles.add("Estimated Start");
        this.titles.add("Code");
        this.columnsType.add(Task.class);
        this.columnsType.add(String.class);
        this.columnsType.add(Long.class);
        this.columnsType.add(Date.class);
        this.columnsType.add(Date.class);
        this.columnsType.add(Double.class);
        this.columnsType.add(Long.class);
        this.columnsType.add(Integer.class);
        this.columnsType.add(Integer.class);
        this.columnsType.add(String.class);
        this.columnsType.add(CalendarManager.class);
        this.columnsType.add(Date.class);
        this.columnsType.add(String.class);
        this.taskHandler = new TaskHandler();
        this.addTasksListeners(task);
    }

    public int getHierarchicalColumn() {
        if (this.getColumnCount() == 0) {
            return -1;
        }
        return 0;
    }

    private void addTasksListeners(Task task) {
        if (task.isProject()) {
            task.addTaskListener(this.taskHandler);
        }
        for (int i = 0; i < task.getProjectChildNumber(); ++i) {
            this.addTasksListeners(task.getProjectChildAt(i));
        }
    }

    private void removeTasksListeners(Task task) {
        task.removeTaskListener(this.taskHandler);
        for (int i = 0; i < task.getProjectChildNumber(); ++i) {
            this.removeTasksListeners(task.getProjectChildAt(i));
        }
    }

    public boolean isCellEditable(Object object, int n) {
        return n == 0 || n == 9;
    }

    public Object getValueAt(Object object, int n) {
        if (!(object instanceof Task)) {
            return null;
        }
        Task task = (Task)object;
        switch (n) {
            case 0: {
                return task;
            }
            case 1: {
                return task.getManager();
            }
            case 3: {
                return task.getStartDate();
            }
            case 4: {
                return task.getEndDate();
            }
            case 2: {
                if (task.isProjectLeaf()) {
                    return new Long(task.getDuration());
                }
                return new Long(task.getWorkingDuration());
            }
            case 5: {
                return task.getCost();
            }
            case 6: {
                return task.getWork();
            }
            case 7: {
                return task.getCompletion();
            }
            case 8: {
                return task.getWorkCompletion();
            }
            case 9: {
                return task.getStatus();
            }
            case 10: {
                return task.getCalendar();
            }
            case 11: {
                return task.getConstraint().getDate();
            }
            case 12: {
                return task.getCode();
            }
        }
        return "";
    }

    public void setValueAt(Object object, Object object2, int n) {
        ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(this.company.getRootTask());
        Task task = (Task)object2;
        boolean bl = task.isEmpty();
        AbstractUndoableEdit abstractUndoableEdit = null;
        TaskNonEmptyEdit taskNonEmptyEdit = null;
        switch (n) {
            case 0: {
                abstractUndoableEdit = new TaskNameEdit(task, task.getName(), object.toString(), "02-10-2009 12:41:01");
                task.setName(object.toString());
                break;
            }
            case 4: {
                SNET sNET = new SNET((Date)object);
                abstractUndoableEdit = new TaskConstraintEdit(task, task.getConstraint(), sNET, true, "09/11/09 12:37:06");
                task.setForce(true);
                task.setConstraint(sNET);
                break;
            }
            case 5: {
                break;
            }
            case 3: {
                long l = (Long)object;
                abstractUndoableEdit = new TaskDurationEdit(task, task.getDuration(), l, "02-10-2009 13:00:01");
                task.changeDuration(l);
                break;
            }
            case 6: {
                CalendarManager calendarManager = object instanceof CalendarManager ? (CalendarManager)object : null;
                abstractUndoableEdit = new TaskCalendarEdit(task, task.getCalendar(), calendarManager, "09/11/09 12:53:00");
                task.setCalendar(calendarManager);
                break;
            }
            case 7: {
                int n2 = (Integer)object;
                abstractUndoableEdit = new TaskCompletionEdit(task, task.getCompletion(), n2, "09/11/09 12:40:12");
                task.setCompletion(n2);
                break;
            }
            case 8: {
                int n3 = (Integer)object;
                abstractUndoableEdit = new TaskWorkCompletionEdit(task, task.getWorkCompletion(), n3, "01-10-2009 17:20:04");
                task.setWorkCompletion(n3, true);
                break;
            }
            case 9: {
                String string = object.toString();
                abstractUndoableEdit = new TaskStatusEdit(task, task.getStatus(), string, "01-10-2009 17:31:01");
                task.setStatus(string);
                break;
            }
        }
        if (bl) {
            taskNonEmptyEdit = new TaskNonEmptyEdit(task, "02-10-2009 : 12:40:01");
            extendedCompoundEdit.addEdit(taskNonEmptyEdit);
        }
        if (abstractUndoableEdit != null) {
            extendedCompoundEdit.addEdit(abstractUndoableEdit);
        }
        extendedCompoundEdit.end();
        UndoableEditEvent undoableEditEvent = new UndoableEditEvent((Object)this, extendedCompoundEdit);
        this.fireUndoableEditHappened(undoableEditEvent);
        TaskPlanner.rescheduleTree(task);
    }

    public Object getChild(Object object, int n) {
        Task task = (Task)object;
        return task.getProjectChildAt(n);
    }

    public int getChildCount(Object object) {
        Task task = (Task)object;
        return task.getProjectChildNumber();
    }

    public int getIndexOfChild(Object object, Object object2) {
        if (object == null || object2 == null) {
            return -1;
        }
        return ((Task)object).getProjectChildIndex((Task)object2);
    }

    public boolean isLeaf(Object object) {
        if (((Task)object).equals(this.root)) {
            return false;
        }
        return ((Task)object).isProjectLeaf();
    }

    public void removeRootListeners() {
        this.removeTasksListeners((Task)this.root);
    }

    class TaskHandler
    extends TaskAdapter {
        TaskHandler() {
        }

        public void nameChanged(TaskEvent taskEvent) {
            Task task = (Task)taskEvent.getSource();
            if (task != EPSTreeTableModel.this.root) {
                Task task2 = task.getParent();
                EPSTreeTableModel.this.modelSupport.fireChildChanged(new TreePath(task2.getPath((Task)EPSTreeTableModel.this.root).toArray()), task2.getProjectChildIndex(task), (Object)task);
            }
        }

        public void projectChanged(TaskEvent taskEvent) {
            Task task = (Task)taskEvent.getSource();
            if (task != EPSTreeTableModel.this.root) {
                Task task2 = task.getParent();
                EPSTreeTableModel.this.modelSupport.fireChildChanged(new TreePath(task2.getPath((Task)EPSTreeTableModel.this.root).toArray()), task2.getProjectChildIndex(task), (Object)task);
            }
        }

        public void dataChanged(TaskEvent taskEvent) {
            Task task = (Task)taskEvent.getSource();
            if (task != EPSTreeTableModel.this.root) {
                Task task2 = task.getParent();
                EPSTreeTableModel.this.modelSupport.fireChildChanged(new TreePath(task2.getPath((Task)EPSTreeTableModel.this.root).toArray()), task2.getProjectChildIndex(task), (Object)task);
            }
        }

        public void childAdded(TaskEvent taskEvent) {
            Task task = (Task)taskEvent.getSource();
            Task task2 = taskEvent.getTask();
            if (task2.isProject()) {
                task2.addTaskListener(EPSTreeTableModel.this.taskHandler);
                EPSTreeTableModel.this.modelSupport.fireChildAdded(new TreePath(task.getPath((Task)EPSTreeTableModel.this.root).toArray()), task.getProjectChildIndex(task2), (Object)task2);
            }
        }

        public void childWillRemove(TaskEvent taskEvent) {
            Task task = (Task)taskEvent.getSource();
            Task task2 = taskEvent.getTask();
            if (task2.isProject()) {
                task2.removeTaskListener(EPSTreeTableModel.this.taskHandler);
                EPSTreeTableModel.this.modelSupport.fireChildRemoved(new TreePath(task.getPath((Task)EPSTreeTableModel.this.root).toArray()), task.getProjectChildIndex(task2), (Object)task2);
            }
        }
    }
}

