/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.model;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.ui.component.JProjectView;
import com.sbs.jpm.ui.treetablechart.JTreeTable;
import com.sbs.jpm.undo.InsertEmptyTasksEdit;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.tree.TreePath;
import javax.swing.undo.CompoundEdit;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;

public abstract class ChartTreeTableModel
extends AbstractTreeTableModel {
    public static final int EMPTY_ROWS = 50;
    protected List titles;
    protected List columnsType;
    protected List emptyTasks;
    protected EventListenerList listeners;
    protected JTreeTable treeTable;
    private Task rootTask;

    public ChartTreeTableModel(JTreeTable jTreeTable) {
        this(jTreeTable, null);
    }

    public ChartTreeTableModel(JTreeTable jTreeTable, Object object) {
        super(object);
        if (object instanceof Task) {
            this.rootTask = (Task)object;
        } else if (object instanceof Company) {
            this.rootTask = ((Company)object).getRootTask();
        }
        this.treeTable = jTreeTable;
        this.listeners = new EventListenerList();
        this.titles = new LinkedList();
        this.columnsType = new LinkedList();
        this.emptyTasks = new LinkedList();
        for (int i = 0; i < 50; ++i) {
            this.emptyTasks.add(new Task(Long.MIN_VALUE));
        }
    }

    public int getColumnCount() {
        return this.titles.size();
    }

    public Class getColumnClass(int n) {
        return (Class)this.columnsType.get(n);
    }

    public String getColumnName(int n) {
        return (String)this.titles.get(n);
    }

    public void setColumnName(int n, String string) {
        this.titles.set(n, string);
    }

    public int getHierarchicalColumn() {
        if (this.getColumnCount() == 0) {
            return -1;
        }
        return 0;
    }

    public abstract void removeRootListeners();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task insertEmptyTasks(Task task, CompoundEdit compoundEdit, boolean bl) {
        Task task2 = task;
        int n = this.emptyTasks.indexOf(task2);
        if (n != -1) {
            int n2;
            Task task3 = (Task)this.root;
            if (bl) {
                ++n;
            }
            for (n2 = 0; n2 < n; ++n2) {
                Task task4 = new Task(Common.getIdGenerator().getNewId());
                task3.addChild(task4, false);
                InsertEmptyTasksEdit insertEmptyTasksEdit = new InsertEmptyTasksEdit(task3, task4, "09/11/09 15:15:00");
                compoundEdit.addEdit(insertEmptyTasksEdit);
            }
            task2 = task3.getChildAt(task3.getChildNumber() - 1);
            n2 = this.treeTable.getRowForPath(new TreePath(task2.getPath((Task)this.root).toArray())) + 1;
            JProjectView.BLOCK_UPDATE = true;
            try {
                this.treeTable.getSelectionModel().setSelectionInterval(n2, n2);
                JProjectView.BLOCK_UPDATE = false;
            }
            catch (Throwable throwable) {
                JProjectView.BLOCK_UPDATE = false;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ChartTreeTableModel.this.treeTable.getProjectView().updateToolbar();
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
        return task2;
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    protected void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(UndoableEditListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((UndoableEditListener)eventListenerArray[i]).undoableEditHappened(undoableEditEvent);
        }
    }

    public void setTreeTable(JTreeTable jTreeTable) {
        this.treeTable = jTreeTable;
    }

    public Task getRootTask() {
        return this.rootTask;
    }
}

