/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.chart;

import com.sbs.jpm.core.Task;
import java.awt.Color;
import java.awt.Font;
import javax.swing.UIManager;

public class UIConfiguration {
    protected final Font chartFont;
    protected Color taskColor;
    protected Color taskCompletionColor;
    protected Color taskCriticalColor;
    protected Color phaseTaskColor;
    protected Color projectTaskColor;
    protected Color dayOffColor;
    protected Color milestoneColor;
    protected Color baselineColor;
    public static final Color TASK_DEFAULT_COLOR = new Color(187, 187, 255);
    public static final Color TASK_COMPLETION_DEFAULT_COLOR = Color.BLACK;
    public static final Color PHASE_DEFAULT_COLOR = new Color(62, 62, 62);
    public static final Color TASK_CRITICAL_DEFAULT_COLOR = new Color(255, 147, 147);
    public static final Color PROJECT_DEFAULT_COLOR = Color.GRAY;
    public static final Color MILESTONE_DEFAULT_COLOR = Color.BLUE;
    public static final Color BASELINE_DEFAULT_COLOR = new Color(255, 255, 153);

    public UIConfiguration() {
        this((Font)UIManager.get("table.font"));
    }

    public UIConfiguration(Font font) {
        this.chartFont = font;
        this.taskColor = TASK_DEFAULT_COLOR;
        this.taskCompletionColor = TASK_COMPLETION_DEFAULT_COLOR;
        this.taskCriticalColor = TASK_CRITICAL_DEFAULT_COLOR;
        this.phaseTaskColor = PHASE_DEFAULT_COLOR;
        this.projectTaskColor = PROJECT_DEFAULT_COLOR;
        this.milestoneColor = MILESTONE_DEFAULT_COLOR;
        this.baselineColor = BASELINE_DEFAULT_COLOR;
        this.dayOffColor = new Color(235, 235, 235, 175);
    }

    public Color getDefaultColor(Task task) {
        if (task.isMilestone()) {
            return this.getMilestoneColor();
        }
        if (task.isProject()) {
            return this.getProjectTaskColor();
        }
        if (task.isLeaf()) {
            return this.getTaskColor();
        }
        return this.getPhaseTaskColor();
    }

    public Font getChartFont() {
        return this.chartFont;
    }

    public Color getTaskColor() {
        return this.taskColor;
    }

    public void setTaskColor(Color color) {
        this.taskColor = color;
    }

    public Color getBaselineColor() {
        return this.baselineColor;
    }

    public void setBaselineColor(Color color) {
        this.baselineColor = color;
    }

    public Color getDayOffColor() {
        return this.dayOffColor;
    }

    public void setDayOffColor(Color color) {
        this.dayOffColor = color;
    }

    public Color getPhaseTaskColor() {
        return this.phaseTaskColor;
    }

    public void setPhaseTaskColor(Color color) {
        this.phaseTaskColor = color;
    }

    public Color getTaskCriticalColor() {
        return this.taskCriticalColor;
    }

    public void setTaskCriticalColor(Color color) {
        this.taskCriticalColor = color;
    }

    public Color getProjectTaskColor() {
        return this.projectTaskColor;
    }

    public void setProjectTaskColor(Color color) {
        this.projectTaskColor = color;
    }

    public Color getMilestoneColor() {
        return this.milestoneColor;
    }

    public void setMilestoneColor(Color color) {
        this.milestoneColor = color;
    }

    public void setTaskCompletionColor(Color color) {
        this.taskCompletionColor = color;
    }

    public Color getTaskCompletionColor() {
        return this.taskCompletionColor;
    }

    public Color getTaskCompletionCriticalColor() {
        return this.taskCompletionColor;
    }

    public Color getPhaseTaskCompletionColor() {
        return this.taskCompletionColor;
    }
}

