/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.chart;

import com.sbs.jpm.core.MouseHoover;
import com.sbs.jpm.ui.treetablechart.chart.Painter;
import com.sbs.jpm.ui.treetablechart.chart.PrimitiveStyle;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;

public class GraphicPrimitiveContainer {
    private ArrayList myRectangles = new ArrayList();
    private ArrayList myLines = new ArrayList();
    private ArrayList myTexts = new ArrayList();
    private ArrayList myIcons = new ArrayList();
    private boolean dirty = true;
    private double distanceFromPointToLine = 3.5;

    public GraphicPrimitiveContainer() {
    }

    public GraphicPrimitiveContainer(int n) {
        this.distanceFromPointToLine = n;
    }

    public Rectangle createRectangle(double d, double d2, double d3, double d4) {
        return this.createRectangle(d, d2, d3, d4, false);
    }

    public Line createLine(double d, double d2, double d3, double d4) {
        return this.createLine(d, d2, d3, d4, false);
    }

    public Text createText(double d, double d2, String string) {
        return this.createText(d, d2, string, false);
    }

    public Rectangle createRectangle(double d, double d2, double d3, double d4, boolean bl) {
        if (d3 < 0.0) {
            d3 = -d3;
            d -= d3;
        }
        Rectangle rectangle = new Rectangle(d, d2, d3, d4, bl);
        this.myRectangles.add(rectangle);
        return rectangle;
    }

    public RectangleArrayPart createRectangleArrayPart(double d, double d2, double d3, double d4, boolean bl, int n) {
        if (d3 < 0.0) {
            d3 = -d3;
            d -= d3;
        }
        RectangleArrayPart rectangleArrayPart = new RectangleArrayPart(d, d2, d3, d4, bl, n);
        this.myRectangles.add(rectangleArrayPart);
        return rectangleArrayPart;
    }

    public Line createLine(double d, double d2, double d3, double d4, boolean bl) {
        Line line = new Line(d, d2, d3, d4, bl);
        this.myLines.add(line);
        return line;
    }

    public Line createMultiLine(double d, double d2, double d3, double d4, boolean bl) {
        MultiLine multiLine = new MultiLine(d, d2, d3, d4, bl);
        this.myLines.add(multiLine);
        return multiLine;
    }

    public Text createText(double d, double d2, String string, boolean bl) {
        Text text = new Text(d, d2, string, bl);
        this.myTexts.add(text);
        return text;
    }

    public Image createImage(double d, double d2, Icon icon, Icon icon2, boolean bl) {
        Image image = new Image(d, d2, icon, icon2, bl);
        this.myIcons.add(image);
        return image;
    }

    public void paint(Painter painter, Graphics graphics) {
        GraphicPrimitive graphicPrimitive;
        int n;
        GraphicPrimitive graphicPrimitive2 = null;
        for (n = 0; n < this.myRectangles.size(); ++n) {
            graphicPrimitive = (Rectangle)this.myRectangles.get(n);
            painter.paint((Rectangle)graphicPrimitive);
        }
        for (n = 0; n < this.myLines.size(); ++n) {
            graphicPrimitive = (Line)this.myLines.get(n);
            painter.paint((Line)graphicPrimitive);
            if (!(graphicPrimitive.getModelObject() instanceof MouseHoover) || !((MouseHoover)graphicPrimitive.getModelObject()).getMouseHoover()) continue;
            graphicPrimitive2 = graphicPrimitive;
        }
        for (n = 0; n < this.myTexts.size(); ++n) {
            graphicPrimitive = (Text)this.myTexts.get(n);
            painter.paint((Text)graphicPrimitive);
        }
        for (n = 0; n < this.myIcons.size(); ++n) {
            graphicPrimitive = (Image)this.myIcons.get(n);
            painter.paint((Image)graphicPrimitive);
        }
        if (graphicPrimitive2 != null && graphicPrimitive2 instanceof Line) {
            painter.paint((Line)graphicPrimitive2);
        }
    }

    public void clear() {
        this.myRectangles.clear();
        this.myLines.clear();
        this.myTexts.clear();
        this.myIcons.clear();
    }

    public GraphicPrimitive getPrimitive(int n, int n2) {
        return this.getPrimitive(n, 0, n2, 0);
    }

    public GraphicPrimitive getSelectablePrimitive(int n, int n2) {
        return this.getSelectablePrimitive(n, 0, n2, 0, null);
    }

    public GraphicPrimitive getSelectablePrimitive(int n, int n2, PrimitiveStyle primitiveStyle) {
        return this.getSelectablePrimitive(n, 0, n2, 0, primitiveStyle);
    }

    public GraphicPrimitive getPrimitive(int n, int n2, int n3, int n4) {
        GraphicPrimitive graphicPrimitive;
        int n5;
        for (n5 = 0; n5 < this.myLines.size(); ++n5) {
            graphicPrimitive = (Line)this.myLines.get(n5);
            if (!this.pointOverLine(n, n3, (Line)graphicPrimitive)) continue;
            return graphicPrimitive;
        }
        for (n5 = 0; n5 < this.myRectangles.size(); ++n5) {
            graphicPrimitive = (Rectangle)this.myRectangles.get(n5);
            if (!(((Rectangle)graphicPrimitive).leftX <= (double)(n + n2)) || !(((Rectangle)graphicPrimitive).leftX + ((Rectangle)graphicPrimitive).width >= (double)(n - n2)) || !(((Rectangle)graphicPrimitive).topY <= (double)(n3 + n4)) || !(((Rectangle)graphicPrimitive).topY + ((Rectangle)graphicPrimitive).height >= (double)(n3 - n4))) continue;
            return graphicPrimitive;
        }
        return null;
    }

    public GraphicPrimitive getSelectablePrimitive(int n, int n2, int n3, int n4) {
        return this.getSelectablePrimitive(n, n2, n3, n4, null);
    }

    public GraphicPrimitive getSelectablePrimitive(int n, int n2, int n3, int n4, PrimitiveStyle primitiveStyle) {
        GraphicPrimitive graphicPrimitive;
        int n5;
        for (n5 = 0; n5 < this.myIcons.size(); ++n5) {
            graphicPrimitive = (Image)this.myIcons.get(n5);
            if (!graphicPrimitive.isSelectable() || !(((Image)graphicPrimitive).getLeftX() <= (double)(n + n2)) || !(((Image)graphicPrimitive).getLeftX() + (double)((Image)graphicPrimitive).getIcon().getIconWidth() >= (double)(n - n2)) || !(((Image)graphicPrimitive).getTopY() <= (double)(n3 + n4)) || !(((Image)graphicPrimitive).getTopY() + (double)((Image)graphicPrimitive).getIcon().getIconHeight() >= (double)(n3 - n4))) continue;
            if (primitiveStyle == null) {
                return graphicPrimitive;
            }
            if (!graphicPrimitive.getStyle().equals(primitiveStyle)) continue;
            return graphicPrimitive;
        }
        for (n5 = 0; n5 < this.myLines.size(); ++n5) {
            graphicPrimitive = (Line)this.myLines.get(n5);
            if (!graphicPrimitive.isSelectable()) continue;
            if (graphicPrimitive instanceof MultiLine) {
                List list = ((MultiLine)graphicPrimitive).lines;
                if (primitiveStyle != null && (primitiveStyle == null || !graphicPrimitive.getStyle().equals(primitiveStyle))) continue;
                for (Line line : list) {
                    if (!this.pointOverLine(n, n3, line)) continue;
                    return graphicPrimitive;
                }
                continue;
            }
            if (!this.pointOverLine(n, n3, (Line)graphicPrimitive)) continue;
            if (primitiveStyle == null) {
                return graphicPrimitive;
            }
            if (!graphicPrimitive.getStyle().equals(primitiveStyle)) continue;
            return graphicPrimitive;
        }
        for (n5 = 0; n5 < this.myRectangles.size(); ++n5) {
            graphicPrimitive = (Rectangle)this.myRectangles.get(n5);
            if (!graphicPrimitive.isSelectable() || !(((Rectangle)graphicPrimitive).leftX <= (double)(n + n2)) || !(((Rectangle)graphicPrimitive).leftX + ((Rectangle)graphicPrimitive).width >= (double)(n - n2)) || !(((Rectangle)graphicPrimitive).topY <= (double)(n3 + n4)) || !(((Rectangle)graphicPrimitive).topY + ((Rectangle)graphicPrimitive).height >= (double)(n3 - n4))) continue;
            if (primitiveStyle == null) {
                return graphicPrimitive;
            }
            if (!graphicPrimitive.getStyle().equals(primitiveStyle)) continue;
            return graphicPrimitive;
        }
        return null;
    }

    private boolean pointOverLine(double d, double d2, Line line) {
        double d3 = line.startX;
        double d4 = line.finishX;
        double d5 = line.startY;
        double d6 = line.finishY;
        double d7 = d4 - d3;
        double d8 = d6 - d5;
        double d9 = d - d3;
        double d10 = d2 - d5;
        double d11 = Math.sqrt(d7 * d7 + d8 * d8);
        if (d8 == 0.0) {
            d8 = 1.0;
        }
        if (d7 == 0.0) {
            d7 = 1.0;
        }
        if (d11 == 0.0) {
            d11 = 1.0;
        }
        double d12 = d9 * d8 / d7;
        double d13 = d10 - d12;
        double d14 = d12 / (d8 / d11);
        double d15 = d13 * d8 / d11;
        double d16 = d13 * d7 / d11;
        double d17 = d14 + d15;
        boolean bl = d17 <= d11 + 2.0 && d17 >= -2.0;
        boolean bl2 = d16 <= this.distanceFromPointToLine && d16 >= -this.distanceFromPointToLine;
        return bl && bl2;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public class Text
    extends GraphicPrimitive {
        private final double myLeftX;
        private final double myBottomY;
        private final String myText;
        private Font myFont;
        private double myMaxLength;

        Text(double d, double d2, String string, boolean bl) {
            super(bl);
            this.myLeftX = d;
            this.myBottomY = d2;
            this.myText = string;
            this.myMaxLength = -1.0;
        }

        public void setFont(Font font) {
            this.myFont = font;
        }

        public void setMaxLength(double d) {
            this.myMaxLength = d;
        }

        public double getMaxLength() {
            return this.myMaxLength;
        }

        public Font getFont() {
            return this.myFont;
        }

        public String getText() {
            return this.myText;
        }

        public double getLeftX() {
            return this.myLeftX;
        }

        public double getBottomY() {
            return this.myBottomY;
        }
    }

    public class Image
    extends GraphicPrimitive {
        private final double leftX;
        private final double topY;
        private Icon icon;
        private Icon highlightedIcon;
        private MouseHoover mouseHoover;

        public Image(double d, double d2, Icon icon, Icon icon2, boolean bl) {
            super(bl);
            this.mouseHoover = new MouseHoover();
            this.leftX = d;
            this.topY = d2;
            this.icon = icon;
            this.highlightedIcon = icon2;
        }

        public double getLeftX() {
            return this.leftX;
        }

        public double getTopY() {
            return this.topY;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public Icon getHighlightedIcon() {
            return this.highlightedIcon;
        }

        MouseHoover getMouseHoover() {
            return this.mouseHoover;
        }
    }

    public class Line
    extends GraphicPrimitive {
        protected double startX;
        protected double startY;
        protected double finishX;
        protected double finishY;

        protected Line(double d, double d2, double d3, double d4, boolean bl) {
            super(bl);
            this.startX = d;
            this.startY = d2;
            this.finishX = d3;
            this.finishY = d4;
        }

        public double getFinishX() {
            return this.finishX;
        }

        public double getFinishY() {
            return this.finishY;
        }

        public double getStartX() {
            return this.startX;
        }

        public double getStartY() {
            return this.startY;
        }
    }

    public class Rectangle
    extends GraphicPrimitive {
        private final double leftX;
        private final double topY;
        private final double width;
        private final double height;

        Rectangle(double d, double d2, double d3, double d4, boolean bl) {
            super(bl);
            this.leftX = d;
            this.topY = d2;
            this.width = d3;
            this.height = d4;
        }

        public double getRightX() {
            return this.leftX + this.width;
        }

        public double getBottomY() {
            return this.topY + this.height;
        }

        public String toString() {
            return "leftx=" + this.leftX + " topy=" + this.topY + " width=" + this.width + " height=" + this.height;
        }

        public double getMiddleY() {
            return this.topY + this.height / 2.0;
        }

        public double getMiddleX() {
            return this.leftX + this.width / 2.0;
        }

        public double getLeftX() {
            return this.leftX;
        }

        public double getTopY() {
            return this.topY;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }
    }

    public class RectangleArrayPart
    extends Rectangle {
        int part;

        RectangleArrayPart(double d, double d2, double d3, double d4, boolean bl, int n) {
            super(d, d2, d3, d4, bl);
            this.part = n;
        }

        public int getPartNo() {
            return this.part;
        }
    }

    public class MultiLine
    extends Line {
        private List lines;

        private MultiLine(double d, double d2, double d3, double d4, boolean bl) {
            super(d, d2, d3, d4, bl);
            this.lines = new LinkedList();
            this.lines.add(new Line(d, d2, d3, d2, false));
            this.lines.add(new Line(d3, d2, d3, d4, false));
        }
    }

    public class GraphicPrimitive {
        private Color myBackgroundColor;
        private Color myForegroundColor;
        private PrimitiveStyle myStyle;
        private Object myModelObject;
        private boolean selectable;

        public boolean isSelectable() {
            return this.selectable;
        }

        public GraphicPrimitive(boolean bl) {
            this.selectable = bl;
        }

        public void setStyle(PrimitiveStyle primitiveStyle) {
            this.myStyle = primitiveStyle;
        }

        public PrimitiveStyle getStyle() {
            return this.myStyle;
        }

        public Color getBackgroundColor() {
            return this.myBackgroundColor;
        }

        public void setBackgroundColor(Color color) {
            this.myBackgroundColor = color;
        }

        public Color getForegroundColor() {
            return this.myForegroundColor;
        }

        public void setForegroundColor(Color color) {
            this.myForegroundColor = color;
        }

        public Object getModelObject() {
            return this.myModelObject;
        }

        public void setModelObject(Object object) {
            this.myModelObject = object;
        }
    }
}

