/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart;

import com.sbs.jpm.Common;
import com.sbs.jpm.configuration.Configuration;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.field.FieldAdapter;
import com.sbs.jpm.core.field.FieldEvent;
import com.sbs.jpm.core.field.FieldManager;
import com.sbs.jpm.print.CustomPageable;
import com.sbs.jpm.print.PrintManager;
import com.sbs.jpm.ui.UIManager;
import com.sbs.jpm.ui.component.JRowHeader;
import com.sbs.jpm.ui.component.view.JProjectViewWBS;
import com.sbs.jpm.ui.treetablechart.JTaskTreeTable;
import com.sbs.jpm.ui.treetablechart.JTreeTable;
import com.sbs.jpm.ui.treetablechart.TaskHighlighter;
import com.sbs.jpm.ui.treetablechart.model.ChartTreeTableModel;
import com.sbs.jpm.ui.treetablechart.model.TaskTreeTableModel;
import com.sbs.jpm.ui.treetablechart.model.WBSTreeTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.treetable.TreeTableModel;

public class JWBSTreeTable
extends JTaskTreeTable
implements Printable,
CustomPageable {
    public JWBSTreeTable() {
        super(null, (TreeTableModel)new WBSTreeTableModel());
        this.addHighlighter((Highlighter)new TaskHighlighter(0));
        this.setHorizontalScrollEnabled(false);
        this.setRootVisible(UIManager.getInstance().isShowProjectRoot());
        FieldManager.getInstance().addFieldListener(new FieldAdapter(){

            public void taskNameChanged(FieldEvent fieldEvent) {
                int n = fieldEvent.getTaskIndex();
                String string = fieldEvent.getName();
                int n2 = JWBSTreeTable.this.getModel().getColumnCount() - 10 + n;
                String string2 = JWBSTreeTable.this.getModel().getColumnName(n2);
                ((ChartTreeTableModel)JWBSTreeTable.this.getTreeTableModel()).setColumnName(n2, string);
                JWBSTreeTable.this.getColumnExt(string2).setHeaderValue((Object)string);
                JWBSTreeTable.this.getTableHeader().resizeAndRepaint();
            }
        });
    }

    public void setProject(Task task) {
        super.setProject(task);
        this.getColumnExt(TaskTreeTableModel.INFO).setVisible(false);
        this.getColumnExt(TaskTreeTableModel.DURATION).setVisible(false);
        this.getColumnExt(TaskTreeTableModel.ACTUAL_DURATION).setVisible(false);
        this.getColumnExt(TaskTreeTableModel.REMAINING_DURATION).setVisible(false);
        this.getColumnExt(TaskTreeTableModel.START).setVisible(false);
        this.getColumnExt(TaskTreeTableModel.ACTUAL_START).setVisible(false);
        this.getColumnExt(TaskTreeTableModel.END).setVisible(false);
        this.getColumnExt(TaskTreeTableModel.ACTUAL_END).setVisible(false);
        this.getColumnExt(TaskTreeTableModel.CALENDAR).setVisible(false);
        this.getColumnExt(TaskTreeTableModel.PERCENT_COMPLETE).setVisible(false);
        this.getColumnExt(TaskTreeTableModel.PERCENT_WORK_COMPLETE).setVisible(false);
        this.getColumnExt(TaskTreeTableModel.DEADLINE).setVisible(false);
        this.getColumnExt(TaskTreeTableModel.FIXED_COST).setVisible(false);
        this.getColumnExt(TaskTreeTableModel.ACCRUAL).setVisible(false);
        this.getColumnExt(TaskTreeTableModel.WORK).setVisible(false);
        this.getColumnExt(TaskTreeTableModel.ACTUAL_WORK).setVisible(false);
        this.getColumnExt(TaskTreeTableModel.REMAINING_WORK).setVisible(false);
        this.getColumnExt(TaskTreeTableModel.COST).setVisible(false);
        this.getColumnExt(TaskTreeTableModel.ACTUAL_COST).setVisible(false);
        this.getColumnExt(TaskTreeTableModel.REMAINING_COST).setVisible(false);
        this.getColumnExt(TaskTreeTableModel.RESOURCE_NAME).setVisible(false);
        this.getColumnExt(TaskTreeTableModel.RESOURCE_CODE).setVisible(false);
        Configuration.getInstance().loadColumnsSettings();
    }

    protected ChartTreeTableModel createModel(Task task) {
        return new WBSTreeTableModel((JTreeTable)this, task);
    }

    protected void setHeaderWidths() {
        super.setHeaderWidths();
        this.getColumn(TaskTreeTableModel.TASK_NAME).setMinWidth(50);
        this.getColumn(TaskTreeTableModel.TASK_NAME).setPreferredWidth(800);
    }

    private void computeValues() {
        PageFormat pageFormat = this.getPageFormat(0);
        this.pageHeight = pageFormat.getImageableHeight() * 1.3 / PrintManager.ZOOM - 2.0 - 20.0;
        this.pageWidth = pageFormat.getImageableWidth() * 1.3 / PrintManager.ZOOM - 2.0 - 2.0;
        this.tableWidth = (double)this.getColumnModel().getTotalColumnWidth() + (double)((JProjectViewWBS)this.projectView).getRowHeader().getWidth();
        this.headerHeightOnPage = this.getTableHeader().getHeight();
        double d = this.getRowHeight();
        if (PrintManager.isShowHeader()) {
            int n = (int)((this.pageHeight - this.headerHeightOnPage) / d);
            this.totalVerticalNumPages = (int)Math.ceil(((double)this.getRowCount() - 50.0) / (double)n);
        } else {
            int n = (int)(this.pageHeight / d);
            int n2 = (int)((this.pageHeight - this.headerHeightOnPage) / d);
            this.totalVerticalNumPages = (int)Math.ceil(((double)this.getRowCount() - 50.0 - (double)n2) / (double)n) + 1;
        }
        this.totalHorizontalNumPages = (int)Math.ceil(this.tableWidth / this.pageWidth);
    }

    public int getNumberOfPages() {
        this.computeValues();
        return this.totalHorizontalNumPages * this.totalVerticalNumPages;
    }

    public Dimension getPrintSize() {
        Dimension dimension = new Dimension();
        dimension.setSize(((JProjectViewWBS)this.projectView).getRowHeader().getWidth() + this.getWidth(), this.getHeight() - 50 * this.getRowHeight());
        return dimension;
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        return Common.getApplication().getPageFormat();
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        return this;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.computeValues();
        this.clearSelection();
        this.getTableHeader().setBackground(Color.WHITE);
        ((JProjectViewWBS)this.projectView).getRowHeader().setBackground(Color.WHITE);
        this.setBackground(Color.WHITE);
        graphics2D.scale(1.0 / (1.3 / PrintManager.ZOOM), 1.0 / (1.3 / PrintManager.ZOOM));
        graphics2D.setColor(Color.BLACK);
        int n3 = graphics2D.getFontMetrics().getDescent();
        double d = this.getRowHeight();
        int n4 = (int)((this.pageHeight - this.headerHeightOnPage) / d);
        int n5 = (int)(this.pageHeight / d);
        double d2 = d * (double)n4;
        double d3 = d * (double)n5;
        int n6 = this.totalHorizontalNumPages;
        int n7 = this.totalHorizontalNumPages * this.totalVerticalNumPages;
        if (n >= n7) {
            return 1;
        }
        graphics2D.translate(pageFormat.getImageableX() * 1.3 / PrintManager.ZOOM, pageFormat.getImageableY() * 1.3 / PrintManager.ZOOM);
        graphics2D.drawLine(0, 1, 2 + (int)this.pageWidth + 2, 1);
        graphics2D.drawLine(0, (int)(2.0 + this.pageHeight), 2 + (int)this.pageWidth + 1, (int)(2.0 + this.pageHeight));
        graphics2D.drawLine(0, (int)(2.0 + this.pageHeight + 20.0), 2 + (int)this.pageWidth + 2, (int)(2.0 + this.pageHeight + 20.0));
        graphics2D.drawLine(0, 2, 0, (int)(2.0 + this.pageHeight + 20.0));
        graphics2D.drawLine(2 + (int)this.pageWidth + 2, 2, 2 + (int)this.pageWidth + 2, (int)(2.0 + this.pageHeight + 20.0));
        String string = Common.I18N_RP.getString("project") + ": " + this.project.getName() + "     " + Common.I18N_RP.getString("manager") + ": " + this.project.getManager();
        graphics2D.drawString(string, 2, (int)(2.0 + this.pageHeight + 20.0 - (double)n3));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd, yyyy");
        string = Common.I18N_RP.getString("page") + ": " + (n + 1) + "/" + this.getNumberOfPages() + "     " + Common.I18N_RP.getString("date") + ": " + simpleDateFormat.format(new Date());
        int n8 = graphics2D.getFontMetrics().stringWidth(string);
        graphics2D.drawString(string, (int)(2.0 + this.pageWidth - (double)n8), (int)(2.0 + this.pageHeight + 20.0 - (double)n3));
        graphics2D.translate(2, 2);
        int n9 = n / this.totalHorizontalNumPages;
        int n10 = n % this.totalHorizontalNumPages;
        JRowHeader jRowHeader = ((JProjectViewWBS)this.projectView).getRowHeader();
        int n11 = n10 < n6 - 1 ? (n10 == 0 ? (int)Math.ceil(this.pageWidth) - ((JProjectViewWBS)this.projectView).getRowHeader().getWidth() : (int)Math.ceil(this.pageWidth)) : (int)Math.ceil(this.tableWidth - (double)n10 * this.pageWidth);
        if (n9 + 1 == this.totalVerticalNumPages) {
            if (!PrintManager.isShowHeader()) {
                int n12 = n9 == 0 ? 0 : n4 + n5 * (n9 - 1);
                int n13 = this.getRowCount() - 50 - n12;
                n2 = (int)Math.ceil(d * (double)n13);
            } else {
                int n14 = n4 * n9;
                int n15 = this.getRowCount() - 50 - n14;
                n2 = (int)Math.ceil(d * (double)n15);
            }
        } else {
            n2 = !PrintManager.isShowHeader() ? (n9 == 0 ? (int)Math.ceil(d2) : (int)Math.ceil(d3)) : (int)Math.ceil(d2);
        }
        if (n9 == 0 || n9 != 0 && PrintManager.isShowHeader()) {
            graphics2D.translate((double)(-n10) * this.pageWidth + (double)jRowHeader.getWidth(), 0.0);
            if (n10 == 0) {
                graphics2D.setClip((int)((double)n10 * this.pageWidth), 0, n11, (int)Math.ceil(this.headerHeightOnPage));
            } else {
                graphics2D.setClip((int)((double)n10 * this.pageWidth) - jRowHeader.getWidth(), 0, n11, (int)Math.ceil(this.headerHeightOnPage));
            }
            PrintManager.bufferAndPaint(graphics2D, this.getTableHeader());
            graphics2D.translate((double)n10 * this.pageWidth - (double)jRowHeader.getWidth(), this.headerHeightOnPage);
        }
        if (n10 == 0) {
            if (PrintManager.isShowHeader()) {
                graphics2D.translate((double)(-n10) * this.pageWidth, (double)(-((int)(d2 * (double)n9))));
            } else if (n9 == 0) {
                graphics2D.translate((double)(-n10) * this.pageWidth, 0.0);
            } else {
                graphics2D.translate((double)(-n10) * this.pageWidth, (double)(-((int)(d2 + d3 * (double)(n9 - 1)))));
            }
            if (PrintManager.isShowHeader()) {
                graphics2D.setClip((int)((double)n10 * this.pageWidth), (int)(d2 * (double)n9), jRowHeader.getWidth(), n2);
            } else if (n9 == 0) {
                graphics2D.setClip((int)((double)n10 * this.pageWidth), 0, jRowHeader.getWidth(), n2);
            } else {
                graphics2D.setClip((int)((double)n10 * this.pageWidth), (int)(d2 + d3 * (double)(n9 - 1)), jRowHeader.getWidth(), n2);
            }
            PrintManager.bufferAndPaint(graphics2D, jRowHeader);
            if (PrintManager.isShowHeader()) {
                graphics2D.translate((double)n10 * this.pageWidth, (double)((int)(d2 * (double)n9)));
            } else if (n9 == 0) {
                graphics2D.translate((double)n10 * this.pageWidth, 0.0);
            } else {
                graphics2D.translate((double)n10 * this.pageWidth, (double)((int)(d2 + d3 * (double)(n9 - 1))));
            }
        }
        if (PrintManager.isShowHeader()) {
            graphics2D.translate((double)(-n10) * this.pageWidth + (double)jRowHeader.getWidth(), (double)(-((int)(d2 * (double)n9))));
        } else if (n9 == 0) {
            graphics2D.translate((double)(-n10) * this.pageWidth + (double)jRowHeader.getWidth(), 0.0);
        } else {
            graphics2D.translate((double)(-n10) * this.pageWidth + (double)jRowHeader.getWidth(), (double)(-((int)(d2 + d3 * (double)(n9 - 1)))));
        }
        if (PrintManager.isShowHeader()) {
            if (n10 == 0) {
                graphics2D.setClip((int)((double)n10 * this.pageWidth), (int)(d2 * (double)n9), n11, n2);
            } else {
                graphics2D.setClip((int)((double)n10 * this.pageWidth) - jRowHeader.getWidth(), (int)(d2 * (double)n9), n11, n2);
            }
        } else if (n10 == 0) {
            if (n9 == 0) {
                graphics2D.setClip((int)((double)n10 * this.pageWidth), 0, n11, n2);
            } else {
                graphics2D.setClip((int)((double)n10 * this.pageWidth), (int)(d2 + d3 * (double)(n9 - 1)), n11, n2);
            }
        } else if (n9 == 0) {
            graphics2D.setClip((int)((double)n10 * this.pageWidth) - jRowHeader.getWidth(), 0, n11, n2);
        } else {
            graphics2D.setClip((int)((double)n10 * this.pageWidth) - jRowHeader.getWidth(), (int)(d2 + d3 * (double)(n9 - 1)), n11, n2);
        }
        PrintManager.bufferAndPaint(graphics2D, (Component)((Object)this));
        if (PrintManager.isShowHeader()) {
            graphics2D.translate((double)n10 * this.pageWidth - (double)jRowHeader.getWidth(), (double)((int)(d2 * (double)n9)));
        } else if (n9 == 0) {
            graphics2D.translate((double)n10 * this.pageWidth - (double)jRowHeader.getWidth(), (double)((int)(d2 * (double)n9)));
        } else {
            graphics2D.translate((double)n10 * this.pageWidth - (double)jRowHeader.getWidth(), (double)((int)(d2 + d3 * (double)(n9 - 1))));
        }
        if (n9 == 0 || n9 != 0 && PrintManager.isShowHeader()) {
            graphics2D.translate(0.0, -this.headerHeightOnPage);
        }
        graphics2D.translate(-2, -2);
        graphics2D.translate(-pageFormat.getImageableX() * 1.3 / PrintManager.ZOOM, -pageFormat.getImageableY() * 1.3 / PrintManager.ZOOM);
        this.getTableHeader().setBackground((Color)javax.swing.UIManager.get("TableHeader.background"));
        this.setBackground((Color)javax.swing.UIManager.get("Table.background"));
        jRowHeader.setBackground((Color)javax.swing.UIManager.get("TableHeader.background"));
        return 0;
    }

    public int getHorizontalNumberOfPages() {
        this.computeValues();
        return this.totalHorizontalNumPages;
    }

    public int getVerticalNumberOfPages() {
        this.computeValues();
        return this.totalVerticalNumPages;
    }
}

