/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.field.FieldManager;
import com.sbs.jpm.ui.UIManager;
import com.sbs.jpm.ui.action.ActionMapper;
import com.sbs.jpm.ui.component.JEditTaskColumnDialog;
import com.sbs.jpm.ui.component.JInsertColumnDialog;
import com.sbs.jpm.ui.component.JProjectView;
import com.sbs.jpm.ui.treetablechart.JEPSTreeTable;
import com.sbs.jpm.ui.treetablechart.JResourceTreeTable;
import com.sbs.jpm.ui.treetablechart.JTreeTableChart;
import com.sbs.jpm.ui.treetablechart.model.ChartTreeTableModel;
import com.sbs.jpm.undo.UndoHandler;
import com.sbs.util.SystemUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.treetable.TreeTableModel;

public abstract class JTreeTable
extends JXTreeTable {
    protected JTreeTableChart treeTableChart;
    protected Task project;
    protected JProjectView projectView;
    protected EventListenerList listeners;
    protected UndoHandler undoHandler;
    protected JPopupMenu headerPopup;
    protected JMenuItem insertItem;
    protected JMenuItem hideItem;
    protected JMenuItem editItem;
    private int popupColumn;

    public JTreeTable(JTreeTableChart jTreeTableChart, TreeTableModel treeTableModel) {
        super(treeTableModel);
        this.treeTableChart = jTreeTableChart;
        this.listeners = new EventListenerList();
        this.initTreeTable();
        this.headerPopup = new JPopupMenu();
        this.hideItem = new JMenuItem(Common.I18N_ACTIONS.getString("hideColumn"));
        this.hideItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTreeTable.this.getColumnExt(JTreeTable.this.popupColumn).setVisible(false);
            }
        });
        this.insertItem = new JMenuItem(Common.I18N_ACTIONS.getString("insertColumn") + "...");
        this.insertItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                List list = JTreeTable.this.getColumns(true);
                List list2 = JTreeTable.this.getColumns();
                list.removeAll(list2);
                if (!list.isEmpty()) {
                    JInsertColumnDialog jInsertColumnDialog = new JInsertColumnDialog((JXTable)JTreeTable.this, list, JTreeTable.this.popupColumn);
                    jInsertColumnDialog.pack();
                    jInsertColumnDialog.setLocationRelativeTo(Common.getApplication());
                    jInsertColumnDialog.setVisible(true);
                }
            }
        });
        this.editItem = new JMenuItem(Common.I18N_ACTIONS.getString("editColumn") + "...");
        this.editItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JEditTaskColumnDialog jEditTaskColumnDialog = new JEditTaskColumnDialog((JXTable)JTreeTable.this, JTreeTable.this.popupColumn);
                jEditTaskColumnDialog.pack();
                jEditTaskColumnDialog.setLocationRelativeTo(Common.getApplication());
                jEditTaskColumnDialog.setVisible(true);
            }
        });
        this.headerPopup.add(this.hideItem);
        this.headerPopup.add(this.insertItem);
        this.headerPopup.add(this.editItem);
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            private void showPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    JTreeTable.this.popupColumn = JTreeTable.this.getTableHeader().columnAtPoint(mouseEvent.getPoint());
                    if (JTreeTable.this.popupColumn != -1) {
                        List list = JTreeTable.this.getColumns(true);
                        List list2 = JTreeTable.this.getColumns();
                        list.removeAll(list2);
                        JTreeTable.this.insertItem.setEnabled(!list.isEmpty());
                        int n = JTreeTable.this.convertColumnIndexToModel(JTreeTable.this.popupColumn);
                        if (JTreeTable.this instanceof JResourceTreeTable || JTreeTable.this instanceof JEPSTreeTable) {
                            JTreeTable.this.editItem.setVisible(false);
                        } else {
                            JTreeTable.this.editItem.setVisible(true);
                        }
                        JTreeTable.this.editItem.setEnabled(n >= JTreeTable.this.getModel().getColumnCount() - 10 && JTreeTable.this.popupColumn != -1);
                        JTreeTable.this.headerPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        });
        if (SystemUtilities.isOSMac()) {
            this.setHighlighters(new Highlighter[]{new HighlighterFactory.UIColorHighlighter(HighlightPredicate.EVEN)});
            this.setShowHorizontalLines(false);
        }
        ActionMapper actionMapper = ActionMapper.getInstance();
        actionMapper.mapActions((JComponent)((Object)this));
    }

    public boolean isCellEditable(int n, int n2) {
        return super.isCellEditable(n, n2);
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        if (this.isHierarchical(n2)) {
            DefaultCellEditor defaultCellEditor = (DefaultCellEditor)super.getCellEditor(n, n2);
            ((JTextField)defaultCellEditor.getComponent()).setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
            return defaultCellEditor;
        }
        return super.getCellEditor(n, n2);
    }

    public void setAutoResizeMode(int n) {
        super.setAutoResizeMode(0);
    }

    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        Component component = super.prepareEditor(tableCellEditor, n, n2);
        if (component instanceof JTextComponent) {
            ((JTextField)component).selectAll();
        }
        return component;
    }

    protected JXTreeTable.TreeTableHacker createTreeTableHacker() {
        return new JXTreeTable.TreeTableHackerExt2((JXTreeTable)this);
    }

    protected void initTreeTable() {
        this.setColumnControlVisible(true);
        this.setHorizontalScrollEnabled(true);
        this.setExpandsSelectedPaths(false);
        this.setOpenIcon(null);
        this.setClosedIcon(null);
        this.setLeafIcon(null);
        this.setShowGrid(true, true);
        if (SystemUtilities.isOSMac()) {
            this.setSurrendersFocusOnKeystroke(false);
        } else {
            this.setSurrendersFocusOnKeystroke(true);
        }
        this.setHeaderWidths();
        this.setRenderersAndEditors();
        this.setTreeCellRenderer(new TreeTableCellRenderer());
    }

    public void setProject(Task task) {
        this.project = task;
        this.removeUndoableEditListener(this.undoHandler);
        ((ChartTreeTableModel)this.getTreeTableModel()).removeUndoableEditListener(this.undoHandler);
        ((ChartTreeTableModel)this.getTreeTableModel()).removeRootListeners();
        this.undoHandler = new UndoHandler(task.getCompany().getUndoManager());
        this.addUndoableEditListener(this.undoHandler);
        ChartTreeTableModel chartTreeTableModel = this.createModel(task);
        chartTreeTableModel.addUndoableEditListener(this.undoHandler);
        this.setTreeTableModel((TreeTableModel)chartTreeTableModel);
        this.setHeaderWidths();
        this.setRenderersAndEditors();
        if (!(this instanceof JEPSTreeTable) && !(this instanceof JResourceTreeTable)) {
            for (int i = 1; i <= 10; ++i) {
                this.getColumnExt(FieldManager.CUSTOM_NAME + i).setVisible(false);
            }
        }
    }

    protected abstract ChartTreeTableModel createModel(Task var1);

    protected abstract void setHeaderWidths();

    protected abstract void setRenderersAndEditors();

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.treeTableChart != null) {
            this.treeTableChart.getArea().repaint();
        }
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    protected void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(UndoableEditListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((UndoableEditListener)eventListenerArray[i]).undoableEditHappened(undoableEditEvent);
        }
    }

    public Task getProject() {
        return this.project;
    }

    public JProjectView getProjectView() {
        return this.projectView;
    }

    public void setProjectView(JProjectView jProjectView) {
        this.projectView = jProjectView;
    }

    public JTreeTableChart getTreeTableChart() {
        return this.treeTableChart;
    }

    private class TreeTableCellRenderer
    extends DefaultTreeCellRenderer {
        private String shortText;
        private final Rectangle iconRect = new Rectangle();
        private final Rectangle textRect = new Rectangle();
        private final Rectangle itemRect = new Rectangle();

        private TreeTableCellRenderer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics graphics) {
            String string = super.getText();
            this.shortText = SwingUtilities.layoutCompoundLabel(this, graphics.getFontMetrics(), string, this.getIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), this.getItemRect(this.itemRect), this.iconRect, this.textRect, this.getIconTextGap());
            try {
                this.setText(this.shortText);
                super.paint(graphics);
            }
            finally {
                this.setText(string);
            }
        }

        private Rectangle getItemRect(Rectangle rectangle) {
            this.getBounds(rectangle);
            rectangle.width = JTreeTable.this.getColumn(JTreeTable.this.getHierarchicalColumn()).getWidth() - rectangle.x;
            return rectangle;
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (object instanceof Task) {
                Task task = (Task)object;
                String string = task.isEmpty() ? "" : (UIManager.getInstance().isShowTaskOutline() ? task.getOutlineNumber() + " " + task.getName() : task.getName());
                return super.getTreeCellRendererComponent(jTree, string, bl, bl2, bl3, n, bl4);
            }
            if (object instanceof Assignment) {
                Task task = ((Assignment)object).getTask();
                String string = task.isEmpty() ? "" : (UIManager.getInstance().isShowTaskOutline() ? task.getOutlineNumber() + " " + task.getName() : task.getName());
                return super.getTreeCellRendererComponent(jTree, string, bl, bl2, bl3, n, bl4);
            }
            return super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        }
    }
}

