/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.ui.treetablechart.JArea;
import com.sbs.jpm.ui.treetablechart.chart.Painter;
import com.sbs.jpm.ui.treetablechart.mouse.MouseInteraction;
import com.sbs.jpm.ui.treetablechart.mouse.TimeScaleMouseDispatcher;
import com.sbs.jpm.ui.treetablechart.time.TimeScaleManager;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import javax.swing.Scrollable;

public class JTimeScaleArea
extends JPanel
implements Scrollable {
    protected Task project;
    protected Painter painter;
    protected TimeScaleMouseDispatcher mouseDispatcher;
    protected JArea area;

    public JTimeScaleArea(JArea jArea) {
        this.area = jArea;
        this.setToolTipText("");
        this.mouseDispatcher = new TimeScaleMouseDispatcher(this);
        this.addMouseMotionListener(this.mouseDispatcher);
        this.addMouseListener(this.mouseDispatcher);
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.isControlDown()) {
                    if (mouseWheelEvent.getWheelRotation() > 0) {
                        JTimeScaleArea.this.getTimeScaleManager().zoomOut();
                    } else if (mouseWheelEvent.getWheelRotation() < 0) {
                        JTimeScaleArea.this.getTimeScaleManager().zoomIn();
                    }
                }
            }
        });
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Rectangle2D rectangle2D = this.getTimeScaleManager().getFocusRectangle();
        if (rectangle2D.contains(mouseEvent.getPoint())) {
            return Common.I18N_ACTIONS.getString("scaleArea.zoomFocusPoint");
        }
        return Common.I18N_ACTIONS.getString("scaleArea.dragToZoom");
    }

    public void setProject(Task task) {
        this.project = task;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.painter.setGraphics(graphics);
        this.getTimeScaleManager().paint(this.painter, graphics);
        MouseInteraction mouseInteraction = this.mouseDispatcher.getCurrentMouseInteraction();
        if (mouseInteraction != null) {
            mouseInteraction.paint(graphics);
        }
    }

    public int getTimeScaleHeight() {
        return this.getTimeScaleManager().getCurrentScaleCombination().getHeight();
    }

    public TimeScaleManager getTimeScaleManager() {
        return this.area.getTimeScaleManager();
    }

    public Dimension getPreferredSize() {
        if (this.project != null) {
            return new Dimension((int)((double)(this.project.getEndDate().getTime() - this.project.getStartDate().getTime()) / this.getTimeScaleManager().getPixelDuration()) + 3200, this.getTimeScaleManager().getCurrentScaleCombination().getHeight());
        }
        return new Dimension(100, 40);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getSize();
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            return 0;
        }
        return 10 * this.getTimeScaleManager().getCurrentBottomUnitSize();
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            return 0;
        }
        return this.getTimeScaleManager().getCurrentBottomUnitSize();
    }

    public void setPainter(Painter painter) {
        this.painter = painter;
    }

    public JArea getArea() {
        return this.area;
    }
}

