/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart;

import com.sbs.jpm.Common;
import com.sbs.jpm.print.CustomPageable;
import com.sbs.jpm.print.PrintManager;
import com.sbs.jpm.ui.treetablechart.JArea;
import com.sbs.jpm.ui.treetablechart.JTaskArea;
import com.sbs.jpm.ui.treetablechart.JTaskSheetTreeTable;
import com.sbs.jpm.ui.treetablechart.JTreeTable;
import com.sbs.jpm.ui.treetablechart.JTreeTableChart;
import com.sbs.jpm.ui.treetablechart.time.TimeFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.UIManager;

public class JTaskChart
extends JTreeTableChart
implements Printable,
CustomPageable {
    private int totalVerticalNumPages;
    private int totalHorizontalNumPages;
    private double pageHeight;
    private double pageWidth;
    private double headerHeightOnPage;
    private double tableWidth;
    private double ganttWidth;

    protected JTreeTable createTreeTable() {
        return new JTaskSheetTreeTable(this);
    }

    protected JArea createArea() {
        return new JTaskArea((JTreeTableChart)this, (JTaskSheetTreeTable)this.treeTable);
    }

    private void computeValues() {
        PageFormat pageFormat = this.getPageFormat(0);
        this.pageHeight = pageFormat.getImageableHeight() * 1.3 / PrintManager.ZOOM - 2.0 - 20.0;
        this.pageWidth = pageFormat.getImageableWidth() * 1.3 / PrintManager.ZOOM - 2.0 - 2.0;
        boolean bl = this.treeTable.getVisibleRect().width > 0;
        boolean bl2 = this.area.getChartArea().getVisibleRect().width > 0;
        this.tableWidth = 0.0;
        this.ganttWidth = 0.0;
        if (bl) {
            this.tableWidth = (double)this.treeTable.getColumnModel().getTotalColumnWidth() + (double)this.rowHeader.getWidth();
            this.ganttWidth += Math.ceil(this.tableWidth);
        }
        if (bl2) {
            TimeFrame timeFrame = new TimeFrame(PrintManager.getStartInterval(), PrintManager.getEndInterval());
            this.ganttWidth += Math.ceil(this.area.getTimeScaleManager().getWidth(timeFrame) + (double)(2 * this.area.getTimeScaleManager().getCurrentBottomUnitSize()));
        }
        this.headerHeightOnPage = this.area.getTimeScaleArea().getTimeScaleHeight();
        double d = this.treeTable.getRowHeight();
        if (PrintManager.isShowHeader()) {
            int n = (int)((this.pageHeight - this.headerHeightOnPage) / d);
            this.totalVerticalNumPages = (int)Math.ceil(((double)this.treeTable.getRowCount() - 50.0) / (double)n);
        } else {
            int n = (int)(this.pageHeight / d);
            int n2 = (int)((this.pageHeight - this.headerHeightOnPage) / d);
            this.totalVerticalNumPages = (int)Math.ceil(((double)this.treeTable.getRowCount() - 50.0 - (double)n2) / (double)n) + 1;
        }
        this.totalHorizontalNumPages = (int)Math.ceil(this.ganttWidth / this.pageWidth);
    }

    public int getNumberOfPages() {
        this.computeValues();
        return this.totalHorizontalNumPages * this.totalVerticalNumPages;
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        return Common.getApplication().getPageFormat();
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        return this;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2;
        int n3;
        int n4;
        int n5;
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.computeValues();
        this.getTreeTable().clearSelection();
        this.getTreeTable().setBackground(Color.WHITE);
        this.rowHeader.setBackground(Color.WHITE);
        this.getTreeTable().getTableHeader().setBackground(Color.WHITE);
        this.getArea().getChartUIConfiguration().setTimescaleBackgroundColor(Color.WHITE);
        graphics2D.scale(1.0 / (1.3 / PrintManager.ZOOM), 1.0 / (1.3 / PrintManager.ZOOM));
        graphics2D.setColor(Color.BLACK);
        int n6 = graphics2D.getFontMetrics().getDescent();
        double d = this.treeTable.getRowHeight();
        int n7 = (int)((this.pageHeight - this.headerHeightOnPage) / d);
        int n8 = (int)(this.pageHeight / d);
        double d2 = d * (double)n7;
        double d3 = d * (double)n8;
        int n9 = this.totalHorizontalNumPages * this.totalVerticalNumPages;
        if (n >= n9) {
            return 1;
        }
        graphics2D.translate(pageFormat.getImageableX() * 1.3 / PrintManager.ZOOM, pageFormat.getImageableY() * 1.3 / PrintManager.ZOOM);
        graphics2D.drawLine(0, 1, 2 + (int)this.pageWidth + 2, 1);
        graphics2D.drawLine(0, (int)(2.0 + this.pageHeight), 2 + (int)this.pageWidth + 1, (int)(2.0 + this.pageHeight));
        graphics2D.drawLine(0, (int)(2.0 + this.pageHeight + 20.0), 2 + (int)this.pageWidth + 2, (int)(2.0 + this.pageHeight + 20.0));
        graphics2D.drawLine(0, 2, 0, (int)(2.0 + this.pageHeight + 20.0));
        graphics2D.drawLine(2 + (int)this.pageWidth + 2, 2, 2 + (int)this.pageWidth + 2, (int)(2.0 + this.pageHeight + 20.0));
        String string = Common.I18N_RP.getString("project") + ": " + this.project.getName() + "     " + Common.I18N_RP.getString("manager") + ": " + this.project.getManager();
        graphics2D.drawString(string, 2, (int)(2.0 + this.pageHeight + 20.0 - (double)n6));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd, yyyy");
        string = Common.I18N_RP.getString("page") + ": " + (n + 1) + "/" + this.getNumberOfPages() + "     " + Common.I18N_RP.getString("date") + ": " + simpleDateFormat.format(new Date());
        int n10 = graphics2D.getFontMetrics().stringWidth(string);
        graphics2D.drawString(string, (int)(2.0 + this.pageWidth - (double)n10), (int)(2.0 + this.pageHeight + 20.0 - (double)n6));
        graphics2D.translate(2, 2);
        int n11 = n / this.totalHorizontalNumPages;
        int n12 = n % this.totalHorizontalNumPages;
        boolean bl = this.treeTable.getVisibleRect().width > 0;
        int n13 = n5 = bl ? (int)Math.ceil(this.tableWidth / this.pageWidth) : 0;
        int n14 = n5 == 0 ? 0 : (n12 < n5 - 1 ? (n12 == 0 ? (int)Math.ceil(this.pageWidth) - this.rowHeader.getWidth() : (int)Math.ceil(this.pageWidth)) : (int)Math.ceil(this.tableWidth - (double)n12 * this.pageWidth));
        if (n11 + 1 == this.totalVerticalNumPages) {
            if (!PrintManager.isShowHeader()) {
                n4 = n11 == 0 ? 0 : n7 + n8 * (n11 - 1);
                n3 = this.treeTable.getRowCount() - 50 - n4;
                n2 = (int)Math.ceil(d * (double)n3);
            } else {
                n4 = n7 * n11;
                n3 = this.treeTable.getRowCount() - 50 - n4;
                n2 = (int)Math.ceil(d * (double)n3);
            }
        } else {
            n2 = !PrintManager.isShowHeader() ? (n11 == 0 ? (int)Math.ceil(d2) : (int)Math.ceil(d3)) : (int)Math.ceil(d2);
        }
        if (n11 == 0 || n11 != 0 && PrintManager.isShowHeader()) {
            graphics2D.translate((double)(-n12) * this.pageWidth + (double)this.rowHeader.getWidth(), 0.0);
            if (n12 == 0) {
                graphics2D.setClip((int)((double)n12 * this.pageWidth), 0, n14, (int)Math.ceil(this.headerHeightOnPage));
            } else {
                graphics2D.setClip((int)((double)n12 * this.pageWidth) - this.rowHeader.getWidth(), 0, n14, (int)Math.ceil(this.headerHeightOnPage));
            }
            PrintManager.bufferAndPaint(graphics2D, this.treeTable.getTableHeader());
            graphics2D.translate((double)n12 * this.pageWidth - (double)this.rowHeader.getWidth(), this.headerHeightOnPage);
        }
        if (n12 == 0) {
            if (PrintManager.isShowHeader()) {
                graphics2D.translate((double)(-n12) * this.pageWidth, (double)(-((int)(d2 * (double)n11))));
            } else if (n11 == 0) {
                graphics2D.translate((double)(-n12) * this.pageWidth, 0.0);
            } else {
                graphics2D.translate((double)(-n12) * this.pageWidth, (double)(-((int)(d2 + d3 * (double)(n11 - 1)))));
            }
            if (PrintManager.isShowHeader()) {
                graphics2D.setClip((int)((double)n12 * this.pageWidth), (int)(d2 * (double)n11), this.rowHeader.getWidth(), n2);
            } else if (n11 == 0) {
                graphics2D.setClip((int)((double)n12 * this.pageWidth), 0, this.rowHeader.getWidth(), n2);
            } else {
                graphics2D.setClip((int)((double)n12 * this.pageWidth), (int)(d2 + d3 * (double)(n11 - 1)), this.rowHeader.getWidth(), n2);
            }
            PrintManager.bufferAndPaint(graphics2D, this.rowHeader);
            if (PrintManager.isShowHeader()) {
                graphics2D.translate((double)n12 * this.pageWidth, (double)((int)(d2 * (double)n11)));
            } else if (n11 == 0) {
                graphics2D.translate((double)n12 * this.pageWidth, 0.0);
            } else {
                graphics2D.translate((double)n12 * this.pageWidth, (double)((int)(d2 + d3 * (double)(n11 - 1))));
            }
        }
        if (PrintManager.isShowHeader()) {
            graphics2D.translate((double)(-n12) * this.pageWidth + (double)this.rowHeader.getWidth(), (double)(-((int)(d2 * (double)n11))));
        } else if (n11 == 0) {
            graphics2D.translate((double)(-n12) * this.pageWidth + (double)this.rowHeader.getWidth(), 0.0);
        } else {
            graphics2D.translate((double)(-n12) * this.pageWidth + (double)this.rowHeader.getWidth(), (double)(-((int)(d2 + d3 * (double)(n11 - 1)))));
        }
        if (PrintManager.isShowHeader()) {
            if (n12 == 0) {
                graphics2D.setClip((int)((double)n12 * this.pageWidth), (int)(d2 * (double)n11), n14, n2);
            } else {
                graphics2D.setClip((int)((double)n12 * this.pageWidth) - this.rowHeader.getWidth(), (int)(d2 * (double)n11), n14, n2);
            }
        } else if (n12 == 0) {
            if (n11 == 0) {
                graphics2D.setClip((int)((double)n12 * this.pageWidth), 0, n14, n2);
            } else {
                graphics2D.setClip((int)((double)n12 * this.pageWidth), (int)(d2 + d3 * (double)(n11 - 1)), n14, n2);
            }
        } else if (n11 == 0) {
            graphics2D.setClip((int)((double)n12 * this.pageWidth) - this.rowHeader.getWidth(), 0, n14, n2);
        } else {
            graphics2D.setClip((int)((double)n12 * this.pageWidth) - this.rowHeader.getWidth(), (int)(d2 + d3 * (double)(n11 - 1)), n14, n2);
        }
        PrintManager.bufferAndPaint(graphics2D, (Component)((Object)this.treeTable));
        if (PrintManager.isShowHeader()) {
            graphics2D.translate((double)n12 * this.pageWidth - (double)this.rowHeader.getWidth(), (double)((int)(d2 * (double)n11)));
        } else if (n11 == 0) {
            graphics2D.translate((double)n12 * this.pageWidth - (double)this.rowHeader.getWidth(), (double)((int)(d2 * (double)n11)));
        } else {
            graphics2D.translate((double)n12 * this.pageWidth - (double)this.rowHeader.getWidth(), (double)((int)(d2 + d3 * (double)(n11 - 1))));
        }
        if (n11 == 0 || n11 != 0 && PrintManager.isShowHeader()) {
            graphics2D.translate(0.0, -this.headerHeightOnPage);
        }
        int n15 = n4 = this.area.getChartArea().getVisibleRect().width > 0 ? 1 : 0;
        if (n4 == 0) {
            n14 = 0;
            n3 = 0;
        } else if (n12 < n5 - 1) {
            n14 = 0;
            n3 = 0;
        } else if (n12 == n5 - 1) {
            n14 = n12 == this.totalHorizontalNumPages - 1 ? (int)Math.ceil(this.ganttWidth - this.tableWidth) : (int)Math.ceil((double)(n12 + 1) * this.pageWidth - this.tableWidth);
            n3 = 0;
        } else {
            n14 = n12 == this.totalHorizontalNumPages - 1 ? (int)(this.ganttWidth - (double)n12 * Math.ceil(this.pageWidth)) : (int)Math.ceil(this.pageWidth);
            n3 = (int)((double)n12 * this.pageWidth - this.tableWidth);
        }
        TimeFrame timeFrame = new TimeFrame(this.project.getStartDate(), PrintManager.getStartInterval());
        double d4 = 1600.0 + this.area.getTimeScaleManager().getWidth(timeFrame) - (double)this.area.getTimeScaleManager().getCurrentBottomUnitSize();
        n3 += (int)d4;
        if (n12 >= n5 - 1) {
            if (n11 == 0 || n11 != 0 && PrintManager.isShowHeader()) {
                graphics2D.translate(-d4 - (double)n12 * this.pageWidth + this.tableWidth, 0.0);
                graphics2D.setClip(n3, 0, n14, (int)Math.ceil(this.headerHeightOnPage));
                PrintManager.bufferAndPaint(graphics2D, this.area.getTimeScaleArea());
                graphics2D.translate(d4 + (double)n12 * this.pageWidth - this.tableWidth, this.headerHeightOnPage);
            }
            if (PrintManager.isShowHeader()) {
                graphics2D.translate(-d4 - (double)n12 * this.pageWidth + this.tableWidth, (double)(-n11) * d2);
            } else if (n11 == 0) {
                graphics2D.translate(-d4 - (double)n12 * this.pageWidth + this.tableWidth, 0.0);
            } else {
                graphics2D.translate(-d4 - (double)n12 * this.pageWidth + this.tableWidth, (double)(-((int)(d2 + d3 * (double)(n11 - 1)))));
            }
            if (PrintManager.isShowHeader()) {
                graphics2D.setClip(n3, (int)(d2 * (double)n11), n14, n2);
            } else if (n11 == 0) {
                graphics2D.setClip(n3, 0, n14, n2);
            } else {
                graphics2D.setClip(n3, (int)(d2 + d3 * (double)(n11 - 1)), n14, n2);
            }
            PrintManager.bufferAndPaint(graphics2D, this.area.getChartArea());
            if (PrintManager.isShowHeader()) {
                graphics2D.translate(d4 + (double)n12 * this.pageWidth - this.tableWidth, (double)n11 * d2);
            } else if (n11 == 0) {
                graphics2D.translate(d4 + (double)n12 * this.pageWidth - this.tableWidth, 0.0);
            } else {
                graphics2D.translate(d4 + (double)n12 * this.pageWidth - this.tableWidth, (double)((int)(d2 + d3 * (double)(n11 - 1))));
            }
            if (n11 == 0 || n11 != 0 && PrintManager.isShowHeader()) {
                graphics2D.translate(0.0, -this.headerHeightOnPage);
            }
        }
        graphics2D.translate(-2, -2);
        graphics2D.translate(-pageFormat.getImageableX() * 1.3 / PrintManager.ZOOM, -pageFormat.getImageableY() * 1.3 / PrintManager.ZOOM);
        this.getTreeTable().getTableHeader().setBackground((Color)UIManager.get("TableHeader.background"));
        this.getTreeTable().setBackground((Color)UIManager.get("Table.background"));
        this.rowHeader.setBackground((Color)UIManager.get("TableHeader.background"));
        this.getArea().getChartUIConfiguration().setTimescaleBackgroundColor(UIManager.getColor("TableHeader.background"));
        return 0;
    }

    public int getHorizontalNumberOfPages() {
        this.computeValues();
        return this.totalHorizontalNumPages;
    }

    public int getVerticalNumberOfPages() {
        this.computeValues();
        return this.totalVerticalNumPages;
    }

    public Dimension getPrintSize() {
        Dimension dimension = new Dimension();
        Date date = PrintManager.getStartInterval();
        Date date2 = PrintManager.getEndInterval();
        TimeFrame timeFrame = new TimeFrame(date, date2);
        dimension.setSize((double)(this.rowHeader.getWidth() + this.treeTable.getWidth()) + this.area.getTimeScaleManager().getWidth(timeFrame) + (double)(2 * this.area.getTimeScaleManager().getCurrentBottomUnitSize()), (double)(this.treeTable.getHeight() - 50 * this.treeTable.getRowHeight()));
        return dimension;
    }
}

