/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.DurationManager;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.print.CustomPageable;
import com.sbs.jpm.print.PrintManager;
import com.sbs.jpm.ui.UIManager;
import com.sbs.jpm.ui.action.ActionMapper;
import com.sbs.jpm.ui.component.JEditTaskColumnDialog;
import com.sbs.jpm.ui.component.JInsertColumnDialog;
import com.sbs.jpm.ui.component.JProjectView;
import com.sbs.jpm.ui.component.JRowHeader;
import com.sbs.jpm.ui.component.util.TaskDurationFormat;
import com.sbs.jpm.ui.component.view.JProjectViewEPS;
import com.sbs.jpm.ui.event.JApplicationEvent;
import com.sbs.jpm.ui.event.JApplicationListener;
import com.sbs.jpm.ui.treetablechart.model.EPSTableModel;
import com.sbs.jpm.undo.UndoHandler;
import com.sbs.util.SystemUtilities;
import com.standbysoft.component.date.DateSelectionException;
import com.standbysoft.component.date.swing.JDatePicker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class JEPSTable
extends JXTable
implements Printable,
CustomPageable {
    private int totalVerticalNumPages;
    private int totalHorizontalNumPages;
    private double pageHeight;
    private double pageWidth;
    private double headerHeightOnPage;
    private double tableWidth;
    private JDatePicker datePicker;
    protected Task project;
    protected JProjectView projectView;
    protected EventListenerList listeners = new EventListenerList();
    protected UndoHandler undoHandler;
    protected JPopupMenu headerPopup;
    protected JMenuItem insertItem;
    protected JMenuItem hideItem;
    protected JMenuItem editItem;
    private int popupColumn;
    private static final JFormattedTextField formattedTextField = new JFormattedTextField();

    public JEPSTable() {
        this(new EPSTableModel());
    }

    public JEPSTable(TableModel tableModel) {
        super(tableModel);
        this.setColumnControlVisible(true);
        this.setHorizontalScrollEnabled(true);
        if (SystemUtilities.isOSMac()) {
            this.setSurrendersFocusOnKeystroke(false);
        } else {
            this.setSurrendersFocusOnKeystroke(true);
        }
        this.setAutoCreateColumnsFromModel(false);
        this.setHeaderWidths();
        this.setRenderersAndEditors();
        this.headerPopup = new JPopupMenu();
        this.hideItem = new JMenuItem(Common.I18N_ACTIONS.getString("hideColumn"));
        this.hideItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JEPSTable.this.getColumnExt(JEPSTable.this.popupColumn).setVisible(false);
            }
        });
        this.insertItem = new JMenuItem(Common.I18N_ACTIONS.getString("insertColumn") + "...");
        this.insertItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                List list = JEPSTable.this.getColumns(true);
                List list2 = JEPSTable.this.getColumns();
                list.removeAll(list2);
                if (!list.isEmpty()) {
                    JInsertColumnDialog jInsertColumnDialog = new JInsertColumnDialog(JEPSTable.this, list, JEPSTable.this.popupColumn);
                    jInsertColumnDialog.pack();
                    jInsertColumnDialog.setLocationRelativeTo(Common.getApplication());
                    jInsertColumnDialog.setVisible(true);
                }
            }
        });
        this.editItem = new JMenuItem(Common.I18N_ACTIONS.getString("editColumn") + "...");
        this.editItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JEditTaskColumnDialog jEditTaskColumnDialog = new JEditTaskColumnDialog(JEPSTable.this, JEPSTable.this.popupColumn);
                jEditTaskColumnDialog.pack();
                jEditTaskColumnDialog.setLocationRelativeTo(Common.getApplication());
                jEditTaskColumnDialog.setVisible(true);
            }
        });
        this.editItem.setVisible(false);
        this.headerPopup.add(this.hideItem);
        this.headerPopup.add(this.insertItem);
        this.headerPopup.add(this.editItem);
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            private void showPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    JEPSTable.this.popupColumn = JEPSTable.this.getTableHeader().columnAtPoint(mouseEvent.getPoint());
                    if (JEPSTable.this.popupColumn != -1) {
                        List list = JEPSTable.this.getColumns(true);
                        List list2 = JEPSTable.this.getColumns();
                        list.removeAll(list2);
                        JEPSTable.this.insertItem.setEnabled(!list.isEmpty());
                        int n = JEPSTable.this.convertColumnIndexToModel(JEPSTable.this.popupColumn);
                        JEPSTable.this.editItem.setEnabled(n >= JEPSTable.this.getModel().getColumnCount() - 10 && JEPSTable.this.popupColumn != -1);
                        JEPSTable.this.headerPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        });
        if (SystemUtilities.isOSMac()) {
            this.setHighlighters(new Highlighter[]{new HighlighterFactory.UIColorHighlighter(HighlightPredicate.EVEN)});
            this.setShowHorizontalLines(false);
            this.setShowVerticalLines(true);
        }
        ActionMapper actionMapper = ActionMapper.getInstance();
        actionMapper.mapActions((JComponent)((Object)this));
        final UIManager uIManager = UIManager.getInstance();
        uIManager.addJApplicationListener(new JApplicationListener(){

            public void dateFormatChanged(JApplicationEvent jApplicationEvent) {
                JEPSTable.this.datePicker.setDateFormat(uIManager.getDateFormat());
                JEPSTable.this.repaint();
            }
        });
    }

    public void setProject(Task task) {
        this.project = task;
        this.removeUndoableEditListener(this.undoHandler);
        ((EPSTableModel)this.getModel()).removeUndoableEditListener(this.undoHandler);
        this.undoHandler = new UndoHandler(task.getCompany().getUndoManager());
        this.addUndoableEditListener(this.undoHandler);
        EPSTableModel ePSTableModel = new EPSTableModel(this, task.getCompany());
        ePSTableModel.addUndoableEditListener(this.undoHandler);
        this.setModel(ePSTableModel);
        this.setHeaderWidths();
    }

    protected void setHeaderWidths() {
        this.getColumn(EPSTableModel.NAME).setMinWidth(50);
        this.getColumn(EPSTableModel.NAME).setPreferredWidth(150);
        this.getColumn(EPSTableModel.START).setPreferredWidth(150);
        this.getColumn(EPSTableModel.END).setPreferredWidth(150);
    }

    private void setRenderersAndEditors() {
        this.getColumn(EPSTableModel.NAME).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                int n3 = JEPSTable.this.convertRowIndexToModel(n);
                Task task = JEPSTable.this.project.getCompany().getRootTask().getProjectChildAt(n3);
                String string = UIManager.getInstance().isShowTaskOutline() ? task.getOutlineNumber() + " " + task.getName() : task.getName();
                return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            }
        });
        this.datePicker = new JDatePicker();
        this.datePicker.setEditable(true);
        try {
            this.datePicker.setEmptySelectionAllowed(false);
        }
        catch (DateSelectionException dateSelectionException) {
            Common.logException("Error:", dateSelectionException);
        }
        this.datePicker.setEmptySelectionText("");
        this.datePicker.setDateFormat(UIManager.getInstance().getDateFormat());
        this.getColumn(EPSTableModel.START).setCellRenderer(new DateRenderer(this.getDefaultRenderer(Date.class)));
        this.getColumn(EPSTableModel.END).setCellRenderer(new DateRenderer(this.getDefaultRenderer(Date.class)));
        this.getColumn(EPSTableModel.ACTUAL_START).setCellRenderer(new DateRenderer(this.getDefaultRenderer(Date.class)));
        this.getColumn(EPSTableModel.ACTUAL_END).setCellRenderer(new DateRenderer(this.getDefaultRenderer(Date.class)));
        this.getColumn(EPSTableModel.ESTIMATED_START).setCellRenderer(new DateRenderer(this.getDefaultRenderer(Date.class)));
        this.getColumn(EPSTableModel.CALENDAR).setCellRenderer(new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                this.setHorizontalAlignment(4);
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
        });
        this.getColumn(EPSTableModel.PERCENT_COMPLETE).setCellRenderer(new CompletionCellRenderer());
        this.getColumn(EPSTableModel.PERCENT_WORK_COMPLETE).setCellRenderer(new CompletionCellRenderer());
        this.getColumn(EPSTableModel.COST).setCellRenderer(new CostCellRenderer());
        this.getColumn(EPSTableModel.ACTUAL_COST).setCellRenderer(new CostCellRenderer());
        this.getColumn(EPSTableModel.REMAINING_COST).setCellRenderer(new CostCellRenderer());
        this.getColumn(EPSTableModel.WORK).setCellRenderer(new WorkCellRenderer());
        this.getColumn(EPSTableModel.ACTUAL_WORK).setCellRenderer(new WorkCellRenderer());
        this.getColumn(EPSTableModel.REMAINING_WORK).setCellRenderer(new WorkCellRenderer());
        this.getColumn(EPSTableModel.DURATION).setCellRenderer(new DurationCellRenderer());
        this.getColumn(EPSTableModel.ACTUAL_DURATION).setCellRenderer(new DurationCellRenderer());
        this.getColumn(EPSTableModel.REMAINING_DURATION).setCellRenderer(new DurationCellRenderer());
        String[] stringArray = new String[]{Task.PLANNING, Task.IN_PROGRESS, Task.ON_HOLD, Task.CLOSED};
        this.getColumn(EPSTableModel.STATUS).setCellEditor(new DefaultCellEditor(new JComboBox<String>(stringArray)));
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    private void computeValues() {
        PageFormat pageFormat = this.getPageFormat(0);
        this.pageHeight = pageFormat.getImageableHeight() * 1.3 / PrintManager.ZOOM - 2.0 - 20.0;
        this.pageWidth = pageFormat.getImageableWidth() * 1.3 / PrintManager.ZOOM - 2.0 - 2.0;
        this.tableWidth = (double)this.getColumnModel().getTotalColumnWidth() + (double)((JProjectViewEPS)this.projectView).getRowHeader().getWidth();
        this.headerHeightOnPage = this.getTableHeader().getHeight();
        double d = this.getRowHeight();
        if (PrintManager.isShowHeader()) {
            int n = (int)((this.pageHeight - this.headerHeightOnPage) / d);
            this.totalVerticalNumPages = (int)Math.ceil((double)this.getRowCount() / (double)n);
        } else {
            int n = (int)(this.pageHeight / d);
            int n2 = (int)((this.pageHeight - this.headerHeightOnPage) / d);
            this.totalVerticalNumPages = (int)Math.ceil(((double)this.getRowCount() - (double)n2) / (double)n) + 1;
        }
        this.totalHorizontalNumPages = (int)Math.ceil(this.tableWidth / this.pageWidth);
    }

    public int getNumberOfPages() {
        this.computeValues();
        return this.totalHorizontalNumPages * this.totalVerticalNumPages;
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        return Common.getApplication().getPageFormat();
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        return this;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.computeValues();
        this.clearSelection();
        this.getTableHeader().setBackground(Color.WHITE);
        ((JProjectViewEPS)this.projectView).getRowHeader().setBackground(Color.WHITE);
        this.setBackground(Color.WHITE);
        graphics2D.scale(1.0 / (1.3 / PrintManager.ZOOM), 1.0 / (1.3 / PrintManager.ZOOM));
        graphics2D.setColor(Color.BLACK);
        int n3 = graphics2D.getFontMetrics().getDescent();
        double d = this.getRowHeight();
        int n4 = (int)((this.pageHeight - this.headerHeightOnPage) / d);
        int n5 = (int)(this.pageHeight / d);
        double d2 = d * (double)n4;
        double d3 = d * (double)n5;
        int n6 = this.totalHorizontalNumPages;
        int n7 = this.totalHorizontalNumPages * this.totalVerticalNumPages;
        if (n >= n7) {
            return 1;
        }
        graphics2D.translate(pageFormat.getImageableX() * 1.3 / PrintManager.ZOOM, pageFormat.getImageableY() * 1.3 / PrintManager.ZOOM);
        graphics2D.drawLine(0, 1, 2 + (int)this.pageWidth + 2, 1);
        graphics2D.drawLine(0, (int)(2.0 + this.pageHeight), 2 + (int)this.pageWidth + 1, (int)(2.0 + this.pageHeight));
        graphics2D.drawLine(0, (int)(2.0 + this.pageHeight + 20.0), 2 + (int)this.pageWidth + 2, (int)(2.0 + this.pageHeight + 20.0));
        graphics2D.drawLine(0, 2, 0, (int)(2.0 + this.pageHeight + 20.0));
        graphics2D.drawLine(2 + (int)this.pageWidth + 2, 2, 2 + (int)this.pageWidth + 2, (int)(2.0 + this.pageHeight + 20.0));
        String string = Common.I18N_RP.getString("project") + ": " + this.project.getName() + "     " + Common.I18N_RP.getString("manager") + ": " + this.project.getManager();
        graphics2D.drawString(string, 2, (int)(2.0 + this.pageHeight + 20.0 - (double)n3));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd, yyyy");
        string = Common.I18N_RP.getString("page") + ": " + (n + 1) + "/" + this.getNumberOfPages() + "     " + Common.I18N_RP.getString("date") + ": " + simpleDateFormat.format(new Date());
        int n8 = graphics2D.getFontMetrics().stringWidth(string);
        graphics2D.drawString(string, (int)(2.0 + this.pageWidth - (double)n8), (int)(2.0 + this.pageHeight + 20.0 - (double)n3));
        graphics2D.translate(2, 2);
        int n9 = n / this.totalHorizontalNumPages;
        int n10 = n % this.totalHorizontalNumPages;
        JRowHeader jRowHeader = ((JProjectViewEPS)this.projectView).getRowHeader();
        int n11 = n10 < n6 - 1 ? (n10 == 0 ? (int)Math.ceil(this.pageWidth) - ((JProjectViewEPS)this.projectView).getRowHeader().getWidth() : (int)Math.ceil(this.pageWidth)) : (int)Math.ceil(this.tableWidth - (double)n10 * this.pageWidth);
        if (n9 + 1 == this.totalVerticalNumPages) {
            if (!PrintManager.isShowHeader()) {
                int n12 = n9 == 0 ? 0 : n4 + n5 * (n9 - 1);
                int n13 = this.getRowCount() - n12;
                n2 = (int)Math.ceil(d * (double)n13);
            } else {
                int n14 = n4 * n9;
                int n15 = this.getRowCount() - n14;
                n2 = (int)Math.ceil(d * (double)n15);
            }
        } else {
            n2 = !PrintManager.isShowHeader() ? (n9 == 0 ? (int)Math.ceil(d2) : (int)Math.ceil(d3)) : (int)Math.ceil(d2);
        }
        if (n9 == 0 || n9 != 0 && PrintManager.isShowHeader()) {
            graphics2D.translate((double)(-n10) * this.pageWidth + (double)jRowHeader.getWidth(), 0.0);
            if (n10 == 0) {
                graphics2D.setClip((int)((double)n10 * this.pageWidth), 0, n11, (int)Math.ceil(this.headerHeightOnPage));
            } else {
                graphics2D.setClip((int)((double)n10 * this.pageWidth) - jRowHeader.getWidth(), 0, n11, (int)Math.ceil(this.headerHeightOnPage));
            }
            PrintManager.bufferAndPaint(graphics2D, this.getTableHeader());
            graphics2D.translate((double)n10 * this.pageWidth - (double)jRowHeader.getWidth(), this.headerHeightOnPage);
        }
        if (n10 == 0) {
            if (PrintManager.isShowHeader()) {
                graphics2D.translate((double)(-n10) * this.pageWidth, (double)(-((int)(d2 * (double)n9))));
            } else if (n9 == 0) {
                graphics2D.translate((double)(-n10) * this.pageWidth, 0.0);
            } else {
                graphics2D.translate((double)(-n10) * this.pageWidth, (double)(-((int)(d2 + d3 * (double)(n9 - 1)))));
            }
            if (PrintManager.isShowHeader()) {
                graphics2D.setClip((int)((double)n10 * this.pageWidth), (int)(d2 * (double)n9), jRowHeader.getWidth(), n2);
            } else if (n9 == 0) {
                graphics2D.setClip((int)((double)n10 * this.pageWidth), 0, jRowHeader.getWidth(), n2);
            } else {
                graphics2D.setClip((int)((double)n10 * this.pageWidth), (int)(d2 + d3 * (double)(n9 - 1)), jRowHeader.getWidth(), n2);
            }
            PrintManager.bufferAndPaint(graphics2D, jRowHeader);
            if (PrintManager.isShowHeader()) {
                graphics2D.translate((double)n10 * this.pageWidth, (double)((int)(d2 * (double)n9)));
            } else if (n9 == 0) {
                graphics2D.translate((double)n10 * this.pageWidth, 0.0);
            } else {
                graphics2D.translate((double)n10 * this.pageWidth, (double)((int)(d2 + d3 * (double)(n9 - 1))));
            }
        }
        if (PrintManager.isShowHeader()) {
            graphics2D.translate((double)(-n10) * this.pageWidth + (double)jRowHeader.getWidth(), (double)(-((int)(d2 * (double)n9))));
        } else if (n9 == 0) {
            graphics2D.translate((double)(-n10) * this.pageWidth + (double)jRowHeader.getWidth(), 0.0);
        } else {
            graphics2D.translate((double)(-n10) * this.pageWidth + (double)jRowHeader.getWidth(), (double)(-((int)(d2 + d3 * (double)(n9 - 1)))));
        }
        if (PrintManager.isShowHeader()) {
            if (n10 == 0) {
                graphics2D.setClip((int)((double)n10 * this.pageWidth), (int)(d2 * (double)n9), n11, n2);
            } else {
                graphics2D.setClip((int)((double)n10 * this.pageWidth) - jRowHeader.getWidth(), (int)(d2 * (double)n9), n11, n2);
            }
        } else if (n10 == 0) {
            if (n9 == 0) {
                graphics2D.setClip((int)((double)n10 * this.pageWidth), 0, n11, n2);
            } else {
                graphics2D.setClip((int)((double)n10 * this.pageWidth), (int)(d2 + d3 * (double)(n9 - 1)), n11, n2);
            }
        } else if (n9 == 0) {
            graphics2D.setClip((int)((double)n10 * this.pageWidth) - jRowHeader.getWidth(), 0, n11, n2);
        } else {
            graphics2D.setClip((int)((double)n10 * this.pageWidth) - jRowHeader.getWidth(), (int)(d2 + d3 * (double)(n9 - 1)), n11, n2);
        }
        PrintManager.bufferAndPaint(graphics2D, (Component)((Object)this));
        if (PrintManager.isShowHeader()) {
            graphics2D.translate((double)n10 * this.pageWidth - (double)jRowHeader.getWidth(), (double)((int)(d2 * (double)n9)));
        } else if (n9 == 0) {
            graphics2D.translate((double)n10 * this.pageWidth - (double)jRowHeader.getWidth(), (double)((int)(d2 * (double)n9)));
        } else {
            graphics2D.translate((double)n10 * this.pageWidth - (double)jRowHeader.getWidth(), (double)((int)(d2 + d3 * (double)(n9 - 1))));
        }
        if (n9 == 0 || n9 != 0 && PrintManager.isShowHeader()) {
            graphics2D.translate(0.0, -this.headerHeightOnPage);
        }
        graphics2D.translate(-2, -2);
        graphics2D.translate(-pageFormat.getImageableX() * 1.3 / PrintManager.ZOOM, -pageFormat.getImageableY() * 1.3 / PrintManager.ZOOM);
        this.getTableHeader().setBackground((Color)javax.swing.UIManager.get("TableHeader.background"));
        this.setBackground((Color)javax.swing.UIManager.get("Table.background"));
        jRowHeader.setBackground((Color)javax.swing.UIManager.get("TableHeader.background"));
        return 0;
    }

    public int getHorizontalNumberOfPages() {
        this.computeValues();
        return this.totalHorizontalNumPages;
    }

    public int getVerticalNumberOfPages() {
        this.computeValues();
        return this.totalVerticalNumPages;
    }

    public Dimension getPrintSize() {
        Dimension dimension = new Dimension();
        dimension.setSize(((JProjectViewEPS)this.projectView).getRowHeader().getWidth() + this.getWidth(), this.getHeight());
        return dimension;
    }

    public JProjectView getProjectView() {
        return this.projectView;
    }

    public void setProjectView(JProjectView jProjectView) {
        this.projectView = jProjectView;
    }

    public Task getProject() {
        return this.project;
    }

    static {
        formattedTextField.setHorizontalAlignment(4);
    }

    class CostCellRenderer
    extends DefaultTableCellRenderer {
        public CostCellRenderer() {
            this.setHorizontalAlignment(4);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Task task = JEPSTable.this.project.getProjectChildAt(n);
            if (task.isEmpty() || object == null) {
                return super.getTableCellRendererComponent(jTable, null, bl, bl2, n, n2);
            }
            Double d = (Double)object;
            String string = JEPSTable.this.project.getCompany().getRootTask().getCurrencyUnit() + d;
            return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
        }
    }

    class WorkCellRenderer
    extends DefaultTableCellRenderer {
        public WorkCellRenderer() {
            this.setHorizontalAlignment(4);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string;
            Task task = JEPSTable.this.project.getProjectChildAt(n);
            if (task.isEmpty() || object == null) {
                return super.getTableCellRendererComponent(jTable, null, bl, bl2, n, n2);
            }
            if (object instanceof Long) {
                Long l = (Long)object;
                string = l / JEPSTable.this.project.getDurationManager().getDuration(DurationManager.HOUR) + DurationManager.HOUR;
            } else {
                Double d = (Double)object;
                string = "" + d;
            }
            return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
        }
    }

    private class DateRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private TableCellRenderer delegate;

        public DateRenderer(TableCellRenderer tableCellRenderer) {
            this.delegate = tableCellRenderer;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel;
            if (object != null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(UIManager.getInstance().getDateFormat());
                String string = simpleDateFormat.format((Date)object);
                jLabel = (JLabel)this.delegate.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            } else {
                jLabel = (JLabel)this.delegate.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            jLabel.setHorizontalAlignment(4);
            return jLabel;
        }
    }

    private class DurationCellRenderer
    extends DefaultTableCellRenderer {
        public DurationCellRenderer() {
            this.setHorizontalAlignment(4);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Task task = JEPSTable.this.project.getProjectChildAt(n);
            if (task.isEmpty() || object == null) {
                return super.getTableCellRendererComponent(jTable, null, bl, bl2, n, n2);
            }
            String string = TaskDurationFormat.formatDuration(task, (Long)object);
            return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
        }
    }

    private class CompletionCellRenderer
    extends DefaultTableCellRenderer {
        public CompletionCellRenderer() {
            this.setHorizontalAlignment(4);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Task task = JEPSTable.this.project.getProjectChildAt(n);
            if (task.isEmpty() || object == null) {
                return super.getTableCellRendererComponent(jTable, null, bl, bl2, n, n2);
            }
            Double d = (Double)object;
            String string = d + "%";
            return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
        }
    }
}

