/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Dependency;
import com.sbs.jpm.core.DependencyManager;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.constraint.ASAP;
import com.sbs.jpm.core.constraint.ConstraintManager;
import com.sbs.jpm.ui.UIManager;
import com.sbs.jpm.ui.treetablechart.JTreeTable;
import com.sbs.jpm.ui.treetablechart.JTreeTableChart;
import com.sbs.jpm.ui.treetablechart.chart.GraphicPrimitiveContainer;
import com.sbs.jpm.ui.treetablechart.chart.Painter;
import com.sbs.jpm.ui.treetablechart.chart.PrimitiveStyle;
import com.sbs.jpm.ui.treetablechart.mouse.ChartArea;
import com.sbs.jpm.ui.treetablechart.mouse.MouseDispatcher;
import com.sbs.jpm.ui.treetablechart.mouse.MouseInteraction;
import com.sbs.jpm.ui.treetablechart.time.BackgroundManager;
import com.sbs.jpm.ui.treetablechart.time.GanttTreeTableManager;
import com.sbs.jpm.ui.treetablechart.time.TimeScaleManager;
import com.sbs.jpm.ui.treetablechart.time.TreeTableManager;
import com.sbs.jpm.undo.UndoHandler;
import com.sbs.util.SystemUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.SimpleDateFormat;
import java.util.Formatter;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.Scrollable;

public abstract class JChartArea
extends JPanel
implements Scrollable {
    protected JTreeTable treeTable;
    protected JTreeTableChart treeTableChart;
    protected Task project;
    protected Painter painter;
    protected TimeScaleManager timeScaleManager;
    protected UndoHandler undoHandler;
    protected TreeTableManager treeTableManager;
    protected BackgroundManager backgroundManager;
    protected MouseDispatcher mouseDispatcher;
    protected CalendaristicAction calendaristicAction;
    long allowTooltipShowTime;
    boolean whiteSpaceArea = true;
    static final long tooltipRearm = 2000L;

    public JChartArea(JTreeTableChart jTreeTableChart, JTreeTable jTreeTable) {
        this.treeTable = jTreeTable;
        this.treeTableChart = jTreeTableChart;
        this.setBackground(Color.WHITE);
        this.setToolTipText("");
        this.setAutoscrolls(true);
        this.treeTableManager = this.createTreeTableManager();
        this.backgroundManager = this.createBackgroundManager();
        this.calendaristicAction = new CalendaristicAction();
        this.mouseDispatcher = this.createMouseDispatcher();
        this.addMouseMotionListener(this.mouseDispatcher);
        this.addMouseListener(this.mouseDispatcher);
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.isControlDown()) {
                    if (mouseWheelEvent.getWheelRotation() > 0) {
                        JChartArea.this.timeScaleManager.zoomOut();
                    } else if (mouseWheelEvent.getWheelRotation() < 0) {
                        JChartArea.this.timeScaleManager.zoomIn();
                    }
                } else {
                    JChartArea.this.treeTable.dispatchEvent(new MouseWheelEvent((Component)((Object)JChartArea.this.treeTable), mouseWheelEvent.getID(), mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiers(), 0, mouseWheelEvent.getY(), mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation()));
                }
            }
        });
    }

    private String getTaskToolTipText(Task task) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>" + Common.I18N_RP.getString("name") + ": ");
        stringBuffer.append(task.getName());
        stringBuffer.append("<br>" + Common.I18N_RP.getString("start") + ": ");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(UIManager.getInstance().getDateFormat());
        stringBuffer.append(simpleDateFormat.format(task.getStartDate()));
        stringBuffer.append("<br>" + Common.I18N_RP.getString("end") + ": ");
        stringBuffer.append(simpleDateFormat.format(task.getEndDate()));
        stringBuffer.append("<br>" + Common.I18N_RP.getString("duration") + ": ");
        Double d = task.getDuration();
        String string = task.getDurationUnit();
        d = d / (double)task.getProjectTask().getDurationManager().getDuration(string);
        Formatter formatter = new Formatter();
        if (d - (double)d.longValue() != 0.0) {
            formatter.format("%.1f", d);
        } else {
            formatter.format("%.0f", d);
        }
        stringBuffer.append(formatter.toString());
        stringBuffer.append(string);
        stringBuffer.append("<br>" + Common.I18N_RP.getString("completion") + ": ");
        stringBuffer.append(task.getCompletion());
        stringBuffer.append("<br>" + Common.I18N_RP.getString("constraintType") + ": ");
        stringBuffer.append(ConstraintManager.getConstraintType(task.getConstraint()));
        if (!(task.getConstraint() instanceof ASAP)) {
            stringBuffer.append("<br>" + Common.I18N_RP.getString("constraintDate") + ": ");
            stringBuffer.append(simpleDateFormat.format(task.getConstraint().getDate()));
        }
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }

    private String getDependencyToolTipText(Dependency dependency) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>" + Common.I18N_RP.getString("linkType") + ": ");
        stringBuffer.append(DependencyManager.getDependencyType(dependency));
        stringBuffer.append("<br>" + Common.I18N_RP.getString("predecessor") + ": ");
        stringBuffer.append(dependency.getPredecessor());
        stringBuffer.append("<br>" + Common.I18N_RP.getString("successor") + ": ");
        stringBuffer.append(dependency.getSuccessor());
        stringBuffer.append("<br>" + Common.I18N_RP.getString("lag") + ": ");
        String string = dependency.getUnit();
        String string2 = dependency.getTaskDelay() / dependency.getSuccessor().getProjectTask().getDurationManager().getDuration(string) + string;
        stringBuffer.append(string2);
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        if (System.currentTimeMillis() < this.allowTooltipShowTime) {
            return null;
        }
        return new Point(mouseEvent.getX() + 14, mouseEvent.getY() + 14);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        boolean bl = this.whiteSpaceArea;
        String string = this.getToolTipText(mouseEvent.getX(), mouseEvent.getY());
        if (this.whiteSpaceArea & !bl) {
            this.allowTooltipShowTime = System.currentTimeMillis() + 2000L;
            return null;
        }
        if (this.whiteSpaceArea && System.currentTimeMillis() < this.allowTooltipShowTime) {
            return null;
        }
        return string;
    }

    public String getToolTipText(int n, int n2) {
        this.whiteSpaceArea = false;
        if (this.treeTableManager instanceof GanttTreeTableManager) {
            GanttTreeTableManager ganttTreeTableManager = (GanttTreeTableManager)this.treeTableManager;
            int n3 = 2;
            int n4 = 0;
            GraphicPrimitiveContainer.GraphicPrimitive graphicPrimitive = ganttTreeTableManager.getSelectablePrimitive(n, n3, n2, n4, PrimitiveStyle.MILESTONE);
            if (graphicPrimitive != null) {
                Task task = (Task)((GraphicPrimitiveContainer.Rectangle)graphicPrimitive).getModelObject();
                return this.getTaskToolTipText(task);
            }
            graphicPrimitive = ganttTreeTableManager.getSelectablePrimitive(n, n3, n2, n4, PrimitiveStyle.TASK_COMPLETION);
            if (graphicPrimitive != null) {
                Task task = (Task)((GraphicPrimitiveContainer.Rectangle)graphicPrimitive).getModelObject();
                return this.getTaskToolTipText(task);
            }
            graphicPrimitive = ganttTreeTableManager.getSelectablePrimitive(n, n3, n2, n4, PrimitiveStyle.TASK);
            if (graphicPrimitive != null) {
                Task task = (Task)((GraphicPrimitiveContainer.Rectangle)graphicPrimitive).getModelObject();
                return this.getTaskToolTipText(task);
            }
            graphicPrimitive = ganttTreeTableManager.getSelectablePrimitive(n, n3, n2, n4, PrimitiveStyle.SPLITTED_TASK_PART);
            if (graphicPrimitive != null) {
                Task task = (Task)((GraphicPrimitiveContainer.Rectangle)graphicPrimitive).getModelObject();
                return this.getTaskToolTipText(task);
            }
            graphicPrimitive = ganttTreeTableManager.getSelectablePrimitive(n, n3, n2, n4, PrimitiveStyle.SUPERTASK);
            if (graphicPrimitive != null) {
                Task task = (Task)((GraphicPrimitiveContainer.Rectangle)graphicPrimitive).getModelObject();
                return this.getTaskToolTipText(task);
            }
            graphicPrimitive = ganttTreeTableManager.getSelectablePrimitive(n, n3, n2, n4, PrimitiveStyle.PROJECT);
            if (graphicPrimitive != null) {
                Task task = (Task)((GraphicPrimitiveContainer.Rectangle)graphicPrimitive).getModelObject();
                return this.getTaskToolTipText(task);
            }
            graphicPrimitive = ganttTreeTableManager.getSelectablePrimitive(n, n3, n2, n4, PrimitiveStyle.DEPENDENCY);
            if (graphicPrimitive != null) {
                Dependency dependency = (Dependency)((GraphicPrimitiveContainer.MultiLine)graphicPrimitive).getModelObject();
                return this.getDependencyToolTipText(dependency);
            }
            this.whiteSpaceArea = true;
            return SystemUtilities.isOSMac() ? Common.I18N_RP.getString("ctrlClickForOptions") : Common.I18N_RP.getString("rightClickForOptions");
        }
        this.whiteSpaceArea = true;
        return SystemUtilities.isOSMac() ? Common.I18N_RP.getString("ctrlClickForOptions") : Common.I18N_RP.getString("rightClickForOptions");
    }

    protected abstract TreeTableManager createTreeTableManager();

    protected abstract BackgroundManager createBackgroundManager();

    protected abstract MouseDispatcher createMouseDispatcher();

    public Task getProject() {
        return this.project;
    }

    public void setProject(Task task) {
        this.project = task;
        this.backgroundManager.setProject(task);
        this.treeTableManager.setProject(task);
        this.mouseDispatcher.getChartArea().removeUndoableEditListener(this.undoHandler);
        this.undoHandler = new UndoHandler(task.getCompany().getUndoManager());
        this.mouseDispatcher.getChartArea().addUndoableEditListener(this.undoHandler);
    }

    public ChartArea getChartArea() {
        return this.mouseDispatcher.getChartArea();
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.painter.setGraphics(graphics);
        int n = this.treeTable.getRowCount() * this.treeTable.getRowHeight();
        int n2 = this.getHeight();
        n = n2 > n ? n2 : n;
        this.backgroundManager.paint(this.painter, graphics, n);
        this.treeTableManager.paint(this.painter, graphics, n);
        MouseInteraction mouseInteraction = this.mouseDispatcher.getCurrentMouseInteraction();
        if (mouseInteraction != null) {
            mouseInteraction.paint(graphics);
        }
    }

    public JTreeTable getTreeTable() {
        return this.treeTable;
    }

    public TreeTableManager getTreeTableManager() {
        return this.treeTableManager;
    }

    public void setTreeTableManager(TreeTableManager treeTableManager) {
        this.treeTableManager = treeTableManager;
        this.repaint();
    }

    public JTreeTableChart getTreeTableChart() {
        return this.treeTableChart;
    }

    public CalendaristicAction getCalendaristicAction() {
        return this.calendaristicAction;
    }

    public void switchCalendaristicView() {
        this.calendaristicAction.switchCalendaristicView();
    }

    public Dimension getPreferredSize() {
        if (this.project != null) {
            return new Dimension((int)((double)(this.project.getEndDate().getTime() - this.project.getStartDate().getTime()) / this.timeScaleManager.getPixelDuration()) + 3200, this.treeTable.getPreferredSize().height);
        }
        return new Dimension(3200, 100);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getSize();
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            return this.treeTable.getScrollableBlockIncrement(rectangle, n, n2);
        }
        return 10 * this.timeScaleManager.getCurrentBottomUnitSize();
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.treeTable.getScrollableTracksViewportHeight();
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            return this.treeTable.getScrollableUnitIncrement(rectangle, n, n2);
        }
        return this.timeScaleManager.getCurrentBottomUnitSize();
    }

    public void setTimeScaleManager(TimeScaleManager timeScaleManager) {
        this.timeScaleManager = timeScaleManager;
        this.backgroundManager.setTimeScaleManager(timeScaleManager);
        this.treeTableManager.setTimeScaleManager(timeScaleManager);
    }

    public TimeScaleManager getTimeScaleManager() {
        return this.timeScaleManager;
    }

    public void setPainter(Painter painter) {
        this.painter = painter;
    }

    public class CalendaristicAction
    extends AbstractAction {
        public CalendaristicAction() {
            if (JChartArea.this.backgroundManager.isCalendaristic()) {
                this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/round_view.png")));
                this.putValue("ShortDescription", Common.I18N_RP.getString("roundToDaysView"));
            } else {
                this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/normal_view.png")));
                this.putValue("ShortDescription", Common.I18N_RP.getString("normalView"));
            }
        }

        public void switchCalendaristicView() {
            boolean bl = JChartArea.this.backgroundManager.isCalendaristic();
            if (bl) {
                this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/normal_view.png")));
                this.putValue("ShortDescription", Common.I18N_RP.getString("normalView"));
                JChartArea.this.backgroundManager.setCalendaristic(false);
                JChartArea.this.treeTableManager.setCalendaristic(false);
            } else {
                this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/round_view.png")));
                this.putValue("ShortDescription", Common.I18N_RP.getString("roundToDaysView"));
                JChartArea.this.backgroundManager.setCalendaristic(true);
                JChartArea.this.treeTableManager.setCalendaristic(true);
            }
            JChartArea.this.repaint();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.switchCalendaristicView();
        }
    }
}

