/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.core;

import com.sbs.jpm.ui.core.Data;
import com.sbs.jpm.ui.core.Node;
import com.sbs.jpm.ui.core.ProjectData;
import java.util.LinkedList;
import java.util.List;

public class ProjectNode
implements Node {
    private Data data;
    private Node parent;
    private List children;

    public ProjectNode() {
        this(new ProjectData());
    }

    public ProjectNode(Data data) {
        this.data = data;
        this.children = new LinkedList();
    }

    public Node getParent() {
        return this.parent;
    }

    public Node getChildAt(int n) {
        return (ProjectNode)this.children.get(n);
    }

    public int getChildrenNumber() {
        return this.children.size();
    }

    public Data getData() {
        return this.data;
    }

    public void addChild(Node node) {
        node.setParent(this);
        this.children.add(node);
    }

    public void removeChild(Node node) {
        node.setParent(null);
        this.children.remove(node);
    }

    public void setParent(Node node) {
        this.parent = node;
    }

    public void setData(Data data) {
        this.data = data;
    }

    public boolean isLeaf() {
        return this.getChildrenNumber() == 0;
    }

    public int getChildPosition(Node node) {
        return this.children.indexOf(node);
    }

    public String toString() {
        return this.data.getName();
    }

    public Node[] getChildren() {
        return this.children.toArray(new Node[this.children.size()]);
    }
}

