/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component.view;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.print.CustomPageable;
import com.sbs.jpm.ui.component.JCorner;
import com.sbs.jpm.ui.component.JProjectRisksTable;
import com.sbs.jpm.ui.component.JProjectView;
import com.sbs.jpm.ui.component.JRowHeader;
import com.sbs.jpm.ui.component.RiskDetailView;
import com.sbs.jpm.ui.component.model.ProjectRisksTableModel;
import com.sbs.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JProjectViewRisks
extends JProjectView
implements CustomPageable {
    private JProjectRisksTable projectRisksTable;
    private JRowHeader rowHeader;
    private JSplitPane splitPane;
    private JToggleButton infoButton;
    private RiskDetailView riskView;
    private Action detailsAction;

    public void setProject(Task task) {
        super.setProject(task);
        if (this.project != null) {
            this.projectRisksTable.setEnabled(true);
            this.projectRisksTable.setProject(task);
        } else {
            this.projectRisksTable.clearSelection();
            this.projectRisksTable.setModel(new ProjectRisksTableModel());
            this.projectRisksTable.setEnabled(false);
        }
        this.rowHeader.setTableModel(this.projectRisksTable.getModel());
    }

    protected void updateDetailsAndToolbar() {
    }

    private JPanel createContentsRisks() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(5, 5, 5, 5);
        Insets insets2 = new Insets(5, 10, 5, 5);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        this.projectRisksTable = new JProjectRisksTable();
        this.projectRisksTable.setProjectView(this);
        this.projectRisksTable.setSelectionMode(0);
        this.projectRisksTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                final int n = listSelectionModel.getMinSelectionIndex();
                int n2 = listSelectionModel.getMaxSelectionIndex();
                if (!listSelectionEvent.getValueIsAdjusting() && n == n2 && n != -1) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            int n2 = JProjectViewRisks.this.projectRisksTable.convertRowIndexToModel(n);
                            if (n2 != JProjectViewRisks.this.projectRisksTable.getModel().getRowCount() - 1) {
                                JProjectViewRisks.this.riskView.setRisk(null);
                                JProjectViewRisks.this.riskView.setRisk(JProjectViewRisks.this.projectRisksTable.getProject().getRiskAt(n2));
                            }
                        }
                    });
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.projectRisksTable));
        jScrollPane.getViewport().setBackground(this.projectRisksTable.getBackground());
        this.rowHeader = new JRowHeader((JTable)((Object)this.projectRisksTable));
        this.rowHeader.setFixedCellWidth(20);
        jScrollPane.setRowHeaderView(this.rowHeader);
        JCorner jCorner = new JCorner();
        jScrollPane.setCorner("UPPER_LEFT_CORNER", jCorner);
        jCorner = new JCorner();
        jScrollPane.setCorner("LOWER_LEFT_CORNER", jCorner);
        jPanel2.add((Component)new JLabel(Common.I18N_RP.getString("project.risks") + ":"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, insets2, 0, 0));
        jPanel2.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 21, 1, insets, 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 9, 0));
        return jPanel;
    }

    private JPanel createContentsRisk() {
        this.riskView = new RiskDetailView();
        this.riskView.setRisk(null);
        return this.riskView;
    }

    protected JPanel createContents() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.splitPane = new JSplitPane(0, this.createContentsRisks(), this.createContentsRisk());
        this.splitPane.setResizeWeight(0.6);
        this.splitPane.setDividerSize(5);
        this.splitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        if (SystemUtilities.isOSMac()) {
            this.splitPane.putClientProperty("Quaqua.SplitPane.style", "bar");
        }
        jPanel.add((Component)this.splitPane, "Center");
        return jPanel;
    }

    protected void createToolBar() {
        super.createToolBar();
        KeyStroke keyStroke = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(68, 256) : KeyStroke.getKeyStroke(68, 128);
        this.detailsAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/info.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!JProjectViewRisks.this.riskView.isVisible()) {
                    JProjectViewRisks.this.riskView.setVisible(true);
                    JProjectViewRisks.this.infoButton.setSelected(true);
                    JProjectViewRisks.this.splitPane.setDividerLocation(-1);
                    JProjectViewRisks.this.splitPane.setDividerSize(5);
                } else {
                    JProjectViewRisks.this.riskView.setVisible(false);
                    JProjectViewRisks.this.infoButton.setSelected(false);
                    JProjectViewRisks.this.splitPane.setDividerSize(0);
                }
            }
        };
        String string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("details.tooltip") + " (Cmmd-D)" : Common.I18N_ACTIONS.getString("details.tooltip") + " (Ctrl-D)";
        this.detailsAction.putValue("ShortDescription", string);
        this.infoButton = new JToggleButton(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/info.png")), false);
        this.infoButton.setAction(this.detailsAction);
        this.toolBar.add(this.infoButton);
        ActionMap actionMap = this.projectRisksTable.getActionMap();
        actionMap.put("details", this.detailsAction);
        InputMap inputMap = this.projectRisksTable.getInputMap(1);
        inputMap.put(keyStroke, "details");
    }

    public JRowHeader getRowHeader() {
        return this.rowHeader;
    }

    public JProjectRisksTable getProjectRisksTable() {
        return this.projectRisksTable;
    }

    public void updateInfoButtons() {
        this.infoButton.setSelected(this.riskView.isVisible());
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        this.rowHeader.setBackground(Color.WHITE);
        int n2 = this.projectRisksTable.print(graphics, pageFormat, n);
        this.rowHeader.setBackground((Color)UIManager.get("TableHeader.background"));
        return n2;
    }

    public int getNumberOfPages() {
        return this.projectRisksTable.getNumberOfPages();
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        return this.projectRisksTable.getPageFormat(n);
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        return this.projectRisksTable.getPrintable(n);
    }

    public int getHorizontalNumberOfPages() {
        return this.projectRisksTable.getHorizontalNumberOfPages();
    }

    public int getVerticalNumberOfPages() {
        return this.projectRisksTable.getVerticalNumberOfPages();
    }

    public Dimension getPrintSize() {
        return this.projectRisksTable.getPrintSize();
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }
}

