/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component.view;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.MaterialResource;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.print.CustomPageable;
import com.sbs.jpm.ui.component.DefaultDropDownButton;
import com.sbs.jpm.ui.component.HResourceDetailView;
import com.sbs.jpm.ui.component.JProjectView;
import com.sbs.jpm.ui.component.MResourceDetailView;
import com.sbs.jpm.ui.component.TaskDetailView;
import com.sbs.jpm.ui.component.ZoomDropDownButton;
import com.sbs.jpm.ui.treetablechart.JArea;
import com.sbs.jpm.ui.treetablechart.JResourceChart;
import com.sbs.jpm.ui.treetablechart.JResourceTreeTable;
import com.sbs.jpm.ui.treetablechart.time.CostTreeTableManager;
import com.sbs.jpm.ui.treetablechart.time.ProjectsTreeTableManager;
import com.sbs.jpm.ui.treetablechart.time.TimeScaleManager;
import com.sbs.jpm.ui.treetablechart.time.WorkTreeTableManager;
import com.sbs.jpm.ui.treetablechart.time.event.TimeScaleAdapter;
import com.sbs.jpm.ui.treetablechart.time.event.TimeScaleEvent;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import com.sbs.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class JProjectViewResourceSheet
extends JProjectView
implements CustomPageable {
    private ZoomDropDownButton zoomInButton;
    private ZoomDropDownButton zoomOutButton;
    private JToggleButton infoButton;
    private JCheckBoxMenuItem infoItem;
    private Action expandAllAction;
    private Action collapseAllAction;
    private Action expandAction;
    private Action collapseAction;
    private Action gotoAction;
    private Action deleteAction;
    private Action detailsAction;
    private JPopupMenu popupMenu;
    private HResourceDetailView humanView;
    private MResourceDetailView materialView;
    private TaskDetailView taskView;
    private JSplitPane splitPane;
    private JResourceChart resourceSheet;

    public JProjectViewResourceSheet() {
        this.resourceSheet.getArea().getTimeScaleManager().addTimeScaleListener(new TimeScaleAdapter(){

            public void timeScaleChanged(TimeScaleEvent timeScaleEvent) {
                TimeScaleManager timeScaleManager = (TimeScaleManager)timeScaleEvent.getSource();
                JProjectViewResourceSheet.this.zoomInButton.setEnabled(timeScaleManager.canZoomIn());
                JProjectViewResourceSheet.this.zoomOutButton.setEnabled(timeScaleManager.canZoomOut());
            }
        });
    }

    protected void updateDetailsAndToolbar() {
        this.humanView.setResource(null);
        this.materialView.setResource(null);
        int n = this.splitPane.getDividerLocation();
        int[] nArray = this.resourceSheet.getTreeTable().getSelectedRows();
        int n2 = this.resourceSheet.getTreeTable().getSelectedRowCount();
        LinkedList<Task> linkedList = new LinkedList<Task>();
        boolean bl = true;
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i];
            Object object = this.resourceSheet.getTreeTable().getPathForRow(n3).getLastPathComponent();
            if (object instanceof Assignment) {
                linkedList.add(((Assignment)object).getTask());
                continue;
            }
            bl = false;
        }
        if (bl) {
            this.taskView.setTasks(linkedList);
            this.splitPane.setRightComponent(this.taskView);
        } else {
            this.taskView.setTasks(new LinkedList<Task>());
            if (this.resourceSheet.getTreeTable().getSelectedRowCount() == 1) {
                Object object = this.resourceSheet.getTreeTable().getPathForRow(this.resourceSheet.getTreeTable().getSelectedRow()).getLastPathComponent();
                if (object instanceof Resource) {
                    if (object instanceof HumanResource) {
                        this.humanView.setResource((HumanResource)object);
                        this.splitPane.setRightComponent(this.humanView);
                    } else if (object instanceof MaterialResource) {
                        this.materialView.setResource((MaterialResource)object);
                        this.splitPane.setRightComponent(this.materialView);
                    }
                } else {
                    this.splitPane.setRightComponent(this.taskView);
                }
            }
        }
        if (this.resourceSheet.getTreeTable().getSelectedRowCount() == 1) {
            Object object = this.resourceSheet.getTreeTable().getPathForRow(this.resourceSheet.getTreeTable().getSelectedRow()).getLastPathComponent();
            if (object instanceof Resource) {
                Resource resource = (Resource)object;
                if (!resource.isEmpty()) {
                    if (resource.getFirstWorkingDate() != null) {
                        this.gotoAction.setEnabled(true);
                    } else {
                        this.gotoAction.setEnabled(false);
                    }
                } else {
                    this.gotoAction.setEnabled(false);
                }
                this.deleteAction.setEnabled(true);
            } else if (object instanceof Assignment) {
                this.gotoAction.setEnabled(true);
                this.deleteAction.setEnabled(true);
            } else {
                this.gotoAction.setEnabled(false);
                this.deleteAction.setEnabled(false);
            }
        } else {
            this.gotoAction.setEnabled(false);
            this.deleteAction.setEnabled(false);
        }
        this.splitPane.setDividerLocation(n);
    }

    private JPanel createContentsResourceSheet() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        this.resourceSheet = new JResourceChart();
        this.resourceSheet.getTreeTable().setProjectView(this);
        this.resourceSheet.getTreeTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    JProjectViewResourceSheet.this.updateToolbar();
                }
            }
        });
        jPanel.add((Component)this.resourceSheet, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, insets, 9, 0));
        return jPanel;
    }

    private JPanel createContentsTask() {
        this.humanView = new HResourceDetailView();
        this.humanView.setVisible(false);
        this.materialView = new MResourceDetailView();
        this.materialView.setVisible(false);
        this.taskView = new TaskDetailView(false);
        this.taskView.setVisible(false);
        return this.humanView;
    }

    protected JPanel createContents() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.popupMenu = new JPopupMenu();
        this.splitPane = new JSplitPane(0, this.createContentsResourceSheet(), this.createContentsTask());
        this.splitPane.setResizeWeight(1.0);
        this.splitPane.setDividerSize(5);
        this.splitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        if (SystemUtilities.isOSMac()) {
            this.splitPane.putClientProperty("Quaqua.SplitPane.style", "bar");
        }
        jPanel.add((Component)this.splitPane, "Center");
        this.materialView.setResource(null);
        this.humanView.setResource(null);
        return jPanel;
    }

    public void setProject(Task task) {
        super.setProject(task);
        this.resourceSheet.setProject(task);
    }

    protected void createToolBar() {
        super.createToolBar();
        this.setPopup();
        JButton jButton = new JButton();
        this.zoomInButton = new ZoomDropDownButton(jButton, this.resourceSheet.getArea().getTimeScaleManager());
        jButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/ZoomIn16.gif")));
        jButton.setToolTipText(Common.I18N_ACTIONS.getString("zoomIn") + " (Ctrl + mouse wheel up)");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JProjectViewResourceSheet.this.resourceSheet.getArea().getTimeScaleManager().zoomIn();
            }
        });
        JButton jButton2 = new JButton();
        this.zoomOutButton = new ZoomDropDownButton(jButton2, this.resourceSheet.getArea().getTimeScaleManager());
        jButton2.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/ZoomOut16.gif")));
        jButton2.setToolTipText(Common.I18N_ACTIONS.getString("zoomOut") + " (Ctrl + mouse wheel down)");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JProjectViewResourceSheet.this.resourceSheet.getArea().getTimeScaleManager().zoomOut();
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        JToggleButton jToggleButton = new JToggleButton(Common.I18N_ACTIONS.getString("cost"), false);
        DefaultDropDownButton defaultDropDownButton = new DefaultDropDownButton(jToggleButton, this.resourceSheet.getResourceDataType().getCostPopup());
        jToggleButton.setToolTipText(Common.I18N_ACTIONS.getString("cost.tooltip"));
        jToggleButton.setMnemonic(67);
        jToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JArea jArea = JProjectViewResourceSheet.this.resourceSheet.getArea();
                JProjectViewResourceSheet.this.resourceSheet.getWorkTypePanel().setVisible(true);
                jArea.setTreeTableManager(new CostTreeTableManager((JResourceTreeTable)jArea.getTreetable(), jArea.getTimeScaleManager()));
                JProjectViewResourceSheet.this.resourceSheet.getResourceSheetData().updateDataHeight();
            }
        });
        jToggleButton.putClientProperty("Quaqua.Button.style", "toggleCenter");
        JToggleButton jToggleButton2 = new JToggleButton(Common.I18N_ACTIONS.getString("work"), true);
        DefaultDropDownButton defaultDropDownButton2 = new DefaultDropDownButton(jToggleButton2, this.resourceSheet.getResourceDataType().getWorkPopup());
        jToggleButton2.setToolTipText(Common.I18N_ACTIONS.getString("work.tooltip"));
        jToggleButton2.setMnemonic(87);
        jToggleButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JArea jArea = JProjectViewResourceSheet.this.resourceSheet.getArea();
                JProjectViewResourceSheet.this.resourceSheet.getWorkTypePanel().setVisible(true);
                jArea.setTreeTableManager(new WorkTreeTableManager((JResourceTreeTable)jArea.getTreetable(), jArea.getTimeScaleManager()));
                JProjectViewResourceSheet.this.resourceSheet.getResourceSheetData().updateDataHeight();
            }
        });
        jToggleButton2.putClientProperty("Quaqua.Button.style", "toggleWest");
        JToggleButton jToggleButton3 = new JToggleButton(Common.I18N_ACTIONS.getString("projects"), false);
        jToggleButton3.setToolTipText(Common.I18N_ACTIONS.getString("projects.tooltip"));
        jToggleButton3.setMnemonic(80);
        jToggleButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JArea jArea = JProjectViewResourceSheet.this.resourceSheet.getArea();
                JProjectViewResourceSheet.this.resourceSheet.getWorkTypePanel().setVisible(false);
                jArea.setTreeTableManager(new ProjectsTreeTableManager((JResourceTreeTable)jArea.getTreetable(), jArea.getTimeScaleManager()));
                JProjectViewResourceSheet.this.resourceSheet.getResourceSheetData().updateDataHeight();
            }
        });
        jToggleButton3.putClientProperty("Quaqua.Button.style", "toggleEast");
        buttonGroup.add(jToggleButton);
        buttonGroup.add(jToggleButton2);
        buttonGroup.add(jToggleButton3);
        this.infoButton = new JToggleButton(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/info.png")), false);
        this.infoButton.setAction(this.detailsAction);
        this.gotoAction.setEnabled(false);
        this.deleteAction.setEnabled(false);
        JButton jButton3 = new JButton(this.deleteAction);
        jButton3.setFocusable(false);
        JButton jButton4 = new JButton(this.expandAllAction);
        jButton4.setFocusable(false);
        this.toolBar.add(jButton4);
        JButton jButton5 = new JButton(this.collapseAllAction);
        jButton5.setFocusable(false);
        this.toolBar.add(jButton5);
        JButton jButton6 = new JButton(this.gotoAction);
        jButton6.setFocusable(false);
        this.toolBar.add(jButton6);
        this.toolBar.addSeparator();
        defaultDropDownButton2.addToToolBar(this.toolBar);
        defaultDropDownButton.addToToolBar(this.toolBar);
        this.toolBar.addSeparator();
        this.zoomInButton.addToToolBar(this.toolBar);
        this.zoomOutButton.addToToolBar(this.toolBar);
        this.toolBar.add(this.infoButton);
    }

    private void setPopup() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(127, 0);
        KeyStroke keyStroke2 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(107, 256) : KeyStroke.getKeyStroke(107, 128);
        KeyStroke keyStroke3 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(109, 256) : KeyStroke.getKeyStroke(109, 128);
        KeyStroke keyStroke4 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(71, 256) : KeyStroke.getKeyStroke(71, 128);
        KeyStroke keyStroke5 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(68, 256) : KeyStroke.getKeyStroke(68, 128);
        this.deleteAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/delete.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JProjectViewResourceSheet.this.resourceSheet.getTreeTable().getSelectedRowCount() == 1) {
                    int n = JProjectViewResourceSheet.this.resourceSheet.getTreeTable().getSelectedRow();
                    Object object = JProjectViewResourceSheet.this.resourceSheet.getTreeTable().getPathForRow(n).getLastPathComponent();
                    if (object instanceof Assignment) {
                        Assignment assignment = (Assignment)object;
                        ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(JProjectViewResourceSheet.this.project);
                        assignment.discard(extendedCompoundEdit);
                        extendedCompoundEdit.end();
                        TaskPlanner.rescheduleTree(JProjectViewResourceSheet.this.project);
                        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                        JProjectViewResourceSheet.this.fireUndoableEditHappened(undoableEditEvent);
                    } else {
                        Resource resource = (Resource)object;
                        Object[] objectArray = new Object[]{resource.getName()};
                        int n2 = JOptionPane.showConfirmDialog(Common.getApplication(), MessageFormat.format(Common.I18N_MESSAGES.getString("removeAllAssignments.message"), objectArray), Common.I18N_MESSAGES.getString("removeAllAssignments.title"), 0, 2);
                        if (n2 == 0) {
                            Assignment[] assignmentArray = resource.getAssignments().toArray(new Assignment[0]);
                            ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(JProjectViewResourceSheet.this.project);
                            for (int i = 0; i < assignmentArray.length; ++i) {
                                Assignment assignment = assignmentArray[i];
                                assignment.discard(extendedCompoundEdit);
                            }
                            TaskPlanner.rescheduleTree(JProjectViewResourceSheet.this.project);
                            extendedCompoundEdit.end();
                            UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                            JProjectViewResourceSheet.this.fireUndoableEditHappened(undoableEditEvent);
                        }
                    }
                }
            }
        };
        this.deleteAction.putValue("AcceleratorKey", keyStroke);
        this.deleteAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("assignment.delete.tooltip"));
        this.expandAllAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/expand.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                JProjectViewResourceSheet.this.resourceSheet.getTreeTable().expandAll();
            }
        };
        String string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("expandAll") + " (Cmmd-+)" : Common.I18N_ACTIONS.getString("expandAll") + " (Ctrl-+)";
        this.expandAllAction.putValue("ShortDescription", string);
        this.expandAllAction.putValue("AcceleratorKey", keyStroke2);
        this.collapseAllAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/collapse.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                JProjectViewResourceSheet.this.resourceSheet.getTreeTable().collapseAll();
            }
        };
        string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("collapseAll") + " (Cmmd--)" : Common.I18N_ACTIONS.getString("collapseAll") + " (Ctrl--)";
        this.collapseAllAction.putValue("ShortDescription", string);
        this.collapseAllAction.putValue("AcceleratorKey", keyStroke3);
        this.expandAction = new AbstractAction(Common.I18N_ACTIONS.getString("expand"), new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/empty.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeSelectionModel treeSelectionModel = JProjectViewResourceSheet.this.resourceSheet.getTreeTable().getTreeSelectionModel();
                if (!treeSelectionModel.isSelectionEmpty()) {
                    int[] nArray = treeSelectionModel.getSelectionRows();
                    for (int i = 0; i < nArray.length; ++i) {
                        JProjectViewResourceSheet.this.resourceSheet.getTreeTable().expandRow(nArray[i]);
                    }
                }
            }
        };
        this.expandAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("expand"));
        this.collapseAction = new AbstractAction(Common.I18N_ACTIONS.getString("collapse"), new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/empty.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeSelectionModel treeSelectionModel = JProjectViewResourceSheet.this.resourceSheet.getTreeTable().getTreeSelectionModel();
                if (!treeSelectionModel.isSelectionEmpty()) {
                    int[] nArray = treeSelectionModel.getSelectionRows();
                    for (int i = 0; i < nArray.length; ++i) {
                        JProjectViewResourceSheet.this.resourceSheet.getTreeTable().collapseRow(nArray[i]);
                    }
                }
            }
        };
        this.collapseAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("collapse"));
        this.gotoAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/go_to.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JProjectViewResourceSheet.this.resourceSheet.getTreeTable().getSelectedRowCount() == 1) {
                    int n = JProjectViewResourceSheet.this.resourceSheet.getTreeTable().getSelectedRow();
                    Object object = JProjectViewResourceSheet.this.resourceSheet.getTreeTable().getPathForRow(n).getLastPathComponent();
                    TimeScaleManager timeScaleManager = JProjectViewResourceSheet.this.resourceSheet.getArea().getTimeScaleManager();
                    if (object instanceof Assignment) {
                        timeScaleManager.focusOnDate(((Assignment)object).getTask().getStartDate());
                    } else {
                        Date date = ((Resource)object).getFirstWorkingDate();
                        if (date != null) {
                            timeScaleManager.focusOnDate(date);
                        }
                    }
                }
            }
        };
        string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("task.focusOn") + " (Cmmd-G)" : Common.I18N_ACTIONS.getString("task.focusOn") + " (Ctrl-G)";
        this.gotoAction.putValue("ShortDescription", string);
        this.gotoAction.putValue("AcceleratorKey", keyStroke4);
        this.detailsAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/info.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!JProjectViewResourceSheet.this.taskView.isVisible()) {
                    JProjectViewResourceSheet.this.taskView.setVisible(true);
                    JProjectViewResourceSheet.this.humanView.setVisible(true);
                    JProjectViewResourceSheet.this.materialView.setVisible(true);
                    JProjectViewResourceSheet.this.infoButton.setSelected(true);
                    JProjectViewResourceSheet.this.infoItem.setSelected(true);
                    JProjectViewResourceSheet.this.splitPane.setDividerLocation(-1);
                    JProjectViewResourceSheet.this.splitPane.setDividerSize(5);
                } else {
                    JProjectViewResourceSheet.this.taskView.setVisible(false);
                    JProjectViewResourceSheet.this.humanView.setVisible(false);
                    JProjectViewResourceSheet.this.materialView.setVisible(false);
                    JProjectViewResourceSheet.this.infoButton.setSelected(false);
                    JProjectViewResourceSheet.this.infoItem.setSelected(false);
                    JProjectViewResourceSheet.this.splitPane.setDividerSize(0);
                }
            }
        };
        string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("details.tooltip") + " (Cmmd-D)" : Common.I18N_ACTIONS.getString("details.tooltip") + " (Ctrl-D)";
        this.detailsAction.putValue("ShortDescription", string);
        this.detailsAction.putValue("AcceleratorKey", keyStroke5);
        ActionMap actionMap = this.resourceSheet.getTreeTable().getActionMap();
        actionMap.put("delete", this.deleteAction);
        actionMap.put("expandAll", this.expandAllAction);
        actionMap.put("collapseAll", this.collapseAllAction);
        actionMap.put("goto", this.gotoAction);
        actionMap.put("details", this.detailsAction);
        InputMap inputMap = this.resourceSheet.getTreeTable().getInputMap(1);
        inputMap.put(keyStroke, "delete");
        inputMap.put(keyStroke2, "expandAll");
        inputMap.put(keyStroke3, "collapseAll");
        inputMap.put(keyStroke4, "goto");
        inputMap.put(keyStroke5, "details");
        JMenuItem jMenuItem = new JMenuItem(this.deleteAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("assignment.delete"));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.expandAction);
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.collapseAction);
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.gotoAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("item.focusOn"));
        this.popupMenu.add(jMenuItem);
        this.infoItem = new JCheckBoxMenuItem(Common.I18N_ACTIONS.getString("details"), new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/info.png")));
        this.infoItem.setToolTipText(Common.I18N_ACTIONS.getString("details.tooltip"));
        this.infoItem.setAccelerator(keyStroke5);
        this.infoItem.setSelected(false);
        this.infoItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JProjectViewResourceSheet.this.infoButton.doClick();
            }
        });
        this.popupMenu.add(this.infoItem);
        this.resourceSheet.getTreeTable().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            private void showPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    TreePath treePath = JProjectViewResourceSheet.this.resourceSheet.getTreeTable().getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    TreePath[] treePathArray = JProjectViewResourceSheet.this.resourceSheet.getTreeTable().getTreeSelectionModel().getSelectionPaths();
                    boolean bl = false;
                    if (treePathArray != null) {
                        for (int i = 0; i < treePathArray.length; ++i) {
                            TreePath treePath2 = treePathArray[i];
                            if (!treePath2.equals(treePath)) continue;
                            bl = true;
                        }
                    }
                    if (!bl) {
                        JProjectViewResourceSheet.this.resourceSheet.getTreeTable().getTreeSelectionModel().setSelectionPath(treePath);
                    }
                    JProjectViewResourceSheet.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        return this.resourceSheet.print(graphics, pageFormat, n);
    }

    public int getNumberOfPages() {
        return this.resourceSheet.getNumberOfPages();
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        return this.resourceSheet.getPageFormat(n);
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        return this.resourceSheet.getPrintable(n);
    }

    public int getHorizontalNumberOfPages() {
        return this.resourceSheet.getHorizontalNumberOfPages();
    }

    public int getVerticalNumberOfPages() {
        return this.resourceSheet.getVerticalNumberOfPages();
    }

    public Dimension getPrintSize() {
        return this.resourceSheet.getPrintSize();
    }

    public JResourceChart getResourceSheet() {
        return this.resourceSheet;
    }

    public void showInfo() {
        this.taskView.setVisible(true);
        this.humanView.setVisible(true);
        this.materialView.setVisible(true);
        this.splitPane.setDividerLocation(-1);
        this.infoButton.setSelected(true);
    }

    public JToggleButton getInfoButton() {
        return this.infoButton;
    }

    public TaskDetailView getTaskView() {
        return this.taskView;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public void updateInfoButtons() {
        this.infoButton.setSelected(this.taskView.isVisible());
        this.infoItem.setSelected(this.taskView.isVisible());
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }
}

