/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component.view;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Link;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.event.TaskAdapter;
import com.sbs.jpm.core.event.TaskEvent;
import com.sbs.jpm.core.event.TaskListener;
import com.sbs.jpm.ui.component.JCorner;
import com.sbs.jpm.ui.component.JLinkEditorDialog;
import com.sbs.jpm.ui.component.JProjectLinksTable;
import com.sbs.jpm.ui.component.JProjectView;
import com.sbs.jpm.ui.component.JRowHeader;
import com.sbs.jpm.ui.component.model.ProjectLinksTableModel;
import com.sbs.jpm.ui.component.util.JTextComponentUndoHandler;
import com.sbs.jpm.undo.LinkDeleteEdit;
import com.sbs.jpm.undo.TaskNotesEdit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;

public class JProjectViewNotes
extends JProjectView {
    private Action addAction;
    private Action deleteAction;
    private Action editAction;
    private JTextArea projectNotesArea;
    private JRowHeader rowHeader;
    private JProjectLinksTable projectLinksTable;
    private DocumentListener projectNotesDocumentListener;
    private AssumptionsHandler assumptionHandler;
    private TaskListener taskHandler = new TaskHandler();

    public JProjectViewNotes() {
        this.assumptionHandler = new AssumptionsHandler();
        this.projectNotesDocumentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!JProjectViewNotes.this.projectNotesArea.getText().equals(JProjectViewNotes.this.project.getNotes())) {
                    JProjectViewNotes.this.project.setNotes(JProjectViewNotes.this.projectNotesArea.getText());
                }
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                if (!JProjectViewNotes.this.projectNotesArea.getText().equals(JProjectViewNotes.this.project.getNotes())) {
                    JProjectViewNotes.this.project.setNotes(JProjectViewNotes.this.projectNotesArea.getText());
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
    }

    protected void updateDetailsAndToolbar() {
    }

    public void setProject(Task task) {
        if (this.project != null) {
            this.project.removeTaskListener(this.taskHandler);
        }
        super.setProject(task);
        if (this.project != null) {
            this.projectNotesArea.setEnabled(true);
            this.projectLinksTable.setEnabled(true);
            this.addAction.setEnabled(true);
            this.deleteAction.setEnabled(true);
            this.editAction.setEnabled(true);
            this.updateValues();
            new JTextComponentUndoHandler(this.projectNotesArea);
            this.project.addTaskListener(this.taskHandler);
        } else {
            this.projectNotesArea.setEnabled(false);
            this.projectLinksTable.clearSelection();
            this.projectLinksTable.setEnabled(false);
            this.addAction.setEnabled(false);
            this.deleteAction.setEnabled(false);
            this.editAction.setEnabled(false);
            this.updateValues();
        }
    }

    private JPanel createContentsNotes() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(5, 5, 5, 5);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        this.projectNotesArea = new JTextArea(7, 30);
        this.projectNotesArea.setLineWrap(true);
        this.projectNotesArea.setWrapStyleWord(true);
        this.projectLinksTable = new JProjectLinksTable();
        this.projectLinksTable.setSelectionMode(0);
        this.rowHeader = new JRowHeader(this.projectLinksTable){

            protected void dispatch(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    int n = JProjectViewNotes.this.projectLinksTable.rowAtPoint(mouseEvent.getPoint());
                    JProjectViewNotes.this.projectLinksTable.getSelectionModel().setSelectionInterval(n, n);
                } else {
                    super.dispatch(mouseEvent);
                }
            }
        };
        jPanel2.add((Component)new JLabel(Common.I18N_RP.getString("projectNotes") + ":"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel2.add((Component)new JScrollPane(this.projectNotesArea), new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 21, 1, insets, 0, 0));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEtchedBorder());
        Dimension dimension = new Dimension(2, 2);
        jPanel3.setMinimumSize(dimension);
        jPanel3.setMaximumSize(dimension);
        jPanel3.setPreferredSize(dimension);
        jPanel2.add((Component)jPanel3, new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 23, 2, insets, 0, 0));
        this.addAction = new AbstractAction(Common.I18N_ACTIONS.getString("link.add"), new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/new.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                JLinkEditorDialog jLinkEditorDialog = new JLinkEditorDialog(JProjectViewNotes.this.project, null, JProjectViewNotes.this);
                jLinkEditorDialog.pack();
                jLinkEditorDialog.setLocationRelativeTo(Common.getApplication());
                jLinkEditorDialog.setVisible(true);
            }
        };
        this.deleteAction = new AbstractAction(Common.I18N_ACTIONS.getString("link.delete"), new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/delete.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectLinksTableModel projectLinksTableModel;
                Task task;
                int n;
                if (JProjectViewNotes.this.projectLinksTable.getSelectedRowCount() == 1 && (n = JProjectViewNotes.this.projectLinksTable.getSelectedRow()) < (task = (projectLinksTableModel = (ProjectLinksTableModel)JProjectViewNotes.this.projectLinksTable.getModel()).getProject()).getLinksNumber()) {
                    Link link = task.getLinkAt(n);
                    LinkDeleteEdit linkDeleteEdit = new LinkDeleteEdit(task, link, n, "05/10/2009 16:37:01");
                    task.removeLinkAt(n);
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, linkDeleteEdit);
                    JProjectViewNotes.this.fireUndoableEditHappened(undoableEditEvent);
                }
            }
        };
        this.editAction = new AbstractAction(Common.I18N_ACTIONS.getString("link.edit"), new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/edit.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JProjectViewNotes.this.projectLinksTable.getSelectedRowCount() == 1) {
                    Link link = JProjectViewNotes.this.project.getLinkAt(JProjectViewNotes.this.projectLinksTable.getSelectedRow());
                    JLinkEditorDialog jLinkEditorDialog = new JLinkEditorDialog(JProjectViewNotes.this.project, link, JProjectViewNotes.this);
                    jLinkEditorDialog.pack();
                    jLinkEditorDialog.setLocationRelativeTo(Common.getApplication());
                    jLinkEditorDialog.setVisible(true);
                }
            }
        };
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        jPanel4.add((Component)new JButton(this.addAction), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 3, 0, 3), 0, 0));
        jPanel4.add((Component)new JButton(this.deleteAction), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 3, 0, 3), 0, 0));
        jPanel4.add((Component)new JButton(this.editAction), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 3, 0, 3), 0, 0));
        jPanel2.add((Component)new JLabel(Common.I18N_RP.getString("projectLinks") + ": "), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        jPanel2.add((Component)jPanel4, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 13, 0, insets, 0, 0));
        JScrollPane jScrollPane = new JScrollPane(this.projectLinksTable);
        jScrollPane.setPreferredSize(new Dimension(100, 100));
        jScrollPane.setRowHeaderView(this.rowHeader);
        jScrollPane.setCorner("UPPER_LEFT_CORNER", new JCorner());
        jPanel2.add((Component)jScrollPane, new GridBagConstraints(0, 5, 3, 1, 1.0, 0.3, 21, 1, insets, 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 9, 0));
        return jPanel;
    }

    protected JPanel createContents() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        jPanel.add((Component)this.createContentsNotes(), "Center");
        return jPanel;
    }

    private void updateValues() {
        this.removeListeners();
        if (this.project != null) {
            try {
                this.projectNotesArea.setText(this.project.getNotes());
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.projectLinksTable.setProject(this.project);
            this.rowHeader.setTableModel(this.projectLinksTable.getModel());
        } else {
            this.projectNotesArea.setText("");
            this.projectLinksTable.setModel(new ProjectLinksTableModel());
        }
        this.addListeners();
    }

    private void addListeners() {
        this.projectNotesArea.addFocusListener(this.assumptionHandler);
        this.projectNotesArea.getDocument().addDocumentListener(this.projectNotesDocumentListener);
    }

    private void removeListeners() {
        this.projectNotesArea.getDocument().removeDocumentListener(this.projectNotesDocumentListener);
        this.projectNotesArea.removeFocusListener(this.assumptionHandler);
    }

    private class AssumptionsHandler
    implements FocusListener {
        private String oldNotes = "";

        private AssumptionsHandler() {
        }

        private void doIt() {
            String string = JProjectViewNotes.this.projectNotesArea.getText();
            if (!string.equals(this.oldNotes)) {
                TaskNotesEdit taskNotesEdit = new TaskNotesEdit(JProjectViewNotes.this.project, this.oldNotes, string, "02/10/2009 17:50:00");
                JProjectViewNotes.this.project.setNotes(string);
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, taskNotesEdit);
                JProjectViewNotes.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            this.oldNotes = JProjectViewNotes.this.projectNotesArea.getText();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }

    private class TaskHandler
    extends TaskAdapter {
        private TaskHandler() {
        }

        public void projectChanged(TaskEvent taskEvent) {
            JProjectViewNotes.this.updateValues();
        }

        public void nameChanged(TaskEvent taskEvent) {
            JProjectViewNotes.this.updateValues();
        }

        public void notesChanged(TaskEvent taskEvent) {
            JProjectViewNotes.this.updateValues();
        }

        public void dataChanged(TaskEvent taskEvent) {
            JProjectViewNotes.this.updateValues();
        }
    }
}

