/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component.view;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.MaterialResource;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.print.CustomPageable;
import com.sbs.jpm.ui.action.CustomFlavor;
import com.sbs.jpm.ui.action.MaterialResourceSelection;
import com.sbs.jpm.ui.component.JCorner;
import com.sbs.jpm.ui.component.JMaterialResourcesTable;
import com.sbs.jpm.ui.component.JProjectView;
import com.sbs.jpm.ui.component.JRowHeader;
import com.sbs.jpm.ui.component.MResourceDetailView;
import com.sbs.jpm.ui.component.model.MaterialResourcesTableModel;
import com.sbs.jpm.undo.DeleteEmptyMaterialResourcesEdit;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import com.sbs.jpm.undo.ResourceDeleteEdit;
import com.sbs.jpm.undo.ResourceInsertEdit;
import com.sbs.jpm.undo.ResourceNameEdit;
import com.sbs.util.ExcelAdapter;
import com.sbs.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.UndoableEditEvent;

public class JProjectViewMaterialResource
extends JProjectView
implements CustomPageable {
    private static final long serialVersionUID = 1L;
    private JMaterialResourcesTable resourceTable;
    private MResourceDetailView resourceView;
    private JRowHeader rowHeader;
    private JToggleButton infoButton;
    private JCheckBoxMenuItem infoItem;
    private Action insertAction;
    private Action newResourceAction;
    private Action deleteAction;
    private Action cutAction;
    private Action copyAction;
    private Action pasteAction;
    private Action detailsAction;
    private JPopupMenu popupMenu;
    private JSplitPane splitPane;

    private JPanel createContentsResourceTable() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        this.resourceTable = new JMaterialResourcesTable();
        this.resourceTable.setProjectView(this);
        this.resourceTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    JProjectViewMaterialResource.this.updateToolbar();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.resourceTable));
        jScrollPane.getViewport().setBackground(this.resourceTable.getBackground());
        this.rowHeader = new JRowHeader((JTable)((Object)this.resourceTable));
        jScrollPane.setRowHeaderView(this.rowHeader);
        JCorner jCorner = new JCorner();
        jScrollPane.setCorner("UPPER_LEFT_CORNER", jCorner);
        jCorner = new JCorner();
        jScrollPane.setCorner("LOWER_LEFT_CORNER", jCorner);
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, insets, 9, 0));
        return jPanel;
    }

    private JPanel createContentsResource() {
        this.resourceView = new MResourceDetailView();
        this.resourceView.setVisible(false);
        return this.resourceView;
    }

    protected JPanel createContents() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.popupMenu = new JPopupMenu();
        this.splitPane = new JSplitPane(0, this.createContentsResourceTable(), this.createContentsResource());
        this.splitPane.setResizeWeight(0.7);
        this.splitPane.setDividerSize(5);
        this.splitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        if (SystemUtilities.isOSMac()) {
            this.splitPane.putClientProperty("Quaqua.SplitPane.style", "bar");
        }
        jPanel.add((Component)this.splitPane, "Center");
        this.resourceView.setResource(null);
        return jPanel;
    }

    public void setProject(Task task) {
        super.setProject(task);
        this.resourceTable.setProject(task);
        this.rowHeader.setTableModel(this.resourceTable.getModel());
    }

    protected void createToolBar() {
        super.createToolBar();
        this.setPopup();
        this.infoButton = new JToggleButton(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/info.png")), false);
        this.infoButton.setAction(this.detailsAction);
        this.insertAction.setEnabled(false);
        this.deleteAction.setEnabled(false);
        this.cutAction.setEnabled(false);
        this.copyAction.setEnabled(false);
        this.pasteAction.setEnabled(false);
        JButton jButton = new JButton(this.insertAction);
        jButton.setFocusable(false);
        this.toolBar.add(jButton);
        JButton jButton2 = new JButton(this.deleteAction);
        jButton2.setFocusable(false);
        this.toolBar.addSeparator();
        JButton jButton3 = new JButton(this.cutAction);
        jButton3.setFocusable(false);
        JButton jButton4 = new JButton(this.copyAction);
        jButton4.setFocusable(false);
        JButton jButton5 = new JButton(this.pasteAction);
        jButton5.setFocusable(false);
        this.toolBar.add(this.infoButton);
    }

    private void setPopup() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(155, 0);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(127, 0);
        KeyStroke keyStroke3 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(88, 256) : KeyStroke.getKeyStroke(88, 128);
        KeyStroke keyStroke4 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(67, 256) : KeyStroke.getKeyStroke(67, 128);
        KeyStroke keyStroke5 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(86, 256) : KeyStroke.getKeyStroke(86, 128);
        KeyStroke keyStroke6 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(68, 256) : KeyStroke.getKeyStroke(68, 128);
        this.insertAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/insertLine.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JProjectViewMaterialResource.this.resourceTable.getSelectedRowCount() == 1) {
                    int n = JProjectViewMaterialResource.this.resourceTable.getSelectedRow();
                    MaterialResourcesTableModel materialResourcesTableModel = (MaterialResourcesTableModel)JProjectViewMaterialResource.this.resourceTable.getModel();
                    Company company = materialResourcesTableModel.getCompany();
                    MaterialResource materialResource = new MaterialResource(Common.getIdGenerator().getNewId());
                    ResourceInsertEdit resourceInsertEdit = new ResourceInsertEdit(company, materialResource, n, false, "09/11/09 14:56:03");
                    company.addResource(n, materialResource);
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, resourceInsertEdit);
                    JProjectViewMaterialResource.this.fireUndoableEditHappened(undoableEditEvent);
                    JProjectViewMaterialResource.this.resourceTable.setRowSelectionInterval(n, n);
                }
            }
        };
        String string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("insertLine") : Common.I18N_ACTIONS.getString("insertLine") + " (Insert)";
        this.insertAction.putValue("ShortDescription", string);
        this.insertAction.putValue("AcceleratorKey", keyStroke);
        this.newResourceAction = new AbstractAction(Common.I18N_ACTIONS.getString("resource.new"), new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/empty.png"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                JProjectView.BLOCK_UPDATE = true;
                try {
                    if (JProjectViewMaterialResource.this.resourceTable.getSelectedRowCount() == 1) {
                        MaterialResourcesTableModel materialResourcesTableModel;
                        Company company;
                        int n = JProjectViewMaterialResource.this.resourceTable.getSelectedRow();
                        if (n < (company = (materialResourcesTableModel = (MaterialResourcesTableModel)JProjectViewMaterialResource.this.resourceTable.getModel()).getCompany()).getMaterialResourcesNumber()) {
                            MaterialResource materialResource = new MaterialResource(Common.getIdGenerator().getNewId());
                            ResourceInsertEdit resourceInsertEdit = new ResourceInsertEdit(company, materialResource, n, false, "09/11/09 14:56:06");
                            company.addResource(n, materialResource);
                            materialResource.setName(Common.I18N_ACTIONS.getString("resource.new"));
                            UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, resourceInsertEdit);
                            JProjectViewMaterialResource.this.fireUndoableEditHappened(undoableEditEvent);
                            JProjectViewMaterialResource.this.resourceTable.setRowSelectionInterval(n, n);
                        } else {
                            ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                            ((MaterialResourcesTableModel)JProjectViewMaterialResource.this.resourceTable.getModel()).insertEmptyResources(n - company.getMaterialResourcesNumber() + 1, extendedCompoundEdit);
                            MaterialResource materialResource = company.getMaterialResourceAt(n);
                            ResourceNameEdit resourceNameEdit = new ResourceNameEdit(materialResource, materialResource.getName(), Common.I18N_ACTIONS.getString("resource.new"), "09/11/09 13:14:04");
                            materialResource.setName(Common.I18N_ACTIONS.getString("resource.new"));
                            extendedCompoundEdit.addEdit(resourceNameEdit);
                            extendedCompoundEdit.end();
                            UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                            JProjectViewMaterialResource.this.fireUndoableEditHappened(undoableEditEvent);
                        }
                    }
                }
                finally {
                    JProjectView.BLOCK_UPDATE = false;
                    JProjectViewMaterialResource.this.updateToolbar();
                }
            }
        };
        this.newResourceAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("resource.new"));
        this.deleteAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/delete.png"))){

            /*
             * WARNING - void declaration
             */
            public void actionPerformed(ActionEvent actionEvent) {
                void var10_14;
                int[] nArray = JProjectViewMaterialResource.this.resourceTable.getSelectedRows();
                int n = nArray.length;
                int n2 = nArray[n - 1];
                MaterialResourcesTableModel materialResourcesTableModel = (MaterialResourcesTableModel)JProjectViewMaterialResource.this.resourceTable.getModel();
                Company company = materialResourcesTableModel.getCompany();
                LinkedList<MaterialResource> linkedList = new LinkedList<MaterialResource>();
                for (int i = 0; i < nArray.length; ++i) {
                    int n3 = nArray[i];
                    if (n3 >= company.getMaterialResourcesNumber()) continue;
                    linkedList.add(company.getMaterialResourceAt(n3));
                }
                ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                for (Resource resource : linkedList) {
                    int n3 = company.getMaterialResourceIndex(resource);
                    ResourceDeleteEdit resourceDeleteEdit = new ResourceDeleteEdit(company, resource, n3, "09/11/09 14:59:02");
                    company.removeResource(resource);
                    List<MaterialResource> list = company.removeEmptyMaterialResources();
                    DeleteEmptyMaterialResourcesEdit deleteEmptyMaterialResourcesEdit = new DeleteEmptyMaterialResourcesEdit(company, list, "06/10/09 18:04:00");
                    extendedCompoundEdit.addEdit(resourceDeleteEdit);
                    extendedCompoundEdit.addEdit(deleteEmptyMaterialResourcesEdit);
                }
                extendedCompoundEdit.end();
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                JProjectViewMaterialResource.this.fireUndoableEditHappened(undoableEditEvent);
                int n5 = n2 - n + 1;
                if (n5 != 0 && n2 == JProjectViewMaterialResource.this.resourceTable.getRowCount() - 1) {
                    --var10_14;
                }
                JProjectViewMaterialResource.this.resourceTable.setRowSelectionInterval((int)var10_14, (int)var10_14);
            }
        };
        this.deleteAction.putValue("AcceleratorKey", keyStroke2);
        this.deleteAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("resource.delete"));
        this.cutAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Cut16.gif"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = JProjectViewMaterialResource.this.resourceTable.getSelectedRows();
                if (JProjectViewMaterialResource.this.resourceTable.getSelectedRowCount() != 0) {
                    Object object;
                    Company company = ((MaterialResourcesTableModel)JProjectViewMaterialResource.this.resourceTable.getModel()).getCompany();
                    Arrays.sort(nArray);
                    LinkedList<Resource> linkedList = new LinkedList<Resource>();
                    ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                    for (int i = 0; i < nArray.length; ++i) {
                        if (nArray[i] >= company.getMaterialResourcesNumber() || ((Resource)(object = company.getMaterialResourceAt(nArray[i]))).isEmpty()) continue;
                        linkedList.add((Resource)object);
                    }
                    List<Resource> list = Company.cloneResources(linkedList, false);
                    object = new MaterialResourceSelection(list, ExcelAdapter.resourcesToString(JProjectViewMaterialResource.this.resourceTable));
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)object, null);
                    JProjectView.BLOCK_UPDATE = true;
                    try {
                        for (Resource resource : linkedList) {
                            ResourceDeleteEdit resourceDeleteEdit = new ResourceDeleteEdit(company, resource, company.getMaterialResourceIndex(resource), "09/11/09 14:59:03");
                            company.removeResource(resource);
                            extendedCompoundEdit.addEdit(resourceDeleteEdit);
                            company.removeEmptyMaterialResources();
                        }
                        extendedCompoundEdit.end();
                        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                        JProjectViewMaterialResource.this.fireUndoableEditHappened(undoableEditEvent);
                        int n = 0;
                        for (Resource resource : linkedList) {
                            n = company.getMaterialResourceIndex(resource);
                            JProjectViewMaterialResource.this.resourceTable.getSelectionModel().addSelectionInterval(n, n);
                        }
                        JProjectViewMaterialResource.this.resourceTable.scrollRowToVisible(n);
                    }
                    finally {
                        JProjectView.BLOCK_UPDATE = false;
                        JProjectViewMaterialResource.this.updateToolbar();
                    }
                }
            }
        };
        this.cutAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("cut"));
        this.cutAction.putValue("AcceleratorKey", keyStroke3);
        this.copyAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Copy16.gif"))){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = JProjectViewMaterialResource.this.resourceTable.getSelectedRows();
                if (JProjectViewMaterialResource.this.resourceTable.getSelectedRowCount() != 0) {
                    Object object;
                    Company company = ((MaterialResourcesTableModel)JProjectViewMaterialResource.this.resourceTable.getModel()).getCompany();
                    Arrays.sort(nArray);
                    LinkedList<Resource> linkedList = new LinkedList<Resource>();
                    for (int i = 0; i < nArray.length; ++i) {
                        if (nArray[i] >= company.getMaterialResourcesNumber() || ((Resource)(object = company.getMaterialResourceAt(nArray[i]))).isEmpty()) continue;
                        linkedList.add((Resource)object);
                    }
                    List<Resource> list = Company.cloneResources(linkedList, false);
                    object = new MaterialResourceSelection(list, ExcelAdapter.resourcesToString(JProjectViewMaterialResource.this.resourceTable));
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)object, null);
                }
            }
        };
        this.copyAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("copy"));
        this.copyAction.putValue("AcceleratorKey", keyStroke4);
        this.pasteAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Paste16.gif"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                block19: {
                    if (JProjectViewMaterialResource.this.resourceTable.getSelectedRowCount() != 0) {
                        JProjectView.BLOCK_UPDATE = true;
                        try {
                            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                            List list = null;
                            try {
                                if (transferable == null) break block19;
                                if (transferable.isDataFlavorSupported(CustomFlavor.materialResourceListFlavor)) {
                                    Company company;
                                    ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                                    int n = JProjectViewMaterialResource.this.resourceTable.getSelectedRow();
                                    if (n >= (company = ((MaterialResourcesTableModel)JProjectViewMaterialResource.this.resourceTable.getModel()).getCompany()).getMaterialResourcesNumber()) {
                                        ((MaterialResourcesTableModel)JProjectViewMaterialResource.this.resourceTable.getModel()).insertEmptyResources(n - company.getMaterialResourcesNumber(), extendedCompoundEdit);
                                    }
                                    list = (List)transferable.getTransferData(CustomFlavor.materialResourceListFlavor);
                                    List<Resource> list2 = Company.cloneResources(list, true);
                                    JProjectViewMaterialResource.this.resourceTable.getSelectionModel().clearSelection();
                                    for (MaterialResource materialResource : list2) {
                                        ResourceInsertEdit resourceInsertEdit = new ResourceInsertEdit(company, materialResource, n, true, "09/11/09 14:56:04");
                                        extendedCompoundEdit.addEdit(resourceInsertEdit);
                                        company.addResource(n, materialResource);
                                        JProjectViewMaterialResource.this.resourceTable.getSelectionModel().addSelectionInterval(n, n);
                                        ++n;
                                    }
                                    extendedCompoundEdit.end();
                                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                                    JProjectViewMaterialResource.this.fireUndoableEditHappened(undoableEditEvent);
                                    break block19;
                                }
                                if (!transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) break block19;
                                int n = JProjectViewMaterialResource.this.resourceTable.getSelectedRows()[0];
                                int n2 = JProjectViewMaterialResource.this.resourceTable.getSelectedColumns()[0];
                                try {
                                    String string = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).getTransferData(DataFlavor.stringFlavor);
                                    StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                                    int n3 = 0;
                                    while (stringTokenizer.hasMoreTokens()) {
                                        String string2 = stringTokenizer.nextToken();
                                        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "\t");
                                        int n4 = 0;
                                        while (stringTokenizer2.hasMoreTokens()) {
                                            String string3 = stringTokenizer2.nextToken();
                                            if (n + n3 < JProjectViewMaterialResource.this.resourceTable.getRowCount() && n2 + n4 < JProjectViewMaterialResource.this.resourceTable.getColumnCount()) {
                                                Number number;
                                                Class clazz = JProjectViewMaterialResource.this.resourceTable.getColumnClass(n2 + n4);
                                                if (clazz.equals(Double.class)) {
                                                    number = Double.parseDouble(string3);
                                                    JProjectViewMaterialResource.this.resourceTable.setValueAt(number, n + n3, n2 + n4);
                                                } else if (clazz.equals(Long.class)) {
                                                    number = Long.parseLong(string3);
                                                    JProjectViewMaterialResource.this.resourceTable.setValueAt(number, n + n3, n2 + n4);
                                                } else {
                                                    JProjectViewMaterialResource.this.resourceTable.setValueAt(string3, n + n3, n2 + n4);
                                                }
                                            }
                                            ++n4;
                                        }
                                        ++n3;
                                    }
                                }
                                catch (Exception exception) {
                                    Common.logException("Error:", exception);
                                    exception.printStackTrace();
                                }
                            }
                            catch (UnsupportedFlavorException unsupportedFlavorException) {
                                Common.logException("Error:", unsupportedFlavorException);
                                unsupportedFlavorException.printStackTrace();
                            }
                            catch (IOException iOException) {
                                Common.logException("Error:", iOException);
                                iOException.printStackTrace();
                            }
                        }
                        finally {
                            JProjectView.BLOCK_UPDATE = false;
                            JProjectViewMaterialResource.this.updateToolbar();
                        }
                    }
                }
            }
        };
        this.pasteAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("paste"));
        this.pasteAction.putValue("AcceleratorKey", keyStroke5);
        this.detailsAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/info.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!JProjectViewMaterialResource.this.resourceView.isVisible()) {
                    JProjectViewMaterialResource.this.resourceView.setVisible(true);
                    JProjectViewMaterialResource.this.infoButton.setSelected(true);
                    JProjectViewMaterialResource.this.infoItem.setSelected(true);
                    JProjectViewMaterialResource.this.splitPane.setDividerLocation(-1);
                    JProjectViewMaterialResource.this.splitPane.setDividerSize(5);
                } else {
                    JProjectViewMaterialResource.this.resourceView.setVisible(false);
                    JProjectViewMaterialResource.this.infoButton.setSelected(false);
                    JProjectViewMaterialResource.this.infoItem.setSelected(false);
                    JProjectViewMaterialResource.this.splitPane.setDividerSize(0);
                }
            }
        };
        string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("details.tooltip") + " (Cmmd-D)" : Common.I18N_ACTIONS.getString("details.tooltip") + " (Ctrl-D)";
        this.detailsAction.putValue("ShortDescription", string);
        this.detailsAction.putValue("AcceleratorKey", keyStroke6);
        ActionMap actionMap = this.resourceTable.getActionMap();
        actionMap.put("insert", this.insertAction);
        actionMap.put("delete", this.deleteAction);
        actionMap.put("cut", this.cutAction);
        actionMap.put("copy", this.copyAction);
        actionMap.put("paste", this.pasteAction);
        actionMap.put("details", this.detailsAction);
        InputMap inputMap = this.resourceTable.getInputMap(1);
        inputMap.put(keyStroke, "insert");
        inputMap.put(keyStroke2, "delete");
        inputMap.put(keyStroke3, "cut");
        inputMap.put(keyStroke4, "copy");
        inputMap.put(keyStroke5, "paste");
        inputMap.put(keyStroke6, "details");
        JMenuItem jMenuItem = new JMenuItem(this.insertAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("insertLine"));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.newResourceAction);
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.deleteAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("resource.delete"));
        this.popupMenu.add(jMenuItem);
        this.popupMenu.addSeparator();
        jMenuItem = new JMenuItem(this.cutAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("cut"));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.copyAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("copy"));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.pasteAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("paste"));
        this.popupMenu.add(jMenuItem);
        this.popupMenu.addSeparator();
        this.infoItem = new JCheckBoxMenuItem(Common.I18N_ACTIONS.getString("details.resource"), new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/info.png")));
        this.infoItem.setAccelerator(keyStroke6);
        this.infoItem.setSelected(false);
        this.infoItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JProjectViewMaterialResource.this.infoButton.doClick();
            }
        });
        this.popupMenu.add(this.infoItem);
        this.resourceTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            private void showPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    int n = JProjectViewMaterialResource.this.resourceTable.rowAtPoint(mouseEvent.getPoint());
                    int[] nArray = JProjectViewMaterialResource.this.resourceTable.getSelectedRows();
                    boolean bl = false;
                    if (nArray != null) {
                        for (int i = 0; i < nArray.length; ++i) {
                            int n2 = nArray[i];
                            if (n2 != n) continue;
                            bl = true;
                        }
                    }
                    if (!bl) {
                        JProjectViewMaterialResource.this.resourceTable.getSelectionModel().setSelectionInterval(n, n);
                    }
                    JProjectViewMaterialResource.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    protected void updateDetailsAndToolbar() {
        Object object;
        MaterialResource materialResource;
        int n;
        int n2;
        Object object2;
        this.resourceView.setResource(null);
        int n3 = this.resourceTable.getSelectedRowCount();
        int[] nArray = this.resourceTable.getSelectedRows();
        if (n3 != 0) {
            object2 = ((MaterialResourcesTableModel)this.resourceTable.getModel()).getCompany();
            if (n3 == 1) {
                if (nArray[0] < ((Company)object2).getMaterialResourcesNumber()) {
                    this.insertAction.setEnabled(true);
                } else {
                    this.insertAction.setEnabled(false);
                }
            } else {
                this.insertAction.setEnabled(false);
            }
            n2 = 0;
            n = 0;
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] >= ((Company)object2).getMaterialResourcesNumber() || (materialResource = ((Company)object2).getMaterialResourceAt(nArray[i])).isEmpty()) continue;
                n2 = 1;
                n = 1;
            }
            this.deleteAction.setEnabled(true);
            this.cutAction.setEnabled(n2 != 0);
            this.copyAction.setEnabled(n != 0);
            object = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (object != null && (object.isDataFlavorSupported(CustomFlavor.materialResourceListFlavor) || object.isDataFlavorSupported(DataFlavor.stringFlavor))) {
                this.pasteAction.setEnabled(true);
            } else {
                this.pasteAction.setEnabled(false);
            }
        } else {
            this.insertAction.setEnabled(false);
            this.deleteAction.setEnabled(false);
            this.cutAction.setEnabled(false);
            this.copyAction.setEnabled(false);
            this.pasteAction.setEnabled(false);
        }
        object2 = this.resourceTable.getSelectionModel();
        n2 = object2.getMinSelectionIndex();
        n = object2.getMaxSelectionIndex();
        if (n2 == n && n2 != -1 && n2 < ((Company)(object = ((MaterialResourcesTableModel)this.resourceTable.getModel()).getCompany())).getMaterialResourcesNumber()) {
            materialResource = ((Company)object).getMaterialResourceAt(n2);
            this.resourceView.setResource(materialResource);
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        this.rowHeader.setBackground(Color.WHITE);
        int n2 = this.resourceTable.print(graphics, pageFormat, n);
        this.rowHeader.setBackground((Color)UIManager.get("TableHeader.background"));
        return n2;
    }

    public int getNumberOfPages() {
        return this.resourceTable.getNumberOfPages();
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        return this.resourceTable.getPageFormat(n);
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        return this.resourceTable.getPrintable(n);
    }

    public int getHorizontalNumberOfPages() {
        return this.resourceTable.getHorizontalNumberOfPages();
    }

    public int getVerticalNumberOfPages() {
        return this.resourceTable.getVerticalNumberOfPages();
    }

    public Dimension getPrintSize() {
        return this.resourceTable.getPrintSize();
    }

    public JMaterialResourcesTable getResourceTable() {
        return this.resourceTable;
    }

    public JRowHeader getRowHeader() {
        return this.rowHeader;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public void updateInfoButtons() {
        this.infoButton.setSelected(this.resourceView.isVisible());
        this.infoItem.setSelected(this.resourceView.isVisible());
    }

    public JToggleButton getInfoButton() {
        return this.infoButton;
    }
}

