/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component.view;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Client;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.core.constraint.SNET;
import com.sbs.jpm.core.event.CompanyAdapter;
import com.sbs.jpm.core.event.CompanyEvent;
import com.sbs.jpm.core.event.CompanyListener;
import com.sbs.jpm.core.event.TaskAdapter;
import com.sbs.jpm.core.event.TaskEvent;
import com.sbs.jpm.core.event.TaskListener;
import com.sbs.jpm.ui.component.JProjectView;
import com.sbs.jpm.ui.component.util.JTextComponentUndoHandler;
import com.sbs.jpm.undo.ClientInsertEdit;
import com.sbs.jpm.undo.ClientNameEdit;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import com.sbs.jpm.undo.ProjectClientEdit;
import com.sbs.jpm.undo.ProjectCodeEdit;
import com.sbs.jpm.undo.ProjectDescriptionEdit;
import com.sbs.jpm.undo.ProjectManagerEdit;
import com.sbs.jpm.undo.TaskConstraintEdit;
import com.sbs.jpm.undo.TaskNameEdit;
import com.sbs.jpm.undo.UndoHandler;
import com.standbysoft.component.date.event.DateSelectionAdapter;
import com.standbysoft.component.date.event.DateSelectionEvent;
import com.standbysoft.component.date.event.DateSelectionListener;
import com.standbysoft.component.date.swing.JDatePicker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;

public class JProjectViewInfo
extends JProjectView {
    private JTextField projectNameField;
    private JTextField projectCodeField;
    private JComboBox clientCombo;
    private JTextField projectManagerField;
    private JDatePicker projectStartDatePicker;
    private JTextArea projectDescriptionArea;
    private DocumentListener projectNameDocumentListener;
    private NameHandler taskNameListener;
    private DescriptionHandler taskDescriptionListener;
    private CodeHandler taskCodeListener;
    private ClientHandler clientListener;
    private CompanyListener companyHandler;
    private ManagerHandler taskManagerListener;
    private DateSelectionListener projectStartDateListener;
    private DocumentListener projectDescriptionDocumentListener;
    private TaskListener taskHandler = new TaskHandler();

    public JProjectViewInfo() {
        this.companyHandler = new CompanyHandler();
        this.taskNameListener = new NameHandler();
        this.taskDescriptionListener = new DescriptionHandler();
        this.taskCodeListener = new CodeHandler();
        this.clientListener = new ClientHandler();
        this.taskManagerListener = new ManagerHandler();
        this.projectNameDocumentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JProjectViewInfo.this.project.setChangingName(JProjectViewInfo.this.projectNameField.getText());
                    }
                });
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JProjectViewInfo.this.project.setChangingName(JProjectViewInfo.this.projectNameField.getText());
                    }
                });
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        this.projectDescriptionDocumentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!JProjectViewInfo.this.projectDescriptionArea.getText().equals(JProjectViewInfo.this.project.getDescription())) {
                    JProjectViewInfo.this.project.setDescription(JProjectViewInfo.this.projectDescriptionArea.getText());
                }
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                if (!JProjectViewInfo.this.projectDescriptionArea.getText().equals(JProjectViewInfo.this.project.getDescription())) {
                    JProjectViewInfo.this.project.setDescription(JProjectViewInfo.this.projectDescriptionArea.getText());
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        this.projectStartDateListener = new DateSelectionAdapter(){

            public void dateSelectionChanged(DateSelectionEvent dateSelectionEvent) {
                SNET sNET = new SNET(JProjectViewInfo.this.project.getConstraint().getDate());
                SNET sNET2 = new SNET(dateSelectionEvent.getFirstDate());
                TaskConstraintEdit taskConstraintEdit = new TaskConstraintEdit(JProjectViewInfo.this.project, sNET, sNET2, "09/11/09 12:37:09");
                ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createReschedulSingleEdit(JProjectViewInfo.this.project, taskConstraintEdit);
                JProjectViewInfo.this.project.setConstraint(sNET2);
                extendedCompoundEdit.addEdit(taskConstraintEdit);
                extendedCompoundEdit.end();
                TaskPlanner.rescheduleTree(JProjectViewInfo.this.project);
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent((Object)this, extendedCompoundEdit);
                JProjectViewInfo.this.fireUndoableEditHappened(undoableEditEvent);
            }
        };
    }

    protected void updateDetailsAndToolbar() {
    }

    public void setProject(Task task) {
        if (this.project != null) {
            this.project.removeTaskListener(this.taskHandler);
            this.project.getCompany().removeCompanyListener(this.companyHandler);
        }
        super.setProject(task);
        if (this.project != null) {
            this.projectNameField.setEnabled(true);
            this.projectCodeField.setEnabled(true);
            this.clientCombo.setEnabled(true);
            this.projectManagerField.setEnabled(true);
            this.projectStartDatePicker.setEnabled(true);
            this.projectDescriptionArea.setEnabled(true);
            this.updateValues();
            new JTextComponentUndoHandler(this.projectNameField);
            new JTextComponentUndoHandler(this.projectCodeField);
            new JTextComponentUndoHandler(this.projectManagerField);
            new JTextComponentUndoHandler(this.projectDescriptionArea);
            this.project.addTaskListener(this.taskHandler);
            this.project.getCompany().addCompanyListener(this.companyHandler);
            this.removeUndoableEditListener(this.undoHandler);
            this.undoHandler = new UndoHandler(task.getCompany().getUndoManager());
            this.addUndoableEditListener(this.undoHandler);
        } else {
            this.projectNameField.setEnabled(false);
            this.projectCodeField.setEnabled(false);
            this.clientCombo.setEnabled(false);
            this.projectManagerField.setEnabled(false);
            this.projectStartDatePicker.setEnabled(false);
            this.projectDescriptionArea.setEnabled(false);
            this.updateValues();
        }
    }

    private JPanel createContentsInfo() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(5, 5, 5, 5);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        this.projectNameField = new JTextField(30);
        this.projectCodeField = new JTextField(30);
        this.projectManagerField = new JTextField(30);
        this.clientCombo = new JComboBox();
        this.clientCombo.setEditable(true);
        this.projectStartDatePicker = new JDatePicker(true);
        this.projectStartDatePicker.setDateFormat(1, 2);
        try {
            this.projectStartDatePicker.setEmptySelectionText("");
            this.projectStartDatePicker.setEmptySelectionAllowed(false);
        }
        catch (Exception exception) {
            Common.logException("Error:", exception);
        }
        this.projectDescriptionArea = new JTextArea(7, 30);
        this.projectDescriptionArea.setLineWrap(true);
        this.projectDescriptionArea.setWrapStyleWord(true);
        jPanel2.add((Component)new JLabel(Common.I18N_RP.getString("projectName") + ":"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel2.add((Component)this.projectNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 23, 2, insets, 0, 0));
        jPanel2.add((Component)new JLabel(Common.I18N_RP.getString("projectCode") + ":"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel2.add((Component)this.projectCodeField, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 23, 2, insets, 0, 0));
        jPanel2.add((Component)new JLabel(Common.I18N_RP.getString("projectManager") + ":"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel2.add((Component)this.projectManagerField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 23, 2, insets, 0, 0));
        jPanel2.add((Component)new JLabel(Common.I18N_RP.getString("projectEstimatedStart") + ":"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel2.add((Component)this.projectStartDatePicker, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 21, 2, insets, 0, 0));
        jPanel2.add((Component)new JLabel(Common.I18N_RP.getString("projectScope") + ":"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel2.add((Component)new JScrollPane(this.projectDescriptionArea), new GridBagConstraints(1, 3, 4, 1, 1.0, 1.0, 21, 1, insets, 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 9, 0));
        return jPanel;
    }

    protected JPanel createContents() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        jPanel.add((Component)this.createContentsInfo(), "Center");
        this.setFocusable(false);
        return jPanel;
    }

    private void updateValues() {
        this.removeListeners();
        if (this.project != null) {
            this.projectNameField.setText(this.project.getName());
            this.projectCodeField.setText(this.project.getCode());
            this.projectManagerField.setText(this.project.getManager());
            this.projectStartDatePicker.setSelectedDate(this.project.getConstraint().getDate());
            this.clientCombo.setModel(new DefaultComboBoxModel<Object>(this.project.getCompany().getNonEmptyClients().toArray()));
            this.clientCombo.setSelectedItem(this.project.getClient());
            try {
                this.projectDescriptionArea.setText(this.project.getDescription());
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            this.projectNameField.setText("");
            this.projectCodeField.setText("");
            this.projectManagerField.setText("");
            this.projectStartDatePicker.setSelectedDate(null);
            this.clientCombo.setModel(new DefaultComboBoxModel());
            try {
                this.projectDescriptionArea.setText("");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.addListeners();
    }

    private void addListeners() {
        this.projectNameField.addActionListener(this.taskNameListener);
        this.projectNameField.addFocusListener(this.taskNameListener);
        this.projectNameField.getDocument().addDocumentListener(this.projectNameDocumentListener);
        this.projectCodeField.addActionListener(this.taskCodeListener);
        this.projectCodeField.addFocusListener(this.taskCodeListener);
        this.clientCombo.addItemListener(this.clientListener);
        this.projectManagerField.addActionListener(this.taskManagerListener);
        this.projectManagerField.addFocusListener(this.taskManagerListener);
        this.projectStartDatePicker.addDateSelectionListener(this.projectStartDateListener);
        this.projectDescriptionArea.addFocusListener(this.taskDescriptionListener);
        this.projectDescriptionArea.getDocument().addDocumentListener(this.projectDescriptionDocumentListener);
    }

    private void removeListeners() {
        this.projectNameField.removeActionListener(this.taskNameListener);
        this.projectNameField.removeFocusListener(this.taskNameListener);
        this.projectNameField.getDocument().removeDocumentListener(this.projectNameDocumentListener);
        this.projectCodeField.removeActionListener(this.taskCodeListener);
        this.projectCodeField.removeFocusListener(this.taskCodeListener);
        this.clientCombo.removeItemListener(this.clientListener);
        this.projectManagerField.removeActionListener(this.taskManagerListener);
        this.projectManagerField.removeFocusListener(this.taskManagerListener);
        this.projectStartDatePicker.removeDateSelectionListener(this.projectStartDateListener);
        this.projectDescriptionArea.removeFocusListener(this.taskDescriptionListener);
        this.projectDescriptionArea.getDocument().removeDocumentListener(this.projectDescriptionDocumentListener);
    }

    private class TaskHandler
    extends TaskAdapter {
        private TaskHandler() {
        }

        public void projectChanged(TaskEvent taskEvent) {
            JProjectViewInfo.this.updateValues();
        }

        public void nameChanged(TaskEvent taskEvent) {
            JProjectViewInfo.this.updateValues();
        }

        public void notesChanged(TaskEvent taskEvent) {
            JProjectViewInfo.this.updateValues();
        }

        public void dataChanged(TaskEvent taskEvent) {
            JProjectViewInfo.this.updateValues();
        }

        public void projectDescriptionChanged(TaskEvent taskEvent) {
            JProjectViewInfo.this.updateValues();
        }
    }

    private class CompanyHandler
    extends CompanyAdapter {
        private CompanyHandler() {
        }

        public void clientAdded(CompanyEvent companyEvent) {
            this.refresh();
        }

        public void clientRemoved(CompanyEvent companyEvent) {
            this.refresh();
        }

        private void refresh() {
            JProjectViewInfo.this.clientCombo.removeItemListener(JProjectViewInfo.this.clientListener);
            JProjectViewInfo.this.clientCombo.setModel(new DefaultComboBoxModel<Object>(JProjectViewInfo.this.project.getCompany().getNonEmptyClients().toArray()));
            JProjectViewInfo.this.clientCombo.setSelectedItem(JProjectViewInfo.this.project.getClient());
            JProjectViewInfo.this.clientCombo.addItemListener(JProjectViewInfo.this.clientListener);
        }
    }

    private class ManagerHandler
    implements FocusListener,
    ActionListener {
        private ManagerHandler() {
        }

        private void doIt() {
            if (!JProjectViewInfo.this.project.getManager().equals(JProjectViewInfo.this.projectManagerField.getText())) {
                String string = JProjectViewInfo.this.projectManagerField.getText();
                ProjectManagerEdit projectManagerEdit = new ProjectManagerEdit(JProjectViewInfo.this.project, JProjectViewInfo.this.project.getManager(), string, "05/10/2009 15:00:03");
                JProjectViewInfo.this.project.setManager(string);
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, projectManagerEdit);
                JProjectViewInfo.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.doIt();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }

    private class ClientHandler
    implements ItemListener {
        private ClientHandler() {
        }

        private void doIt() {
            if (JProjectViewInfo.this.project.getClient() == null) {
                Object object = JProjectViewInfo.this.clientCombo.getSelectedItem();
                if (object instanceof Client) {
                    Client client = (Client)object;
                    ProjectClientEdit projectClientEdit = new ProjectClientEdit(JProjectViewInfo.this.project, JProjectViewInfo.this.project.getClient(), client, "05/10/2009 15:00:00");
                    JProjectViewInfo.this.project.setClient(client);
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, projectClientEdit);
                    JProjectViewInfo.this.fireUndoableEditHappened(undoableEditEvent);
                } else if (!object.toString().equals("")) {
                    Company company = JProjectViewInfo.this.project.getCompany();
                    ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                    Client client = new Client(Common.getIdGenerator().getNewId());
                    ClientInsertEdit clientInsertEdit = new ClientInsertEdit(company, client, company.getClientsNumber(), "06/10/2009 13:14:02");
                    JProjectViewInfo.this.project.getCompany().addClient(client);
                    ClientNameEdit clientNameEdit = new ClientNameEdit(client, client.getName(), object.toString(), "06/10/2009 13:28:02");
                    client.setName(object.toString());
                    ProjectClientEdit projectClientEdit = new ProjectClientEdit(JProjectViewInfo.this.project, JProjectViewInfo.this.project.getClient(), client, "05/10/2009 15:00:01");
                    JProjectViewInfo.this.project.setClient(client);
                    extendedCompoundEdit.addEdit(clientInsertEdit);
                    extendedCompoundEdit.addEdit(clientNameEdit);
                    extendedCompoundEdit.addEdit(projectClientEdit);
                    extendedCompoundEdit.end();
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                    JProjectViewInfo.this.fireUndoableEditHappened(undoableEditEvent);
                }
            } else {
                Object object = JProjectViewInfo.this.clientCombo.getSelectedItem();
                if (object instanceof Client) {
                    Client client = (Client)object;
                    ProjectClientEdit projectClientEdit = new ProjectClientEdit(JProjectViewInfo.this.project, JProjectViewInfo.this.project.getClient(), client, "05/10/2009 15:00:02");
                    JProjectViewInfo.this.project.setClient(client);
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, projectClientEdit);
                    JProjectViewInfo.this.fireUndoableEditHappened(undoableEditEvent);
                } else {
                    Client client = JProjectViewInfo.this.project.getClient();
                    ClientNameEdit clientNameEdit = new ClientNameEdit(client, client.getName(), object.toString(), "06/10/2009 13:28:03");
                    client.setName(object.toString());
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, clientNameEdit);
                    JProjectViewInfo.this.fireUndoableEditHappened(undoableEditEvent);
                }
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                this.doIt();
            }
        }
    }

    private class CodeHandler
    implements FocusListener,
    ActionListener {
        private CodeHandler() {
        }

        private void doIt() {
            if (!JProjectViewInfo.this.project.getCode().equals(JProjectViewInfo.this.projectCodeField.getText())) {
                String string = JProjectViewInfo.this.projectCodeField.getText();
                ProjectCodeEdit projectCodeEdit = new ProjectCodeEdit(JProjectViewInfo.this.project, JProjectViewInfo.this.project.getCode(), string, "10/01/09 16:53:00");
                JProjectViewInfo.this.project.setCode(string);
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, projectCodeEdit);
                JProjectViewInfo.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.doIt();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }

    private class DescriptionHandler
    implements FocusListener {
        private String oldDescription = "";

        private DescriptionHandler() {
        }

        private void doIt() {
            String string = JProjectViewInfo.this.projectDescriptionArea.getText();
            if (!string.equals(this.oldDescription)) {
                ProjectDescriptionEdit projectDescriptionEdit = new ProjectDescriptionEdit(JProjectViewInfo.this.project, this.oldDescription, string, "02/10/2009 13:43:00");
                JProjectViewInfo.this.project.setDescription(string);
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, projectDescriptionEdit);
                JProjectViewInfo.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            this.oldDescription = JProjectViewInfo.this.projectDescriptionArea.getText();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }

    private class NameHandler
    implements FocusListener,
    ActionListener {
        private String oldName = "";

        private NameHandler() {
        }

        private void doIt() {
            String string = JProjectViewInfo.this.projectNameField.getText();
            if (!string.equals(this.oldName)) {
                TaskNameEdit taskNameEdit = new TaskNameEdit(JProjectViewInfo.this.project, this.oldName, string, "02-10-2009 12:41:06");
                JProjectViewInfo.this.project.setName(string);
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, taskNameEdit);
                JProjectViewInfo.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.doIt();
        }

        public void focusGained(FocusEvent focusEvent) {
            this.oldName = JProjectViewInfo.this.projectNameField.getText();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }
}

