/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component.view;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.Dependency;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.core.constraint.SNET;
import com.sbs.jpm.print.CustomPageable;
import com.sbs.jpm.ui.JProject;
import com.sbs.jpm.ui.action.CustomFlavor;
import com.sbs.jpm.ui.action.TaskSelection;
import com.sbs.jpm.ui.component.JCorner;
import com.sbs.jpm.ui.component.JProjectView;
import com.sbs.jpm.ui.component.JRowHeader;
import com.sbs.jpm.ui.component.ProjectDetailView;
import com.sbs.jpm.ui.component.view.ViewCommon;
import com.sbs.jpm.ui.treetablechart.JEPSTable;
import com.sbs.jpm.undo.CompanyCurrentProjectEdit;
import com.sbs.jpm.undo.DeleteEmptyTasksEdit;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import com.sbs.jpm.undo.TaskConstraintEdit;
import com.sbs.jpm.undo.TaskDownEdit;
import com.sbs.jpm.undo.TaskInsertEdit;
import com.sbs.jpm.undo.TaskPasteEdit;
import com.sbs.jpm.undo.TaskPasteSerializableEdit;
import com.sbs.jpm.undo.TaskUpEdit;
import com.sbs.util.ExcelAdapter;
import com.sbs.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public class JProjectViewEPS
extends JProjectView
implements CustomPageable {
    private static final long serialVersionUID = 1L;
    private JEPSTable eps;
    private ProjectDetailView projectDetailsView;
    private JRowHeader rowHeader;
    private JSplitPane splitPane;
    private Action insertAction;
    private Action deleteAction;
    private Action upAction;
    private Action downAction;
    private Action cutAction;
    private Action copyAction;
    private Action pasteAction;
    private Action setCurrentProjectAction;
    private Action detailsAction;
    private JPopupMenu popupMenu;
    private JToggleButton infoButton;
    private JCheckBoxMenuItem infoItem;

    private JPanel createContentsEPS() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        this.eps = new JEPSTable();
        this.eps.setProjectView(this);
        this.eps.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    JProjectViewEPS.this.updateToolbar();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.eps));
        jScrollPane.getViewport().setBackground(this.eps.getBackground());
        this.rowHeader = new JRowHeader((JTable)((Object)this.eps));
        jScrollPane.setRowHeaderView(this.rowHeader);
        JCorner jCorner = new JCorner();
        jScrollPane.setCorner("UPPER_LEFT_CORNER", jCorner);
        jCorner = new JCorner();
        jScrollPane.setCorner("LOWER_LEFT_CORNER", jCorner);
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, insets, 9, 0));
        return jPanel;
    }

    protected JPanel createContents() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.popupMenu = new JPopupMenu();
        this.splitPane = new JSplitPane(0, this.createContentsEPS(), this.createContentsTask());
        this.splitPane.setResizeWeight(0.8);
        this.splitPane.setDividerSize(5);
        this.splitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jPanel.add((Component)this.splitPane, "Center");
        this.projectDetailsView.setTask(null);
        return jPanel;
    }

    private JPanel createContentsTask() {
        this.projectDetailsView = new ProjectDetailView();
        this.projectDetailsView.setVisible(false);
        this.projectDetailsView.setTask(null);
        return this.projectDetailsView;
    }

    public void showInfo() {
        this.projectDetailsView.setVisible(true);
        this.infoButton.setSelected(true);
    }

    public void setProject(Task task) {
        super.setProject(task);
        this.eps.setProject(task);
        this.rowHeader.setTableModel(this.eps.getModel());
    }

    public JEPSTable getEps() {
        return this.eps;
    }

    private void insertTask(Task task, Task task2, int n, CompoundEdit compoundEdit) {
        LinkedList<Dependency> linkedList;
        Task[] taskArray = task2.getChildList().toArray(new Task[0]);
        int n2 = taskArray.length;
        for (int i = 0; i < n2; ++i) {
            linkedList = taskArray[i];
            this.insertTask(task2, (Task)((Object)linkedList), i, compoundEdit);
        }
        LinkedList<Dependency> linkedList2 = new LinkedList<Dependency>();
        linkedList = task2.getPredecessorDependencies().iterator();
        while (linkedList.hasNext()) {
            linkedList2.add((Dependency)linkedList.next());
        }
        linkedList = new LinkedList<Dependency>();
        Object object = task2.getSuccessorDependencies().iterator();
        while (object.hasNext()) {
            linkedList.add(object.next());
        }
        object = new LinkedList();
        Object object2 = task2.getAssignments().iterator();
        while (object2.hasNext()) {
            object.add(object2.next());
        }
        object2 = new TaskPasteEdit(task, task2, n, linkedList2, linkedList, (List<Assignment>)object, "02-10-2009 : 12:31:00");
        compoundEdit.addEdit((UndoableEdit)object2);
        TaskPlanner.rescheduleTree(task);
    }

    private void setPopup() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(127, 0);
        KeyStroke keyStroke2 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(38, 256) : KeyStroke.getKeyStroke(38, 128);
        KeyStroke keyStroke3 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(40, 256) : KeyStroke.getKeyStroke(40, 128);
        KeyStroke keyStroke4 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(88, 256) : KeyStroke.getKeyStroke(88, 128);
        KeyStroke keyStroke5 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(67, 256) : KeyStroke.getKeyStroke(67, 128);
        KeyStroke keyStroke6 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(86, 256) : KeyStroke.getKeyStroke(86, 128);
        KeyStroke keyStroke7 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(68, 256) : KeyStroke.getKeyStroke(68, 128);
        this.insertAction = new AbstractAction(Common.I18N_ACTIONS.getString("project.new")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                JProjectView.BLOCK_UPDATE = true;
                try {
                    JProject jProject = Common.getApplication().getWorkspace().getJProject();
                    Task task = new Task(Common.getIdGenerator().getNewId(), Common.I18N_RP.getString("project") + " " + jProject.getProjectNo());
                    jProject.setProjectNo(jProject.getProjectNo() + 1);
                    task.setCalendar(JProjectViewEPS.this.project.getCalendar());
                    JProjectViewEPS.this.project.addChild(task, false);
                    ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(JProjectViewEPS.this.project);
                    TaskInsertEdit taskInsertEdit = new TaskInsertEdit(JProjectViewEPS.this.project, task, JProjectViewEPS.this.project.getProjectChildNumber(), "02-10-2009 12:44:03");
                    extendedCompoundEdit.addEdit(taskInsertEdit);
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                    JProjectViewEPS.this.fireUndoableEditHappened(undoableEditEvent);
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeInMillis(CalendarManager.getDayStartTime(calendar));
                    task.getUsedCalendar().getFirstTime(calendar, true, Long.MAX_VALUE);
                    SNET sNET = new SNET(calendar.getTime());
                    TaskConstraintEdit taskConstraintEdit = new TaskConstraintEdit(task, task.getConstraint(), sNET, "09/11/09 12:37:10");
                    extendedCompoundEdit.addEdit(taskConstraintEdit);
                    task.setConstraint(sNET);
                    extendedCompoundEdit.end();
                    TaskPlanner.rescheduleTree(JProjectViewEPS.this.project);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JProjectViewEPS.this.eps.setRowSelectionInterval(JProjectViewEPS.this.eps.getRowCount() - 1, JProjectViewEPS.this.eps.getRowCount() - 1);
                        }
                    });
                }
                finally {
                    JProjectView.BLOCK_UPDATE = false;
                    JProjectViewEPS.this.updateToolbar();
                }
            }
        };
        this.deleteAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/delete.png"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = JProjectViewEPS.this.eps.getSelectedRows();
                int n = nArray.length;
                int n2 = nArray[n - 1];
                JProjectView.BLOCK_UPDATE = true;
                try {
                    LinkedList<Task> linkedList = new LinkedList<Task>();
                    for (int i = 0; i < nArray.length; ++i) {
                        int n3 = nArray[i];
                        linkedList.add(JProjectViewEPS.this.project.getProjectChildAt(n3));
                    }
                    ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(JProjectViewEPS.this.project);
                    for (Task task : linkedList) {
                        ViewCommon.deleteTask(task, extendedCompoundEdit);
                        List<Task> list = task.getParent().removeEmptyTasks();
                        DeleteEmptyTasksEdit deleteEmptyTasksEdit = new DeleteEmptyTasksEdit(task.getParent(), list, "15-09-09 12:37:00");
                        extendedCompoundEdit.addEdit(deleteEmptyTasksEdit);
                    }
                    TaskPlanner.rescheduleTree(JProjectViewEPS.this.project);
                    extendedCompoundEdit.end();
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                    JProjectViewEPS.this.fireUndoableEditHappened(undoableEditEvent);
                    int n4 = n2 - n + 1;
                    if (n2 == JProjectViewEPS.this.eps.getRowCount()) {
                        --n4;
                    }
                    if (JProjectViewEPS.this.project.getProjectChildNumber() > 0) {
                        JProjectViewEPS.this.eps.setRowSelectionInterval(n4, n4);
                    }
                }
                finally {
                    JProjectView.BLOCK_UPDATE = false;
                    JProjectViewEPS.this.updateToolbar();
                }
            }
        };
        this.deleteAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("project.delete"));
        this.deleteAction.putValue("AcceleratorKey", keyStroke);
        this.upAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/up.png"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = JProjectViewEPS.this.eps.getSelectedRows();
                JProjectView.BLOCK_UPDATE = true;
                try {
                    int n;
                    ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                    LinkedList<Task> linkedList = new LinkedList<Task>();
                    for (int i = 0; i < nArray.length; ++i) {
                        n = nArray[i];
                        linkedList.add(JProjectViewEPS.this.project.getProjectChildAt(n));
                    }
                    Task[] taskArray = linkedList.toArray(new Task[0]);
                    for (n = 0; n < taskArray.length; ++n) {
                        Task task = taskArray[n];
                        if (!task.isDescendent(linkedList)) continue;
                        linkedList.remove(task);
                    }
                    for (Task task : linkedList) {
                        TaskUpEdit taskUpEdit = new TaskUpEdit(task, "01-10-2009 17:25:00");
                        task.moveUp();
                        extendedCompoundEdit.addEdit(taskUpEdit);
                    }
                    extendedCompoundEdit.end();
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                    JProjectViewEPS.this.fireUndoableEditHappened(undoableEditEvent);
                    JProjectViewEPS.this.eps.setRowSelectionInterval(JProjectViewEPS.this.project.getProjectChildIndex(taskArray[0]), JProjectViewEPS.this.project.getProjectChildIndex(taskArray[taskArray.length - 1]));
                }
                finally {
                    JProjectView.BLOCK_UPDATE = false;
                    JProjectViewEPS.this.updateToolbar();
                }
            }
        };
        String string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("task.up") + " (Cmmd-Up)" : Common.I18N_ACTIONS.getString("task.up") + " (Ctrl-Up)";
        this.upAction.putValue("ShortDescription", string);
        this.upAction.putValue("AcceleratorKey", keyStroke2);
        this.downAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/down.png"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = JProjectViewEPS.this.eps.getSelectedRows();
                JProjectView.BLOCK_UPDATE = true;
                try {
                    Task task;
                    int n;
                    ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                    LinkedList<Task> linkedList = new LinkedList<Task>();
                    for (int i = 0; i < nArray.length; ++i) {
                        n = nArray[i];
                        linkedList.add(JProjectViewEPS.this.project.getProjectChildAt(n));
                    }
                    Task[] taskArray = linkedList.toArray(new Task[0]);
                    for (n = 0; n < taskArray.length; ++n) {
                        task = taskArray[n];
                        if (!task.isDescendent(linkedList)) continue;
                        linkedList.remove(task);
                    }
                    taskArray = linkedList.toArray(new Task[0]);
                    for (n = taskArray.length - 1; n >= 0; --n) {
                        task = taskArray[n];
                        TaskDownEdit taskDownEdit = new TaskDownEdit(task, "02-10-2009 13:29:00");
                        task.moveDown();
                        extendedCompoundEdit.addEdit(taskDownEdit);
                    }
                    extendedCompoundEdit.end();
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                    JProjectViewEPS.this.fireUndoableEditHappened(undoableEditEvent);
                    JProjectViewEPS.this.eps.setRowSelectionInterval(JProjectViewEPS.this.project.getProjectChildIndex(taskArray[0]), JProjectViewEPS.this.project.getProjectChildIndex(taskArray[taskArray.length - 1]));
                }
                finally {
                    JProjectView.BLOCK_UPDATE = false;
                    JProjectViewEPS.this.updateToolbar();
                }
            }
        };
        string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("task.down") + " (Cmmd-Down)" : Common.I18N_ACTIONS.getString("task.down") + " (Ctrl-Down)";
        this.downAction.putValue("ShortDescription", string);
        this.downAction.putValue("AcceleratorKey", keyStroke3);
        this.cutAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Cut16.gif"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = JProjectViewEPS.this.eps.getSelectedRows();
                if (JProjectViewEPS.this.eps.getSelectedRowCount() != 0) {
                    Object object;
                    Arrays.sort(nArray);
                    LinkedList<Task> linkedList = new LinkedList<Task>();
                    ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(JProjectViewEPS.this.project);
                    for (int i = 0; i < nArray.length; ++i) {
                        Task task = JProjectViewEPS.this.project.getProjectChildAt(nArray[i]);
                        if (task.isEmpty()) continue;
                        linkedList.add(task);
                    }
                    Task[] taskArray = linkedList.toArray(new Task[0]);
                    for (int i = 0; i < taskArray.length; ++i) {
                        object = taskArray[i];
                        if (!((Task)object).isDescendent(linkedList)) continue;
                        linkedList.remove(object);
                    }
                    List<Task> list = Task.cloneTasks(linkedList, false);
                    object = new TaskSelection(list, ExcelAdapter.projectsToString(JProjectViewEPS.this.eps));
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)object, null);
                    JProjectView.BLOCK_UPDATE = true;
                    try {
                        Serializable serializable;
                        for (Task task : linkedList) {
                            ViewCommon.deleteTask(task, extendedCompoundEdit);
                            List<Task> list2 = task.getParent().removeEmptyTasks();
                            serializable = new DeleteEmptyTasksEdit(task.getParent(), list2, "15-09-09 12:37:01");
                            extendedCompoundEdit.addEdit((UndoableEdit)((Object)serializable));
                        }
                        TaskPlanner.rescheduleTree(JProjectViewEPS.this.project);
                        extendedCompoundEdit.end();
                        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                        JProjectViewEPS.this.fireUndoableEditHappened(undoableEditEvent);
                        int n = 0;
                        for (int i = 0; i < taskArray.length; ++i) {
                            serializable = taskArray[i];
                            n = JProjectViewEPS.this.project.getProjectChildIndex((Task)serializable);
                            JProjectViewEPS.this.eps.getSelectionModel().addSelectionInterval(n, n);
                        }
                        JProjectViewEPS.this.eps.scrollRowToVisible(n);
                    }
                    finally {
                        JProjectView.BLOCK_UPDATE = false;
                        JProjectViewEPS.this.updateToolbar();
                    }
                }
            }
        };
        this.cutAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("cut"));
        this.cutAction.putValue("AcceleratorKey", keyStroke4);
        this.copyAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Copy16.gif"))){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JProjectViewEPS.this.eps.getSelectedRowCount() != 0) {
                    Object object;
                    int[] nArray = JProjectViewEPS.this.eps.getSelectedRows();
                    Arrays.sort(nArray);
                    LinkedList<Task> linkedList = new LinkedList<Task>();
                    for (int i = 0; i < nArray.length; ++i) {
                        Task task = JProjectViewEPS.this.project.getProjectChildAt(nArray[i]);
                        if (task.isEmpty()) continue;
                        linkedList.add(task);
                    }
                    Task[] taskArray = linkedList.toArray(new Task[0]);
                    for (int i = 0; i < taskArray.length; ++i) {
                        object = taskArray[i];
                        if (!((Task)object).isDescendent(linkedList)) continue;
                        linkedList.remove(object);
                    }
                    List<Task> list = Task.cloneTasks(linkedList, false);
                    object = new TaskSelection(list, ExcelAdapter.projectsToString(JProjectViewEPS.this.eps));
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)object, null);
                }
            }
        };
        this.copyAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("copy"));
        this.copyAction.putValue("AcceleratorKey", keyStroke5);
        this.pasteAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Paste16.gif"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                if (JProjectViewEPS.this.eps.getSelectedRowCount() != 0) {
                    JProjectView.BLOCK_UPDATE = true;
                    try {
                        ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(JProjectViewEPS.this.project);
                        int n = JProjectViewEPS.this.eps.getSelectedRow();
                        Task task = JProjectViewEPS.this.project.getProjectChildAt(n);
                        Task task2 = task.getParent();
                        int n2 = task2.getChildIndex(task);
                        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                        List list = null;
                        try {
                            if (transferable != null && transferable.isDataFlavorSupported(CustomFlavor.taskListFlavor)) {
                                list = (List)transferable.getTransferData(CustomFlavor.taskListFlavor);
                            }
                        }
                        catch (UnsupportedFlavorException unsupportedFlavorException) {
                            Common.logException("Error:", unsupportedFlavorException);
                            unsupportedFlavorException.printStackTrace();
                        }
                        catch (IOException iOException) {
                            Common.logException("Error:", iOException);
                            iOException.printStackTrace();
                        }
                        List<Task> list2 = Task.cloneTasks(list, true);
                        List<Task> list3 = Task.cloneTasks(list2, false);
                        int n3 = 0;
                        for (Task task3 : list2) {
                            JProjectViewEPS.this.insertTask(task2, task3, n2, extendedCompoundEdit);
                            extendedCompoundEdit.addEdit(new TaskPasteSerializableEdit(task2, list3.get(n3++), n2));
                            task3.updateClonedAssignments(JProjectViewEPS.this.project.getCompany());
                            task2.addChild(n2, task3);
                            ++n2;
                            JProjectViewEPS.this.eps.getSelectionModel().addSelectionInterval(n, n);
                        }
                        task2.setDirty(true, false);
                        TaskPlanner.rescheduleTree(task.getCompany().getRootTask());
                        extendedCompoundEdit.end();
                        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                        JProjectViewEPS.this.fireUndoableEditHappened(undoableEditEvent);
                    }
                    finally {
                        JProjectView.BLOCK_UPDATE = false;
                        JProjectViewEPS.this.updateToolbar();
                    }
                }
            }
        };
        this.pasteAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("paste"));
        this.pasteAction.putValue("AcceleratorKey", keyStroke6);
        this.setCurrentProjectAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/currentProject.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                Task task = JProjectViewEPS.this.project.getCompany().getRootTask().getProjectChildAt(JProjectViewEPS.this.eps.getSelectedRow());
                CompanyCurrentProjectEdit companyCurrentProjectEdit = new CompanyCurrentProjectEdit(JProjectViewEPS.this.project.getCompany(), JProjectViewEPS.this.project.getCompany().getCurrentTask(), task, 2);
                JProjectViewEPS.this.project.getCompany().setCurrentTask(task);
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, companyCurrentProjectEdit);
                JProjectViewEPS.this.fireUndoableEditHappened(undoableEditEvent);
            }
        };
        this.setCurrentProjectAction.putValue("ShortDescription", Common.I18N_RP.getString("setAsCurrentProject"));
        this.detailsAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/info.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!JProjectViewEPS.this.projectDetailsView.isVisible()) {
                    JProjectViewEPS.this.projectDetailsView.setVisible(true);
                    JProjectViewEPS.this.infoButton.setSelected(true);
                    JProjectViewEPS.this.infoItem.setSelected(true);
                    JProjectViewEPS.this.splitPane.setDividerLocation(-1);
                    JProjectViewEPS.this.splitPane.setDividerSize(5);
                } else {
                    JProjectViewEPS.this.projectDetailsView.setVisible(false);
                    JProjectViewEPS.this.infoButton.setSelected(false);
                    JProjectViewEPS.this.infoItem.setSelected(false);
                    JProjectViewEPS.this.splitPane.setDividerSize(0);
                }
            }
        };
        string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("details.tooltip") + " (Cmmd-D)" : Common.I18N_ACTIONS.getString("details.tooltip") + " (Ctrl-D)";
        this.detailsAction.putValue("ShortDescription", string);
        this.detailsAction.putValue("AcceleratorKey", keyStroke7);
        ActionMap actionMap = this.eps.getActionMap();
        actionMap.put("delete", this.deleteAction);
        actionMap.put("up", this.upAction);
        actionMap.put("down", this.downAction);
        actionMap.put("cut", this.cutAction);
        actionMap.put("copy", this.copyAction);
        actionMap.put("paste", this.pasteAction);
        actionMap.put("details", this.detailsAction);
        InputMap inputMap = this.eps.getInputMap(1);
        inputMap.put(keyStroke, "delete");
        inputMap.put(keyStroke2, "up");
        inputMap.put(keyStroke3, "down");
        inputMap.put(keyStroke4, "cut");
        inputMap.put(keyStroke5, "copy");
        inputMap.put(keyStroke6, "paste");
        inputMap.put(keyStroke7, "details");
        JMenuItem jMenuItem = new JMenuItem(this.deleteAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("project.delete"));
        this.popupMenu.add(jMenuItem);
        this.popupMenu.addSeparator();
        jMenuItem = new JMenuItem(this.upAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("task.up"));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.downAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("task.down"));
        this.popupMenu.add(jMenuItem);
        this.popupMenu.addSeparator();
        jMenuItem = new JMenuItem(this.cutAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("cut"));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.copyAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("copy"));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.pasteAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("paste"));
        this.popupMenu.add(jMenuItem);
        this.popupMenu.addSeparator();
        jMenuItem = new JMenuItem(this.setCurrentProjectAction);
        jMenuItem.setText(Common.I18N_RP.getString("setAsCurrentProject"));
        this.popupMenu.add(jMenuItem);
        this.infoItem = new JCheckBoxMenuItem(Common.I18N_ACTIONS.getString("details.project"), new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/info.png")));
        this.infoItem.setToolTipText(Common.I18N_ACTIONS.getString("details.tooltip"));
        this.infoItem.setAccelerator(keyStroke7);
        this.infoItem.setSelected(false);
        this.infoItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JProjectViewEPS.this.infoButton.doClick();
            }
        });
        this.popupMenu.add(this.infoItem);
        this.eps.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            private void showPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    int n = JProjectViewEPS.this.eps.rowAtPoint(mouseEvent.getPoint());
                    int[] nArray = JProjectViewEPS.this.eps.getSelectedRows();
                    boolean bl = false;
                    if (nArray != null) {
                        for (int i = 0; i < nArray.length; ++i) {
                            int n2 = nArray[i];
                            if (n2 != n) continue;
                            bl = true;
                        }
                    }
                    if (!bl) {
                        JProjectViewEPS.this.eps.getSelectionModel().setSelectionInterval(n, n);
                    }
                    JProjectViewEPS.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    protected void createToolBar() {
        super.createToolBar();
        this.setPopup();
        this.insertAction.setEnabled(false);
        this.deleteAction.setEnabled(false);
        this.setCurrentProjectAction.setEnabled(false);
        this.upAction.setEnabled(false);
        this.downAction.setEnabled(false);
        this.cutAction.setEnabled(false);
        this.copyAction.setEnabled(false);
        this.pasteAction.setEnabled(false);
        JButton jButton = new JButton(this.insertAction);
        jButton.setFocusable(false);
        JButton jButton2 = new JButton(this.deleteAction);
        jButton2.setFocusable(false);
        JButton jButton3 = new JButton(this.upAction);
        jButton3.setFocusable(false);
        this.toolBar.add(jButton3);
        JButton jButton4 = new JButton(this.downAction);
        jButton4.setFocusable(false);
        this.toolBar.add(jButton4);
        JButton jButton5 = new JButton(this.cutAction);
        jButton5.setFocusable(false);
        JButton jButton6 = new JButton(this.copyAction);
        jButton6.setFocusable(false);
        JButton jButton7 = new JButton(this.pasteAction);
        jButton7.setFocusable(false);
        jButton = new JButton(this.setCurrentProjectAction);
        jButton.setFocusable(false);
        this.toolBar.add(jButton);
        this.infoButton = new JToggleButton(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/info.png")), false);
        this.infoButton.setAction(this.detailsAction);
        this.toolBar.addSeparator();
        this.toolBar.add(this.infoButton);
    }

    protected void updateDetailsAndToolbar() {
        this.projectDetailsView.setTask(null);
        int n = this.eps.getSelectedRowCount();
        int[] nArray = this.eps.getSelectedRows();
        if (n != 0) {
            boolean bl;
            boolean bl2 = true;
            boolean bl3 = true;
            boolean bl4 = false;
            boolean bl5 = false;
            Arrays.sort(nArray);
            LinkedList<Task> linkedList = new LinkedList<Task>();
            for (int i = 0; i < nArray.length; ++i) {
                linkedList.add(this.project.getProjectChildAt(nArray[i]));
            }
            for (Task task : linkedList) {
                if (task.isEmpty()) continue;
                bl4 = true;
                bl5 = true;
            }
            for (Task task : linkedList) {
                boolean bl6;
                Task task2 = task.getParent();
                if (task.isEmpty()) {
                    bl = false;
                    bl3 = false;
                    break;
                }
                bl6 = bl6 && task2.getChildIndex(task) != 0;
                bl3 = bl3 && task2.getChildIndex(task) != task2.getChildNumber() - 1;
            }
            this.deleteAction.setEnabled(true);
            this.setCurrentProjectAction.setEnabled(true);
            this.upAction.setEnabled(bl);
            this.downAction.setEnabled(bl3);
            this.cutAction.setEnabled(bl4);
            this.copyAction.setEnabled(bl5);
            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (transferable != null && transferable.isDataFlavorSupported(CustomFlavor.taskListFlavor)) {
                this.pasteAction.setEnabled(true);
            } else {
                this.pasteAction.setEnabled(false);
            }
        } else {
            this.deleteAction.setEnabled(false);
            this.setCurrentProjectAction.setEnabled(false);
            this.upAction.setEnabled(false);
            this.downAction.setEnabled(false);
            this.cutAction.setEnabled(false);
            this.copyAction.setEnabled(false);
            this.pasteAction.setEnabled(false);
        }
        if (n == 1) {
            int n2 = this.eps.convertRowIndexToModel(this.eps.getSelectedRow());
            Task task = this.project.getProjectChildAt(n2);
            this.projectDetailsView.setTask(task);
        }
    }

    public void updateInfoButtons() {
        this.infoButton.setSelected(this.projectDetailsView.isVisible());
        this.infoItem.setSelected(this.projectDetailsView.isVisible());
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        this.rowHeader.setBackground(Color.WHITE);
        int n2 = this.eps.print(graphics, pageFormat, n);
        this.rowHeader.setBackground((Color)UIManager.get("TableHeader.background"));
        return n2;
    }

    public int getNumberOfPages() {
        return this.eps.getNumberOfPages();
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        return this.eps.getPageFormat(n);
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        return this.eps.getPrintable(n);
    }

    public int getHorizontalNumberOfPages() {
        return this.eps.getHorizontalNumberOfPages();
    }

    public int getVerticalNumberOfPages() {
        return this.eps.getVerticalNumberOfPages();
    }

    public Dimension getPrintSize() {
        return this.eps.getPrintSize();
    }

    public JRowHeader getRowHeader() {
        return this.rowHeader;
    }

    public ProjectDetailView getProjectDetailsView() {
        return this.projectDetailsView;
    }

    public JToggleButton getInfoButton() {
        return this.infoButton;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }
}

