/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component.util;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class ComboBoxCompletion {
    private JComboBox comboBox;
    private JTextComponent editor;
    boolean pressingKey;
    int count = 0;
    Comparator comparator;
    ComboDocumentListener comboDocumentListener;
    ComboBoxModel originalComboModel;
    DefaultComboBoxModel searchComboModel;

    public ComboBoxCompletion(JComboBox jComboBox) {
        this(jComboBox, new Comparator(){

            public int compare(Object object, Object object2) {
                if (object == null) {
                    if (object2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (object2 == null) {
                    return 1;
                }
                return object.toString().compareToIgnoreCase(object2.toString());
            }
        });
    }

    public ComboBoxCompletion(JComboBox jComboBox, Comparator comparator) {
        this.comparator = comparator;
        this.comboBox = jComboBox;
        this.setModel(jComboBox.getModel());
        this.editor = (JTextComponent)jComboBox.getEditor().getEditorComponent();
        this.comboDocumentListener = new ComboDocumentListener();
        this.editor.getDocument().addDocumentListener(this.comboDocumentListener);
        this.editor.addKeyListener(new KeyHandler());
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        this.originalComboModel = comboBoxModel;
        this.searchComboModel = new DefaultComboBoxModel();
        this.comboBox.setModel(this.searchComboModel);
        for (int i = 0; i < this.originalComboModel.getSize(); ++i) {
            this.searchComboModel.addElement(this.originalComboModel.getElementAt(i));
        }
    }

    public void searchAndSelect(String string) {
        String string2 = string;
        this.comboBox.hidePopup();
        while (this.searchComboModel.getSize() > 0) {
            this.searchComboModel.removeElementAt(0);
        }
        if (string.length() > 0) {
            int n;
            Vector vector = new Vector();
            for (n = 0; n < this.originalComboModel.getSize(); ++n) {
                Object e = this.originalComboModel.getElementAt(n);
                if (!this.startsWithIgnoreCase(e.toString(), string)) continue;
                vector.addElement(this.originalComboModel.getElementAt(n));
            }
            Collections.sort(vector, this.comparator);
            for (n = 0; n < vector.size(); ++n) {
                this.searchComboModel.addElement(vector.elementAt(n));
            }
        } else {
            for (int i = 0; i < this.originalComboModel.getSize(); ++i) {
                this.searchComboModel.addElement(this.originalComboModel.getElementAt(i));
            }
        }
        this.editor.setText(string2);
        int n = 0;
        if (string2 != null && string2.length() > 0) {
            n = string2.length();
        }
        this.editor.setSelectionStart(n);
        this.editor.setSelectionEnd(n);
        this.editor.setCaretPosition(n);
        this.comboBox.showPopup();
        this.editor.getDocument().addDocumentListener(this.comboDocumentListener);
    }

    private int lookupItem(String string) {
        ComboBoxModel comboBoxModel = this.comboBox.getModel();
        int n = comboBoxModel.getSize();
        for (int i = 0; i < n; ++i) {
            Object e = comboBoxModel.getElementAt(i);
            if (!this.startsWithIgnoreCase(e.toString(), string)) continue;
            return i;
        }
        return -1;
    }

    private boolean startsWithIgnoreCase(String string, String string2) {
        return string.toUpperCase().startsWith(string2.toUpperCase());
    }

    public void stopEditing() {
        this.pressingKey = false;
    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        public void keyReleased(KeyEvent keyEvent) {
            ComboBoxCompletion.this.pressingKey = false;
        }

        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 27: 
                case 38: 
                case 40: {
                    break;
                }
                case 10: {
                    if (ComboBoxCompletion.this.comboBox.getSelectedItem() != null) {
                        ComboBoxCompletion.this.editor.setText(ComboBoxCompletion.this.comboBox.getSelectedItem().toString());
                        break;
                    }
                    ComboBoxCompletion.this.editor.setText("");
                    break;
                }
                default: {
                    ComboBoxCompletion.this.pressingKey = true;
                    if (!ComboBoxCompletion.this.comboBox.isDisplayable()) break;
                    ComboBoxCompletion.this.comboBox.setPopupVisible(true);
                }
            }
        }
    }

    class ComboDocumentListener
    implements DocumentListener {
        ComboDocumentListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.documentChanged(documentEvent);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.documentChanged(documentEvent);
        }

        public void documentChanged(DocumentEvent documentEvent) {
            if (!ComboBoxCompletion.this.pressingKey) {
                return;
            }
            ComboBoxCompletion.this.editor.getDocument().removeDocumentListener(ComboBoxCompletion.this.comboDocumentListener);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ComboBoxCompletion.this.searchAndSelect(ComboBoxCompletion.this.editor.getText());
                }
            });
        }
    }
}

