/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component.model;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.calendar.DayWorkingPattern;
import com.sbs.jpm.calendar.event.CalendarManagerEvent;
import com.sbs.jpm.calendar.event.CalendarManagerListener;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.undo.CalendarWeekPatternEdit;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.AbstractTableModel;

public class WeekTableModel
extends AbstractTableModel {
    public static Map indexToDay;
    private static Map indexToName;
    private static String[] columns;
    private static Class[] columnsType;
    private CalendarManager calendar;
    private EventListenerList listeners;
    private CalendarManagerHandler calendarHandler = new CalendarManagerHandler();

    public WeekTableModel() {
        this.listeners = new EventListenerList();
    }

    public WeekTableModel(CalendarManager calendarManager) {
        this();
        this.calendar = calendarManager;
        this.calendar.addCalendarManagerListener(this.calendarHandler);
    }

    public CalendarManager getCalendar() {
        return this.calendar;
    }

    public int getRowCount() {
        if (this.calendar == null) {
            return 0;
        }
        return 7;
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == 0;
    }

    public Object getValueAt(int n, int n2) {
        DayWorkingPattern dayWorkingPattern = this.calendar.getDayPattern((Integer)indexToDay.get(n));
        if (n2 == 0) {
            return dayWorkingPattern.isWorking();
        }
        if (n2 == 1) {
            return indexToName.get(n);
        }
        return "";
    }

    public void setValueAt(Object object, int n, int n2) {
        boolean bl = (Boolean)object;
        int n3 = (Integer)indexToDay.get(n);
        DayWorkingPattern dayWorkingPattern = this.calendar.getDayPattern(n3);
        DayWorkingPattern dayWorkingPattern2 = (DayWorkingPattern)dayWorkingPattern.clone();
        if (n2 == 0) {
            Task task = this.calendar.getOwner().getRootTask();
            ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(task);
            this.calendar.beginTransaction();
            this.calendar.setDayPattern(n3, dayWorkingPattern2);
            dayWorkingPattern2.setWorking(bl);
            this.calendar.endTransaction();
            CalendarWeekPatternEdit calendarWeekPatternEdit = new CalendarWeekPatternEdit(this.calendar.getOwner(), this.calendar, dayWorkingPattern, dayWorkingPattern2, n3, "28/11/09 17:53:00");
            extendedCompoundEdit.addEdit(calendarWeekPatternEdit);
            extendedCompoundEdit.end();
            this.fireUndoableEditHappened(new UndoableEditEvent(this, extendedCompoundEdit));
            TaskPlanner.rescheduleTree(task);
        }
    }

    public Class getColumnClass(int n) {
        return columnsType[n];
    }

    public String getColumnName(int n) {
        return columns[n];
    }

    public int getColumnCount() {
        return columns.length;
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    private void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(UndoableEditListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((UndoableEditListener)eventListenerArray[i]).undoableEditHappened(undoableEditEvent);
        }
    }

    static {
        int n;
        int n2;
        indexToDay = new HashMap();
        indexToName = new HashMap();
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols();
        String[] stringArray = dateFormatSymbols.getWeekdays();
        Calendar calendar = Calendar.getInstance();
        for (n2 = n = calendar.getFirstDayOfWeek(); n2 < stringArray.length; ++n2) {
            indexToDay.put(n2 - n, n2);
            indexToName.put(n2 - n, stringArray[n2].toUpperCase());
        }
        for (n2 = 1; n2 < n; ++n2) {
            indexToDay.put(n2 + 7 - n, n2);
            indexToName.put(n2 + 7 - n, stringArray[n2].toUpperCase());
        }
        columns = new String[]{"!", Common.I18N_RP.getString("column.weekDays")};
        columnsType = new Class[]{Boolean.class, String.class};
    }

    private class CalendarManagerHandler
    implements CalendarManagerListener {
        private CalendarManagerHandler() {
        }

        public void dayWorkingPatternChanged(CalendarManagerEvent calendarManagerEvent) {
        }

        public void calendarChanged(CalendarManagerEvent calendarManagerEvent) {
            WeekTableModel.this.fireTableRowsUpdated(0, 6);
        }

        public void nameChanged(CalendarManagerEvent calendarManagerEvent) {
        }
    }
}

