/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component.model;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Risk;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.event.RiskAdapter;
import com.sbs.jpm.core.event.RiskEvent;
import com.sbs.jpm.core.event.TaskAdapter;
import com.sbs.jpm.core.event.TaskEvent;
import com.sbs.jpm.undo.RiskDescriptionEdit;
import com.sbs.jpm.undo.RiskImpactEdit;
import com.sbs.jpm.undo.RiskInsertEdit;
import com.sbs.jpm.undo.RiskProbabilityEdit;
import com.sbs.jpm.undo.RiskStatusEdit;
import java.util.EventListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.AbstractTableModel;

public class ProjectRisksTableModel
extends AbstractTableModel {
    public static final String DESCRIPTION = Common.I18N_RP.getString("column.description");
    public static final String STATUS = Common.I18N_RP.getString("column.status");
    public static final String IMPACT = Common.I18N_RP.getString("column.impact");
    public static final String PROBABILITY = Common.I18N_RP.getString("column.probability");
    private static String[] columns = new String[]{DESCRIPTION, STATUS, IMPACT, PROBABILITY};
    private static Class[] columnsType = new Class[]{String.class, Risk.Status.class, Risk.Level.class, Risk.Level.class};
    private Task data;
    protected RiskHandler riskHandler;
    private EventListenerList listeners;

    public ProjectRisksTableModel() {
        this.listeners = new EventListenerList();
    }

    public ProjectRisksTableModel(Task task) {
        this.data = task;
        this.listeners = new EventListenerList();
        this.riskHandler = new RiskHandler();
        this.addRisksListeners();
        this.data.addTaskListener(new TaskAdapter(){

            public void riskAdded(TaskEvent taskEvent) {
                Risk risk = taskEvent.getRisk();
                risk.addRiskListener(ProjectRisksTableModel.this.riskHandler);
                int n = taskEvent.getRiskIndex();
                ProjectRisksTableModel.this.fireTableRowsInserted(n, n);
            }

            public void riskRemoved(TaskEvent taskEvent) {
                Risk risk = taskEvent.getRisk();
                risk.removeRiskListener(ProjectRisksTableModel.this.riskHandler);
                int n = taskEvent.getRiskIndex();
                ProjectRisksTableModel.this.fireTableRowsDeleted(n, n);
            }
        });
    }

    private void addRisksListeners() {
        for (int i = 0; i < this.data.getRisksNumber(); ++i) {
            this.data.getRiskAt(i).addRiskListener(this.riskHandler);
        }
    }

    public Task getProject() {
        return this.data;
    }

    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.getProject().getRisksNumber() + 1;
    }

    public boolean isCellEditable(int n, int n2) {
        return n != this.getProject().getRisksNumber() || n2 == 0;
    }

    public Object getValueAt(int n, int n2) {
        if (n != this.getRowCount() - 1) {
            Risk risk = this.getProject().getRiskAt(n);
            if (n2 == 1) {
                return risk.getStatus();
            }
            if (n2 == 2) {
                return risk.getImpact();
            }
            if (n2 == 3) {
                return risk.getProbability();
            }
            if (n2 == 0) {
                return risk.getDescription();
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n == this.getRowCount() - 1) {
            if (object.toString().equals("")) {
                return;
            }
            Risk risk = new Risk(Common.getIdGenerator().getNewId(), object.toString());
            RiskInsertEdit riskInsertEdit = new RiskInsertEdit(this.getProject(), risk, n, "05/10/2009 11:23:00");
            this.getProject().addRisk(risk);
            UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, riskInsertEdit);
            this.fireUndoableEditHappened(undoableEditEvent);
        } else {
            Risk risk = this.getProject().getRiskAt(n);
            switch (n2) {
                case 1: {
                    RiskStatusEdit riskStatusEdit = new RiskStatusEdit(risk, risk.getStatus(), (Risk.Status)object, "05/10/2009 12:12:00");
                    risk.setStatus((Risk.Status)object);
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, riskStatusEdit);
                    this.fireUndoableEditHappened(undoableEditEvent);
                    break;
                }
                case 2: {
                    RiskImpactEdit riskImpactEdit = new RiskImpactEdit(risk, risk.getImpact(), (Risk.Level)object, "05/10/2009 12:22:00");
                    risk.setImpact((Risk.Level)object);
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, riskImpactEdit);
                    this.fireUndoableEditHappened(undoableEditEvent);
                    break;
                }
                case 3: {
                    RiskProbabilityEdit riskProbabilityEdit = new RiskProbabilityEdit(risk, risk.getProbability(), (Risk.Level)object, "05/10/2009 11:24:00");
                    risk.setProbability((Risk.Level)object);
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, riskProbabilityEdit);
                    this.fireUndoableEditHappened(undoableEditEvent);
                    break;
                }
                case 0: {
                    RiskDescriptionEdit riskDescriptionEdit = new RiskDescriptionEdit(risk, risk.getDescription(), object.toString(), "05/10/2009 12:24:00");
                    risk.setDescription(object.toString());
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, riskDescriptionEdit);
                    this.fireUndoableEditHappened(undoableEditEvent);
                    break;
                }
            }
        }
    }

    public Class getColumnClass(int n) {
        return columnsType[n];
    }

    public String getColumnName(int n) {
        return columns[n];
    }

    public int getColumnCount() {
        return columns.length;
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    private void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(UndoableEditListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((UndoableEditListener)eventListenerArray[i]).undoableEditHappened(undoableEditEvent);
        }
    }

    private class RiskHandler
    extends RiskAdapter {
        private RiskHandler() {
        }

        public void dataChanged(RiskEvent riskEvent) {
            Risk risk = (Risk)riskEvent.getSource();
            int n = ProjectRisksTableModel.this.data.getRiskIndex(risk);
            ProjectRisksTableModel.this.fireTableRowsUpdated(n, n);
        }
    }
}

