/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component.model;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Link;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.event.LinkAdapter;
import com.sbs.jpm.core.event.LinkEvent;
import com.sbs.jpm.core.event.TaskAdapter;
import com.sbs.jpm.core.event.TaskEvent;
import java.util.EventListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.AbstractTableModel;

public class ProjectLinksTableModel
extends AbstractTableModel {
    public static final String DESCRIPTION = Common.I18N_RP.getString("column.description");
    public static final String LINK = Common.I18N_RP.getString("column.link");
    private static String[] columns = new String[]{LINK, DESCRIPTION};
    private static Class[] columnsType = new Class[]{String.class, String.class};
    private Task data;
    protected LinkHandler linkHandler;
    private EventListenerList listeners;

    public ProjectLinksTableModel() {
        this.listeners = new EventListenerList();
    }

    public ProjectLinksTableModel(Task task) {
        this.data = task;
        this.listeners = new EventListenerList();
        this.linkHandler = new LinkHandler();
        this.addLinksListeners();
        this.data.addTaskListener(new TaskAdapter(){

            public void linkAdded(TaskEvent taskEvent) {
                Link link = taskEvent.getLink();
                link.addLinkListener(ProjectLinksTableModel.this.linkHandler);
                int n = taskEvent.getLinkIndex();
                ProjectLinksTableModel.this.fireTableRowsInserted(n, n);
            }

            public void linkRemoved(TaskEvent taskEvent) {
                Link link = taskEvent.getLink();
                link.removeLinkListener(ProjectLinksTableModel.this.linkHandler);
                int n = taskEvent.getLinkIndex();
                ProjectLinksTableModel.this.fireTableRowsDeleted(n, n);
            }
        });
    }

    private void addLinksListeners() {
        for (int i = 0; i < this.data.getLinksNumber(); ++i) {
            this.data.getLinkAt(i).addLinkListener(this.linkHandler);
        }
    }

    public Task getProject() {
        return this.data;
    }

    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.getProject().getLinksNumber();
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public Object getValueAt(int n, int n2) {
        Link link = this.getProject().getLinkAt(n);
        if (n2 == 0) {
            return link.getName();
        }
        if (n2 == 1) {
            return link.getDescription();
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
    }

    public Class getColumnClass(int n) {
        return columnsType[n];
    }

    public String getColumnName(int n) {
        return columns[n];
    }

    public int getColumnCount() {
        return columns.length;
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    private void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(UndoableEditListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((UndoableEditListener)eventListenerArray[i]).undoableEditHappened(undoableEditEvent);
        }
    }

    private class LinkHandler
    extends LinkAdapter {
        private LinkHandler() {
        }

        public void dataChanged(LinkEvent linkEvent) {
            Link link = (Link)linkEvent.getSource();
            int n = ProjectLinksTableModel.this.data.getLinkIndex(link);
            ProjectLinksTableModel.this.fireTableRowsUpdated(n, n);
        }
    }
}

