/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component.model;

import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.event.TaskAdapter;
import com.sbs.jpm.core.event.TaskEvent;
import com.sbs.jpm.core.event.TaskListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class MultiProjectTreeModel
implements TreeModel {
    protected Task root;
    protected TaskListener taskHandler;
    protected EventListenerList listenerList = new EventListenerList();

    public MultiProjectTreeModel(Task task) {
        this.root = task;
        this.taskHandler = new TaskHandler();
        this.addTasksListeners(task);
    }

    private void addTasksListeners(Task task) {
        if (task.isProject()) {
            task.addTaskListener(this.taskHandler);
        }
        for (int i = 0; i < task.getProjectChildNumber(); ++i) {
            this.addTasksListeners(task.getProjectChildAt(i));
        }
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object object, int n) {
        Task task = (Task)object;
        return task.getProjectChildAt(n);
    }

    public int getChildCount(Object object) {
        return ((Task)object).getProjectChildNumber();
    }

    public boolean isLeaf(Object object) {
        return ((Task)object).isProjectLeaf();
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        Task task = (Task)treePath.getLastPathComponent();
        task.setName(object.toString());
    }

    public int getIndexOfChild(Object object, Object object2) {
        return ((Task)object).getProjectChildIndex((Task)object2);
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(TreeModelListener.class, treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    protected void fireTreeNodesChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesChanged(treeModelEvent);
        }
    }

    protected void fireTreeNodesInserted(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesInserted(treeModelEvent);
        }
    }

    protected void fireTreeNodesRemoved(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesRemoved(treeModelEvent);
        }
    }

    protected void fireTreeStructureChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeStructureChanged(treeModelEvent);
        }
    }

    class TaskHandler
    extends TaskAdapter {
        TaskHandler() {
        }

        public void nameChanged(TaskEvent taskEvent) {
            Task task = (Task)taskEvent.getSource();
            if (task.getParent() != null) {
                Task task2 = task.getParent();
                int[] nArray = new int[]{task2.getProjectChildIndex(task)};
                Object[] objectArray = new Object[]{task};
                MultiProjectTreeModel.this.fireTreeNodesChanged(this, task2.getPath(MultiProjectTreeModel.this.root).toArray(), nArray, objectArray);
            }
        }

        public void childAdded(TaskEvent taskEvent) {
            Task task = (Task)taskEvent.getSource();
            Task task2 = taskEvent.getTask();
            if (task2.isProject()) {
                task2.addTaskListener(MultiProjectTreeModel.this.taskHandler);
                if (task != null) {
                    int[] nArray = new int[]{task.getProjectChildIndex(task2)};
                    Object[] objectArray = new Object[]{task2};
                    MultiProjectTreeModel.this.fireTreeNodesInserted(this, task.getPath(MultiProjectTreeModel.this.root).toArray(), nArray, objectArray);
                }
            }
        }

        public void childWillRemove(TaskEvent taskEvent) {
            Task task = (Task)taskEvent.getSource();
            Task task2 = taskEvent.getTask();
            if (task2.isProject()) {
                task2.removeTaskListener(MultiProjectTreeModel.this.taskHandler);
                if (task != null) {
                    int[] nArray = new int[]{task.getProjectChildIndex(task2)};
                    Object[] objectArray = new Object[]{task2};
                    MultiProjectTreeModel.this.fireTreeNodesRemoved(this, task.getPath(MultiProjectTreeModel.this.root).toArray(), nArray, objectArray);
                }
            }
        }
    }
}

