/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component.model;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.MaterialResource;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.core.event.CompanyAdapter;
import com.sbs.jpm.core.event.CompanyEvent;
import com.sbs.jpm.core.event.ResourceAdapter;
import com.sbs.jpm.core.event.ResourceEvent;
import com.sbs.jpm.core.field.FieldManager;
import com.sbs.jpm.ui.component.JMaterialResourcesTable;
import com.sbs.jpm.ui.component.JProjectView;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import com.sbs.jpm.undo.MResourceMeasurementUnitEdit;
import com.sbs.jpm.undo.ResourceAdditionalFieldEdit;
import com.sbs.jpm.undo.ResourceCodeEdit;
import com.sbs.jpm.undo.ResourceNameEdit;
import com.sbs.jpm.undo.ResourceStdRateEdit;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CompoundEdit;

public class MaterialResourcesTableModel
extends AbstractTableModel {
    public static final int EMPTY_ROWS = 50;
    public static final String RESOURCE_NAME = Common.I18N_RP.getString("column.resourceName");
    public static final String PRICE_PER_UNIT = Common.I18N_RP.getString("column.pricePerUnit");
    public static final String MEASURE_UNIT = Common.I18N_RP.getString("column.measureUnit");
    public static final String CODE = Common.I18N_RP.getString("column.code");
    protected List titles;
    protected List columnsType;
    private Company data;
    private EventListenerList listeners;
    protected ResourceHandler resourceHandler;
    private JMaterialResourcesTable table;

    public MaterialResourcesTableModel() {
        this(null, new Company());
    }

    public MaterialResourcesTableModel(JMaterialResourcesTable jMaterialResourcesTable, Company company) {
        int n;
        this.data = company;
        this.table = jMaterialResourcesTable;
        this.listeners = new EventListenerList();
        this.titles = new LinkedList();
        this.columnsType = new LinkedList();
        this.titles.add(RESOURCE_NAME);
        this.titles.add(PRICE_PER_UNIT);
        this.titles.add(MEASURE_UNIT);
        this.titles.add(CODE);
        for (n = 1; n <= 10; ++n) {
            this.titles.add(FieldManager.CUSTOM_NAME + n);
        }
        this.columnsType.add(String.class);
        this.columnsType.add(Double.class);
        this.columnsType.add(String.class);
        this.columnsType.add(String.class);
        for (n = 0; n < 10; ++n) {
            this.columnsType.add(String.class);
        }
        this.resourceHandler = new ResourceHandler();
        this.addResourcesListeners();
        this.data.addCompanyListener(new CompanyAdapter(){

            public void resourceAdded(CompanyEvent companyEvent) {
                Resource resource = companyEvent.getResource();
                if (resource instanceof MaterialResource) {
                    resource.addResourceListener(MaterialResourcesTableModel.this.resourceHandler);
                    int n = companyEvent.getResourceIndex();
                    MaterialResourcesTableModel.this.fireTableRowsInserted(n, n);
                }
            }

            public void resourceRemoved(CompanyEvent companyEvent) {
                Resource resource = companyEvent.getResource();
                if (resource instanceof MaterialResource) {
                    resource.removeResourceListener(MaterialResourcesTableModel.this.resourceHandler);
                    int n = companyEvent.getResourceIndex();
                    MaterialResourcesTableModel.this.fireTableRowsDeleted(n, n);
                }
            }
        });
    }

    private void addResourcesListeners() {
        for (int i = 0; i < this.data.getMaterialResourcesNumber(); ++i) {
            this.data.getMaterialResourceAt(i).addResourceListener(this.resourceHandler);
        }
    }

    public Company getCompany() {
        return this.data;
    }

    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.getCompany().getMaterialResourcesNumber() + 50;
    }

    public boolean isCellEditable(int n, int n2) {
        if (n >= this.getCompany().getMaterialResourcesNumber()) {
            return n2 == 0;
        }
        MaterialResource materialResource = this.getCompany().getMaterialResourceAt(n);
        if (materialResource.isEmpty()) {
            return n2 == 0;
        }
        return true;
    }

    public Object getValueAt(int n, int n2) {
        if (n >= this.getCompany().getMaterialResourcesNumber()) {
            return null;
        }
        MaterialResource materialResource = this.getCompany().getMaterialResourceAt(n);
        if (!materialResource.isEmpty()) {
            if (n2 >= this.titles.size() - 10) {
                return materialResource.getFieldAt(n2 - (this.titles.size() - 10));
            }
            if (n2 == 0) {
                return materialResource.getName();
            }
            if (n2 == 1) {
                return materialResource.getStandardRate();
            }
            if (n2 == 2) {
                return materialResource.getMeasurementUnit();
            }
            if (n2 == 3) {
                return materialResource.getCode();
            }
        } else {
            return null;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertEmptyResources(int n, CompoundEdit compoundEdit) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            MaterialResource materialResource = new MaterialResource(Common.getIdGenerator().getNewId());
            this.data.addResource(materialResource, compoundEdit);
        }
        n2 = this.data.getMaterialResourcesNumber();
        JProjectView.BLOCK_UPDATE = true;
        try {
            this.table.getSelectionModel().setSelectionInterval(n2, n2);
            JProjectView.BLOCK_UPDATE = false;
        }
        catch (Throwable throwable) {
            JProjectView.BLOCK_UPDATE = false;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MaterialResourcesTableModel.this.table.getProjectView().updateToolbar();
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    public void setValueAt(Object object, int n, int n2) {
        ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(this.getCompany().getRootTask());
        if (n >= this.getCompany().getMaterialResourcesNumber()) {
            if (object.toString().equals("")) {
                return;
            }
            this.insertEmptyResources(n - this.getCompany().getMaterialResourcesNumber() + 1, extendedCompoundEdit);
        }
        MaterialResource materialResource = this.getCompany().getMaterialResourceAt(n);
        boolean bl = materialResource.isEmpty();
        AbstractUndoableEdit abstractUndoableEdit = null;
        boolean bl2 = false;
        if (n2 >= this.titles.size() - 10) {
            int n3 = n2 - (this.titles.size() - 10);
            abstractUndoableEdit = new ResourceAdditionalFieldEdit(materialResource, materialResource.getFieldAt(n3), object.toString(), n3, "09/11/09 15:04:01");
            materialResource.setFieldAt(n3, object.toString());
        } else {
            switch (n2) {
                case 0: {
                    if (object.toString().equals("")) break;
                    abstractUndoableEdit = new ResourceNameEdit(materialResource, materialResource.getName(), object.toString(), "09/11/09 13:14:05");
                    materialResource.setName(object.toString());
                    break;
                }
                case 1: {
                    if (object == null) break;
                    double d = (Double)object;
                    abstractUndoableEdit = new ResourceStdRateEdit(materialResource, materialResource.getStandardRate(), d, "09/11/09 13:12:03");
                    materialResource.setStandardRate(d);
                    bl2 = true;
                    break;
                }
                case 2: {
                    if (object == null) break;
                    String string = object.toString();
                    abstractUndoableEdit = new MResourceMeasurementUnitEdit(materialResource, materialResource.getMeasurementUnit(), string, "09/11/09 15:13:00");
                    materialResource.setMeasurementUnit(string);
                    break;
                }
                case 3: {
                    if (object == null || object.toString().equals("")) break;
                    String string = object.toString();
                    abstractUndoableEdit = new ResourceCodeEdit(materialResource, materialResource.getCode(), string, "09/11/09 15:01:04");
                    materialResource.setCode(string);
                }
            }
        }
        if (abstractUndoableEdit != null) {
            extendedCompoundEdit.addEdit(abstractUndoableEdit);
        }
        if (bl2 && !bl) {
            TaskPlanner.rescheduleTree(this.getCompany().getRootTask());
        } else {
            extendedCompoundEdit.discardReschedule();
        }
        extendedCompoundEdit.end();
        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
        this.fireUndoableEditHappened(undoableEditEvent);
        if (bl) {
            this.table.getProjectView().updateToolbar();
        }
    }

    public Class getColumnClass(int n) {
        return (Class)this.columnsType.get(n);
    }

    public String getColumnName(int n) {
        return (String)this.titles.get(n);
    }

    public void setColumnName(int n, String string) {
        this.titles.set(n, string);
    }

    public int getColumnCount() {
        return this.titles.size();
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    private void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(UndoableEditListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((UndoableEditListener)eventListenerArray[i]).undoableEditHappened(undoableEditEvent);
        }
    }

    private class ResourceHandler
    extends ResourceAdapter {
        private ResourceHandler() {
        }

        public void dataChanged(ResourceEvent resourceEvent) {
            MaterialResource materialResource = (MaterialResource)resourceEvent.getSource();
            int n = MaterialResourcesTableModel.this.data.getMaterialResourceIndex(materialResource);
            MaterialResourcesTableModel.this.fireTableRowsUpdated(n, n);
        }
    }
}

