/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component.model;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Client;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Contact;
import com.sbs.jpm.core.event.ClientAdapter;
import com.sbs.jpm.core.event.ClientEvent;
import com.sbs.jpm.core.event.CompanyAdapter;
import com.sbs.jpm.core.event.CompanyEvent;
import com.sbs.jpm.core.field.FieldManager;
import com.sbs.jpm.ui.component.JClientsTable;
import com.sbs.jpm.ui.component.JProjectView;
import com.sbs.jpm.undo.ClientAddContactEdit;
import com.sbs.jpm.undo.ClientAdditionalFieldEdit;
import com.sbs.jpm.undo.ClientAddressEdit;
import com.sbs.jpm.undo.ClientInsertEdit;
import com.sbs.jpm.undo.ClientMainContactEdit;
import com.sbs.jpm.undo.ClientNameEdit;
import com.sbs.jpm.undo.ClientNonEmptyEdit;
import com.sbs.jpm.undo.ClientSiteEdit;
import com.sbs.jpm.undo.ContactEmailEdit;
import com.sbs.jpm.undo.ContactNameEdit;
import com.sbs.jpm.undo.ContactPhoneEdit;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import java.io.Serializable;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public class ClientsTableModel
extends AbstractTableModel {
    public static final String NAME = Common.I18N_RP.getString("column.clientName");
    public static final String ADDRESS = Common.I18N_RP.getString("column.address");
    public static final String SITE = Common.I18N_RP.getString("column.site");
    public static final String MAIN_CONTACT = Common.I18N_RP.getString("column.mainContact");
    public static final String EMAIL = Common.I18N_RP.getString("column.email");
    public static final String PHONE = Common.I18N_RP.getString("column.phone");
    public static final int EMPTY_ROWS = 50;
    protected List titles;
    protected List columnsType;
    private Company data;
    private EventListenerList listeners;
    protected ClientHandler clientHandler;
    private JClientsTable table;

    public ClientsTableModel() {
        this(null, new Company());
    }

    public ClientsTableModel(JClientsTable jClientsTable, Company company) {
        int n;
        this.data = company;
        this.table = jClientsTable;
        this.listeners = new EventListenerList();
        this.titles = new LinkedList();
        this.columnsType = new LinkedList();
        this.titles.add(NAME);
        this.titles.add(ADDRESS);
        this.titles.add(SITE);
        this.titles.add(MAIN_CONTACT);
        this.titles.add(EMAIL);
        this.titles.add(PHONE);
        for (n = 1; n <= 10; ++n) {
            this.titles.add(FieldManager.CUSTOM_NAME + n);
        }
        this.columnsType.add(String.class);
        this.columnsType.add(String.class);
        this.columnsType.add(String.class);
        this.columnsType.add(Contact.class);
        this.columnsType.add(String.class);
        this.columnsType.add(String.class);
        for (n = 0; n < 10; ++n) {
            this.columnsType.add(String.class);
        }
        this.clientHandler = new ClientHandler();
        this.addClientsListeners();
        this.data.addCompanyListener(new CompanyAdapter(){

            public void clientAdded(CompanyEvent companyEvent) {
                Client client = companyEvent.getClient();
                client.addClientListener(ClientsTableModel.this.clientHandler);
                int n = companyEvent.getClientIndex();
                ClientsTableModel.this.fireTableRowsInserted(n, n);
            }

            public void clientRemoved(CompanyEvent companyEvent) {
                Client client = companyEvent.getClient();
                client.removeClientListener(ClientsTableModel.this.clientHandler);
                int n = companyEvent.getClientIndex();
                ClientsTableModel.this.fireTableRowsDeleted(n, n);
            }
        });
    }

    private void addClientsListeners() {
        for (int i = 0; i < this.data.getClientsNumber(); ++i) {
            this.data.getClientAt(i).addClientListener(this.clientHandler);
        }
    }

    public Company getCompany() {
        return this.data;
    }

    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.getCompany().getClientsNumber() + 50;
    }

    public boolean isCellEditable(int n, int n2) {
        if (n >= this.getCompany().getClientsNumber()) {
            return n2 == 0;
        }
        Client client = this.getCompany().getClientAt(n);
        if (client.isEmpty()) {
            return n2 == 0;
        }
        return true;
    }

    public Object getValueAt(int n, int n2) {
        if (n >= this.getCompany().getClientsNumber()) {
            return null;
        }
        Client client = this.getCompany().getClientAt(n);
        if (!client.isEmpty()) {
            if (n2 >= this.titles.size() - 10) {
                return client.getFieldAt(n2 - (this.titles.size() - 10));
            }
            if (n2 == 0) {
                return client.getName();
            }
            if (n2 == 1) {
                return client.getAddress();
            }
            if (n2 == 2) {
                return client.getSite();
            }
            if (n2 == 3) {
                return client.getMainContact();
            }
            if (n2 == 4) {
                Contact contact = client.getMainContact();
                if (contact != null) {
                    return contact.getEmail();
                }
                return null;
            }
            if (n2 == 5) {
                Contact contact = client.getMainContact();
                if (contact != null) {
                    return contact.getPhone();
                }
                return null;
            }
        } else {
            return null;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertEmptyClients(int n, CompoundEdit compoundEdit) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            Client client = new Client(Common.getIdGenerator().getNewId());
            this.data.addClient(client);
            int n3 = this.data.getClientIndex(client);
            ClientInsertEdit clientInsertEdit = new ClientInsertEdit(this.data, client, n3, "06/10/2009 15:38:00");
            compoundEdit.addEdit(clientInsertEdit);
        }
        n2 = this.data.getClientsNumber();
        JProjectView.BLOCK_UPDATE = true;
        try {
            this.table.getSelectionModel().setSelectionInterval(n2, n2);
            JProjectView.BLOCK_UPDATE = false;
        }
        catch (Throwable throwable) {
            JProjectView.BLOCK_UPDATE = false;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ClientsTableModel.this.table.getProjectView().updateToolbar();
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    public void setValueAt(Object object, int n, int n2) {
        ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
        if (n >= this.getCompany().getClientsNumber()) {
            if (object.toString().equals("")) {
                return;
            }
            this.insertEmptyClients(n - this.getCompany().getClientsNumber() + 1, extendedCompoundEdit);
        }
        Client client = this.getCompany().getClientAt(n);
        boolean bl = client.isEmpty();
        if (n2 >= this.titles.size() - 10) {
            Serializable serializable;
            int n3 = n2 - (this.titles.size() - 10);
            ClientAdditionalFieldEdit clientAdditionalFieldEdit = new ClientAdditionalFieldEdit(client, client.getFieldAt(n3), object.toString(), n3, 1);
            client.setFieldAt(n3, object.toString());
            if (bl) {
                serializable = new ClientNonEmptyEdit(client, 1);
                extendedCompoundEdit.addEdit((UndoableEdit)((Object)serializable));
            }
            extendedCompoundEdit.addEdit(clientAdditionalFieldEdit);
            extendedCompoundEdit.end();
            serializable = new UndoableEditEvent(this, extendedCompoundEdit);
            this.fireUndoableEditHappened((UndoableEditEvent)serializable);
        } else {
            switch (n2) {
                case 0: {
                    Serializable serializable;
                    if (object.toString().equals("")) break;
                    ClientNameEdit clientNameEdit = new ClientNameEdit(client, client.getName(), object.toString(), "06/10/2009 13:28:01");
                    client.setName(object.toString());
                    if (bl) {
                        serializable = new ClientNonEmptyEdit(client, 2);
                        extendedCompoundEdit.addEdit((UndoableEdit)((Object)serializable));
                    }
                    extendedCompoundEdit.addEdit(clientNameEdit);
                    extendedCompoundEdit.end();
                    serializable = new UndoableEditEvent(this, extendedCompoundEdit);
                    this.fireUndoableEditHappened((UndoableEditEvent)serializable);
                    break;
                }
                case 1: {
                    Serializable serializable;
                    if (object == null) break;
                    ClientAddressEdit clientAddressEdit = new ClientAddressEdit(client, client.getAddress(), object.toString(), "06/10/2009 13:27:01");
                    client.setAddress(object.toString());
                    if (bl) {
                        serializable = new ClientNonEmptyEdit(client, 3);
                        extendedCompoundEdit.addEdit((UndoableEdit)((Object)serializable));
                    }
                    extendedCompoundEdit.addEdit(clientAddressEdit);
                    extendedCompoundEdit.end();
                    serializable = new UndoableEditEvent(this, extendedCompoundEdit);
                    this.fireUndoableEditHappened((UndoableEditEvent)serializable);
                    break;
                }
                case 2: {
                    Serializable serializable;
                    if (object == null) break;
                    ClientSiteEdit clientSiteEdit = new ClientSiteEdit(client, client.getSite(), object.toString(), "06/10/2009 15:02:01");
                    client.setSite(object.toString());
                    if (bl) {
                        serializable = new ClientNonEmptyEdit(client, 4);
                        extendedCompoundEdit.addEdit((UndoableEdit)((Object)serializable));
                    }
                    extendedCompoundEdit.addEdit(clientSiteEdit);
                    extendedCompoundEdit.end();
                    serializable = new UndoableEditEvent(this, extendedCompoundEdit);
                    this.fireUndoableEditHappened((UndoableEditEvent)serializable);
                    break;
                }
                case 3: {
                    Serializable serializable;
                    if (object == null) break;
                    if (object instanceof Contact) {
                        Serializable serializable2;
                        ClientMainContactEdit clientMainContactEdit = new ClientMainContactEdit(client, client.getMainContact(), (Contact)object, 1);
                        client.setMainContact((Contact)object);
                        if (bl) {
                            serializable2 = new ClientNonEmptyEdit(client, 5);
                            extendedCompoundEdit.addEdit((UndoableEdit)((Object)serializable2));
                        }
                        extendedCompoundEdit.addEdit(clientMainContactEdit);
                        extendedCompoundEdit.end();
                        serializable2 = new UndoableEditEvent(this, extendedCompoundEdit);
                        this.fireUndoableEditHappened((UndoableEditEvent)serializable2);
                        break;
                    }
                    if (object.toString().equals("")) break;
                    Contact contact = new Contact(Common.getIdGenerator().getNewId());
                    ClientAddContactEdit clientAddContactEdit = new ClientAddContactEdit(client, contact, 1);
                    extendedCompoundEdit.addEdit(clientAddContactEdit);
                    client.addContact(contact);
                    ContactNameEdit contactNameEdit = new ContactNameEdit(contact, contact.getName(), object.toString(), 3);
                    contact.setName(object.toString());
                    extendedCompoundEdit.addEdit(contactNameEdit);
                    ClientMainContactEdit clientMainContactEdit = new ClientMainContactEdit(client, client.getMainContact(), contact, 2);
                    client.setMainContact(contact);
                    extendedCompoundEdit.addEdit(clientMainContactEdit);
                    if (bl) {
                        serializable = new ClientNonEmptyEdit(client, 6);
                        extendedCompoundEdit.addEdit((UndoableEdit)((Object)serializable));
                    }
                    extendedCompoundEdit.end();
                    serializable = new UndoableEditEvent(this, extendedCompoundEdit);
                    this.fireUndoableEditHappened((UndoableEditEvent)serializable);
                    break;
                }
                case 4: {
                    Serializable serializable;
                    if (object == null) break;
                    Contact contact = client.getMainContact();
                    if (contact != null) {
                        ContactEmailEdit contactEmailEdit = new ContactEmailEdit(contact, contact.getEmail(), object.toString(), 1);
                        contact.setEmail(object.toString());
                        extendedCompoundEdit.addEdit(contactEmailEdit);
                        extendedCompoundEdit.end();
                        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                        this.fireUndoableEditHappened(undoableEditEvent);
                        break;
                    }
                    Contact contact2 = new Contact(Common.getIdGenerator().getNewId());
                    ClientAddContactEdit clientAddContactEdit = new ClientAddContactEdit(client, contact2, 2);
                    extendedCompoundEdit.addEdit(clientAddContactEdit);
                    client.addContact(contact2);
                    String string = Common.I18N_RP.getString("contact") + "?";
                    ContactNameEdit contactNameEdit = new ContactNameEdit(contact2, contact2.getName(), string, 4);
                    contact2.setName(string);
                    extendedCompoundEdit.addEdit(contactNameEdit);
                    ContactEmailEdit contactEmailEdit = new ContactEmailEdit(contact2, contact2.getEmail(), object.toString(), 2);
                    contact2.setEmail(object.toString());
                    extendedCompoundEdit.addEdit(contactEmailEdit);
                    ClientMainContactEdit clientMainContactEdit = new ClientMainContactEdit(client, client.getMainContact(), contact2, 3);
                    client.setMainContact(contact2);
                    extendedCompoundEdit.addEdit(clientMainContactEdit);
                    if (bl) {
                        serializable = new ClientNonEmptyEdit(client, 7);
                        extendedCompoundEdit.addEdit((UndoableEdit)((Object)serializable));
                    }
                    extendedCompoundEdit.end();
                    serializable = new UndoableEditEvent(this, extendedCompoundEdit);
                    this.fireUndoableEditHappened((UndoableEditEvent)serializable);
                    break;
                }
                case 5: {
                    Serializable serializable;
                    if (object == null) break;
                    Contact contact = client.getMainContact();
                    if (contact != null) {
                        ContactPhoneEdit contactPhoneEdit = new ContactPhoneEdit(contact, contact.getPhone(), object.toString(), 2);
                        contact.setPhone(object.toString());
                        extendedCompoundEdit.addEdit(contactPhoneEdit);
                        extendedCompoundEdit.end();
                        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                        this.fireUndoableEditHappened(undoableEditEvent);
                        break;
                    }
                    Contact contact3 = new Contact(Common.getIdGenerator().getNewId());
                    ClientAddContactEdit clientAddContactEdit = new ClientAddContactEdit(client, contact3, 3);
                    extendedCompoundEdit.addEdit(clientAddContactEdit);
                    client.addContact(contact3);
                    String string = Common.I18N_RP.getString("contact") + "?";
                    ContactNameEdit contactNameEdit = new ContactNameEdit(contact3, contact3.getName(), string, 5);
                    contact3.setName(string);
                    extendedCompoundEdit.addEdit(contactNameEdit);
                    ContactPhoneEdit contactPhoneEdit = new ContactPhoneEdit(contact3, contact3.getPhone(), object.toString(), 3);
                    contact3.setPhone(object.toString());
                    extendedCompoundEdit.addEdit(contactPhoneEdit);
                    ClientMainContactEdit clientMainContactEdit = new ClientMainContactEdit(client, client.getMainContact(), contact3, 4);
                    client.setMainContact(contact3);
                    extendedCompoundEdit.addEdit(clientMainContactEdit);
                    if (bl) {
                        serializable = new ClientNonEmptyEdit(client, 8);
                        extendedCompoundEdit.addEdit((UndoableEdit)((Object)serializable));
                    }
                    extendedCompoundEdit.end();
                    serializable = new UndoableEditEvent(this, extendedCompoundEdit);
                    this.fireUndoableEditHappened((UndoableEditEvent)serializable);
                }
            }
        }
        if (bl) {
            this.table.getProjectView().updateToolbar();
        }
    }

    public Class getColumnClass(int n) {
        return (Class)this.columnsType.get(n);
    }

    public String getColumnName(int n) {
        return (String)this.titles.get(n);
    }

    public void setColumnName(int n, String string) {
        this.titles.set(n, string);
    }

    public int getColumnCount() {
        return this.titles.size();
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    private void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(UndoableEditListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((UndoableEditListener)eventListenerArray[i]).undoableEditHappened(undoableEditEvent);
        }
    }

    private class ClientHandler
    extends ClientAdapter {
        private ClientHandler() {
        }

        public void dataChanged(ClientEvent clientEvent) {
            Client client = (Client)clientEvent.getSource();
            int n = ClientsTableModel.this.data.getClientIndex(client);
            ClientsTableModel.this.fireTableRowsUpdated(n, n);
        }
    }
}

