/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component.model;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Dependency;
import com.sbs.jpm.core.DependencyManager;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.event.TaskAdapter;
import com.sbs.jpm.core.event.TaskEvent;
import java.util.Date;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDependencyTableModel
extends AbstractTableModel {
    public static final String TYPE = Common.I18N_RP.getString("column.type");
    public static final String LAG = Common.I18N_RP.getString("column.lag");
    protected List titles = new LinkedList();
    protected List columnsType = new LinkedList();
    protected List<Task> data = new LinkedList<Task>();
    protected List<TaskDependencies> dependencies = new LinkedList<TaskDependencies>();
    protected boolean parentSplitted;
    protected EventListenerList listeners;
    protected TaskHandler taskHandler = new TaskHandler();

    public AbstractDependencyTableModel() {
        this(new LinkedList<Task>());
    }

    public AbstractDependencyTableModel(List<Task> list) {
        this.removeListeners();
        this.data = list;
        for (Task task : list) {
            Task task2 = task.getParent();
            if (task2 == null || !task2.isSplitted()) continue;
            this.parentSplitted = true;
            break;
        }
        this.listeners = new EventListenerList();
        this.titles = new LinkedList();
        this.columnsType = new LinkedList();
        this.createColumns();
        this.computeDependencies();
        this.setListeners();
    }

    public void discard() {
        this.removeListeners();
    }

    protected void createColumns() {
        this.titles.add("");
        this.titles.add(TYPE);
        this.titles.add(LAG);
        this.titles.add("");
        this.columnsType.add(Task.class);
        this.columnsType.add(String.class);
        this.columnsType.add(Long.class);
        this.columnsType.add(Date.class);
    }

    @Override
    public int getColumnCount() {
        return this.titles.size();
    }

    public Class getColumnClass(int n) {
        return (Class)this.columnsType.get(n);
    }

    @Override
    public String getColumnName(int n) {
        return (String)this.titles.get(n);
    }

    protected void setListeners() {
        for (Task object : this.data) {
            object.addTaskListener(this.taskHandler);
        }
        for (TaskDependencies taskDependencies : this.dependencies) {
            Task task = taskDependencies.getTask();
            task.addTaskListener(this.taskHandler);
        }
    }

    protected void removeListeners() {
        for (Task object : this.data) {
            object.removeTaskListener(this.taskHandler);
        }
        for (TaskDependencies taskDependencies : this.dependencies) {
            Task task = taskDependencies.getTask();
            task.removeTaskListener(this.taskHandler);
        }
    }

    protected abstract void computeDependencies();

    public List<Task> getTasks() {
        return this.data;
    }

    @Override
    public int getRowCount() {
        return this.dependencies.size() + 1;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.parentSplitted) {
            if (n >= this.dependencies.size()) {
                return false;
            }
            return n2 == 2;
        }
        if (n == this.dependencies.size()) {
            return n2 == 0;
        }
        return n2 != 3;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n < this.dependencies.size()) {
            TaskDependencies taskDependencies = this.dependencies.get(n);
            Task task = taskDependencies.getTask();
            if (n2 == 0) {
                return task;
            }
            if (n2 == 1) {
                boolean bl = true;
                String string = DependencyManager.getDependencyType(taskDependencies.getDependencies().get(0));
                for (Dependency dependency : taskDependencies.getDependencies()) {
                    if (string.equals(DependencyManager.getDependencyType(dependency))) continue;
                    bl = false;
                }
                if (bl) {
                    return string;
                }
                return null;
            }
            if (n2 == 2) {
                boolean bl = true;
                long l = taskDependencies.getDependencies().get(0).getTaskDelay();
                for (Dependency dependency : taskDependencies.getDependencies()) {
                    if (l == dependency.getTaskDelay()) continue;
                    bl = false;
                }
                if (bl) {
                    return l;
                }
                return null;
            }
            if (n2 == 3) {
                if (task.equals(taskDependencies.getDependencies().get(0).getSuccessor())) {
                    return task.getStartDate();
                }
                return task.getEndDate();
            }
        } else {
            return null;
        }
        return "";
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    protected void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(UndoableEditListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((UndoableEditListener)eventListenerArray[i]).undoableEditHappened(undoableEditEvent);
        }
    }

    protected abstract void successorAddedEvent(TaskEvent var1);

    protected abstract void successorRemovedEvent(TaskEvent var1);

    protected abstract void predecessorAddedEvent(TaskEvent var1);

    protected abstract void predecessorRemovedEvent(TaskEvent var1);

    public List<TaskDependencies> getDependencies() {
        return this.dependencies;
    }

    public boolean isParentSplitted() {
        return this.parentSplitted;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TaskDependencies {
        private Task task;
        private List<Dependency> dependencies;

        public TaskDependencies(Task task) {
            this.task = task;
            this.dependencies = new LinkedList<Dependency>();
        }

        public void addDependency(Dependency dependency) {
            this.dependencies.add(dependency);
        }

        public void removeDependency(Dependency dependency) {
            this.dependencies.remove(dependency);
        }

        public Task getTask() {
            return this.task;
        }

        public void setTask(Task task) {
            this.task = task;
        }

        public List<Dependency> getDependencies() {
            return this.dependencies;
        }
    }

    private class TaskHandler
    extends TaskAdapter {
        private TaskHandler() {
        }

        public void dataChanged(TaskEvent taskEvent) {
            Task task = (Task)taskEvent.getSource();
            int n = 0;
            for (TaskDependencies taskDependencies : AbstractDependencyTableModel.this.dependencies) {
                if (!task.equals(taskDependencies.getTask())) continue;
                n = AbstractDependencyTableModel.this.dependencies.indexOf(taskDependencies);
            }
            AbstractDependencyTableModel.this.fireTableRowsUpdated(n, n);
        }

        public void successorAdded(TaskEvent taskEvent) {
            AbstractDependencyTableModel.this.successorAddedEvent(taskEvent);
        }

        public void successorRemoved(TaskEvent taskEvent) {
            AbstractDependencyTableModel.this.successorRemovedEvent(taskEvent);
        }

        public void predecessorAdded(TaskEvent taskEvent) {
            AbstractDependencyTableModel.this.predecessorAddedEvent(taskEvent);
        }

        public void predecessorRemoved(TaskEvent taskEvent) {
            AbstractDependencyTableModel.this.predecessorRemovedEvent(taskEvent);
        }
    }
}

