/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.Common;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public final class Splash {
    private Frame parent;
    private MediaTracker mediaTracker;
    private Image image;
    private SplashWindow window;
    private int steps;
    private int step;

    public Splash(String string, int n) {
        this.steps = n;
        this.parent = new Frame();
        this.mediaTracker = new MediaTracker(this.parent);
        this.image = Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource(string));
    }

    public void showSplash() {
        this.parent.setSize(this.image.getWidth(null), this.image.getHeight(null));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rectangle = this.parent.getBounds();
        this.parent.setLocation((dimension.width - rectangle.width) / 2, (dimension.height - rectangle.height) / 2);
        this.mediaTracker.addImage(this.image, 0);
        try {
            this.mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            Common.logException("Error:", interruptedException);
        }
        this.window = new SplashWindow(this.parent, this.image);
    }

    public void hideSplash() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Splash.this.parent.dispose();
            }
        });
    }

    public void setVisible(boolean bl) {
        this.window.setVisible(bl);
    }

    public void increaseStep() {
        ++this.step;
        this.window.setRatio((double)this.step / (double)this.steps);
        this.window.repaint();
    }

    public void increaseStep(int n) {
        this.step += n;
        this.window.setRatio((double)this.step / (double)this.steps);
        this.window.repaint();
    }

    public Frame getParent() {
        return this.parent;
    }

    private class SplashWindow
    extends Window {
        private Image image;
        private Color bgcolor;
        private Color color;
        private int thick;
        private int extraHeight;
        private int indent;
        private double ratio;

        SplashWindow(Frame frame, Image image) {
            super(frame);
            this.bgcolor = new Color(16, 93, 199);
            this.color = new Color(255, 130, 97);
            this.thick = 8;
            this.extraHeight = 14;
            this.indent = 6;
            this.ratio = 0.0;
            this.image = image;
            this.setSize(this.image.getWidth(null), this.image.getHeight(null) + this.extraHeight);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Rectangle rectangle = this.getBounds();
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    SplashWindow.this.setVisible(false);
                }
            });
            this.setLocation((dimension.width - rectangle.width) / 2, (dimension.height - rectangle.height) / 2);
            this.setVisible(true);
        }

        public void setRatio(double d) {
            this.ratio = d;
        }

        public void repaint() {
            super.repaint(this.indent, this.getHeight() - this.extraHeight / 2 - this.thick, this.indent + (int)((double)(this.getWidth() - 2 * this.indent) * this.ratio), this.getHeight() - this.extraHeight / 2 - this.thick);
        }

        public void paint(Graphics graphics) {
            if (this.image != null) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.drawImage(this.image, 0, 0, this);
                graphics2D.setColor(this.bgcolor);
                graphics2D.fillRect(0, this.getHeight() - this.extraHeight, this.getWidth(), this.extraHeight);
                graphics2D.setStroke(new BasicStroke(this.thick));
                graphics2D.setColor(Color.WHITE);
                graphics2D.drawLine(this.indent, this.getHeight() - this.extraHeight / 2, this.indent + (this.getWidth() - 2 * this.indent), this.getHeight() - this.extraHeight / 2);
                graphics2D.setColor(this.color);
                graphics2D.drawLine(this.indent, this.getHeight() - this.extraHeight / 2, this.indent + (int)((double)(this.getWidth() - 2 * this.indent) * this.ratio), this.getHeight() - this.extraHeight / 2);
            }
        }
    }
}

