/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.Common;
import com.sbs.jpm.ui.UIManager;
import com.sbs.jpm.ui.action.ActionID;
import com.sbs.jpm.ui.action.ActionManager;
import com.sbs.jpm.ui.component.MRUList;
import com.sbs.util.SystemUtilities;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToolBar;

public class SmartMenuBar
extends JMenuBar {
    private JMenu fileMenu;
    private JMenu editMenu;
    private JMenu settingsMenu;
    private JMenu viewMenu;
    private JMenu baselineMenu;
    private JMenu projectMenu;
    private MRUList mruList;
    private JMenu helpMenu;

    public SmartMenuBar() {
        this.initFileMenu();
        this.initEditMenu();
        this.initSettingsMenu();
        this.initBaselineMenu();
        this.initViewMenu();
        this.initProjectMenu();
        this.initHelpMenu();
        this.add(this.fileMenu);
        this.add(this.editMenu);
        this.add(this.viewMenu);
        this.add(this.settingsMenu);
        this.add(this.baselineMenu);
        this.add(this.helpMenu);
    }

    private void initFileMenu() {
        ActionManager actionManager = ActionManager.getActionManager();
        this.fileMenu = new JMenu(Common.I18N_ACTIONS.getString("file"));
        this.fileMenu.setMnemonic('F');
        this.fileMenu.add(new JMenuItem(actionManager.getAction(ActionID.FILE_NEW)));
        this.fileMenu.add(new JMenuItem(actionManager.getAction(ActionID.FILE_OPEN)));
        this.fileMenu.add(new JMenuItem(actionManager.getAction(ActionID.FILE_CLOSE)));
        actionManager.getAction(ActionID.FILE_CLOSE).setEnabled(false);
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(new JMenuItem(actionManager.getAction(ActionID.FILE_SAVE)));
        actionManager.getAction(ActionID.FILE_SAVE).setEnabled(false);
        this.fileMenu.add(new JMenuItem(actionManager.getAction(ActionID.FILE_SAVE_AS)));
        actionManager.getAction(ActionID.FILE_SAVE_AS).setEnabled(false);
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(new JMenuItem(actionManager.getAction(ActionID.FILE_EXPORT)));
        actionManager.getAction(ActionID.FILE_EXPORT).setEnabled(false);
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(new JMenuItem(actionManager.getAction(ActionID.FILE_PAGE_SETUP)));
        this.fileMenu.add(new JMenuItem(actionManager.getAction(ActionID.FILE_PRINT_PREVIEW)));
        actionManager.getAction(ActionID.FILE_PRINT_PREVIEW).setEnabled(false);
        this.fileMenu.add(new JMenuItem(actionManager.getAction(ActionID.FILE_PRINT_TO)));
        actionManager.getAction(ActionID.FILE_PRINT_TO).setEnabled(false);
        this.fileMenu.add(new JMenuItem(actionManager.getAction(ActionID.FILE_PRINT)));
        actionManager.getAction(ActionID.FILE_PRINT).setEnabled(false);
        this.fileMenu.add(new JSeparator());
        this.mruList = new MRUList(this.fileMenu);
        if (!SystemUtilities.isOSMac()) {
            this.fileMenu.add(new JSeparator());
            this.fileMenu.add(new JMenuItem(actionManager.getAction(ActionID.FILE_EXIT)));
        }
    }

    private void initEditMenu() {
        ActionManager actionManager = ActionManager.getActionManager();
        this.editMenu = new JMenu(Common.I18N_ACTIONS.getString("edit"));
        this.editMenu.setMnemonic('E');
        this.editMenu.add(new JMenuItem(actionManager.getAction(ActionID.EDIT_UNDO)));
        this.editMenu.add(new JMenuItem(actionManager.getAction(ActionID.EDIT_REDO)));
        actionManager.getAction(ActionID.EDIT_UNDO).setEnabled(false);
        actionManager.getAction(ActionID.EDIT_REDO).setEnabled(false);
    }

    private void initSettingsMenu() {
        this.settingsMenu = new JMenu(Common.I18N_ACTIONS.getString("settings"));
        this.settingsMenu.setMnemonic('S');
        ActionManager actionManager = ActionManager.getActionManager();
        JMenuItem jMenuItem = new JMenuItem(actionManager.getAction(ActionID.SETTINGS_CALENDAR));
        this.settingsMenu.add(jMenuItem);
        actionManager.getAction(ActionID.SETTINGS_CALENDAR).setEnabled(false);
        final UIManager uIManager = UIManager.getInstance();
        JMenu jMenu = new JMenu(Common.I18N_ACTIONS.getString("settings.toolbar"));
        this.settingsMenu.add(jMenu);
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(Common.I18N_ACTIONS.getString("settings.toolbar.mainToolbar"), uIManager.isShowMainToolBar());
        jCheckBoxMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JToolBar jToolBar = Common.getApplication().getWorkspace().getJProject().getMainToolbar();
                if (itemEvent.getStateChange() == 1) {
                    jToolBar.setVisible(true);
                    uIManager.setShowMainToolBar(true);
                } else {
                    jToolBar.setVisible(false);
                    uIManager.setShowMainToolBar(false);
                }
            }
        });
        jMenu.add(jCheckBoxMenuItem);
        JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem(Common.I18N_ACTIONS.getString("settings.toolbar.projectToolbar"), uIManager.isShowProjectToolBar());
        jCheckBoxMenuItem2.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JToolBar jToolBar = Common.getApplication().getWorkspace().getJProject().getProjectsToolbar();
                if (itemEvent.getStateChange() == 1) {
                    jToolBar.setVisible(true);
                    uIManager.setShowProjectToolBar(true);
                } else {
                    jToolBar.setVisible(false);
                    uIManager.setShowProjectToolBar(false);
                }
            }
        });
        jMenu.add(jCheckBoxMenuItem2);
        JCheckBoxMenuItem jCheckBoxMenuItem3 = new JCheckBoxMenuItem(Common.I18N_ACTIONS.getString("settings.toolbar.mailToolbar"), uIManager.isShowMailToolBar());
        jCheckBoxMenuItem3.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JToolBar jToolBar = Common.getApplication().getWorkspace().getJProject().getMailToolBar();
                if (itemEvent.getStateChange() == 1) {
                    jToolBar.setVisible(true);
                    uIManager.setShowMailToolBar(true);
                } else {
                    jToolBar.setVisible(false);
                    uIManager.setShowMailToolBar(false);
                }
            }
        });
        jMenu.add(jCheckBoxMenuItem3);
        JCheckBoxMenuItem jCheckBoxMenuItem4 = new JCheckBoxMenuItem(Common.I18N_ACTIONS.getString("settings.toolbar.viewToolbar"), uIManager.isShowViewToolBar());
        jCheckBoxMenuItem4.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JToolBar jToolBar = Common.getApplication().getWorkspace().getJProject().getViewToolbar();
                if (itemEvent.getStateChange() == 1) {
                    jToolBar.setVisible(true);
                    uIManager.setShowViewToolBar(true);
                } else {
                    jToolBar.setVisible(false);
                    uIManager.setShowViewToolBar(false);
                }
            }
        });
        jMenu.add(jCheckBoxMenuItem4);
        JCheckBoxMenuItem jCheckBoxMenuItem5 = new JCheckBoxMenuItem(Common.I18N_ACTIONS.getString("settings.toolbar.buttonToolbar"), uIManager.isShowButtonToolBar());
        jCheckBoxMenuItem5.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JToolBar jToolBar = Common.getApplication().getWorkspace().getJProject().getButtonToolbar();
                if (itemEvent.getStateChange() == 1) {
                    jToolBar.setVisible(true);
                    uIManager.setShowButtonToolBar(true);
                } else {
                    jToolBar.setVisible(false);
                    uIManager.setShowButtonToolBar(false);
                }
            }
        });
        jMenu.add(jCheckBoxMenuItem5);
        JMenuItem jMenuItem2 = new JMenuItem(actionManager.getAction(ActionID.SETTINGS_OPTIONS));
        this.settingsMenu.add(jMenuItem2);
        actionManager.getAction(ActionID.SETTINGS_OPTIONS).setEnabled(false);
    }

    private void initBaselineMenu() {
        this.baselineMenu = new JMenu(Common.I18N_ACTIONS.getString("baselines"));
        this.baselineMenu.setMnemonic('B');
        ActionManager actionManager = ActionManager.getActionManager();
        JMenuItem jMenuItem = new JMenuItem(actionManager.getAction(ActionID.TOOLS_SAVE_BASELINE));
        this.baselineMenu.add(jMenuItem);
        actionManager.getAction(ActionID.TOOLS_SAVE_BASELINE).setEnabled(false);
        JMenuItem jMenuItem2 = new JMenuItem(actionManager.getAction(ActionID.TOOLS_CLEAR_BASELINE));
        this.baselineMenu.add(jMenuItem2);
        actionManager.getAction(ActionID.TOOLS_CLEAR_BASELINE).setEnabled(false);
        JMenuItem jMenuItem3 = new JMenuItem(actionManager.getAction(ActionID.TOOLS_COMPARE_BASELINE));
        this.baselineMenu.add(jMenuItem3);
        actionManager.getAction(ActionID.TOOLS_COMPARE_BASELINE).setEnabled(false);
        JMenuItem jMenuItem4 = new JMenuItem(actionManager.getAction(ActionID.TOOLS_HIDE_BASELINE));
        this.baselineMenu.add(jMenuItem4);
        actionManager.getAction(ActionID.TOOLS_HIDE_BASELINE).setEnabled(false);
    }

    private void initViewMenu() {
        this.viewMenu = new JMenu(Common.I18N_ACTIONS.getString("view"));
        this.viewMenu.setMnemonic('V');
        ActionManager actionManager = ActionManager.getActionManager();
        JMenuItem jMenuItem = new JMenuItem(actionManager.getAction(ActionID.VIEW_WBS));
        this.viewMenu.add(jMenuItem);
        actionManager.getAction(ActionID.VIEW_WBS).setEnabled(false);
        JMenuItem jMenuItem2 = new JMenuItem(actionManager.getAction(ActionID.VIEW_GANTT));
        this.viewMenu.add(jMenuItem2);
        actionManager.getAction(ActionID.VIEW_GANTT).setEnabled(false);
        JMenuItem jMenuItem3 = new JMenuItem(actionManager.getAction(ActionID.VIEW_RESOURCES));
        this.viewMenu.add(jMenuItem3);
        actionManager.getAction(ActionID.VIEW_RESOURCES).setEnabled(false);
        JMenuItem jMenuItem4 = new JMenuItem(actionManager.getAction(ActionID.VIEW_TASK_SHEET));
        this.viewMenu.add(jMenuItem4);
        actionManager.getAction(ActionID.VIEW_TASK_SHEET).setEnabled(false);
        JMenuItem jMenuItem5 = new JMenuItem(actionManager.getAction(ActionID.VIEW_RESOURCE_SHEET));
        this.viewMenu.add(jMenuItem5);
        actionManager.getAction(ActionID.VIEW_RESOURCE_SHEET).setEnabled(false);
        this.viewMenu.addSeparator();
        JMenuItem jMenuItem6 = new JMenuItem(actionManager.getAction(ActionID.VIEW_GUIDE));
        this.viewMenu.add(jMenuItem6);
        actionManager.getAction(ActionID.VIEW_GUIDE).setEnabled(false);
        JMenuItem jMenuItem7 = new JMenuItem(actionManager.getAction(ActionID.VIEW_GUIDE_DETAILS));
        this.viewMenu.add(jMenuItem7);
        actionManager.getAction(ActionID.VIEW_GUIDE_DETAILS).setEnabled(false);
    }

    private void initProjectMenu() {
        this.projectMenu = new JMenu(Common.I18N_ACTIONS.getString("project"));
        this.projectMenu.setMnemonic('P');
        ActionManager actionManager = ActionManager.getActionManager();
    }

    private void initHelpMenu() {
        ActionManager actionManager = ActionManager.getActionManager();
        this.helpMenu = new JMenu(Common.I18N_ACTIONS.getString("help"));
        this.helpMenu.setMnemonic('H');
        this.helpMenu.add(new JMenuItem(actionManager.getAction(ActionID.HELP_CONTENTS)));
        this.helpMenu.add(new JSeparator());
        if (!SystemUtilities.isOSMac()) {
            this.helpMenu.add(new JMenuItem(actionManager.getAction(ActionID.HELP_ABOUT)));
        }
    }

    public void addMRUItem(String string) {
        this.mruList.addMRUItem(string);
    }

    public List getMRUItems() {
        return this.mruList.getMRUList();
    }
}

