/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.MaterialResource;
import com.sbs.jpm.core.event.ResourceAdapter;
import com.sbs.jpm.core.event.ResourceEvent;
import com.sbs.jpm.core.event.ResourceListener;
import com.sbs.jpm.ui.component.util.CostFormat;
import com.sbs.jpm.ui.component.util.JTextComponentUndoHandler;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import com.sbs.jpm.undo.MResourceMeasurementUnitEdit;
import com.sbs.jpm.undo.ResourceCodeEdit;
import com.sbs.jpm.undo.ResourceNameEdit;
import com.sbs.jpm.undo.ResourceNotesEdit;
import com.sbs.jpm.undo.ResourceStdRateEdit;
import com.sbs.jpm.undo.UndoHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.ParseException;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.InternationalFormatter;

public class MResourceDetailView
extends JPanel {
    private UndoHandler undoHandler;
    private EventListenerList listeners = new EventListenerList();
    private MaterialResource resource;
    private JLabel nameLabel;
    private JLabel measurementUnitLabel;
    private JLabel pricePerUnitLabel;
    private JLabel codeLabel;
    private JLabel notesLabel;
    private JTabbedPane tabbedPane;
    private JFormattedTextField pricePerUnitField;
    private JTextField nameField;
    private JTextField codeField;
    private JTextField measurementUnitField;
    private JTextArea notesArea;
    private NameHandler nameListener;
    private NotesHandler notesHandler;
    private CodeHandler codeListener;
    private UnitHandler measurementUnitListener;
    private PricePerUnitHandler pricePerUnitListener;
    private DocumentListener notesListener;
    private CostFormat costFormat;
    private ResourceListener resourceHandler;

    public MResourceDetailView() {
        this.setLayout(new BorderLayout());
        this.costFormat = new CostFormat();
        this.resourceHandler = new ResourceHandler();
        this.add((Component)this.createContents(), "Center");
        this.nameListener = new NameHandler();
        this.notesHandler = new NotesHandler();
        this.codeListener = new CodeHandler();
        this.measurementUnitListener = new UnitHandler();
        this.pricePerUnitListener = new PricePerUnitHandler();
        this.notesListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!MResourceDetailView.this.notesArea.getText().equals(MResourceDetailView.this.resource.getNotes())) {
                    MResourceDetailView.this.resource.setNotes(MResourceDetailView.this.notesArea.getText());
                }
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                if (!MResourceDetailView.this.notesArea.getText().equals(MResourceDetailView.this.resource.getNotes())) {
                    MResourceDetailView.this.resource.setNotes(MResourceDetailView.this.notesArea.getText());
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
    }

    public void setResource(MaterialResource materialResource) {
        if (this.resource != null) {
            this.resource.removeResourceListener(this.resourceHandler);
        }
        this.resource = materialResource != null && materialResource.isEmpty() ? null : materialResource;
        if (this.resource != null) {
            this.resource.addResourceListener(this.resourceHandler);
        }
        if (this.resource == null) {
            this.removeListeners();
            this.pricePerUnitField.setValue(0);
            this.nameField.setText("");
            this.codeField.setText("");
            this.measurementUnitField.setText("");
            this.notesArea.setText("");
            this.nameLabel.setEnabled(false);
            this.measurementUnitLabel.setEnabled(false);
            this.pricePerUnitLabel.setEnabled(false);
            this.codeLabel.setEnabled(false);
            this.notesLabel.setEnabled(false);
            this.tabbedPane.setEnabled(false);
            this.pricePerUnitField.setEnabled(false);
            this.nameField.setEnabled(false);
            this.codeField.setEnabled(false);
            this.measurementUnitField.setEnabled(false);
            this.notesArea.setEnabled(false);
        } else {
            this.tabbedPane.setEnabled(true);
            this.nameLabel.setEnabled(true);
            this.measurementUnitLabel.setEnabled(true);
            this.pricePerUnitLabel.setEnabled(true);
            this.codeLabel.setEnabled(true);
            this.notesLabel.setEnabled(true);
            this.pricePerUnitField.setEnabled(true);
            this.nameField.setEnabled(true);
            this.codeField.setEnabled(true);
            this.measurementUnitField.setEnabled(true);
            this.notesArea.setEnabled(true);
            this.costFormat.setResource(materialResource);
            this.nameField.setText(materialResource.getName());
            this.codeField.setText(materialResource.getCode());
            this.measurementUnitField.setText(materialResource.getMeasurementUnit());
            this.pricePerUnitField.setValue(materialResource.getStandardRate());
            this.notesArea.setText(materialResource.getNotes());
            new JTextComponentUndoHandler(this.notesArea);
            this.removeUndoableEditListener(this.undoHandler);
            this.undoHandler = new UndoHandler(materialResource.getOwner().getUndoManager());
            this.addUndoableEditListener(this.undoHandler);
            this.addListeners();
        }
    }

    private void addListeners() {
        this.nameField.addActionListener(this.nameListener);
        this.nameField.addFocusListener(this.nameListener);
        this.notesArea.addFocusListener(this.notesHandler);
        this.codeField.addActionListener(this.codeListener);
        this.codeField.addFocusListener(this.codeListener);
        this.measurementUnitField.addActionListener(this.measurementUnitListener);
        this.measurementUnitField.addFocusListener(this.measurementUnitListener);
        this.pricePerUnitField.addActionListener(this.pricePerUnitListener);
        this.pricePerUnitField.addFocusListener(this.pricePerUnitListener);
        this.notesArea.getDocument().addDocumentListener(this.notesListener);
    }

    private void removeListeners() {
        this.nameField.removeActionListener(this.nameListener);
        this.nameField.removeFocusListener(this.nameListener);
        this.notesArea.removeFocusListener(this.notesHandler);
        this.codeField.removeActionListener(this.codeListener);
        this.codeField.removeFocusListener(this.codeListener);
        this.measurementUnitField.removeActionListener(this.measurementUnitListener);
        this.measurementUnitField.removeFocusListener(this.measurementUnitListener);
        this.pricePerUnitField.removeActionListener(this.pricePerUnitListener);
        this.pricePerUnitField.removeFocusListener(this.pricePerUnitListener);
        this.notesArea.getDocument().removeDocumentListener(this.notesListener);
    }

    private JPanel createDetailsTab() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(1, 1, 1, 1);
        this.nameLabel = new JLabel(Common.I18N_RP.getString("resource.name") + ":");
        this.measurementUnitLabel = new JLabel(Common.I18N_RP.getString("resource.measurementUnit") + ":");
        this.pricePerUnitLabel = new JLabel(Common.I18N_RP.getString("resource.pricePerUnit") + ":");
        this.codeLabel = new JLabel(Common.I18N_RP.getString("resource.code") + ":");
        this.nameField = new JTextField(30);
        this.codeField = new JTextField(30);
        this.measurementUnitField = new JTextField(30);
        this.pricePerUnitField = new JFormattedTextField();
        this.pricePerUnitField.setHorizontalAlignment(4);
        this.pricePerUnitField.setFormatterFactory(new DefaultFormatterFactory(new InternationalFormatter(this.costFormat)));
        jPanel.add((Component)this.nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.nameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        jPanel.add((Component)this.measurementUnitLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.measurementUnitField, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        jPanel.add((Component)this.pricePerUnitLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.pricePerUnitField, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        jPanel.add((Component)this.codeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.codeField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        jPanel.add((Component)new JPanel(), new GridBagConstraints(0, 2, 6, 1, 1.0, 1.0, 21, 1, insets, 0, 0));
        return jPanel;
    }

    private JPanel createNotesTab() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(1, 1, 1, 1);
        this.notesLabel = new JLabel(Common.I18N_RP.getString("resource.notes") + ":");
        this.notesArea = new JTextArea();
        this.notesArea.setLineWrap(true);
        this.notesArea.setWrapStyleWord(true);
        jPanel.add((Component)this.notesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)new JScrollPane(this.notesArea, 20, 31), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 21, 1, insets, 0, 0));
        return jPanel;
    }

    private JComponent createContents() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add(Common.I18N_RP.getString("resource.details"), this.createDetailsTab());
        this.tabbedPane.add(Common.I18N_RP.getString("resource.notes"), this.createNotesTab());
        return this.tabbedPane;
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    private void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(UndoableEditListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((UndoableEditListener)eventListenerArray[i]).undoableEditHappened(undoableEditEvent);
        }
    }

    private void updateValues() {
        this.removeListeners();
        this.nameField.setText(this.resource.getName());
        this.codeField.setText(this.resource.getCode());
        this.measurementUnitField.setText(this.resource.getMeasurementUnit());
        this.pricePerUnitField.setValue(this.resource.getStandardRate());
        try {
            this.notesArea.setText(this.resource.getNotes());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.addListeners();
    }

    private class ResourceHandler
    extends ResourceAdapter {
        private ResourceHandler() {
        }

        public void dataChanged(ResourceEvent resourceEvent) {
            MResourceDetailView.this.updateValues();
        }

        public void notesChanged(ResourceEvent resourceEvent) {
            MResourceDetailView.this.updateValues();
        }

        public void assignmentAdded(ResourceEvent resourceEvent) {
        }

        public void assignmentRemoved(ResourceEvent resourceEvent) {
        }
    }

    private class NotesHandler
    implements FocusListener {
        private String oldNotes = "";

        private NotesHandler() {
        }

        private void doIt() {
            String string = MResourceDetailView.this.notesArea.getText();
            if (!string.equals(this.oldNotes)) {
                ResourceNotesEdit resourceNotesEdit = new ResourceNotesEdit(MResourceDetailView.this.resource, this.oldNotes, string, "05/10/2009 19:02:00");
                MResourceDetailView.this.resource.setNotes(string);
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, resourceNotesEdit);
                MResourceDetailView.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            this.oldNotes = MResourceDetailView.this.notesArea.getText();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }

    private class PricePerUnitHandler
    implements FocusListener,
    ActionListener {
        private PricePerUnitHandler() {
        }

        private void doIt() {
            try {
                MResourceDetailView.this.pricePerUnitField.commitEdit();
            }
            catch (ParseException parseException) {
                return;
            }
            if (!MResourceDetailView.this.pricePerUnitField.getValue().equals(MResourceDetailView.this.resource.getStandardRate())) {
                UndoableEditEvent undoableEditEvent;
                double d = (Double)MResourceDetailView.this.pricePerUnitField.getValue();
                ResourceStdRateEdit resourceStdRateEdit = new ResourceStdRateEdit(MResourceDetailView.this.resource, MResourceDetailView.this.resource.getStandardRate(), d, "09/11/09 13:12:01");
                boolean bl = MResourceDetailView.this.resource.isEmpty();
                MResourceDetailView.this.resource.setStandardRate(d);
                if (bl) {
                    ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                    extendedCompoundEdit.addEdit(resourceStdRateEdit);
                    extendedCompoundEdit.end();
                    undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                } else {
                    undoableEditEvent = new UndoableEditEvent(this, resourceStdRateEdit);
                }
                MResourceDetailView.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.doIt();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }

    private class UnitHandler
    implements FocusListener,
    ActionListener {
        private UnitHandler() {
        }

        private void doIt() {
            if (!MResourceDetailView.this.measurementUnitField.getText().equals(MResourceDetailView.this.resource.getMeasurementUnit())) {
                UndoableEditEvent undoableEditEvent;
                String string = MResourceDetailView.this.measurementUnitField.getText();
                MResourceMeasurementUnitEdit mResourceMeasurementUnitEdit = new MResourceMeasurementUnitEdit(MResourceDetailView.this.resource, MResourceDetailView.this.resource.getMeasurementUnit(), string, "09/11/09 15:13:00");
                boolean bl = MResourceDetailView.this.resource.isEmpty();
                MResourceDetailView.this.resource.setMeasurementUnit(string);
                if (bl) {
                    ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                    extendedCompoundEdit.addEdit(mResourceMeasurementUnitEdit);
                    extendedCompoundEdit.end();
                    undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                } else {
                    undoableEditEvent = new UndoableEditEvent(this, mResourceMeasurementUnitEdit);
                }
                MResourceDetailView.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.doIt();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }

    private class CodeHandler
    implements FocusListener,
    ActionListener {
        private CodeHandler() {
        }

        private void doIt() {
            if (!MResourceDetailView.this.codeField.getText().equals(MResourceDetailView.this.resource.getCode())) {
                UndoableEditEvent undoableEditEvent;
                String string = MResourceDetailView.this.codeField.getText();
                ResourceCodeEdit resourceCodeEdit = new ResourceCodeEdit(MResourceDetailView.this.resource, MResourceDetailView.this.resource.getCode(), string, "09/11/09 15:01:01");
                boolean bl = MResourceDetailView.this.resource.isEmpty();
                MResourceDetailView.this.resource.setCode(string);
                if (bl) {
                    ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                    extendedCompoundEdit.addEdit(resourceCodeEdit);
                    extendedCompoundEdit.end();
                    undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                } else {
                    undoableEditEvent = new UndoableEditEvent(this, resourceCodeEdit);
                }
                MResourceDetailView.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.doIt();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }

    private class NameHandler
    implements FocusListener,
    ActionListener {
        private NameHandler() {
        }

        private void doIt() {
            if (!MResourceDetailView.this.nameField.getText().equals(MResourceDetailView.this.resource.getName())) {
                UndoableEditEvent undoableEditEvent;
                String string = MResourceDetailView.this.nameField.getText();
                ResourceNameEdit resourceNameEdit = new ResourceNameEdit(MResourceDetailView.this.resource, MResourceDetailView.this.resource.getName(), string, "09/11/09 13:14:01");
                boolean bl = MResourceDetailView.this.resource.isEmpty();
                MResourceDetailView.this.resource.setName(string);
                if (bl) {
                    ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                    extendedCompoundEdit.addEdit(resourceNameEdit);
                    extendedCompoundEdit.end();
                    undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                } else {
                    undoableEditEvent = new UndoableEditEvent(this, resourceNameEdit);
                }
                MResourceDetailView.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.doIt();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }
}

