/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.Common;
import com.sbs.jpm.configuration.Configuration;
import com.sbs.jpm.configuration.ConfigurationSetting;
import com.sbs.jpm.ui.JApplication;
import com.sbs.util.Product;
import com.sbs.util.SystemUtilities;
import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JUpdateDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JCheckBox checkBox;
    private Product product;

    public JUpdateDialog(Frame frame, Product product) {
        super(frame, Common.I18N_RP.getString("newVersionAvailable"), true);
        this.product = product;
        ((Frame)this.getOwner()).setIconImage(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/logo-16.png")).getImage());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createContent(), "Center");
        this.pack();
        this.setResizable(false);
    }

    private JPanel createContent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(4, 4, 4, 4);
        JButton jButton = new JButton(Common.I18N_RP.getString("upgradeNow"));
        jButton.setVisible(false);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JUpdateDialog.this.setVisible(false);
                Thread thread = new Thread(){

                    public void run() {
                        try {
                            BrowserLauncher browserLauncher = new BrowserLauncher();
                            browserLauncher.openURLinBrowser(JUpdateDialog.this.product.getTrialLinkMac());
                        }
                        catch (Exception exception) {
                            Common.logException("Error:", exception);
                        }
                    }
                };
                thread.start();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.exit(0);
            }
        });
        JButton jButton2 = new JButton(Common.I18N_RP.getString("upgradeNow"));
        jButton2.setVisible(false);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JUpdateDialog.this.setVisible(false);
                Thread thread = new Thread(){

                    public void run() {
                        try {
                            BrowserLauncher browserLauncher = new BrowserLauncher();
                            browserLauncher.openURLinBrowser(JUpdateDialog.this.product.getTrialLinkWindows());
                        }
                        catch (Exception exception) {
                            Common.logException("Error:", exception);
                        }
                    }
                };
                thread.start();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.exit(0);
            }
        });
        JButton jButton3 = new JButton(Common.I18N_RP.getString("upgradeNow"));
        jButton3.setVisible(false);
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JUpdateDialog.this.setVisible(false);
                Thread thread = new Thread(){

                    public void run() {
                        try {
                            BrowserLauncher browserLauncher = new BrowserLauncher();
                            browserLauncher.openURLinBrowser(JUpdateDialog.this.product.getTrialLinkCross());
                        }
                        catch (Exception exception) {
                            Common.logException("Error:", exception);
                        }
                    }
                };
                thread.start();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.exit(0);
            }
        });
        JButton jButton4 = new JButton(Common.I18N_RP.getString("skipUpgrade"));
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JUpdateDialog.this.setVisible(false);
            }
        });
        this.checkBox = new JCheckBox(Common.I18N_RP.getString("doNotShowAgain"));
        this.checkBox.setSelected(false);
        this.checkBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    Configuration.getInstance().setValue(ConfigurationSetting.STARTUP_UPDATE, false);
                }
            }
        });
        if (SystemUtilities.isOSMac()) {
            jButton.setVisible(true);
            this.getRootPane().setDefaultButton(jButton);
        } else if (SystemUtilities.isOSWindows()) {
            jButton2.setVisible(true);
            this.getRootPane().setDefaultButton(jButton2);
        } else {
            jButton3.setVisible(true);
            this.getRootPane().setDefaultButton(jButton2);
        }
        Object[] objectArray = new Object[]{JApplication.getApplicationVersion(), this.product.getVersion()};
        String string = MessageFormat.format(Common.I18N_RP.getString("updateToLatestVersion"), objectArray);
        jPanel.add((Component)new JLabel(string), new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)jButton, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 22, 0, insets, 0, 0));
        jPanel.add((Component)jButton2, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 22, 0, insets, 0, 0));
        jPanel.add((Component)jButton3, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 22, 0, insets, 0, 0));
        jPanel.add((Component)jButton4, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 22, 0, insets, 0, 0));
        jPanel.add((Component)this.checkBox, new GridBagConstraints(0, 6, 4, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        return jPanel;
    }
}

