/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.Common;
import com.sbs.jpm.CompanyDocumentManager;
import com.sbs.jpm.configuration.Configuration;
import com.sbs.jpm.configuration.ConfigurationSetting;
import com.sbs.jpm.document.DocumentException;
import com.sbs.jpm.ui.JApplication;
import com.sbs.jpm.ui.UIManager;
import com.sbs.jpm.ui.action.ActionID;
import com.sbs.jpm.ui.action.ActionManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class JStartupDialog
extends JDialog {
    private JLabel welcomeLabel;
    private JButton newButton;
    private JButton openButton;
    private JButton openLastButton;
    private JCheckBox checkBox;
    private boolean isViewer;

    public JStartupDialog(Frame frame, boolean bl) {
        super(frame);
        this.isViewer = bl;
        this.setTitle(JApplication.getApplicationName() + " " + Common.I18N_RP.getString("welcome"));
        ((Frame)this.getOwner()).setIconImage(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/logo-16.png")).getImage());
        this.setModal(true);
        this.setResizable(false);
        this.setSize(500, 150);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createContent(), "Center");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (!JStartupDialog.this.isViewer) {
                    JStartupDialog.this.newButton.doClick();
                }
                JStartupDialog.this.setVisible(false);
            }
        });
        UIManager uIManager = UIManager.getInstance();
        if (uIManager.getStartupAction() == 0) {
            this.getRootPane().setDefaultButton(this.newButton);
        } else if (uIManager.getStartupAction() == 1) {
            this.getRootPane().setDefaultButton(this.openButton);
        } else if (uIManager.getStartupAction() == 2) {
            this.getRootPane().setDefaultButton(this.openLastButton);
        }
        this.pack();
    }

    private JPanel createContent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(4, 4, 4, 4);
        this.welcomeLabel = new JLabel(Common.I18N_RP.getString("pleaseSelectYourAction") + ":");
        ActionManager actionManager = ActionManager.getActionManager();
        this.newButton = new JButton(Common.I18N_ACTIONS.getString("file.new"), (Icon)actionManager.getAction(ActionID.FILE_NEW).getValue("SmallIcon"));
        this.newButton.setVisible(!this.isViewer);
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JStartupDialog.this.setVisible(false);
            }
        });
        this.openButton = new JButton(Common.I18N_ACTIONS.getString("file.open") + "...", (Icon)actionManager.getAction(ActionID.FILE_OPEN).getValue("SmallIcon"));
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JStartupDialog.this.setVisible(false);
                ActionManager actionManager = ActionManager.getActionManager();
                actionManager.getAction(ActionID.FILE_OPEN).actionPerformed(new ActionEvent(this, actionEvent.getID(), ""));
                UIManager.getInstance().setStartupAction(1);
            }
        });
        this.openLastButton = new JButton(Common.I18N_ACTIONS.getString("openLast"));
        Configuration configuration = Configuration.getInstance();
        final List list = (List)configuration.getValue(ConfigurationSetting.MRU_FILES);
        this.openLastButton.setEnabled(list.size() != 0);
        this.openLastButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JStartupDialog.this.setVisible(false);
                String string = list.get(0).toString();
                File file = new File(string);
                if (file.exists()) {
                    try {
                        CompanyDocumentManager companyDocumentManager = Common.getProjectDocumentManager();
                        companyDocumentManager.open(file);
                    }
                    catch (DocumentException documentException) {
                        Common.logException("Error:", documentException);
                        JOptionPane.showMessageDialog(null, documentException.getLocalizedMessage(), Common.I18N_MESSAGES.getString("file.failedToOpen"), 0);
                    }
                    Configuration.getInstance().setValue(ConfigurationSetting.CURRENT_DIR, file.getParent());
                    UIManager.getInstance().setStartupAction(2);
                } else {
                    Object[] objectArray = new Object[]{string};
                    JOptionPane.showMessageDialog(null, MessageFormat.format(Common.I18N_MESSAGES.getString("fileDoesNotExist"), objectArray), Common.I18N_MESSAGES.getString("file.failedToOpen"), 0);
                }
            }
        });
        this.checkBox = new JCheckBox(Common.I18N_RP.getString("doNotShowAgain"));
        this.checkBox.setSelected(false);
        this.checkBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    Configuration.getInstance().setValue(ConfigurationSetting.STARTUP_WELCOME, false);
                }
            }
        });
        jPanel.add((Component)this.welcomeLabel, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        jPanel.add((Component)this.newButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.openButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.openLastButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.checkBox, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        return jPanel;
    }
}

