/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.baseline.ProjectBaseline;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.SimpleDateFormat;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JSaveBaselineDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Task project;
    private JComboBox baselines;
    private JTextField description;

    public JSaveBaselineDialog(Frame frame, String string, Task task) {
        super(frame, string, true);
        ((Frame)this.getOwner()).setIconImage(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/logo-16.png")).getImage());
        this.project = task;
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createContent(), "Center");
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setResizable(false);
    }

    private JPanel createContent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(4, 4, 4, 4);
        ProjectBaseline projectBaseline = null;
        Vector<ProjectBaseline> vector = new Vector<ProjectBaseline>();
        for (int i = 0; i < 10; ++i) {
            ProjectBaseline projectBaseline2 = this.project.getProjectBaselineAt(i);
            if (projectBaseline2 != null) {
                vector.add(projectBaseline2);
                continue;
            }
            if (projectBaseline == null) {
                projectBaseline = new ProjectBaseline();
            }
            vector.add(projectBaseline);
        }
        this.baselines = new JComboBox(vector);
        this.baselines.setSelectedIndex(0);
        this.baselines.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                String string;
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MM-yyyy");
                ProjectBaseline projectBaseline = (ProjectBaseline)object;
                if (!projectBaseline.isEmpty()) {
                    String string2 = projectBaseline.getDescription();
                    string2 = string2 != null ? string2 + "; " : "";
                    string = Common.I18N_RP.getString("baseline") + " " + (JSaveBaselineDialog.this.project.getProjectBaselineIndex(projectBaseline) + 1) + "(" + string2 + simpleDateFormat.format(projectBaseline.getDate()) + ")";
                } else {
                    if (n == -1) {
                        n = JSaveBaselineDialog.this.baselines.getSelectedIndex();
                    }
                    string = Common.I18N_RP.getString("baseline") + " " + (n + 1);
                }
                return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            }
        });
        if (projectBaseline != null) {
            this.baselines.setSelectedItem(projectBaseline);
        }
        this.baselines.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ProjectBaseline projectBaseline = (ProjectBaseline)JSaveBaselineDialog.this.baselines.getSelectedItem();
                if (projectBaseline.isEmpty()) {
                    JSaveBaselineDialog.this.description.setText("");
                } else {
                    JSaveBaselineDialog.this.description.setText(projectBaseline.getDescription());
                }
            }
        });
        this.description = new JTextField(20);
        if (this.project.getProjectBaselineAt(0) != null) {
            this.description.setText(this.project.getProjectBaselineAt(0).getDescription());
        }
        jPanel.add((Component)new JLabel(Common.I18N_RP.getString("name") + ":"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.baselines, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)new JLabel(Common.I18N_RP.getString("description") + ":"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.description, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.createButtonsPanel(), new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 22, 0, insets, 0, 0));
        return jPanel;
    }

    private JPanel createButtonsPanel() {
        JPanel jPanel = new JPanel(new GridLayout());
        JButton jButton = new JButton(Common.I18N_RP.getString("cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JSaveBaselineDialog.this.setVisible(false);
            }
        });
        JButton jButton2 = new JButton(Common.I18N_RP.getString("ok"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = JSaveBaselineDialog.this.baselines.getSelectedIndex();
                ProjectBaseline projectBaseline = (ProjectBaseline)JSaveBaselineDialog.this.baselines.getSelectedItem();
                if (!projectBaseline.isEmpty()) {
                    int n2 = JOptionPane.showConfirmDialog(Common.getApplication(), Common.I18N_MESSAGES.getString("baseline.overwrite.message"), Common.I18N_MESSAGES.getString("baseline.overwrite.title"), 0, 1);
                    if (n2 == 0) {
                        JSaveBaselineDialog.this.project.saveBaselineAt(n);
                        JSaveBaselineDialog.this.project.getProjectBaselineAt(n).setDescription(JSaveBaselineDialog.this.description.getText());
                        JSaveBaselineDialog.this.setVisible(false);
                        Common.getApplication().getWorkspace().getJProject().repaint();
                    } else {
                        return;
                    }
                }
                JSaveBaselineDialog.this.project.saveBaselineAt(n);
                JSaveBaselineDialog.this.project.getProjectBaselineAt(n).setDescription(JSaveBaselineDialog.this.description.getText());
                JSaveBaselineDialog.this.setVisible(false);
                Common.getApplication().getWorkspace().getJProject().repaint();
            }
        });
        this.getRootPane().setDefaultButton(jButton2);
        jPanel.add(jButton2);
        jPanel.add(jButton);
        return jPanel;
    }
}

