/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.ui.component.JHumanResourcesTable;
import com.sbs.jpm.ui.component.JMaterialResourcesTable;
import com.sbs.jpm.ui.component.JProjectView;
import com.sbs.jpm.ui.component.model.RowHeaderModel;
import com.sbs.jpm.ui.component.renderer.RowHeaderTableCellRenderer;
import com.sbs.jpm.ui.component.view.JProjectViewEPS;
import com.sbs.jpm.ui.component.view.JProjectViewGantt;
import com.sbs.jpm.ui.component.view.JProjectViewHumanResource;
import com.sbs.jpm.ui.component.view.JProjectViewMaterialResource;
import com.sbs.jpm.ui.component.view.JProjectViewResourceSheet;
import com.sbs.jpm.ui.component.view.JProjectViewTaskSheet;
import com.sbs.jpm.ui.component.view.JProjectViewWBS;
import com.sbs.jpm.ui.treetablechart.JEPSTable;
import com.sbs.jpm.ui.treetablechart.JTreeTable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class JRowHeader
extends JList {
    private JTable table;
    private TableModel tableModel;
    private TableModelListener modelListener;

    public JRowHeader(JTable jTable) {
        this.table = jTable;
        this.setFixedCellWidth(40);
        this.setFixedCellHeight(jTable.getRowHeight());
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                JRowHeader.this.table.grabFocus();
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.setModel(new RowHeaderModel(jTable));
        this.setCellRenderer(new RowHeaderTableCellRenderer(jTable));
        this.modelListener = new TableModelHandler();
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent mouseEvent) {
                JRowHeader.this.dispatch(mouseEvent);
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                JRowHeader.this.dispatch(mouseEvent);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    if (JRowHeader.this.table instanceof JTreeTable) {
                        JTreeTable jTreeTable = (JTreeTable)((Object)JRowHeader.this.table);
                        JProjectView jProjectView = jTreeTable.getProjectView();
                        if (jProjectView instanceof JProjectViewWBS) {
                            ((JProjectViewWBS)jProjectView).getInfoButton().doClick();
                        } else if (jProjectView instanceof JProjectViewGantt) {
                            ((JProjectViewGantt)jProjectView).getInfoButton().doClick();
                            ((JProjectViewGantt)jProjectView).getTaskView().setSelectedIndex(0);
                        } else if (jProjectView instanceof JProjectViewEPS) {
                            ((JProjectViewEPS)jProjectView).getInfoButton().doClick();
                        } else if (jProjectView instanceof JProjectViewTaskSheet) {
                            ((JProjectViewTaskSheet)jProjectView).getInfoButton().doClick();
                        } else if (jProjectView instanceof JProjectViewResourceSheet) {
                            ((JProjectViewResourceSheet)jProjectView).getInfoButton().doClick();
                        }
                    } else if (JRowHeader.this.table instanceof JEPSTable) {
                        JEPSTable jEPSTable = (JEPSTable)((Object)JRowHeader.this.table);
                        JProjectView jProjectView = jEPSTable.getProjectView();
                        ((JProjectViewEPS)jProjectView).getInfoButton().doClick();
                    } else if (JRowHeader.this.table instanceof JHumanResourcesTable) {
                        JHumanResourcesTable jHumanResourcesTable = (JHumanResourcesTable)((Object)JRowHeader.this.table);
                        JProjectViewHumanResource jProjectViewHumanResource = jHumanResourcesTable.getProjectView();
                        jProjectViewHumanResource.getInfoButton().doClick();
                    } else if (JRowHeader.this.table instanceof JMaterialResourcesTable) {
                        JMaterialResourcesTable jMaterialResourcesTable = (JMaterialResourcesTable)((Object)JRowHeader.this.table);
                        JProjectViewMaterialResource jProjectViewMaterialResource = jMaterialResourcesTable.getProjectView();
                        jProjectViewMaterialResource.getInfoButton().doClick();
                    }
                } else {
                    JRowHeader.this.dispatch(mouseEvent);
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                JRowHeader.this.dispatch(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                JRowHeader.this.dispatch(mouseEvent);
            }
        });
    }

    protected void dispatch(MouseEvent mouseEvent) {
        this.table.dispatchEvent(new MouseEvent(this.table, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
    }

    public void updateUI() {
        super.updateUI();
        LookAndFeel.installColorsAndFont(this, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
    }

    public void setTableModel(TableModel tableModel) {
        if (this.tableModel != null) {
            tableModel.removeTableModelListener(this.modelListener);
        }
        this.tableModel = tableModel;
        tableModel.addTableModelListener(this.modelListener);
        this.setModel(new RowHeaderModel(this.table));
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            JRowHeader.this.revalidate();
        }
    }
}

