/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Risk;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.print.CustomPageable;
import com.sbs.jpm.print.PrintManager;
import com.sbs.jpm.ui.action.ActionMapper;
import com.sbs.jpm.ui.component.JProjectView;
import com.sbs.jpm.ui.component.JRowHeader;
import com.sbs.jpm.ui.component.model.ProjectRisksTableModel;
import com.sbs.jpm.ui.component.view.JProjectViewRisks;
import com.sbs.jpm.undo.RiskDeleteEdit;
import com.sbs.jpm.undo.UndoHandler;
import com.sbs.util.SystemUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.JXTable;

public class JProjectRisksTable
extends JXTable
implements Printable,
CustomPageable {
    protected JProjectView projectView;
    protected int totalVerticalNumPages;
    protected int totalHorizontalNumPages;
    protected double pageHeight;
    protected double pageWidth;
    protected double headerHeightOnPage;
    protected double tableWidth;
    private UndoHandler undoHandler;
    private EventListenerList listeners = new EventListenerList();
    private Task project;

    public JProjectRisksTable() {
        super((TableModel)new ProjectRisksTableModel());
        this.setAutoCreateColumnsFromModel(false);
        this.setHeaderWidths();
        this.setRenderersAndEditors();
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        if (SystemUtilities.isOSMac()) {
            this.putClientProperty("Quaqua.Table.style", "striped");
            this.setShowHorizontalLines(false);
            this.setShowVerticalLines(true);
        }
        ActionMapper actionMapper = ActionMapper.getInstance();
        actionMapper.mapActions((JComponent)((Object)this));
        ActionMap actionMap = this.getActionMap();
        actionMap.put("delete", new AbstractAction("delete risk"){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectRisksTableModel projectRisksTableModel;
                Task task;
                int n;
                int n2;
                if (JProjectRisksTable.this.getSelectedRowCount() == 1 && (n2 = JProjectRisksTable.this.convertRowIndexToModel(n = JProjectRisksTable.this.getSelectedRow())) < (task = (projectRisksTableModel = (ProjectRisksTableModel)JProjectRisksTable.this.getModel()).getProject()).getRisksNumber()) {
                    Risk risk = task.getRiskAt(n2);
                    RiskDeleteEdit riskDeleteEdit = new RiskDeleteEdit(task, risk, n2, "05/10/2009 12:34:00");
                    task.removeRiskAt(n2);
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, riskDeleteEdit);
                    JProjectRisksTable.this.fireUndoableEditHappened(undoableEditEvent);
                }
            }
        });
        KeyStroke keyStroke = KeyStroke.getKeyStroke(127, 0);
        this.getInputMap(1).put(keyStroke, "delete");
        if (SystemUtilities.isOSMac()) {
            this.setSurrendersFocusOnKeystroke(false);
        } else {
            this.setSurrendersFocusOnKeystroke(true);
        }
    }

    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        Component component = super.prepareEditor(tableCellEditor, n, n2);
        if (component instanceof JTextComponent) {
            ((JTextField)component).selectAll();
        }
        return component;
    }

    public Task getProject() {
        return this.project;
    }

    public void setProject(Task task) {
        this.project = task;
        this.removeUndoableEditListener(this.undoHandler);
        ((ProjectRisksTableModel)this.getModel()).removeUndoableEditListener(this.undoHandler);
        this.undoHandler = new UndoHandler(task.getCompany().getUndoManager());
        ProjectRisksTableModel projectRisksTableModel = new ProjectRisksTableModel(task);
        this.addUndoableEditListener(this.undoHandler);
        projectRisksTableModel.addUndoableEditListener(this.undoHandler);
        this.setModel(projectRisksTableModel);
        this.setHeaderWidths();
    }

    protected void setHeaderWidths() {
        this.getColumn(ProjectRisksTableModel.STATUS).setMaxWidth(70);
        this.getColumn(ProjectRisksTableModel.IMPACT).setMaxWidth(70);
        this.getColumn(ProjectRisksTableModel.PROBABILITY).setMaxWidth(70);
        this.getColumn(ProjectRisksTableModel.DESCRIPTION).setPreferredWidth(700);
    }

    private void setRenderersAndEditors() {
        Risk.Level[] levelArray = new Risk.Level[]{Risk.LOW, Risk.MEDIUM, Risk.HIGH};
        Risk.Status[] statusArray = new Risk.Status[]{Risk.OPENED, Risk.CLOSED};
        JComboBox<Serializable> jComboBox = new JComboBox<Risk.Status>(statusArray);
        this.getColumn(ProjectRisksTableModel.STATUS).setCellEditor(new DefaultCellEditor(jComboBox));
        jComboBox = new JComboBox<Risk.Level>(levelArray);
        this.getColumn(ProjectRisksTableModel.IMPACT).setCellEditor(new DefaultCellEditor(jComboBox));
        this.getColumn(ProjectRisksTableModel.PROBABILITY).setCellEditor(new DefaultCellEditor(jComboBox));
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    private void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(UndoableEditListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((UndoableEditListener)eventListenerArray[i]).undoableEditHappened(undoableEditEvent);
        }
    }

    public JProjectView getProjectView() {
        return this.projectView;
    }

    public void setProjectView(JProjectView jProjectView) {
        this.projectView = jProjectView;
    }

    public void setAutoResizeMode(int n) {
        super.setAutoResizeMode(0);
    }

    private void computeValues() {
        PageFormat pageFormat = this.getPageFormat(0);
        this.pageHeight = pageFormat.getImageableHeight() * 1.3 / PrintManager.ZOOM - 2.0 - 20.0;
        this.pageWidth = pageFormat.getImageableWidth() * 1.3 / PrintManager.ZOOM - 2.0 - 2.0;
        this.tableWidth = (double)this.getColumnModel().getTotalColumnWidth() + (double)((JProjectViewRisks)this.projectView).getRowHeader().getWidth();
        this.headerHeightOnPage = this.getTableHeader().getHeight();
        double d = this.getRowHeight();
        if (PrintManager.isShowHeader()) {
            int n = (int)((this.pageHeight - this.headerHeightOnPage) / d);
            this.totalVerticalNumPages = (int)Math.ceil(((double)this.getRowCount() - 1.0) / (double)n);
        } else {
            int n = (int)(this.pageHeight / d);
            int n2 = (int)((this.pageHeight - this.headerHeightOnPage) / d);
            this.totalVerticalNumPages = (int)Math.ceil(((double)this.getRowCount() - 1.0 - (double)n2) / (double)n) + 1;
        }
        this.totalHorizontalNumPages = (int)Math.ceil(this.tableWidth / this.pageWidth);
    }

    public int getNumberOfPages() {
        this.computeValues();
        return this.totalHorizontalNumPages * this.totalVerticalNumPages;
    }

    public Dimension getPrintSize() {
        Dimension dimension = new Dimension();
        dimension.setSize(((JProjectViewRisks)this.projectView).getRowHeader().getWidth() + this.getWidth(), this.getHeight() - 1 * this.getRowHeight());
        return dimension;
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        return Common.getApplication().getPageFormat();
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        return this;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.computeValues();
        this.clearSelection();
        this.getTableHeader().setBackground(Color.WHITE);
        ((JProjectViewRisks)this.projectView).getRowHeader().setBackground(Color.WHITE);
        this.setBackground(Color.WHITE);
        graphics2D.scale(1.0 / (1.3 / PrintManager.ZOOM), 1.0 / (1.3 / PrintManager.ZOOM));
        graphics2D.setColor(Color.BLACK);
        int n3 = graphics2D.getFontMetrics().getDescent();
        double d = this.getRowHeight();
        int n4 = (int)((this.pageHeight - this.headerHeightOnPage) / d);
        int n5 = (int)(this.pageHeight / d);
        double d2 = d * (double)n4;
        double d3 = d * (double)n5;
        int n6 = this.totalHorizontalNumPages;
        int n7 = this.totalHorizontalNumPages * this.totalVerticalNumPages;
        if (n >= n7) {
            return 1;
        }
        graphics2D.translate(pageFormat.getImageableX() * 1.3 / PrintManager.ZOOM, pageFormat.getImageableY() * 1.3 / PrintManager.ZOOM);
        graphics2D.drawLine(0, 1, 2 + (int)this.pageWidth + 2, 1);
        graphics2D.drawLine(0, (int)(2.0 + this.pageHeight), 2 + (int)this.pageWidth + 1, (int)(2.0 + this.pageHeight));
        graphics2D.drawLine(0, (int)(2.0 + this.pageHeight + 20.0), 2 + (int)this.pageWidth + 2, (int)(2.0 + this.pageHeight + 20.0));
        graphics2D.drawLine(0, 2, 0, (int)(2.0 + this.pageHeight + 20.0));
        graphics2D.drawLine(2 + (int)this.pageWidth + 2, 2, 2 + (int)this.pageWidth + 2, (int)(2.0 + this.pageHeight + 20.0));
        String string = Common.I18N_RP.getString("project") + ": " + this.project.getName() + "     " + Common.I18N_RP.getString("manager") + ": " + this.project.getManager();
        graphics2D.drawString(string, 2, (int)(2.0 + this.pageHeight + 20.0 - (double)n3));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd, yyyy");
        string = Common.I18N_RP.getString("page") + ": " + (n + 1) + "/" + this.getNumberOfPages() + "     " + Common.I18N_RP.getString("date") + ": " + simpleDateFormat.format(new Date());
        int n8 = graphics2D.getFontMetrics().stringWidth(string);
        graphics2D.drawString(string, (int)(2.0 + this.pageWidth - (double)n8), (int)(2.0 + this.pageHeight + 20.0 - (double)n3));
        graphics2D.translate(2, 2);
        int n9 = n / this.totalHorizontalNumPages;
        int n10 = n % this.totalHorizontalNumPages;
        JRowHeader jRowHeader = ((JProjectViewRisks)this.projectView).getRowHeader();
        int n11 = n10 < n6 - 1 ? (n10 == 0 ? (int)Math.ceil(this.pageWidth) - ((JProjectViewRisks)this.projectView).getRowHeader().getWidth() : (int)Math.ceil(this.pageWidth)) : (int)Math.ceil(this.tableWidth - (double)n10 * this.pageWidth);
        if (n9 + 1 == this.totalVerticalNumPages) {
            if (!PrintManager.isShowHeader()) {
                int n12 = n9 == 0 ? 0 : n4 + n5 * (n9 - 1);
                int n13 = this.getRowCount() - 1 - n12;
                n2 = (int)Math.ceil(d * (double)n13);
            } else {
                int n14 = n4 * n9;
                int n15 = this.getRowCount() - 1 - n14;
                n2 = (int)Math.ceil(d * (double)n15);
            }
        } else {
            n2 = !PrintManager.isShowHeader() ? (n9 == 0 ? (int)Math.ceil(d2) : (int)Math.ceil(d3)) : (int)Math.ceil(d2);
        }
        if (n9 == 0 || n9 != 0 && PrintManager.isShowHeader()) {
            graphics2D.translate((double)(-n10) * this.pageWidth + (double)jRowHeader.getWidth(), 0.0);
            if (n10 == 0) {
                graphics2D.setClip((int)((double)n10 * this.pageWidth), 0, n11, (int)Math.ceil(this.headerHeightOnPage));
            } else {
                graphics2D.setClip((int)((double)n10 * this.pageWidth) - jRowHeader.getWidth(), 0, n11, (int)Math.ceil(this.headerHeightOnPage));
            }
            PrintManager.bufferAndPaint(graphics2D, this.getTableHeader());
            graphics2D.translate((double)n10 * this.pageWidth - (double)jRowHeader.getWidth(), this.headerHeightOnPage);
        }
        if (n10 == 0) {
            if (PrintManager.isShowHeader()) {
                graphics2D.translate((double)(-n10) * this.pageWidth, (double)(-((int)(d2 * (double)n9))));
            } else if (n9 == 0) {
                graphics2D.translate((double)(-n10) * this.pageWidth, 0.0);
            } else {
                graphics2D.translate((double)(-n10) * this.pageWidth, (double)(-((int)(d2 + d3 * (double)(n9 - 1)))));
            }
            if (PrintManager.isShowHeader()) {
                graphics2D.setClip((int)((double)n10 * this.pageWidth), (int)(d2 * (double)n9), jRowHeader.getWidth(), n2);
            } else if (n9 == 0) {
                graphics2D.setClip((int)((double)n10 * this.pageWidth), 0, jRowHeader.getWidth(), n2);
            } else {
                graphics2D.setClip((int)((double)n10 * this.pageWidth), (int)(d2 + d3 * (double)(n9 - 1)), jRowHeader.getWidth(), n2);
            }
            PrintManager.bufferAndPaint(graphics2D, jRowHeader);
            if (PrintManager.isShowHeader()) {
                graphics2D.translate((double)n10 * this.pageWidth, (double)((int)(d2 * (double)n9)));
            } else if (n9 == 0) {
                graphics2D.translate((double)n10 * this.pageWidth, 0.0);
            } else {
                graphics2D.translate((double)n10 * this.pageWidth, (double)((int)(d2 + d3 * (double)(n9 - 1))));
            }
        }
        if (PrintManager.isShowHeader()) {
            graphics2D.translate((double)(-n10) * this.pageWidth + (double)jRowHeader.getWidth(), (double)(-((int)(d2 * (double)n9))));
        } else if (n9 == 0) {
            graphics2D.translate((double)(-n10) * this.pageWidth + (double)jRowHeader.getWidth(), 0.0);
        } else {
            graphics2D.translate((double)(-n10) * this.pageWidth + (double)jRowHeader.getWidth(), (double)(-((int)(d2 + d3 * (double)(n9 - 1)))));
        }
        if (PrintManager.isShowHeader()) {
            if (n10 == 0) {
                graphics2D.setClip((int)((double)n10 * this.pageWidth), (int)(d2 * (double)n9), n11, n2);
            } else {
                graphics2D.setClip((int)((double)n10 * this.pageWidth) - jRowHeader.getWidth(), (int)(d2 * (double)n9), n11, n2);
            }
        } else if (n10 == 0) {
            if (n9 == 0) {
                graphics2D.setClip((int)((double)n10 * this.pageWidth), 0, n11, n2);
            } else {
                graphics2D.setClip((int)((double)n10 * this.pageWidth), (int)(d2 + d3 * (double)(n9 - 1)), n11, n2);
            }
        } else if (n9 == 0) {
            graphics2D.setClip((int)((double)n10 * this.pageWidth) - jRowHeader.getWidth(), 0, n11, n2);
        } else {
            graphics2D.setClip((int)((double)n10 * this.pageWidth) - jRowHeader.getWidth(), (int)(d2 + d3 * (double)(n9 - 1)), n11, n2);
        }
        PrintManager.bufferAndPaint(graphics2D, (Component)((Object)this));
        if (PrintManager.isShowHeader()) {
            graphics2D.translate((double)n10 * this.pageWidth - (double)jRowHeader.getWidth(), (double)((int)(d2 * (double)n9)));
        } else if (n9 == 0) {
            graphics2D.translate((double)n10 * this.pageWidth - (double)jRowHeader.getWidth(), (double)((int)(d2 * (double)n9)));
        } else {
            graphics2D.translate((double)n10 * this.pageWidth - (double)jRowHeader.getWidth(), (double)((int)(d2 + d3 * (double)(n9 - 1))));
        }
        if (n9 == 0 || n9 != 0 && PrintManager.isShowHeader()) {
            graphics2D.translate(0.0, -this.headerHeightOnPage);
        }
        graphics2D.translate(-2, -2);
        graphics2D.translate(-pageFormat.getImageableX() * 1.3 / PrintManager.ZOOM, -pageFormat.getImageableY() * 1.3 / PrintManager.ZOOM);
        this.getTableHeader().setBackground((Color)UIManager.get("TableHeader.background"));
        this.setBackground((Color)UIManager.get("Table.background"));
        jRowHeader.setBackground((Color)UIManager.get("TableHeader.background"));
        return 0;
    }

    public int getHorizontalNumberOfPages() {
        this.computeValues();
        return this.totalHorizontalNumPages;
    }

    public int getVerticalNumberOfPages() {
        this.computeValues();
        return this.totalVerticalNumPages;
    }
}

