/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Link;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.ui.action.ActionMapper;
import com.sbs.jpm.ui.component.model.ProjectLinksTableModel;
import com.sbs.jpm.undo.LinkDeleteEdit;
import com.sbs.jpm.undo.UndoHandler;
import com.sbs.util.SystemUtilities;
import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

public class JProjectLinksTable
extends JTable {
    private UndoHandler undoHandler;
    private Task project;
    private EventListenerList listeners = new EventListenerList();

    public JProjectLinksTable() {
        super(new ProjectLinksTableModel());
        if (SystemUtilities.isOSMac()) {
            this.putClientProperty("Quaqua.Table.style", "striped");
            this.setShowHorizontalLines(false);
            this.setShowVerticalLines(true);
        }
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        ActionMapper actionMapper = ActionMapper.getInstance();
        actionMapper.mapActions(this);
        ActionMap actionMap = this.getActionMap();
        actionMap.put("delete", new AbstractAction("delete link"){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectLinksTableModel projectLinksTableModel;
                Task task;
                int n;
                if (JProjectLinksTable.this.getSelectedRowCount() == 1 && (n = JProjectLinksTable.this.getSelectedRow()) < (task = (projectLinksTableModel = (ProjectLinksTableModel)JProjectLinksTable.this.getModel()).getProject()).getLinksNumber()) {
                    Link link = task.getLinkAt(n);
                    LinkDeleteEdit linkDeleteEdit = new LinkDeleteEdit(task, link, n, "05/10/2009 16:37:00");
                    task.removeLinkAt(n);
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, linkDeleteEdit);
                    JProjectLinksTable.this.fireUndoableEditHappened(undoableEditEvent);
                }
            }
        });
        KeyStroke keyStroke = KeyStroke.getKeyStroke(127, 0);
        this.getInputMap(1).put(keyStroke, "delete");
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = JProjectLinksTable.this.columnAtPoint(mouseEvent.getPoint());
                final int n2 = JProjectLinksTable.this.rowAtPoint(mouseEvent.getPoint());
                if (n2 != -1 && n == JProjectLinksTable.this.getColumnModel().getColumnIndex(ProjectLinksTableModel.LINK) && n2 < JProjectLinksTable.this.project.getLinksNumber()) {
                    Thread thread = new Thread(){

                        public void run() {
                            try {
                                BrowserLauncher browserLauncher = new BrowserLauncher();
                                browserLauncher.openURLinBrowser(JProjectLinksTable.this.project.getLinkAt(n2).getName());
                            }
                            catch (Exception exception) {
                                Common.logException("Error:", exception);
                            }
                        }
                    };
                    thread.start();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                int n = JProjectLinksTable.this.columnAtPoint(mouseEvent.getPoint());
                if (n == JProjectLinksTable.this.getColumnModel().getColumnIndex(ProjectLinksTableModel.LINK)) {
                    JProjectLinksTable.this.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    JProjectLinksTable.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        if (SystemUtilities.isOSMac()) {
            this.setSurrendersFocusOnKeystroke(false);
        } else {
            this.setSurrendersFocusOnKeystroke(true);
        }
        this.setAutoCreateColumnsFromModel(false);
        this.setHeaderWidths();
        this.setRenderersAndEditors();
    }

    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        Component component = super.prepareEditor(tableCellEditor, n, n2);
        if (component instanceof JTextComponent) {
            ((JTextField)component).selectAll();
        }
        return component;
    }

    private void setHeaderWidths() {
    }

    private void setRenderersAndEditors() {
        this.getColumn(ProjectLinksTableModel.LINK).setCellRenderer(new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (object != null) {
                    return super.getTableCellRendererComponent(jTable, "<html><u style=\"color:#0000FF\">" + object + "</u></html>", bl, bl2, n, n2);
                }
                return super.getTableCellRendererComponent(jTable, "", bl, bl2, n, n2);
            }
        });
    }

    public void setProject(Task task) {
        this.project = task;
        this.removeUndoableEditListener(this.undoHandler);
        ((ProjectLinksTableModel)this.getModel()).removeUndoableEditListener(this.undoHandler);
        this.undoHandler = new UndoHandler(task.getCompany().getUndoManager());
        ProjectLinksTableModel projectLinksTableModel = new ProjectLinksTableModel(task);
        this.addUndoableEditListener(this.undoHandler);
        projectLinksTableModel.addUndoableEditListener(this.undoHandler);
        this.setModel(projectLinksTableModel);
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    private void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(UndoableEditListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((UndoableEditListener)eventListenerArray[i]).undoableEditHappened(undoableEditEvent);
        }
    }
}

