/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.calendar.DayWorkingPattern;
import com.sbs.jpm.configuration.Configuration;
import com.sbs.jpm.configuration.ConfigurationSetting;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.CurrencyManager;
import com.sbs.jpm.core.DurationManager;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.i18n.I18nManager;
import com.sbs.jpm.mail.EmailManager;
import com.sbs.jpm.ui.UIManager;
import com.sbs.jpm.ui.ViewerManager;
import com.sbs.jpm.ui.component.JAbstractPeriodTable;
import com.sbs.jpm.ui.component.JAreaView;
import com.sbs.jpm.ui.component.JPeriodTable;
import com.sbs.jpm.ui.component.model.AbstractPeriodTableModel;
import com.sbs.jpm.ui.component.model.PeriodTableModel;
import com.sbs.jpm.ui.component.util.ProjectSlackFormat;
import com.sbs.jpm.ui.component.view.JProjectViewGantt;
import com.sbs.jpm.ui.treetablechart.JArea;
import com.sbs.jpm.ui.treetablechart.chart.ChartUIConfiguration;
import com.sbs.util.ColorChooserNoHSB;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.InternationalFormatter;

public class JOptionsDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    public static final int SCHEDULE = 0;
    public static final int VIEW = 1;
    public static final int COLORS = 2;
    public static final int EMAIL = 3;
    public static final int STARTUP = 4;
    private JComboBox dateFormatCombo;
    private JLabel dateSampleLabel;
    private JSpinner hoursPerDaySpinner;
    private JSpinner hoursPerWeekSpinner;
    private JFormattedTextField slackField;
    private JComboBox durationCombo;
    private JTextField currencyTextField;
    private JAbstractPeriodTable programTable;
    private JCheckBox useTaskCalendar;
    private JCheckBox projectStartLine;
    private JCheckBox projectEstimatedStartLine;
    private JCheckBox currentDateLine;
    private JCheckBox projectFinishLine;
    private JCheckBox focusPoint;
    private JCheckBox showSelection;
    private JCheckBox showHorizontalGrid;
    private JCheckBox showVerticalGrid;
    private JCheckBox showNonWorking;
    private JCheckBox showTaskId;
    private JCheckBox showTaskName;
    private JCheckBox showAssignmentCode;
    private JCheckBox showProjectCode;
    private JCheckBox showTaskDuration;
    private JCheckBox showTaskWork;
    private JCheckBox showTaskCompletion;
    private JCheckBox showTaskStart;
    private JCheckBox showTaskEnd;
    private JCheckBox showAssignmentName;
    private JCheckBox showProjectRoot;
    private JCheckBox showTaskOutline;
    private JCheckBox showRateInViewer;
    private JCheckBox welcome;
    private JCheckBox update;
    private JCheckBox networkLocking;
    private JComboBox languagesCombo;
    private JTextField emailFromField;
    private JTextField emailHostField;
    private JTextArea emailTextField;
    private JTextField emailPortField;
    private JPasswordField emailPasswordField;
    private JCheckBox authentication;
    private JCheckBox ssl;
    private JTextField emailUsernameField;
    private JLabel emailUsernameLabel;
    private JLabel emailPasswordLabel;
    private JCheckBox attachICalendar;
    private JLabel iCalendarModeLabel;
    JPanel icalendarPanel;
    private JRadioButton eventRadioButton;
    private JRadioButton todoRadioButton;
    private ProjectSlackFormat durationFormat;
    private Company company;
    private BarCustomizePanel barCustomizePanel;
    private JTabbedPane tabbsPanel;

    public JOptionsDialog(JFrame jFrame, Company company) {
        super(jFrame, Common.I18N_ACTIONS.getString("settings.options"), true);
        this.company = company;
        this.getContentPane().add(this.createContent());
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(jFrame);
    }

    public void update() {
        this.dateFormatCombo.setSelectedItem(UIManager.getInstance().getDateFormat());
        Double d = new Double((double)this.company.getCurrentTask().getDurationManager().getDuration(DurationManager.DAY) / 3600000.0);
        Double d2 = new Double((double)this.company.getCurrentTask().getDurationManager().getDuration(DurationManager.WEEK) / 3600000.0);
        this.hoursPerDaySpinner.setValue(d);
        this.hoursPerWeekSpinner.setValue(d2);
        this.slackField.setValue(this.company.getCurrentTask().getCriticalSlackLimit());
        this.durationCombo.setSelectedItem(this.company.getCurrentTask().getDurationManager().getDefaultUnit());
        this.currencyTextField.setText(this.company.getRootTask().getCurrencyUnit());
        LinkedList<DayWorkingPattern> linkedList = new LinkedList<DayWorkingPattern>();
        linkedList.add((DayWorkingPattern)this.company.getCurrentTask().getCustomPattern().clone());
        this.programTable.setModel(new PeriodTableModel(linkedList));
        this.useTaskCalendar.setSelected(this.company.getCurrentTask().isForcedWorking());
        UIManager uIManager = UIManager.getInstance();
        this.projectStartLine.setSelected(uIManager.isShowProjectStart());
        this.projectEstimatedStartLine.setSelected(uIManager.isShowProjectEstimatedStart());
        this.projectFinishLine.setSelected(uIManager.isShowProjectFinish());
        this.currentDateLine.setSelected(uIManager.isShowCurrentDate());
        this.focusPoint.setSelected(uIManager.isShowFocusPoint());
        this.showSelection.setSelected(uIManager.isShowSelection());
        this.showHorizontalGrid.setSelected(uIManager.isShowHorizontalGrid());
        this.showVerticalGrid.setSelected(uIManager.isShowVerticalGrid());
        this.showNonWorking.setSelected(uIManager.isShowNonWorking());
        this.showTaskId.setSelected(uIManager.isShowTaskId());
        this.showTaskName.setSelected(uIManager.isShowTaskName());
        this.showProjectCode.setSelected(uIManager.isShowProjectCode());
        this.showTaskDuration.setSelected(uIManager.isShowTaskDuration());
        this.showTaskWork.setSelected(uIManager.isShowTaskWork());
        this.showTaskCompletion.setSelected(uIManager.isShowTaskCompletion());
        this.showTaskStart.setSelected(uIManager.isShowTaskStart());
        this.showTaskEnd.setSelected(uIManager.isShowTaskEnd());
        this.showAssignmentName.setSelected(uIManager.isShowAssignmentsName());
        this.showAssignmentCode.setSelected(uIManager.isShowAssignmentsCode());
        this.showProjectRoot.setSelected(uIManager.isShowProjectRoot());
        this.showTaskOutline.setSelected(uIManager.isShowTaskOutline());
        this.showRateInViewer.setSelected(ViewerManager.getInstance().isShowRate());
        this.welcome.setSelected(Boolean.parseBoolean(Configuration.getInstance().getValue(ConfigurationSetting.STARTUP_WELCOME).toString()));
        this.update.setSelected(Boolean.parseBoolean(Configuration.getInstance().getValue(ConfigurationSetting.STARTUP_UPDATE).toString()));
        this.networkLocking.setSelected(Boolean.parseBoolean(Configuration.getInstance().getValue(ConfigurationSetting.NETWORK_LOCKING).toString()));
        Locale locale = (Locale)Configuration.getInstance().getValue(ConfigurationSetting.LOCALE);
        this.languagesCombo.setSelectedItem(locale == null ? Locale.getDefault() : locale);
        EmailManager emailManager = EmailManager.getInstance();
        emailManager.loadSettings();
        this.refreshEmailSettings();
    }

    private String[] createDateFormats() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(UIManager.getInstance().getDateFormat());
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
        linkedList.add(((SimpleDateFormat)dateFormat).toPattern());
        dateFormat = DateFormat.getDateTimeInstance(2, 2);
        linkedList.add(((SimpleDateFormat)dateFormat).toPattern());
        dateFormat = DateFormat.getDateTimeInstance(1, 1);
        linkedList.add(((SimpleDateFormat)dateFormat).toPattern());
        dateFormat = DateFormat.getDateTimeInstance(0, 0);
        linkedList.add(((SimpleDateFormat)dateFormat).toPattern());
        return linkedList.toArray(new String[0]);
    }

    private JPanel createSchedulePane() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(4, 4, 4, 4);
        this.dateSampleLabel = new JLabel("(" + new SimpleDateFormat(UIManager.getInstance().getDateFormat()).format(new Date()) + ")");
        this.dateSampleLabel.setForeground(Color.GRAY);
        this.dateFormatCombo = new JComboBox<String>(this.createDateFormats());
        this.dateFormatCombo.setEditable(true);
        this.dateFormatCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JOptionsDialog.this.dateSampleLabel.setText("(" + new SimpleDateFormat(itemEvent.getItem().toString()).format(new Date()) + ")");
            }
        });
        this.dateFormatCombo.setSelectedItem(UIManager.getInstance().getDateFormat());
        Double d = new Double((double)this.company.getCurrentTask().getDurationManager().getDuration(DurationManager.DAY) / 3600000.0);
        Double d2 = new Double((double)this.company.getCurrentTask().getDurationManager().getDuration(DurationManager.WEEK) / 3600000.0);
        Double d3 = new Double(0.1);
        Double d4 = new Double(1.0);
        this.hoursPerDaySpinner = new JSpinner(new SpinnerNumberModel(d, d3, new Double(24.0), d4));
        this.hoursPerWeekSpinner = new JSpinner(new SpinnerNumberModel(d2, d3, new Double(168.0), d4));
        this.slackField = new JFormattedTextField();
        this.slackField.setColumns(3);
        this.slackField.setHorizontalAlignment(4);
        this.durationFormat = new ProjectSlackFormat();
        this.durationFormat.setProject(this.company.getCurrentTask());
        this.slackField.setFormatterFactory(new DefaultFormatterFactory(new InternationalFormatter(this.durationFormat)));
        this.slackField.setValue(this.company.getCurrentTask().getCriticalSlackLimit());
        this.durationCombo = new JComboBox<String>(this.company.getCurrentTask().getDurationManager().getUnits());
        this.durationCombo.setSelectedItem(this.company.getCurrentTask().getDurationManager().getDefaultUnit());
        this.currencyTextField = new JTextField(this.company.getRootTask().getCurrencyUnit(), 3);
        this.programTable = new JPeriodTable();
        LinkedList<DayWorkingPattern> linkedList = new LinkedList<DayWorkingPattern>();
        linkedList.add(CalendarManager.createCustomDayWorkingPattern());
        this.programTable.setModel(new PeriodTableModel(linkedList));
        this.useTaskCalendar = new JCheckBox(Common.I18N_RP.getString("forceResourcesAsDefault"));
        this.useTaskCalendar.setSelected(this.company.getCurrentTask().isForcedWorking());
        jPanel.add((Component)new JLabel(Common.I18N_RP.getString("dateFormat") + ":"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.dateFormatCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(4, 4, 0, 4), 0, 0));
        jPanel.add((Component)this.dateSampleLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 4, 4, 4), 0, 0));
        jPanel.add((Component)new JLabel(Common.I18N_RP.getString("hoursPerDay") + ":"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.hoursPerDaySpinner, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)new JLabel(Common.I18N_RP.getString("hoursPerWeek") + ":"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.hoursPerWeekSpinner, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)new JLabel(Common.I18N_RP.getString("slackForCriticalTasks") + ":"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.slackField, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)new JLabel(Common.I18N_RP.getString("durationUnits") + ":"), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.durationCombo, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)new JLabel(Common.I18N_RP.getString("currencyUnits") + ":"), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.currencyTextField, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.useTaskCalendar, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        Dimension dimension = new Dimension(2, 2);
        jPanel2.setMinimumSize(dimension);
        jPanel2.setMaximumSize(dimension);
        jPanel2.setPreferredSize(dimension);
        jPanel.add((Component)jPanel2, new GridBagConstraints(2, 0, 1, 8, 0.0, 0.0, 21, 3, insets, 0, 0));
        jPanel.add((Component)new JLabel(Common.I18N_RP.getString("defineCustomProgram") + ":"), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.programTable));
        jScrollPane.setMinimumSize(new Dimension(100, 110));
        jScrollPane.setPreferredSize(new Dimension(100, 110));
        jPanel.add((Component)jScrollPane, new GridBagConstraints(3, 1, 1, 7, 0.0, 0.0, 21, 1, insets, 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        JButton jButton = new JButton(Common.I18N_RP.getString("restoreDefaults"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionsDialog.this.dateFormatCombo.setSelectedIndex(0);
                JOptionsDialog.this.durationCombo.setSelectedItem(JOptionsDialog.this.company.getCurrentTask().getDurationManager().getDefaultUnit());
                JOptionsDialog.this.currencyTextField.setText(CurrencyManager.getDefaultCurrency());
                Double d = new Double((double)JOptionsDialog.this.company.getCurrentTask().getDurationManager().getDuration(DurationManager.DAY) / 3600000.0);
                Double d2 = new Double((double)JOptionsDialog.this.company.getCurrentTask().getDurationManager().getDuration(DurationManager.WEEK) / 3600000.0);
                JOptionsDialog.this.hoursPerDaySpinner.setValue(d);
                JOptionsDialog.this.hoursPerWeekSpinner.setValue(d2);
                LinkedList<DayWorkingPattern> linkedList = new LinkedList<DayWorkingPattern>();
                linkedList.add(CalendarManager.createCustomDayWorkingPattern());
                JOptionsDialog.this.programTable.setModel(new PeriodTableModel(linkedList));
                JOptionsDialog.this.useTaskCalendar.setSelected(false);
                JOptionsDialog.this.slackField.setValue(JOptionsDialog.this.company.getCurrentTask().getCriticalSlackLimit());
            }
        });
        JButton jButton2 = new JButton(Common.I18N_RP.getString("cancel"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionsDialog.this.setVisible(false);
            }
        });
        JButton jButton3 = new JButton(Common.I18N_RP.getString("ok"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    new SimpleDateFormat(JOptionsDialog.this.dateFormatCombo.getSelectedItem().toString());
                }
                catch (Exception exception) {
                    Common.logException("Error:", exception);
                    JOptionPane.showMessageDialog(JOptionsDialog.this, Common.I18N_MESSAGES.getString("invalidDateFormat.message"), Common.I18N_MESSAGES.getString("invalidDateFormat.title"), 0);
                    return;
                }
                UIManager.getInstance().setDateFormat(JOptionsDialog.this.dateFormatCombo.getSelectedItem().toString());
                JOptionsDialog.this.company.getCurrentTask().getDurationManager().setDefaultUnit((String)JOptionsDialog.this.durationCombo.getSelectedItem());
                JOptionsDialog.this.company.getCurrentTask().getDurationManager().setDuration(DurationManager.DAY, (long)((Double)JOptionsDialog.this.hoursPerDaySpinner.getValue() * 3600000.0));
                JOptionsDialog.this.company.getCurrentTask().getDurationManager().setDuration(DurationManager.WEEK, (long)((Double)JOptionsDialog.this.hoursPerWeekSpinner.getValue() * 3600000.0));
                JOptionsDialog.this.company.getRootTask().setCurrencyUnit(JOptionsDialog.this.currencyTextField.getText());
                JOptionsDialog.this.company.getCurrentTask().setCustomPattern((DayWorkingPattern)((AbstractPeriodTableModel)JOptionsDialog.this.programTable.getModel()).getDayPatterns().get(0));
                JOptionsDialog.this.company.getCurrentTask().setForcedWorking(JOptionsDialog.this.useTaskCalendar.isSelected());
                JOptionsDialog.this.company.getCurrentTask().setCriticalSlackLimit((Long)JOptionsDialog.this.slackField.getValue());
                TaskPlanner.rescheduleTree(JOptionsDialog.this.company.getCurrentTask());
                JOptionsDialog.this.setVisible(false);
                Common.getApplication().getWorkspace().getJProject().repaint();
            }
        });
        jPanel3.add((Component)jButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, insets, 0, 0));
        jPanel3.add((Component)jButton3, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 22, 0, insets, 0, 0));
        jPanel3.add((Component)jButton2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 22, 0, insets, 0, 0));
        jPanel.add((Component)jPanel3, new GridBagConstraints(0, 8, 4, 1, 1.0, 1.0, 15, 0, insets, 0, 0));
        return jPanel;
    }

    private void refreshEmailSettings() {
        EmailManager emailManager = EmailManager.getInstance();
        this.emailFromField.setText(emailManager.getMailFrom());
        this.emailHostField.setText(emailManager.getMailServer());
        this.emailTextField.setText(emailManager.getDefaultText());
        this.emailPortField.setText(emailManager.getMailPort());
        this.emailUsernameField.setText(emailManager.getMailUsername());
        this.emailPasswordField.setText(emailManager.getMailPassword());
    }

    private JPanel createEmailPane() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(4, 4, 4, 4);
        EmailManager emailManager = EmailManager.getInstance();
        emailManager.loadSettings();
        this.emailFromField = new JTextField(emailManager.getMailFrom());
        this.emailHostField = new JTextField(emailManager.getMailServer());
        this.emailTextField = new JTextArea(7, 30);
        this.emailTextField.setText(emailManager.getDefaultText());
        this.emailTextField.setLineWrap(true);
        this.emailTextField.setWrapStyleWord(true);
        this.emailPortField = new JTextField(emailManager.getMailPort());
        this.emailUsernameField = new JTextField(emailManager.getMailUsername());
        this.emailPasswordField = new JPasswordField(emailManager.getMailPassword());
        this.emailUsernameField.setEnabled(emailManager.isMailAuthentication());
        this.emailPasswordField.setEnabled(emailManager.isMailAuthentication());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(Common.I18N_RP.getString("authenticationInformation")));
        this.authentication = new JCheckBox(Common.I18N_RP.getString("emailRequiresAuthentication"));
        this.authentication.setSelected(emailManager.isMailAuthentication());
        this.authentication.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    JOptionsDialog.this.emailUsernameField.setEnabled(true);
                    JOptionsDialog.this.emailPasswordField.setEnabled(true);
                    JOptionsDialog.this.emailUsernameLabel.setEnabled(true);
                    JOptionsDialog.this.emailPasswordLabel.setEnabled(true);
                } else {
                    JOptionsDialog.this.emailUsernameField.setEnabled(false);
                    JOptionsDialog.this.emailPasswordField.setEnabled(false);
                    JOptionsDialog.this.emailUsernameLabel.setEnabled(false);
                    JOptionsDialog.this.emailPasswordLabel.setEnabled(false);
                }
            }
        });
        this.ssl = new JCheckBox(Common.I18N_RP.getString("useSSL"));
        this.ssl.setEnabled(emailManager.isMailAuthentication());
        this.ssl.setSelected(emailManager.isMailSSL());
        jPanel2.add((Component)this.authentication, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        this.emailUsernameLabel = new JLabel(Common.I18N_RP.getString("username") + ":");
        this.emailUsernameLabel.setEnabled(emailManager.isMailAuthentication());
        jPanel2.add((Component)this.emailUsernameLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel2.add((Component)this.emailUsernameField, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        this.emailPasswordLabel = new JLabel(Common.I18N_RP.getString("password") + ":");
        this.emailPasswordLabel.setEnabled(emailManager.isMailAuthentication());
        jPanel2.add((Component)this.emailPasswordLabel, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel2.add((Component)this.emailPasswordField, new GridBagConstraints(3, 4, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        this.ssl = new JCheckBox(Common.I18N_RP.getString("useSSL"));
        this.ssl.setSelected(emailManager.isMailSSL());
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(new TitledBorder(Common.I18N_RP.getString("emailServerSettings")));
        jPanel3.add((Component)new JLabel(Common.I18N_RP.getString("server") + ":"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel3.add((Component)this.emailHostField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        jPanel3.add((Component)new JLabel(Common.I18N_RP.getString("port") + ":"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel3.add((Component)this.emailPortField, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        jPanel3.add((Component)this.ssl, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        jPanel3.add((Component)jPanel2, new GridBagConstraints(0, 3, 5, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBorder(new TitledBorder(Common.I18N_RP.getString("emailTemplate")));
        jPanel4.add((Component)new JLabel(Common.I18N_RP.getString("emailFrom") + ":"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 15));
        jPanel4.add((Component)this.emailFromField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        jPanel4.add((Component)new JLabel(Common.I18N_RP.getString("templateToBeUsed") + ":"), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel4.add((Component)new JScrollPane(this.emailTextField), new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 21, 1, insets, 0, 0));
        this.attachICalendar = new JCheckBox(Common.I18N_RP.getString("alsoAttachAssignments"));
        this.attachICalendar.setSelected(emailManager.needsICalendarAttached());
        this.attachICalendar.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    JOptionsDialog.this.eventRadioButton.setEnabled(true);
                    JOptionsDialog.this.todoRadioButton.setEnabled(true);
                    JOptionsDialog.this.iCalendarModeLabel.setEnabled(true);
                    JOptionsDialog.this.icalendarPanel.setEnabled(true);
                    JOptionsDialog.this.icalendarPanel.setVisible(true);
                } else {
                    JOptionsDialog.this.eventRadioButton.setEnabled(false);
                    JOptionsDialog.this.todoRadioButton.setEnabled(false);
                    JOptionsDialog.this.iCalendarModeLabel.setEnabled(false);
                    JOptionsDialog.this.icalendarPanel.setEnabled(false);
                    JOptionsDialog.this.icalendarPanel.setVisible(false);
                }
            }
        });
        jPanel4.add((Component)this.attachICalendar, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 21, 1, insets, 0, 0));
        this.icalendarPanel = new JPanel(new GridBagLayout());
        this.icalendarPanel.setBorder(new TitledBorder(Common.I18N_RP.getString("iCalendarSettings")));
        this.eventRadioButton = new JRadioButton(Common.I18N_RP.getString("VEvent"));
        this.todoRadioButton = new JRadioButton(Common.I18N_RP.getString("VToDo"));
        this.eventRadioButton.setSelected(!emailManager.isIcalendarToDo());
        this.todoRadioButton.setSelected(emailManager.isIcalendarToDo());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.eventRadioButton);
        buttonGroup.add(this.todoRadioButton);
        this.iCalendarModeLabel = new JLabel(Common.I18N_RP.getString("generateAssignmentsAs") + ":");
        this.eventRadioButton.setEnabled(this.attachICalendar.isSelected());
        this.todoRadioButton.setEnabled(this.attachICalendar.isSelected());
        this.iCalendarModeLabel.setEnabled(this.attachICalendar.isSelected());
        this.icalendarPanel.setEnabled(this.attachICalendar.isSelected());
        this.icalendarPanel.setVisible(this.attachICalendar.isSelected());
        this.icalendarPanel.add((Component)this.iCalendarModeLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 23, 0, insets, 0, 0));
        this.icalendarPanel.add((Component)this.eventRadioButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        this.icalendarPanel.add((Component)this.todoRadioButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel4.add((Component)this.icalendarPanel, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 21, 1, insets, 0, 0));
        jPanel.add((Component)jPanel3, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 23, 2, insets, 0, 0));
        jPanel.add((Component)jPanel4, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 23, 1, insets, 0, 0));
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        JButton jButton = new JButton(Common.I18N_RP.getString("restoreDefaults"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionsDialog.this.emailHostField.setText("smtp.gmail.com");
                JOptionsDialog.this.emailFromField.setText("rplantest@gmail.com");
                JOptionsDialog.this.emailPortField.setText("465");
                JOptionsDialog.this.emailUsernameField.setText("rplantest@gmail.com");
                JOptionsDialog.this.emailPasswordField.setText("rationalplan");
                JOptionsDialog.this.emailTextField.setText(EmailManager.EMAIL_TEMPLATE);
                JOptionsDialog.this.authentication.setSelected(true);
                JOptionsDialog.this.ssl.setSelected(true);
                JOptionsDialog.this.emailUsernameField.setEnabled(true);
                JOptionsDialog.this.emailPasswordField.setEnabled(true);
                JOptionsDialog.this.ssl.setEnabled(true);
                JOptionsDialog.this.eventRadioButton.setSelected(true);
                JOptionsDialog.this.attachICalendar.setSelected(true);
            }
        });
        JButton jButton2 = new JButton(Common.I18N_RP.getString("cancel"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionsDialog.this.setVisible(false);
            }
        });
        JButton jButton3 = new JButton(Common.I18N_RP.getString("ok"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EmailManager emailManager = EmailManager.getInstance();
                emailManager.setMailFrom(JOptionsDialog.this.emailFromField.getText());
                emailManager.setMailServer(JOptionsDialog.this.emailHostField.getText());
                emailManager.setDefaultText(JOptionsDialog.this.emailTextField.getText());
                emailManager.setMailPort(JOptionsDialog.this.emailPortField.getText());
                emailManager.setMailAuthentication(JOptionsDialog.this.authentication.isSelected());
                emailManager.setMailUsername(JOptionsDialog.this.emailUsernameField.getText());
                emailManager.setMailPassword(new String(JOptionsDialog.this.emailPasswordField.getPassword()));
                emailManager.setMailSSL(JOptionsDialog.this.ssl.isSelected());
                emailManager.setNeedsICalendarAttached(JOptionsDialog.this.attachICalendar.isSelected());
                emailManager.setIcalendarToDo(JOptionsDialog.this.todoRadioButton.isSelected());
                emailManager.storeSettings();
                JOptionsDialog.this.setVisible(false);
                Common.getApplication().getWorkspace().getJProject().repaint();
            }
        });
        jPanel5.add((Component)jButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, insets, 0, 0));
        jPanel5.add((Component)jButton3, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 22, 0, insets, 0, 0));
        jPanel5.add((Component)jButton2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 22, 0, insets, 0, 0));
        jPanel.add((Component)jPanel5, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 15, 0, insets, 0, 0));
        return jPanel;
    }

    private JPanel createViewPane() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(4, 4, 4, 4);
        UIManager uIManager = UIManager.getInstance();
        this.projectStartLine = new JCheckBox(Common.I18N_RP.getString("projectStartLine"));
        this.projectStartLine.setSelected(uIManager.isShowProjectStart());
        this.projectEstimatedStartLine = new JCheckBox(Common.I18N_RP.getString("projectEstimatedStartLine"));
        this.projectEstimatedStartLine.setSelected(uIManager.isShowProjectEstimatedStart());
        this.projectFinishLine = new JCheckBox(Common.I18N_RP.getString("projectFinishLine"));
        this.projectFinishLine.setSelected(uIManager.isShowProjectFinish());
        this.currentDateLine = new JCheckBox(Common.I18N_RP.getString("currentDateLine"));
        this.currentDateLine.setSelected(uIManager.isShowCurrentDate());
        this.focusPoint = new JCheckBox(Common.I18N_RP.getString("focusPointMarker"));
        this.focusPoint.setSelected(uIManager.isShowFocusPoint());
        this.showSelection = new JCheckBox(Common.I18N_RP.getString("ganttSelection"));
        this.showSelection.setSelected(uIManager.isShowSelection());
        this.showHorizontalGrid = new JCheckBox(Common.I18N_RP.getString("ganttHorizontalGrid"));
        this.showHorizontalGrid.setSelected(uIManager.isShowHorizontalGrid());
        this.showVerticalGrid = new JCheckBox(Common.I18N_RP.getString("ganttVerticalGrid"));
        this.showVerticalGrid.setSelected(uIManager.isShowVerticalGrid());
        this.showNonWorking = new JCheckBox(Common.I18N_RP.getString("chartNonWorkingTime"));
        this.showNonWorking.setSelected(uIManager.isShowNonWorking());
        this.showTaskId = new JCheckBox(Common.I18N_RP.getString("ganttTaskId"));
        this.showTaskId.setSelected(uIManager.isShowTaskId());
        this.showTaskName = new JCheckBox(Common.I18N_RP.getString("ganttTaskName"));
        this.showTaskName.setSelected(uIManager.isShowTaskName());
        this.showProjectCode = new JCheckBox(Common.I18N_RP.getString("ganttProjectCode"));
        this.showProjectCode.setSelected(uIManager.isShowProjectCode());
        this.showTaskDuration = new JCheckBox(Common.I18N_RP.getString("ganttTaskDuration"));
        this.showTaskDuration.setSelected(uIManager.isShowTaskDuration());
        this.showTaskWork = new JCheckBox(Common.I18N_RP.getString("ganttTaskWork"));
        this.showTaskWork.setSelected(uIManager.isShowTaskWork());
        this.showTaskCompletion = new JCheckBox(Common.I18N_RP.getString("ganttTaskCompletion"));
        this.showTaskCompletion.setSelected(uIManager.isShowTaskCompletion());
        this.showTaskStart = new JCheckBox(Common.I18N_RP.getString("ganttTaskStart"));
        this.showTaskStart.setSelected(uIManager.isShowTaskStart());
        this.showTaskEnd = new JCheckBox(Common.I18N_RP.getString("ganttTaskEnd"));
        this.showTaskEnd.setSelected(uIManager.isShowTaskEnd());
        this.showAssignmentName = new JCheckBox(Common.I18N_RP.getString("ganttAssignmentsName"));
        this.showAssignmentName.setSelected(uIManager.isShowAssignmentsName());
        this.showAssignmentCode = new JCheckBox(Common.I18N_RP.getString("ganttAssignmentsCode"));
        this.showAssignmentCode.setSelected(uIManager.isShowAssignmentsCode());
        this.showProjectRoot = new JCheckBox(Common.I18N_RP.getString("showProjectTask"));
        this.showProjectRoot.setSelected(uIManager.isShowProjectRoot());
        this.showTaskOutline = new JCheckBox(Common.I18N_RP.getString("showTaskOutline"));
        this.showTaskOutline.setSelected(uIManager.isShowTaskOutline());
        this.showRateInViewer = new JCheckBox(Common.I18N_RP.getString("showRateInViewer"));
        this.showRateInViewer.setSelected(ViewerManager.getInstance().isShowRate());
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        Dimension dimension = new Dimension(2, 2);
        jPanel2.setMinimumSize(dimension);
        jPanel2.setMaximumSize(dimension);
        jPanel2.setPreferredSize(dimension);
        this.showProjectRoot.setVisible(true);
        jPanel2.setVisible(true);
        jPanel.add((Component)this.showProjectRoot, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)this.showRateInViewer, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)this.showTaskOutline, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 23, 2, insets, 0, 0));
        jPanel.add((Component)this.projectStartLine, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)this.projectEstimatedStartLine, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)this.projectFinishLine, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)this.currentDateLine, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)this.showSelection, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)this.showHorizontalGrid, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)this.showVerticalGrid, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)this.showNonWorking, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)this.focusPoint, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)this.showProjectCode, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)this.showTaskName, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)this.showTaskDuration, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)this.showTaskWork, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)this.showTaskCompletion, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)this.showTaskStart, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)this.showTaskEnd, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)this.showAssignmentName, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)this.showAssignmentCode, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        JButton jButton = new JButton(Common.I18N_RP.getString("restoreDefaults"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionsDialog.this.projectStartLine.setSelected(true);
                JOptionsDialog.this.projectEstimatedStartLine.setSelected(true);
                JOptionsDialog.this.projectFinishLine.setSelected(true);
                JOptionsDialog.this.currentDateLine.setSelected(true);
                JOptionsDialog.this.focusPoint.setSelected(true);
                JOptionsDialog.this.showSelection.setSelected(true);
                JOptionsDialog.this.showHorizontalGrid.setSelected(false);
                JOptionsDialog.this.showVerticalGrid.setSelected(false);
                JOptionsDialog.this.showNonWorking.setSelected(true);
                JOptionsDialog.this.showTaskId.setSelected(false);
                JOptionsDialog.this.showTaskName.setSelected(false);
                JOptionsDialog.this.showProjectCode.setSelected(false);
                JOptionsDialog.this.showTaskDuration.setSelected(false);
                JOptionsDialog.this.showTaskWork.setSelected(false);
                JOptionsDialog.this.showTaskCompletion.setSelected(false);
                JOptionsDialog.this.showTaskStart.setSelected(false);
                JOptionsDialog.this.showTaskEnd.setSelected(false);
                JOptionsDialog.this.showAssignmentName.setSelected(true);
                JOptionsDialog.this.showAssignmentCode.setSelected(false);
                JOptionsDialog.this.showProjectRoot.setSelected(false);
                JOptionsDialog.this.showTaskOutline.setSelected(false);
                JOptionsDialog.this.showRateInViewer.setSelected(true);
            }
        });
        JButton jButton2 = new JButton(Common.I18N_RP.getString("cancel"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionsDialog.this.setVisible(false);
            }
        });
        JButton jButton3 = new JButton(Common.I18N_RP.getString("ok"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIManager uIManager = UIManager.getInstance();
                uIManager.setShowProjectStart(JOptionsDialog.this.projectStartLine.isSelected());
                uIManager.setShowProjectEstimatedStart(JOptionsDialog.this.projectEstimatedStartLine.isSelected());
                uIManager.setShowProjectFinish(JOptionsDialog.this.projectFinishLine.isSelected());
                uIManager.setShowCurrentDate(JOptionsDialog.this.currentDateLine.isSelected());
                uIManager.setShowFocusPoint(JOptionsDialog.this.focusPoint.isSelected());
                uIManager.setShowSelection(JOptionsDialog.this.showSelection.isSelected());
                uIManager.setShowHorizontalGrid(JOptionsDialog.this.showHorizontalGrid.isSelected());
                uIManager.setShowVerticalGrid(JOptionsDialog.this.showVerticalGrid.isSelected());
                uIManager.setShowNonWorking(JOptionsDialog.this.showNonWorking.isSelected());
                uIManager.setShowTaskId(JOptionsDialog.this.showTaskId.isSelected());
                uIManager.setShowTaskName(JOptionsDialog.this.showTaskName.isSelected());
                uIManager.setShowProjectCode(JOptionsDialog.this.showProjectCode.isSelected());
                uIManager.setShowTaskDuration(JOptionsDialog.this.showTaskDuration.isSelected());
                uIManager.setShowTaskWork(JOptionsDialog.this.showTaskWork.isSelected());
                uIManager.setShowTaskCompletion(JOptionsDialog.this.showTaskCompletion.isSelected());
                uIManager.setShowTaskStart(JOptionsDialog.this.showTaskStart.isSelected());
                uIManager.setShowTaskEnd(JOptionsDialog.this.showTaskEnd.isSelected());
                uIManager.setShowAssignmentsName(JOptionsDialog.this.showAssignmentName.isSelected());
                uIManager.setShowAssignmentsCode(JOptionsDialog.this.showAssignmentCode.isSelected());
                uIManager.setShowProjectRoot(JOptionsDialog.this.showProjectRoot.isSelected());
                uIManager.setShowTaskOutline(JOptionsDialog.this.showTaskOutline.isSelected());
                ViewerManager.getInstance().setShowRate(JOptionsDialog.this.showRateInViewer.isSelected());
                JOptionsDialog.this.setVisible(false);
                JOptionsDialog.this.updateTaskName(Common.getApplication().getWorkspace().getJProject().getProject().getRootTask());
                Common.getApplication().getWorkspace().getJProject().repaint();
            }
        });
        jPanel3.add((Component)jButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, insets, 0, 0));
        jPanel3.add((Component)jButton3, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 22, 0, insets, 0, 0));
        jPanel3.add((Component)jButton2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 22, 0, insets, 0, 0));
        jPanel.add((Component)jPanel3, new GridBagConstraints(0, 11, 3, 1, 1.0, 1.0, 15, 0, insets, 0, 0));
        return jPanel;
    }

    private void updateTaskName(Task task) {
        task.setName(task.getName());
        for (Task task2 : task.getChildList()) {
            if (task2.isEmpty()) continue;
            this.updateTaskName(task2);
        }
    }

    private JPanel createStartupPane() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(4, 4, 4, 4);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(Common.I18N_RP.getString("settingsApplyAfterRestart")));
        this.welcome = new JCheckBox(Common.I18N_RP.getString("welcomeDialog"));
        this.welcome.setSelected(Boolean.getBoolean(Configuration.getInstance().getValue(ConfigurationSetting.STARTUP_WELCOME).toString()));
        this.update = new JCheckBox(Common.I18N_RP.getString("updateDialog"));
        this.update.setSelected(Boolean.getBoolean(Configuration.getInstance().getValue(ConfigurationSetting.STARTUP_UPDATE).toString()));
        this.networkLocking = new JCheckBox(Common.I18N_RP.getString("networkFileLocking"));
        this.networkLocking.setSelected(Boolean.getBoolean(Configuration.getInstance().getValue(ConfigurationSetting.NETWORK_LOCKING).toString()));
        this.languagesCombo = new JComboBox<Locale>(I18nManager.getAvailableLocales());
        this.languagesCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    Locale locale = (Locale)itemEvent.getItem();
                    if (locale == null) {
                        locale = Locale.getDefault();
                    }
                    ResourceBundle resourceBundle = ResourceBundle.getBundle("com.sbs.jpm.i18n.RationalPlan", locale);
                    EmailManager.getInstance().setDefaultText(resourceBundle.getString("email.template"));
                }
            }
        });
        DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Locale locale = (Locale)object;
                String string = locale == null ? Common.I18N_RP.getString("systemLocale") : locale.getDisplayName();
                return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            }
        };
        this.languagesCombo.setRenderer(defaultListCellRenderer);
        jPanel2.add((Component)this.welcome, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel2.add((Component)this.update, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel2.add((Component)this.networkLocking, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel2.add((Component)new JLabel(Common.I18N_RP.getString("language") + ":"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel2.add((Component)this.languagesCombo, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel2.add((Component)new JPanel(), new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 21, 1, insets, 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        JButton jButton = new JButton(Common.I18N_RP.getString("restoreDefaults"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionsDialog.this.welcome.setSelected(true);
                JOptionsDialog.this.update.setSelected(true);
                JOptionsDialog.this.networkLocking.setSelected(true);
                JOptionsDialog.this.languagesCombo.setSelectedItem(null);
            }
        });
        JButton jButton2 = new JButton(Common.I18N_RP.getString("cancel"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionsDialog.this.setVisible(false);
            }
        });
        JButton jButton3 = new JButton(Common.I18N_RP.getString("ok"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Configuration.getInstance().setValue(ConfigurationSetting.STARTUP_WELCOME, JOptionsDialog.this.welcome.isSelected());
                Configuration.getInstance().setValue(ConfigurationSetting.STARTUP_UPDATE, JOptionsDialog.this.update.isSelected());
                Configuration.getInstance().setValue(ConfigurationSetting.NETWORK_LOCKING, JOptionsDialog.this.networkLocking.isSelected());
                Configuration.getInstance().setValue(ConfigurationSetting.LOCALE, JOptionsDialog.this.languagesCombo.getSelectedItem());
                JOptionsDialog.this.setVisible(false);
                Common.getApplication().getWorkspace().getJProject().repaint();
            }
        });
        jPanel3.add((Component)jButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, insets, 0, 0));
        jPanel3.add((Component)jButton3, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 22, 0, insets, 0, 0));
        jPanel3.add((Component)jButton2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 22, 0, insets, 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        jPanel.add((Component)jPanel3, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 15, 0, insets, 0, 0));
        return jPanel;
    }

    public void selectPanel(int n) {
        this.tabbsPanel.setSelectedIndex(n);
    }

    private JPanel createContent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(4, 4, 4, 4);
        this.tabbsPanel = new JTabbedPane();
        JPanel jPanel2 = this.createSchedulePane();
        this.tabbsPanel.add(Common.I18N_RP.getString("schedule"), jPanel2);
        this.tabbsPanel.add(Common.I18N_RP.getString("view"), this.createViewPane());
        this.barCustomizePanel = this.createColorsPane();
        this.tabbsPanel.add(Common.I18N_RP.getString("colors"), this.barCustomizePanel);
        this.tabbsPanel.add(Common.I18N_RP.getString("email"), this.createEmailPane());
        JPanel jPanel3 = this.createStartupPane();
        this.tabbsPanel.add(Common.I18N_RP.getString("startup"), jPanel3);
        jPanel.add((Component)this.tabbsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 21, 1, insets, 0, 0));
        return jPanel;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    private BarCustomizePanel createColorsPane() {
        return new BarCustomizePanel();
    }

    class BarCustomizePanel
    extends JPanel
    implements ChangeListener {
        private JColorChooser colorChooser;
        private boolean temporaryIgnoreMessages = false;
        private ChartUIConfiguration ganttAreaConfig;
        private JArea jGanttArea;
        private Color activitiesSampleBarColorSave;
        private Color phasesSampleBarColorSave;
        private Color milestonesSampleBarColorSave;
        private Color projectsSampleBarColorSave;
        private Color criticalSampleBarColorSave;
        private Color baselineSampleBarColorSave;
        private Color completionSampleBarColorSave;
        private Action defaultColorAction = new AbstractAction(Common.I18N_RP.getString("restoreDefaults")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent == null || actionEvent.getSource().equals(BarCustomizePanel.this.activitiesDefaultButton)) {
                    JPanel jPanel = BarCustomizePanel.this.activitiesSampleBarColor;
                    BarCustomizePanel.this.ganttAreaConfig;
                    jPanel.setBackground(ChartUIConfiguration.TASK_DEFAULT_COLOR);
                    ChartUIConfiguration chartUIConfiguration = BarCustomizePanel.this.ganttAreaConfig;
                    BarCustomizePanel.this.ganttAreaConfig;
                    chartUIConfiguration.setTaskColor(ChartUIConfiguration.TASK_DEFAULT_COLOR);
                    BarCustomizePanel.this.activitiesDefaultButton.setEnabled(false);
                }
                if (actionEvent == null || actionEvent.getSource().equals(BarCustomizePanel.this.phasesDefaultButton)) {
                    JPanel jPanel = BarCustomizePanel.this.phasesSampleBarColor;
                    BarCustomizePanel.this.ganttAreaConfig;
                    jPanel.setBackground(ChartUIConfiguration.PHASE_DEFAULT_COLOR);
                    ChartUIConfiguration chartUIConfiguration = BarCustomizePanel.this.ganttAreaConfig;
                    BarCustomizePanel.this.ganttAreaConfig;
                    chartUIConfiguration.setPhaseTaskColor(ChartUIConfiguration.PHASE_DEFAULT_COLOR);
                    BarCustomizePanel.this.phasesDefaultButton.setEnabled(false);
                }
                if (actionEvent == null || actionEvent.getSource().equals(BarCustomizePanel.this.milestonesDefaultButton)) {
                    JPanel jPanel = BarCustomizePanel.this.milestonesSampleBarColor;
                    BarCustomizePanel.this.ganttAreaConfig;
                    jPanel.setBackground(ChartUIConfiguration.MILESTONE_DEFAULT_COLOR);
                    ChartUIConfiguration chartUIConfiguration = BarCustomizePanel.this.ganttAreaConfig;
                    BarCustomizePanel.this.ganttAreaConfig;
                    chartUIConfiguration.setMilestoneColor(ChartUIConfiguration.MILESTONE_DEFAULT_COLOR);
                    BarCustomizePanel.this.milestonesDefaultButton.setEnabled(false);
                }
                if (actionEvent == null || actionEvent.getSource().equals(BarCustomizePanel.this.projectsDefaultButton)) {
                    JPanel jPanel = BarCustomizePanel.this.projectsSampleBarColor;
                    BarCustomizePanel.this.ganttAreaConfig;
                    jPanel.setBackground(ChartUIConfiguration.PROJECT_DEFAULT_COLOR);
                    ChartUIConfiguration chartUIConfiguration = BarCustomizePanel.this.ganttAreaConfig;
                    BarCustomizePanel.this.ganttAreaConfig;
                    chartUIConfiguration.setProjectTaskColor(ChartUIConfiguration.PROJECT_DEFAULT_COLOR);
                    BarCustomizePanel.this.projectsDefaultButton.setEnabled(false);
                }
                if (actionEvent == null || actionEvent.getSource().equals(BarCustomizePanel.this.criticalDefaultButton)) {
                    JPanel jPanel = BarCustomizePanel.this.criticalSampleBarColor;
                    BarCustomizePanel.this.ganttAreaConfig;
                    jPanel.setBackground(ChartUIConfiguration.TASK_CRITICAL_DEFAULT_COLOR);
                    ChartUIConfiguration chartUIConfiguration = BarCustomizePanel.this.ganttAreaConfig;
                    BarCustomizePanel.this.ganttAreaConfig;
                    chartUIConfiguration.setTaskCriticalColor(ChartUIConfiguration.TASK_CRITICAL_DEFAULT_COLOR);
                    BarCustomizePanel.this.criticalDefaultButton.setEnabled(false);
                }
                if (actionEvent == null || actionEvent.getSource().equals(BarCustomizePanel.this.baselineDefaultButton)) {
                    JPanel jPanel = BarCustomizePanel.this.baselineSampleBarColor;
                    BarCustomizePanel.this.ganttAreaConfig;
                    jPanel.setBackground(ChartUIConfiguration.BASELINE_DEFAULT_COLOR);
                    ChartUIConfiguration chartUIConfiguration = BarCustomizePanel.this.ganttAreaConfig;
                    BarCustomizePanel.this.ganttAreaConfig;
                    chartUIConfiguration.setBaselineColor(ChartUIConfiguration.BASELINE_DEFAULT_COLOR);
                    BarCustomizePanel.this.baselineDefaultButton.setEnabled(false);
                }
                if (actionEvent == null || actionEvent.getSource().equals(BarCustomizePanel.this.completionDefaultButton)) {
                    JPanel jPanel = BarCustomizePanel.this.completionSampleBarColor;
                    BarCustomizePanel.this.ganttAreaConfig;
                    jPanel.setBackground(ChartUIConfiguration.TASK_COMPLETION_DEFAULT_COLOR);
                    ChartUIConfiguration chartUIConfiguration = BarCustomizePanel.this.ganttAreaConfig;
                    BarCustomizePanel.this.ganttAreaConfig;
                    chartUIConfiguration.setTaskCompletionColor(ChartUIConfiguration.TASK_COMPLETION_DEFAULT_COLOR);
                    BarCustomizePanel.this.completionDefaultButton.setEnabled(false);
                }
                BarCustomizePanel.this.jGanttArea.invalidate();
                BarCustomizePanel.this.jGanttArea.repaint();
            }
        };
        private ButtonGroup allRadio = new ButtonGroup();
        private JPanel activitiesSampleBarColor = new JPanel();
        private JRadioButton activitiesRadio = new JRadioButton(Common.I18N_RP.getString("color.activities"));
        private JButton activitiesDefaultButton = new JButton(this.defaultColorAction);
        private JPanel milestonesSampleBarColor = new JPanel();
        private JRadioButton milestonesRadio = new JRadioButton(Common.I18N_RP.getString("color.milestones"));
        private JButton milestonesDefaultButton = new JButton(this.defaultColorAction);
        private JPanel phasesSampleBarColor = new JPanel();
        private JRadioButton phasesRadio = new JRadioButton(Common.I18N_RP.getString("color.phases"));
        private JButton phasesDefaultButton = new JButton(this.defaultColorAction);
        private JPanel projectsSampleBarColor = new JPanel();
        private JRadioButton projectsRadio = new JRadioButton(Common.I18N_RP.getString("color.projects"));
        private JButton projectsDefaultButton = new JButton(this.defaultColorAction);
        private JPanel criticalSampleBarColor = new JPanel();
        private JPanel baselineSampleBarColor = new JPanel();
        private JRadioButton criticalRadio = new JRadioButton(Common.I18N_RP.getString("color.critical"));
        private JRadioButton baselineRadio = new JRadioButton(Common.I18N_RP.getString("color.baselines"));
        private JButton criticalDefaultButton = new JButton(this.defaultColorAction);
        private JButton baselineDefaultButton = new JButton(this.defaultColorAction);
        private JPanel completionSampleBarColor = new JPanel();
        private JRadioButton completionRadio = new JRadioButton(Common.I18N_RP.getString("color.completion"));
        private JButton completionDefaultButton = new JButton(this.defaultColorAction);

        public void stateChanged(ChangeEvent changeEvent) {
            Color color = this.colorChooser.getColor();
            if (this.temporaryIgnoreMessages) {
                return;
            }
            if (this.activitiesRadio.isSelected()) {
                this.activitiesSampleBarColor.setBackground(color);
                this.ganttAreaConfig.setTaskColor(color);
                this.activitiesDefaultButton.setEnabled(true);
            }
            if (this.phasesRadio.isSelected()) {
                this.phasesSampleBarColor.setBackground(color);
                this.ganttAreaConfig.setPhaseTaskColor(color);
                this.phasesDefaultButton.setEnabled(true);
            }
            if (this.milestonesRadio.isSelected()) {
                this.milestonesSampleBarColor.setBackground(color);
                this.ganttAreaConfig.setMilestoneColor(color);
                this.milestonesDefaultButton.setEnabled(true);
            }
            if (this.projectsRadio.isSelected()) {
                this.projectsSampleBarColor.setBackground(color);
                this.ganttAreaConfig.setProjectTaskColor(color);
                this.projectsDefaultButton.setEnabled(true);
            }
            if (this.criticalRadio.isSelected()) {
                this.criticalSampleBarColor.setBackground(color);
                this.ganttAreaConfig.setTaskCriticalColor(color);
                this.criticalDefaultButton.setEnabled(true);
            }
            if (this.baselineRadio.isSelected()) {
                this.baselineSampleBarColor.setBackground(color);
                this.ganttAreaConfig.setBaselineColor(color);
                this.baselineDefaultButton.setEnabled(true);
            }
            if (this.completionRadio.isSelected()) {
                this.completionSampleBarColor.setBackground(color);
                this.ganttAreaConfig.setTaskCompletionColor(color);
                this.completionDefaultButton.setEnabled(true);
            }
            this.jGanttArea.invalidate();
            this.jGanttArea.repaint();
        }

        public void restoreDefaults(ActionEvent actionEvent) {
            this.defaultColorAction.actionPerformed(null);
        }

        public BarCustomizePanel() {
            this.setLayout(new GridBagLayout());
            Insets insets = new Insets(4, 4, 4, 4);
            this.setBorder(BorderFactory.createTitledBorder(Common.I18N_RP.getString("setApplicationDefaultColors") + ": "));
            this.allRadio.add(this.activitiesRadio);
            this.allRadio.add(this.milestonesRadio);
            this.allRadio.add(this.phasesRadio);
            this.allRadio.add(this.projectsRadio);
            this.allRadio.add(this.criticalRadio);
            this.allRadio.add(this.baselineRadio);
            this.allRadio.add(this.completionRadio);
            this.activitiesRadio.setSelected(true);
            this.colorChooser = new ColorChooserNoHSB();
            this.colorChooser.setPreviewPanel(new JPanel());
            JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
            JProjectViewGantt jProjectViewGantt = (JProjectViewGantt)jAreaView.getViewComponent(JAreaView.GANTT);
            this.jGanttArea = jProjectViewGantt.getGantt().getArea();
            this.ganttAreaConfig = this.jGanttArea.getChartUIConfiguration();
            this.activitiesDefaultButton.setEnabled(!this.ganttAreaConfig.getTaskColor().equals(ChartUIConfiguration.TASK_DEFAULT_COLOR));
            this.phasesDefaultButton.setEnabled(!this.ganttAreaConfig.getPhaseTaskColor().equals(ChartUIConfiguration.PHASE_DEFAULT_COLOR));
            this.milestonesDefaultButton.setEnabled(!this.ganttAreaConfig.getMilestoneColor().equals(ChartUIConfiguration.MILESTONE_DEFAULT_COLOR));
            this.projectsDefaultButton.setEnabled(!this.ganttAreaConfig.getProjectTaskColor().equals(ChartUIConfiguration.PROJECT_DEFAULT_COLOR));
            this.criticalDefaultButton.setEnabled(!this.ganttAreaConfig.getTaskCriticalColor().equals(ChartUIConfiguration.TASK_CRITICAL_DEFAULT_COLOR));
            this.baselineDefaultButton.setEnabled(!this.ganttAreaConfig.getBaselineColor().equals(ChartUIConfiguration.BASELINE_DEFAULT_COLOR));
            this.completionDefaultButton.setEnabled(!this.ganttAreaConfig.getTaskCompletionColor().equals(ChartUIConfiguration.TASK_COMPLETION_DEFAULT_COLOR));
            this.activitiesSampleBarColor.setPreferredSize(new Dimension(70, 15));
            this.activitiesSampleBarColor.setBackground(this.ganttAreaConfig.getTaskColor());
            this.phasesSampleBarColor.setPreferredSize(new Dimension(70, 15));
            this.phasesSampleBarColor.setBackground(this.ganttAreaConfig.getPhaseTaskColor());
            this.milestonesSampleBarColor.setPreferredSize(new Dimension(70, 15));
            this.milestonesSampleBarColor.setBackground(this.ganttAreaConfig.getMilestoneColor());
            this.projectsSampleBarColor.setPreferredSize(new Dimension(70, 15));
            this.projectsSampleBarColor.setBackground(this.ganttAreaConfig.getProjectTaskColor());
            this.criticalSampleBarColor.setPreferredSize(new Dimension(70, 15));
            this.criticalSampleBarColor.setBackground(this.ganttAreaConfig.getTaskCriticalColor());
            this.baselineSampleBarColor.setPreferredSize(new Dimension(70, 15));
            this.baselineSampleBarColor.setBackground(this.ganttAreaConfig.getBaselineColor());
            this.completionSampleBarColor.setPreferredSize(new Dimension(70, 15));
            this.completionSampleBarColor.setBackground(this.ganttAreaConfig.getTaskCompletionColor());
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setBorder(BorderFactory.createTitledBorder(Common.I18N_RP.getString("chooseAColor")));
            jPanel.add((Component)this.colorChooser, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
            this.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel2.setBorder(BorderFactory.createTitledBorder(Common.I18N_RP.getString("useSelectedColor") + ": "));
            int n = 0;
            int n2 = 0;
            jPanel2.add((Component)this.activitiesRadio, new GridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            jPanel2.add((Component)this.activitiesSampleBarColor, new GridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            jPanel2.add((Component)this.activitiesDefaultButton, new GridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            n2 = 0;
            jPanel2.add((Component)this.phasesRadio, new GridBagConstraints(n2++, ++n, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            jPanel2.add((Component)this.phasesSampleBarColor, new GridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            jPanel2.add((Component)this.phasesDefaultButton, new GridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            n2 = 0;
            jPanel2.add((Component)this.milestonesRadio, new GridBagConstraints(n2++, ++n, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            jPanel2.add((Component)this.milestonesSampleBarColor, new GridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            jPanel2.add((Component)this.milestonesDefaultButton, new GridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            n2 = 0;
            jPanel2.add((Component)this.projectsRadio, new GridBagConstraints(n2++, ++n, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            jPanel2.add((Component)this.projectsSampleBarColor, new GridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            jPanel2.add((Component)this.projectsDefaultButton, new GridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            n2 = 0;
            jPanel2.add((Component)this.criticalRadio, new GridBagConstraints(n2++, ++n, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            jPanel2.add((Component)this.criticalSampleBarColor, new GridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            jPanel2.add((Component)this.criticalDefaultButton, new GridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            n2 = 0;
            jPanel2.add((Component)this.baselineRadio, new GridBagConstraints(n2++, ++n, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            jPanel2.add((Component)this.baselineSampleBarColor, new GridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            jPanel2.add((Component)this.baselineDefaultButton, new GridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            n2 = 0;
            jPanel2.add((Component)this.completionRadio, new GridBagConstraints(n2++, ++n, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            jPanel2.add((Component)this.completionSampleBarColor, new GridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            jPanel2.add((Component)this.completionDefaultButton, new GridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            jPanel2.add((Component)new JPanel(), new GridBagConstraints(n2++, n, 1, 1, 1.0, 1.0, 17, 0, insets, 0, 0));
            ++n;
            this.add((Component)jPanel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, insets, 0, 0));
            this.colorChooser.getSelectionModel().addChangeListener(this);
            JPanel jPanel3 = new JPanel(new GridBagLayout());
            JButton jButton = new JButton(Common.I18N_RP.getString("restoreDefaults"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JOptionsDialog.this.barCustomizePanel.restoreDefaults(null);
                }
            });
            JButton jButton2 = new JButton(Common.I18N_RP.getString("cancel"));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BarCustomizePanel.this.activitiesSampleBarColor.setBackground(BarCustomizePanel.this.activitiesSampleBarColorSave);
                    BarCustomizePanel.this.phasesSampleBarColor.setBackground(BarCustomizePanel.this.phasesSampleBarColorSave);
                    BarCustomizePanel.this.milestonesSampleBarColor.setBackground(BarCustomizePanel.this.milestonesSampleBarColorSave);
                    BarCustomizePanel.this.projectsSampleBarColor.setBackground(BarCustomizePanel.this.projectsSampleBarColorSave);
                    BarCustomizePanel.this.criticalSampleBarColor.setBackground(BarCustomizePanel.this.criticalSampleBarColorSave);
                    BarCustomizePanel.this.baselineSampleBarColor.setBackground(BarCustomizePanel.this.baselineSampleBarColorSave);
                    BarCustomizePanel.this.completionSampleBarColor.setBackground(BarCustomizePanel.this.completionSampleBarColorSave);
                    BarCustomizePanel.this.ganttAreaConfig.setTaskColor(BarCustomizePanel.this.activitiesSampleBarColorSave);
                    BarCustomizePanel.this.ganttAreaConfig.setPhaseTaskColor(BarCustomizePanel.this.phasesSampleBarColorSave);
                    BarCustomizePanel.this.ganttAreaConfig.setMilestoneColor(BarCustomizePanel.this.milestonesSampleBarColorSave);
                    BarCustomizePanel.this.ganttAreaConfig.setProjectTaskColor(BarCustomizePanel.this.projectsSampleBarColorSave);
                    BarCustomizePanel.this.ganttAreaConfig.setTaskCriticalColor(BarCustomizePanel.this.criticalSampleBarColorSave);
                    BarCustomizePanel.this.ganttAreaConfig.setBaselineColor(BarCustomizePanel.this.baselineSampleBarColorSave);
                    BarCustomizePanel.this.ganttAreaConfig.setTaskCompletionColor(BarCustomizePanel.this.completionSampleBarColorSave);
                    JOptionsDialog.this.setVisible(false);
                }
            });
            JButton jButton3 = new JButton(Common.I18N_RP.getString("ok"));
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JOptionsDialog.this.setVisible(false);
                    Common.getApplication().getWorkspace().getJProject().repaint();
                    BarCustomizePanel.this.activitiesSampleBarColorSave = BarCustomizePanel.this.activitiesSampleBarColor.getBackground();
                    BarCustomizePanel.this.phasesSampleBarColorSave = BarCustomizePanel.this.phasesSampleBarColor.getBackground();
                    BarCustomizePanel.this.milestonesSampleBarColorSave = BarCustomizePanel.this.milestonesSampleBarColor.getBackground();
                    BarCustomizePanel.this.projectsSampleBarColorSave = BarCustomizePanel.this.projectsSampleBarColor.getBackground();
                    BarCustomizePanel.this.criticalSampleBarColorSave = BarCustomizePanel.this.criticalSampleBarColor.getBackground();
                    BarCustomizePanel.this.baselineSampleBarColorSave = BarCustomizePanel.this.baselineSampleBarColor.getBackground();
                    BarCustomizePanel.this.completionSampleBarColorSave = BarCustomizePanel.this.completionSampleBarColor.getBackground();
                }
            });
            jPanel3.add((Component)jButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, insets, 0, 0));
            jPanel3.add((Component)jButton3, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 22, 0, insets, 0, 0));
            jPanel3.add((Component)jButton2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 22, 0, insets, 0, 0));
            this.add((Component)jPanel3, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 15, 0, insets, 0, 0));
            this.activitiesSampleBarColorSave = this.activitiesSampleBarColor.getBackground();
            this.phasesSampleBarColorSave = this.phasesSampleBarColor.getBackground();
            this.milestonesSampleBarColorSave = this.milestonesSampleBarColor.getBackground();
            this.projectsSampleBarColorSave = this.projectsSampleBarColor.getBackground();
            this.criticalSampleBarColorSave = this.criticalSampleBarColor.getBackground();
            this.baselineSampleBarColorSave = this.baselineSampleBarColor.getBackground();
            this.completionSampleBarColorSave = this.completionSampleBarColor.getBackground();
        }
    }
}

