/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.sbs.jpm.Common;
import com.sbs.jpm.ui.JProject;
import com.sbs.jpm.ui.component.JAreaView;
import com.sbs.jpm.ui.component.JImageSample;
import com.sbs.jpm.ui.component.JProjectView;
import com.sbs.jpm.ui.component.view.JProjectViewCalendar;
import com.sbs.jpm.ui.component.view.JProjectViewGantt;
import com.sbs.jpm.ui.component.view.JProjectViewResourceSheet;
import com.sbs.jpm.ui.component.view.JProjectViewResources;
import com.sbs.jpm.ui.core.Data;
import com.sbs.jpm.ui.core.Node;
import com.sbs.jpm.ui.core.ProjectTree;
import com.sbs.jpm.ui.model.ProjectTreeModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jdesktop.swingx.JXTree;

public class JGuide
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JXTree tree;
    private Data data;
    private JPanel treePanel;
    private JSplitPane splitPane;
    private JEditorPane editorPane;
    private JImageSample imageSample;
    private JButton moreButton;
    private JCustomLabel detailsNextLabel;
    private JCustomLabel detailsPreviousLabel;
    private JCustomLabel guideNextLabel;
    private JCustomLabel guidePreviousLabel;
    private JLabel detailsTitleLabel;
    private MouseListener previousActionHandler;
    private MouseListener nextActionHandler;
    private MouseListener detailsNextActionHandler;
    private MouseListener detailsPreviousActionHandler;
    private JProject jproject;
    private TreePath selectionPath;
    private TreePath oldPath;

    public JGuide(JProject jProject) {
        this.jproject = jProject;
        this.setLayout(new BorderLayout());
        this.setBorder(new LineBorder(Color.GRAY));
        this.add((Component)this.createContents(), "Center");
    }

    private JComponent createContents() {
        this.previousActionHandler = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (JGuide.this.guidePreviousLabel.isEnabled()) {
                    int n;
                    TreePath treePath = JGuide.this.tree.getSelectionPath();
                    if (treePath == null) {
                        treePath = JGuide.this.selectionPath;
                        JGuide.this.tree.expandPath(treePath.getParentPath());
                        JGuide.this.tree.setSelectionPath(treePath);
                    }
                    if ((n = JGuide.this.tree.getRowForPath(treePath) - 1) != -1) {
                        TreePath treePath2 = JGuide.this.tree.getPathForRow(n);
                        if (!((Node)treePath2.getLastPathComponent()).isLeaf()) {
                            if (JGuide.this.tree.isCollapsed(treePath2)) {
                                JGuide.this.tree.expandPath(treePath2);
                                n = JGuide.this.tree.getRowForPath(treePath) - 1;
                            } else {
                                n = JGuide.this.tree.getRowForPath(treePath) - 2;
                                if (n != -1 && !((Node)(treePath2 = JGuide.this.tree.getPathForRow(n)).getLastPathComponent()).isLeaf() && JGuide.this.tree.isCollapsed(treePath2)) {
                                    JGuide.this.tree.expandPath(treePath2);
                                    n = JGuide.this.tree.getRowForPath(treePath) - 2;
                                }
                            }
                        }
                        JGuide.this.tree.setSelectionRow(n);
                    }
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                if (JGuide.this.guidePreviousLabel.isEnabled()) {
                    JGuide.this.guidePreviousLabel.setText("<html><u>" + JGuide.this.guidePreviousLabel.originalText + "</u></html>");
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                JGuide.this.guidePreviousLabel.setText("<html>" + JGuide.this.guidePreviousLabel.originalText + "</html>");
            }
        };
        this.nextActionHandler = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (JGuide.this.guideNextLabel.isEnabled()) {
                    int n;
                    TreePath treePath = JGuide.this.tree.getSelectionPath();
                    if (treePath == null) {
                        treePath = JGuide.this.selectionPath;
                        JGuide.this.tree.expandPath(treePath.getParentPath());
                        JGuide.this.tree.setSelectionPath(treePath);
                    }
                    if ((n = JGuide.this.tree.getRowForPath(treePath) + 1) < JGuide.this.tree.getRowCount()) {
                        TreePath treePath2 = JGuide.this.tree.getPathForRow(n);
                        if (!((Node)treePath2.getLastPathComponent()).isLeaf()) {
                            if (JGuide.this.tree.isCollapsed(treePath2)) {
                                JGuide.this.tree.expandPath(treePath2);
                            }
                            n = JGuide.this.tree.getRowForPath(treePath) + 2;
                        }
                        JGuide.this.tree.setSelectionRow(n);
                    }
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                if (JGuide.this.guideNextLabel.isEnabled()) {
                    JGuide.this.guideNextLabel.setText("<html><u>" + JGuide.this.guideNextLabel.originalText + "</u></html>");
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                JGuide.this.guideNextLabel.setText("<html>" + JGuide.this.guideNextLabel.originalText + "</html>");
            }
        };
        this.detailsNextActionHandler = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (JGuide.this.detailsNextLabel.isEnabled()) {
                    int n;
                    TreePath treePath = JGuide.this.tree.getSelectionPath();
                    if (treePath == null) {
                        treePath = JGuide.this.selectionPath;
                        JGuide.this.tree.expandPath(treePath.getParentPath());
                        JGuide.this.tree.setSelectionPath(treePath);
                    }
                    if ((n = JGuide.this.tree.getRowForPath(treePath) + 1) < JGuide.this.tree.getRowCount()) {
                        TreePath treePath2 = JGuide.this.tree.getPathForRow(n);
                        if (!((Node)treePath2.getLastPathComponent()).isLeaf()) {
                            if (JGuide.this.tree.isCollapsed(treePath2)) {
                                JGuide.this.tree.expandPath(treePath2);
                            }
                            n = JGuide.this.tree.getRowForPath(treePath) + 2;
                        }
                        JGuide.this.tree.setSelectionRow(n);
                    }
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                if (JGuide.this.detailsNextLabel.isEnabled()) {
                    JGuide.this.detailsNextLabel.setText("<html><u>" + JGuide.this.detailsNextLabel.originalText + "</u></html>");
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                JGuide.this.detailsNextLabel.setText("<html>" + JGuide.this.detailsNextLabel.originalText + "</html>");
            }
        };
        this.detailsPreviousActionHandler = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (JGuide.this.detailsPreviousLabel.isEnabled()) {
                    int n;
                    TreePath treePath = JGuide.this.tree.getSelectionPath();
                    if (treePath == null) {
                        treePath = JGuide.this.selectionPath;
                        JGuide.this.tree.expandPath(treePath.getParentPath());
                        JGuide.this.tree.setSelectionPath(treePath);
                    }
                    if ((n = JGuide.this.tree.getRowForPath(treePath) - 1) != -1) {
                        TreePath treePath2 = JGuide.this.tree.getPathForRow(n);
                        if (!((Node)treePath2.getLastPathComponent()).isLeaf()) {
                            if (JGuide.this.tree.isCollapsed(treePath2)) {
                                JGuide.this.tree.expandPath(treePath2);
                                n = JGuide.this.tree.getRowForPath(treePath) - 1;
                            } else {
                                n = JGuide.this.tree.getRowForPath(treePath) - 2;
                                if (n != -1 && !((Node)(treePath2 = JGuide.this.tree.getPathForRow(n)).getLastPathComponent()).isLeaf() && JGuide.this.tree.isCollapsed(treePath2)) {
                                    JGuide.this.tree.expandPath(treePath2);
                                    n = JGuide.this.tree.getRowForPath(treePath) - 2;
                                }
                            }
                        }
                        JGuide.this.tree.setSelectionRow(n);
                    }
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                if (JGuide.this.detailsPreviousLabel.isEnabled()) {
                    JGuide.this.detailsPreviousLabel.setText("<html><u>" + JGuide.this.detailsPreviousLabel.originalText + "</u></html>");
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                JGuide.this.detailsPreviousLabel.setText("<html>" + JGuide.this.detailsPreviousLabel.originalText + "</html>");
            }
        };
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.treePanel = this.createTreePanel();
        jPanel.add((Component)this.treePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 24, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel2 = this.createBottomNavigationPanel();
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 24, 2, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.setBackground(jPanel2.getBackground());
        return jPanel;
    }

    private void toggleDetails() {
        boolean bl = this.treePanel.isVisible();
        this.treePanel.setVisible(!bl);
        if (!bl) {
            this.splitPane.setDividerLocation(-1);
            try {
                this.editorPane.setPage(this.data.getShortDescription());
            }
            catch (IOException iOException) {
                Common.logException("Error:", iOException);
            }
        } else {
            try {
                this.editorPane.setPage(this.data.getLongDescription());
            }
            catch (IOException iOException) {
                Common.logException("Error:", iOException);
            }
        }
    }

    public JPanel createDetailPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new LineBorder(Color.GRAY));
        jPanel.setFocusable(false);
        jPanel.add((Component)this.createDetailTitlePanel(), "North");
        jPanel.add((Component)this.createDetailContentPanel(), "Center");
        jPanel.add((Component)this.moreButton, "South");
        return jPanel;
    }

    private JPanel createDetailContentPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setFocusable(false);
        this.imageSample = new JImageSample();
        this.editorPane = new JEditorPane("text/html", "<html></html>");
        this.editorPane.setEditable(false);
        this.editorPane.setFocusable(false);
        this.editorPane.setBackground(new Color(255, 252, 233));
        this.editorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    JGuide.this.imageSample.setImage(hyperlinkEvent.getURL());
                    JGuide.this.imageSample.pack();
                    JGuide.this.imageSample.setVisible(true);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.editorPane);
        jScrollPane.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.moreButton = new JButton("More");
        this.moreButton.setFocusable(false);
        this.moreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JGuide.this.toggleDetails();
                if (JGuide.this.moreButton.getText().equals("More")) {
                    JGuide.this.moreButton.setText("Back");
                } else {
                    JGuide.this.moreButton.setText("More");
                }
            }
        });
        jPanel.add((Component)this.createDetailNavigationPanel(), "North");
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)this.moreButton, "South");
        return jPanel;
    }

    private JPanel createDetailNavigationPanel() {
        Color color = new Color(255, 252, 233);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(color);
        jPanel.setFocusable(false);
        Insets insets = new Insets(0, 0, 0, 0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, Color.GRAY));
        Dimension dimension = new Dimension(2, 2);
        jPanel2.setMinimumSize(dimension);
        jPanel2.setMaximumSize(dimension);
        jPanel2.setPreferredSize(dimension);
        this.detailsNextLabel = new JCustomLabel(Common.I18N_RP.getString("goToNextStep"));
        this.detailsNextLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/guide/next.png")));
        this.detailsNextLabel.setForeground(Color.BLUE);
        this.detailsNextLabel.setBackground(color);
        this.detailsNextLabel.addMouseListener(this.detailsNextActionHandler);
        this.detailsPreviousLabel = new JCustomLabel(Common.I18N_RP.getString("goToPreviousStep"));
        this.detailsPreviousLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/guide/previous.png")));
        this.detailsPreviousLabel.setForeground(Color.BLUE);
        this.detailsPreviousLabel.setBackground(color);
        this.detailsPreviousLabel.addMouseListener(this.detailsPreviousActionHandler);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBackground(color);
        jPanel.add((Component)jPanel3, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 23, 2, insets, 0, 0));
        jPanel.add((Component)this.detailsPreviousLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 24, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 24, 3, insets, 0, 0));
        jPanel.add((Component)this.detailsNextLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 24, 0, new Insets(0, 5, 0, 20), 0, 0));
        return jPanel;
    }

    private JPanel createBottomNavigationPanel() {
        Color color = this.tree.getBackground();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(color);
        Insets insets = new Insets(0, 0, 0, 0);
        this.guideNextLabel = new JCustomLabel(Common.I18N_RP.getString("goToNextStep"));
        this.guideNextLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/guide/next.png")));
        this.guideNextLabel.setForeground(Color.BLUE);
        this.guideNextLabel.setBackground(color);
        this.guideNextLabel.setMinimumSize(this.guideNextLabel.getPreferredSize());
        this.guideNextLabel.addMouseListener(this.nextActionHandler);
        this.guidePreviousLabel = new JCustomLabel(Common.I18N_RP.getString("goToPreviousStep"));
        this.guidePreviousLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/guide/previous.png")));
        this.guidePreviousLabel.setForeground(Color.BLUE);
        this.guidePreviousLabel.setBackground(color);
        this.guidePreviousLabel.addMouseListener(this.previousActionHandler);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY));
        Dimension dimension = new Dimension(2, 2);
        jPanel2.setMinimumSize(dimension);
        jPanel2.setMaximumSize(dimension);
        jPanel2.setPreferredSize(dimension);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBackground(color);
        Dimension dimension2 = new Dimension(6, 6);
        jPanel3.setMinimumSize(dimension2);
        jPanel3.setMaximumSize(dimension2);
        jPanel3.setPreferredSize(dimension2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBackground(color);
        jPanel4.setMinimumSize(dimension2);
        jPanel4.setMaximumSize(dimension2);
        jPanel4.setPreferredSize(dimension2);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBackground(color);
        jPanel.add((Component)jPanel2, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 23, 2, new Insets(0, 0, 3, 0), 0, 0));
        jPanel.add((Component)jPanel5, new GridBagConstraints(1, 1, 1, 2, 1.0, 1.0, 23, 1, insets, 0, 0));
        jPanel.add((Component)this.guidePreviousLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)this.guideNextLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)jPanel3, new GridBagConstraints(0, 0, 1, 3, 0.0, 1.0, 23, 3, insets, 0, 0));
        jPanel.add((Component)jPanel4, new GridBagConstraints(3, 0, 1, 3, 0.0, 1.0, 23, 3, insets, 0, 0));
        return jPanel;
    }

    public void disableNavigation() {
        this.selectionPath = null;
        this.tree.clearSelection();
        this.guidePreviousLabel.setVisible(false);
        this.guideNextLabel.setVisible(false);
        this.detailsNextLabel.setVisible(false);
        this.detailsPreviousLabel.setVisible(false);
    }

    private JPanel createTreePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        try {
            UIManager.setLookAndFeel((LookAndFeel)new PlasticLookAndFeel());
        }
        catch (Exception exception) {
            Common.logException("Error:", exception);
        }
        this.tree = new JXTree();
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (Exception exception) {
            Common.logException("Error:", exception);
        }
        this.tree.setBackground(Color.WHITE);
        this.tree.setRootVisible(false);
        this.tree.setExpandsSelectedPaths(true);
        this.tree.putClientProperty((Object)"JTree.lineStyle", (Object)"None");
        this.tree.setShowsRootHandles(true);
        CustomTreeCellRenderer customTreeCellRenderer = new CustomTreeCellRenderer();
        customTreeCellRenderer.setBackgroundNonSelectionColor(this.tree.getBackground());
        this.tree.setCellRenderer((TreeCellRenderer)customTreeCellRenderer);
        this.tree.setToggleClickCount(1);
        this.tree.setCollapsedIcon(null);
        this.tree.setExpandedIcon(null);
        URL uRL = this.getClass().getClassLoader().getResource("com/sbs/jpm/ui/images/treeopen.png");
        this.tree.setOpenIcon((Icon)new ImageIcon(uRL));
        uRL = this.getClass().getClassLoader().getResource("com/sbs/jpm/ui/images/treeclosed.png");
        this.tree.setClosedIcon((Icon)new ImageIcon(uRL));
        uRL = this.getClass().getClassLoader().getResource("com/sbs/jpm/ui/images/null.png");
        this.tree.setLeafIcon((Icon)new ImageIcon(uRL));
        this.tree.setModel((TreeModel)new ProjectTreeModel(new ProjectTree()));
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.expandRow(0);
        class MyExpansionListener
        implements TreeExpansionListener {
            MyExpansionListener() {
            }

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                if (JGuide.this.oldPath == null && JGuide.this.selectionPath != null && JGuide.this.tree.isVisible(JGuide.this.selectionPath)) {
                    JGuide.this.tree.setSelectionPath(JGuide.this.selectionPath);
                }
            }
        }
        this.tree.addTreeExpansionListener((TreeExpansionListener)new MyExpansionListener());
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel(){

            public void setSelectionPath(TreePath treePath) {
                JGuide.this.oldPath = JGuide.this.tree.getSelectionPath();
                if (((Node)treePath.getLastPathComponent()).isLeaf()) {
                    super.setSelectionPath(treePath);
                } else if (treePath.isDescendant(JGuide.this.oldPath)) {
                    JGuide.this.selectionPath = JGuide.this.oldPath;
                    JGuide.this.tree.clearSelection();
                } else {
                    super.setSelectionPath(JGuide.this.oldPath);
                }
            }
        };
        this.tree.setSelectionModel((TreeSelectionModel)defaultTreeSelectionModel);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                if (treePath != null) {
                    int n = JGuide.this.tree.getRowForPath(treePath);
                    JGuide.this.guidePreviousLabel.setVisible(n > 1);
                    JGuide.this.detailsPreviousLabel.setVisible(n > 1);
                    JGuide.this.guideNextLabel.setVisible(n < JGuide.this.tree.getRowCount() - 1);
                    JGuide.this.detailsNextLabel.setVisible(n < JGuide.this.tree.getRowCount() - 1);
                    JGuide.this.jproject.deselectViewButtons();
                    JGuide.this.data = ((Node)treePath.getLastPathComponent()).getData();
                    String string = JGuide.this.data.getName();
                    JAreaView jAreaView = JGuide.this.jproject.getAreaView();
                    jAreaView.grabFocus();
                    if (!string.equals(JAreaView.PROJECT)) {
                        JProjectView jProjectView;
                        if (string.equals(JAreaView.GANTT)) {
                            jAreaView.setActiveView(JAreaView.GANTT);
                            jProjectView = jAreaView.getActiveViewComponent();
                            if (jProjectView instanceof JProjectViewGantt) {
                                JGuide.this.jproject.getProject().setShowCriticalPath(((JProjectViewGantt)jProjectView).getShowCriticalPathButton().isSelected());
                            }
                        } else if (!string.equals(JAreaView.DEFINE_RESOURCES)) {
                            if (string.equals(JAreaView.HUMAN_RESOURCES)) {
                                jAreaView.setActiveView(JAreaView.DEFINE_RESOURCES);
                                ((JProjectViewResources)jAreaView.getActiveViewComponent()).setSelectedTab(0);
                            } else if (string.equals(JAreaView.MATERIAL_RESOURCES)) {
                                jAreaView.setActiveView(JAreaView.DEFINE_RESOURCES);
                                ((JProjectViewResources)jAreaView.getActiveViewComponent()).setSelectedTab(1);
                            } else if (string.equals(JAreaView.CLIENTS)) {
                                jAreaView.setActiveView(JAreaView.CLIENTS);
                            } else if (string.equals(JAreaView.ASSIGN_RESOURCES)) {
                                jAreaView.setActiveView(JAreaView.ASSIGN_RESOURCES);
                                jProjectView = jAreaView.getActiveViewComponent();
                                if (jProjectView instanceof JProjectViewGantt) {
                                    ((JProjectViewGantt)jProjectView).showInfo();
                                    ((JProjectViewGantt)jProjectView).getTaskView().setSelectedIndex(3);
                                    JGuide.this.jproject.getProject().setShowCriticalPath(((JProjectViewGantt)jProjectView).getShowCriticalPathButton().isSelected());
                                }
                            } else if (string.equals(JAreaView.LEVEL_RESOURCES)) {
                                jAreaView.setActiveView(JAreaView.LEVEL_RESOURCES);
                                jProjectView = jAreaView.getActiveViewComponent();
                                if (jProjectView instanceof JProjectViewGantt) {
                                    ((JProjectViewGantt)jProjectView).showLeveling();
                                }
                            } else if (string.equals(JAreaView.TASK_SHEET)) {
                                jAreaView.setActiveView(JAreaView.TASK_SHEET);
                            } else if (string.equals(JAreaView.CALENDAR)) {
                                jAreaView.setActiveView(JAreaView.CALENDAR);
                                jProjectView = jAreaView.getActiveViewComponent();
                                if (jProjectView instanceof JProjectViewCalendar) {
                                    ((JProjectViewCalendar)jProjectView).getCalendarView().getWeekTable().setRowSelectionInterval(1, 1);
                                }
                            } else if (string.equals(JAreaView.PROJECT_INFO)) {
                                jAreaView.setActiveView(JAreaView.PROJECT_INFO);
                            } else if (string.equals(JAreaView.PROJECT_NOTES)) {
                                jAreaView.setActiveView(JAreaView.PROJECT_NOTES);
                            } else if (string.equals(JAreaView.PROJECT_ASSUMPTIONS)) {
                                jAreaView.setActiveView(JAreaView.PROJECT_ASSUMPTIONS);
                            } else if (string.equals(JAreaView.PROJECT_RISKS)) {
                                jAreaView.setActiveView(JAreaView.PROJECT_RISKS);
                            } else if (!string.equals(JAreaView.PLANNING)) {
                                if (string.equals(JAreaView.PROJECT_WBS)) {
                                    jAreaView.setActiveView(JAreaView.PROJECT_WBS);
                                } else if (!string.equals(JAreaView.CONTROLING)) {
                                    if (string.equals(JAreaView.PROJECT_UPDATE)) {
                                        jAreaView.setActiveView(JAreaView.PROJECT_UPDATE);
                                        jProjectView = jAreaView.getActiveViewComponent();
                                        if (jProjectView instanceof JProjectViewGantt) {
                                            ((JProjectViewGantt)jProjectView).getShowCriticalPathButton().setSelected(true);
                                            JGuide.this.jproject.getProject().setShowCriticalPath(true);
                                        }
                                    } else if (string.equals(JAreaView.RESOURCE_SHEET)) {
                                        jAreaView.setActiveView(JAreaView.RESOURCE_SHEET);
                                        jProjectView = jAreaView.getActiveViewComponent();
                                        if (jProjectView instanceof JProjectViewResourceSheet) {
                                            ((JProjectViewResourceSheet)jProjectView).showInfo();
                                        }
                                    }
                                }
                            }
                        }
                    }
                    jAreaView.transferFocus();
                    JGuide.this.moreButton.setVisible(JGuide.this.data.getLongDescription() != null);
                    JGuide.this.detailsTitleLabel.setText(Common.I18N_RP.getString("projectGuide") + " - " + string);
                    try {
                        JGuide.this.editorPane.setPage(JGuide.this.data.getShortDescription());
                    }
                    catch (IOException iOException) {
                        Common.logException("Error:", iOException);
                    }
                    JGuide.this.editorPane.setCaretPosition(0);
                } else {
                    JGuide.this.guidePreviousLabel.setVisible(JGuide.this.selectionPath != null);
                    JGuide.this.guideNextLabel.setVisible(JGuide.this.selectionPath != null);
                    JGuide.this.detailsNextLabel.setVisible(JGuide.this.selectionPath != null);
                    JGuide.this.detailsPreviousLabel.setVisible(JGuide.this.selectionPath != null);
                }
            }
        });
        jPanel.add((Component)this.createTopNavigationPanel(), "North");
        JScrollPane jScrollPane = new JScrollPane((Component)this.tree, 20, 31);
        jScrollPane.setBorder(new EmptyBorder(new Insets(0, -15, 0, 0)));
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JPanel createTopNavigationPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setRollover(true);
        JButton jButton = new JButton(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/guide/close.png")));
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JGuide.this.jproject.toggleGuide();
            }
        });
        JLabel jLabel = new JLabel(Common.I18N_RP.getString("projectGuide"));
        jLabel.setFocusable(false);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jToolBar.add(jLabel);
        jToolBar.add(Box.createHorizontalGlue());
        jToolBar.add(jButton);
        jPanel.add((Component)jToolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 23, 2, insets, 0, 0));
        return jPanel;
    }

    private JPanel createDetailTitlePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setFocusable(false);
        Insets insets = new Insets(0, 0, 0, 0);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setRollover(true);
        jToolBar.setFocusable(false);
        JButton jButton = new JButton(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/guide/close.png")));
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JGuide.this.jproject.getAreaView().toggleGuide();
            }
        });
        this.detailsTitleLabel = new JLabel("");
        this.detailsTitleLabel.setFocusable(false);
        this.detailsTitleLabel.setFont(this.detailsTitleLabel.getFont().deriveFont(1));
        jToolBar.add(this.detailsTitleLabel);
        jToolBar.add(Box.createHorizontalGlue());
        jToolBar.add(jButton);
        jPanel.add((Component)jToolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 23, 2, insets, 0, 0));
        return jPanel;
    }

    public JTree getTree() {
        return this.tree;
    }

    public void setData(Data data) {
        this.data = data;
        this.moreButton.setVisible(data.getLongDescription() != null);
        try {
            this.editorPane.setPage(data.getShortDescription());
        }
        catch (IOException iOException) {
            Common.LOGGER.warning("Error setting guide data: (9/10/2009 1:15:05): " + iOException.getLocalizedMessage());
        }
        this.editorPane.setCaretPosition(0);
    }

    public JLabel getDetailsTitleLabel() {
        return this.detailsTitleLabel;
    }

    private class JCustomLabel
    extends JLabel {
        private String originalText;

        public JCustomLabel(String string) {
            super("<html>" + string + "</html>");
            this.originalText = string;
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            if (bl) {
                this.setForeground(Color.BLUE);
            } else {
                this.setForeground(Color.GRAY);
            }
        }
    }

    private class CustomTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private final Color foreground = new Color(0, 0, 178);

        private CustomTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (bl3) {
                if (bl) {
                    this.textSelectionColor = Color.WHITE;
                } else {
                    component.setForeground(this.foreground);
                }
            } else {
                component.setForeground(Color.BLACK);
            }
            return component;
        }
    }
}

