/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.mail.EmailManager;
import com.standbysoft.component.date.event.DateSelectionAdapter;
import com.standbysoft.component.date.event.DateSelectionEvent;
import com.standbysoft.component.date.event.DateSelectionListener;
import com.standbysoft.component.date.swing.JDatePicker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JEmailNotificationDialog
extends JDialog {
    private JTable table;
    private JDatePicker startDatePicker;
    private JDatePicker endDatePicker;
    private Date startDate;
    private Date endDate;
    private JTextArea emailTextArea;
    private JCheckBox showAllResources;
    private Task project;

    public JEmailNotificationDialog(Task task) {
        this.project = task;
        this.setModal(true);
        this.setPreferredSize(new Dimension(450, 500));
        this.setTitle(Common.I18N_ACTIONS.getString("emailAssignments"));
        this.setLayout(new GridBagLayout());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        this.startDate = calendar.getTime();
        this.endDate = new Date(System.currentTimeMillis() + 604800000L);
        this.startDatePicker = new JDatePicker();
        this.startDatePicker.setSelectedDate(this.startDate);
        this.startDatePicker.addDateSelectionListener((DateSelectionListener)new DateSelectionAdapter(){

            public void dateSelectionChanged(DateSelectionEvent dateSelectionEvent) {
                JEmailNotificationDialog.this.startDate = dateSelectionEvent.getFirstDate();
                JEmailNotificationDialog.this.table.setModel(new NotificationResourcesTableModel(JEmailNotificationDialog.this.getNotificationResources()));
                JEmailNotificationDialog.this.setColumnsWidth();
            }
        });
        this.endDatePicker = new JDatePicker();
        this.endDatePicker.setSelectedDate(this.endDate);
        this.endDatePicker.addDateSelectionListener((DateSelectionListener)new DateSelectionAdapter(){

            public void dateSelectionChanged(DateSelectionEvent dateSelectionEvent) {
                JEmailNotificationDialog.this.endDate = dateSelectionEvent.getFirstDate();
                JEmailNotificationDialog.this.table.setModel(new NotificationResourcesTableModel(JEmailNotificationDialog.this.getNotificationResources()));
                JEmailNotificationDialog.this.setColumnsWidth();
            }
        });
        this.showAllResources = new JCheckBox(Common.I18N_RP.getString("showAllResources"));
        this.showAllResources.setSelected(false);
        this.showAllResources.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JEmailNotificationDialog.this.table.setModel(new NotificationResourcesTableModel(JEmailNotificationDialog.this.getNotificationResources()));
                JEmailNotificationDialog.this.setColumnsWidth();
            }
        });
        this.table = new JTable();
        this.table.setModel(new NotificationResourcesTableModel(this.getNotificationResources()));
        this.setColumnsWidth();
        JButton jButton = new JButton(Common.I18N_RP.getString("send"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                final List list = ((NotificationResourcesTableModel)JEmailNotificationDialog.this.table.getModel()).resources;
                boolean bl = false;
                for (NotificationResource notificationResource : list) {
                    if (!notificationResource.isSelected()) continue;
                    bl = true;
                }
                if (!bl) {
                    JOptionPane.showMessageDialog(Common.getApplication(), Common.I18N_ACTIONS.getString("email.checkResources.message"), Common.I18N_ACTIONS.getString("email.checkResources.title"), 2);
                } else {
                    Thread thread = new Thread(){

                        public void run() {
                            EmailManager emailManager = EmailManager.getInstance();
                            emailManager.sendEmails(list, JEmailNotificationDialog.this.emailTextArea.getText(), JEmailNotificationDialog.this.project, JEmailNotificationDialog.this.startDate, JEmailNotificationDialog.this.endDate);
                        }
                    };
                    thread.start();
                    JEmailNotificationDialog.this.setVisible(false);
                }
            }
        });
        JButton jButton2 = new JButton(Common.I18N_RP.getString("cancel"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JEmailNotificationDialog.this.setVisible(false);
            }
        });
        JButton jButton3 = new JButton(Common.I18N_RP.getString("selectAll"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (NotificationResource notificationResource : ((NotificationResourcesTableModel)JEmailNotificationDialog.this.table.getModel()).resources) {
                    notificationResource.selected = true;
                }
                ((AbstractTableModel)JEmailNotificationDialog.this.table.getModel()).fireTableRowsUpdated(0, JEmailNotificationDialog.this.table.getRowCount() - 1);
            }
        });
        JButton jButton4 = new JButton(Common.I18N_RP.getString("deselectAll"));
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (NotificationResource notificationResource : ((NotificationResourcesTableModel)JEmailNotificationDialog.this.table.getModel()).resources) {
                    notificationResource.selected = false;
                }
                ((AbstractTableModel)JEmailNotificationDialog.this.table.getModel()).fireTableRowsUpdated(0, JEmailNotificationDialog.this.table.getRowCount() - 1);
            }
        });
        this.getRootPane().setDefaultButton(jButton);
        EmailManager emailManager = EmailManager.getInstance();
        emailManager.loadSettings();
        this.emailTextArea = new JTextArea(7, 30);
        this.emailTextArea.setText(emailManager.getDefaultText());
        this.emailTextArea.setLineWrap(true);
        this.emailTextArea.setWrapStyleWord(true);
        this.emailTextArea.setCaretPosition(0);
        int n = 0;
        Insets insets = new Insets(5, 5, 5, 5);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(""));
        JLabel jLabel = new JLabel(Common.I18N_RP.getString("resourcesAssignedInSelectedPeriod") + ":");
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n++, 2, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, n++, 2, 1, 1.0, 1.0, 23, 1, insets, 0, 0));
        JPanel jPanel2 = new JPanel(new GridLayout());
        jPanel2.add(jButton3);
        jPanel2.add(jButton4);
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 2, insets, 0, 0));
        jPanel.add((Component)this.showAllResources, new GridBagConstraints(1, n++, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(new TitledBorder(Common.I18N_RP.getString("emailAssignmentsToResourcesWorkingInPeriod") + ":"));
        jPanel3.add((Component)new JLabel(Common.I18N_RP.getString("email.startDate") + ":"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        jPanel3.add((Component)this.startDatePicker, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel3.add((Component)new JLabel(Common.I18N_RP.getString("email.endDate") + ":"), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        jPanel3.add((Component)this.endDatePicker, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 23, 0, insets, 0, 0));
        n = 0;
        this.add((Component)jPanel3, new GridBagConstraints(0, n++, 2, 1, 1.0, 0.0, 23, 2, insets, 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, n++, 2, 1, 1.0, 1.0, 23, 1, insets, 0, 0));
        this.add((Component)new JLabel(Common.I18N_RP.getString("emailTemplate") + ":"), new GridBagConstraints(0, n++, 2, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        this.add((Component)new JScrollPane(this.emailTextArea), new GridBagConstraints(0, n++, 2, 1, 1.0, 1.0, 23, 1, insets, 0, 0));
        JPanel jPanel4 = new JPanel(new GridLayout(1, 2));
        jPanel4.add(jButton2);
        jPanel4.add(jButton);
        this.add((Component)jPanel4, new GridBagConstraints(1, n++, 1, 1, 0.0, 0.0, 24, 0, insets, 0, 0));
    }

    private void setColumnsWidth() {
        this.table.getColumn("!").setMinWidth(20);
        this.table.getColumn("!").setMaxWidth(20);
        this.table.getColumn("!").setPreferredWidth(20);
    }

    private List<NotificationResource> getNotificationResources() {
        LinkedList<HumanResource> linkedList = new LinkedList<HumanResource>();
        LinkedList<NotificationResource> linkedList2 = new LinkedList<NotificationResource>();
        this.computeResources(this.project, linkedList);
        for (HumanResource humanResource : linkedList) {
            linkedList2.add(new NotificationResource(humanResource));
        }
        this.selectResources(this.project, linkedList2);
        return linkedList2;
    }

    private void computeResources(Task task, List<HumanResource> list) {
        if (this.showAllResources.isSelected()) {
            for (HumanResource humanResource : task.getCompany().getHumanResources()) {
                if (humanResource.isEmpty()) continue;
                list.add(humanResource);
            }
        } else {
            for (HumanResource humanResource : task.getCompany().getHumanResources()) {
                if (humanResource.isEmpty()) continue;
                boolean bl = false;
                Iterator<Assignment> iterator = humanResource.getAssignments().iterator();
                while (iterator.hasNext()) {
                    Task task2 = iterator.next().getTask();
                    if (!this.intersects(task2, this.startDate, this.endDate)) continue;
                    bl = true;
                }
                if (!bl) continue;
                list.add(humanResource);
            }
        }
    }

    private void selectResources(Task task, List<NotificationResource> list) {
        for (NotificationResource notificationResource : list) {
            HumanResource humanResource = notificationResource.getResource();
            boolean bl = false;
            Iterator<Assignment> iterator = humanResource.getAssignments().iterator();
            while (iterator.hasNext()) {
                Task task2 = iterator.next().getTask();
                if (!this.intersects(task2, this.startDate, this.endDate)) continue;
                bl = true;
            }
            notificationResource.selected = bl;
        }
    }

    private boolean intersects(Task task, Date date, Date date2) {
        return task.getStartDate().after(this.startDate) ? task.getStartDate().before(this.endDate) : task.getEndDate().after(this.startDate);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NotificationResourcesTableModel
    extends AbstractTableModel {
        protected List titles;
        protected List columnsType;
        private List<NotificationResource> resources;

        public NotificationResourcesTableModel(List<NotificationResource> list) {
            this.resources = list;
            this.titles = new LinkedList();
            this.columnsType = new LinkedList();
            this.titles.add("!");
            this.titles.add(Common.I18N_RP.getString("resourceName"));
            this.titles.add(Common.I18N_RP.getString("resourceEmail"));
            this.columnsType.add(Boolean.class);
            this.columnsType.add(String.class);
            this.columnsType.add(String.class);
        }

        @Override
        public int getRowCount() {
            return this.resources.size();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 1;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            NotificationResource notificationResource = this.resources.get(n);
            if (n2 == 0) {
                return notificationResource.selected;
            }
            if (n2 == 1) {
                return notificationResource.resource.getName();
            }
            if (n2 == 2) {
                return notificationResource.resource.getEmail();
            }
            return "";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            NotificationResource notificationResource = this.resources.get(n);
            if (n2 == 0) {
                notificationResource.selected = Boolean.parseBoolean(object.toString());
                this.fireTableRowsUpdated(n, n);
            } else if (n2 == 2) {
                notificationResource.getResource().setEmail(object.toString());
                this.fireTableRowsUpdated(n, n);
            }
        }

        public Class getColumnClass(int n) {
            return (Class)this.columnsType.get(n);
        }

        @Override
        public String getColumnName(int n) {
            return (String)this.titles.get(n);
        }

        @Override
        public int getColumnCount() {
            return this.titles.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NotificationResource {
        private boolean selected;
        private HumanResource resource;
        private List<Task> tasks;

        public NotificationResource(HumanResource humanResource) {
            this.resource = humanResource;
            this.tasks = new LinkedList<Task>();
            Iterator<Assignment> iterator = humanResource.getAssignments().iterator();
            while (iterator.hasNext()) {
                Task task = iterator.next().getTask();
                if (!JEmailNotificationDialog.this.intersects(task, JEmailNotificationDialog.this.startDate, JEmailNotificationDialog.this.endDate)) continue;
                this.tasks.add(task);
            }
        }

        public List<Task> getTasks() {
            return this.tasks;
        }

        public HumanResource getResource() {
            return this.resource;
        }

        public boolean isSelected() {
            return this.selected;
        }
    }
}

