/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Dependency;
import com.sbs.jpm.core.DependencyManager;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.ui.JProject;
import com.sbs.jpm.ui.UIManager;
import com.sbs.jpm.ui.action.ActionMapper;
import com.sbs.jpm.ui.component.JAreaView;
import com.sbs.jpm.ui.component.model.AbstractDependencyTableModel;
import com.sbs.jpm.ui.component.model.DependencyTableModel;
import com.sbs.jpm.ui.component.model.PredecessorsTableModel;
import com.sbs.jpm.ui.component.renderer.CellEditorInvertedColorAndBorderModel;
import com.sbs.jpm.ui.component.renderer.ComboBoxRenderer;
import com.sbs.jpm.ui.component.util.ComboBoxCompletion;
import com.sbs.jpm.ui.component.util.LagFormat;
import com.sbs.jpm.ui.component.view.JProjectViewGantt;
import com.sbs.jpm.ui.treetablechart.JGanttTreeTable;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import com.sbs.jpm.undo.TaskRemoveDependencyEdit;
import com.sbs.util.SystemUtilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.InternationalFormatter;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JDependencyTable
extends JXTable {
    protected Action deleteAction;
    protected Action gotoTaskAction;
    protected JPopupMenu popupMenu;
    protected EventListenerList listeners;
    protected final JComboBox tasksCombo;
    protected ComboBoxCompletion automaticCompletion;
    private static final JComboBox typeCombo = new JComboBox<String>(DependencyManager.getDependencyList());
    private static final JFormattedTextField formattedTextField;

    public JDependencyTable() {
        super((TableModel)new DependencyTableModel());
        if (SystemUtilities.isOSMac()) {
            this.setSurrendersFocusOnKeystroke(false);
        } else {
            this.setSurrendersFocusOnKeystroke(true);
        }
        this.listeners = new EventListenerList();
        this.tasksCombo = new JComboBox();
        this.tasksCombo.setBorder(BorderFactory.createEmptyBorder(-1, 0, -1, -1));
        this.tasksCombo.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object != null) {
                    Task task = (Task)object;
                    String string = UIManager.getInstance().isShowTaskOutline() ? task.getOutlineNumber() + " " + task.getName() : task.getName();
                    Component component = super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
                    if (component instanceof JComponent) {
                        ((JComponent)component).setToolTipText("<html><b>" + Common.I18N_RP.getString("fromProject") + ":</b> " + task.getProjectTask().getName() + "<html>");
                    }
                    return component;
                }
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        });
        this.tasksCombo.setEditable(true);
        this.automaticCompletion = new ComboBoxCompletion(this.tasksCombo);
        this.setSelectionMode(0);
        this.setSortable(false);
        if (SystemUtilities.isOSMac()) {
            this.putClientProperty("Quaqua.Table.style", "striped");
            this.setShowHorizontalLines(false);
            this.setShowVerticalLines(true);
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(127, 0);
        this.deleteAction = new DeleteAction(null, new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/sbs/jpm/ui/images/delete.png")));
        this.deleteAction.putValue("AcceleratorKey", keyStroke);
        this.deleteAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("dependency.delete"));
        this.gotoTaskAction = new GotoTaskAction(null, new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/sbs/jpm/ui/images/selectTaskLine.png"))){};
        this.gotoTaskAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("selectTaskInGantt"));
        ActionMap actionMap = this.getActionMap();
        actionMap.put("delete", this.deleteAction);
        this.getInputMap(1).put(keyStroke, "delete");
        ActionMapper actionMapper = ActionMapper.getInstance();
        actionMapper.mapActions((JComponent)((Object)this));
        this.popupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(this.deleteAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("dependency.delete"));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.gotoTaskAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("selectTaskInGantt"));
        this.popupMenu.add(jMenuItem);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            private void showPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    int n = JDependencyTable.this.rowAtPoint(mouseEvent.getPoint());
                    int[] nArray = JDependencyTable.this.getSelectedRows();
                    boolean bl = false;
                    if (nArray != null) {
                        for (int i = 0; i < nArray.length; ++i) {
                            int n2 = nArray[i];
                            if (n2 != n) continue;
                            bl = true;
                        }
                    }
                    if (!bl) {
                        JDependencyTable.this.getSelectionModel().setSelectionInterval(n, n);
                    }
                    JDependencyTable.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    private void setPopup() {
    }

    public void selected() {
        this.highlightNextInputCell();
    }

    public void highlightNextInputCell() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (JDependencyTable.this.getModel().getRowCount() > 0) {
                    JDependencyTable.this.getSelectionModel().setSelectionInterval(JDependencyTable.this.getModel().getRowCount() - 1, JDependencyTable.this.getModel().getRowCount() - 1);
                }
            }
        });
    }

    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        Component component = super.prepareEditor(tableCellEditor, n, n2);
        if (component instanceof JTextComponent) {
            ((JTextField)component).selectAll();
        }
        return component;
    }

    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        TableColumnModel tableColumnModel = this.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(200);
        tableColumnModel.getColumn(1).setPreferredWidth(150);
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        if (this.automaticCompletion != null) {
            this.automaticCompletion.setModel(defaultComboBoxModel);
        }
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(typeCombo){

            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                JComboBox jComboBox = (JComboBox)super.getTableCellEditorComponent(jTable, object, bl, n, n2);
                jComboBox.setSelectedItem(object);
                return jComboBox;
            }

            public boolean isCellEditable(EventObject eventObject) {
                if (eventObject == null) {
                    return super.isCellEditable(eventObject);
                }
                JDependencyTable jDependencyTable = (JDependencyTable)((Object)eventObject.getSource());
                if (eventObject instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)eventObject;
                    if (mouseEvent.getClickCount() > 1) {
                        return true;
                    }
                    return jDependencyTable.getSelectedRow() == jDependencyTable.rowAtPoint(mouseEvent.getPoint());
                }
                return true;
            }
        };
        this.getColumn(PredecessorsTableModel.TYPE).setCellEditor(defaultCellEditor);
        List<Task> list = ((AbstractDependencyTableModel)tableModel).getTasks();
        if (!list.isEmpty()) {
            boolean bl = true;
            for (Task object : list) {
                if (!object.isEmpty() && (object.getParent() == null || !object.getParent().isSplitted())) continue;
                bl = false;
            }
            this.setTaskEditor();
            if (bl) {
                this.reloadTasks(list);
                List<Task> list2 = list.get(0).getCompany().getRootTask().getTaskList(false);
                CellEditorInvertedColorAndBorderModel cellEditorInvertedColorAndBorderModel = new CellEditorInvertedColorAndBorderModel();
                this.getColumn(AbstractDependencyTableModel.TYPE).setCellRenderer(new ComboBoxRenderer(DependencyManager.getDependencyList(), cellEditorInvertedColorAndBorderModel, !SystemUtilities.isOSMac(), false, true));
                this.setTaskRenderer(list2);
            }
        }
        this.getColumn(PredecessorsTableModel.LAG).setCellEditor(new LagCellEditor(formattedTextField));
        this.getColumn(PredecessorsTableModel.LAG).setCellRenderer(new LagCellRenderer());
        this.highlightNextInputCell();
    }

    protected abstract void setTaskEditor();

    protected abstract void setTaskRenderer(List<Task> var1);

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    protected void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(UndoableEditListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((UndoableEditListener)eventListenerArray[i]).undoableEditHappened(undoableEditEvent);
        }
    }

    private void reloadTasks(List<Task> list) {
        List<Task> list2 = list.get(0).getCompany().getRootTask().getTaskList(false);
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(list2.toArray());
        this.automaticCompletion.setModel(defaultComboBoxModel);
    }

    static {
        typeCombo.setBorder(BorderFactory.createEmptyBorder(-1, -1, -1, -1));
        formattedTextField = new JFormattedTextField();
    }

    class DeleteAction
    extends AbstractAction {
        public DeleteAction(String string, Icon icon) {
            super(string, icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JDependencyTable.this.getSelectedRowCount() == 1) {
                Dependency[] dependencyArray;
                int n;
                AbstractDependencyTableModel abstractDependencyTableModel;
                if (JDependencyTable.this.getCellEditor() != null) {
                    JDependencyTable.this.getCellEditor().cancelCellEditing();
                }
                if (!(abstractDependencyTableModel = (AbstractDependencyTableModel)JDependencyTable.this.getModel()).isParentSplitted() && (n = JDependencyTable.this.getSelectedRow()) != abstractDependencyTableModel.getRowCount() - 1 && (dependencyArray = abstractDependencyTableModel.getDependencies().get(n).getDependencies().toArray(new Dependency[0])).length > 0) {
                    ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(dependencyArray[0].getSuccessor());
                    for (int i = 0; i < dependencyArray.length; ++i) {
                        Dependency dependency = dependencyArray[i];
                        TaskRemoveDependencyEdit taskRemoveDependencyEdit = new TaskRemoveDependencyEdit(dependency, "01-10-2009 19:26:00");
                        Task.removeDependency(dependency);
                        extendedCompoundEdit.addEdit(taskRemoveDependencyEdit);
                    }
                    extendedCompoundEdit.end();
                    TaskPlanner.rescheduleTree(dependencyArray[0].getSuccessor());
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                    JDependencyTable.this.fireUndoableEditHappened(undoableEditEvent);
                    JDependencyTable.this.getSelectionModel().setSelectionInterval(n, n);
                }
            }
        }
    }

    class GotoTaskAction
    extends AbstractAction {
        public GotoTaskAction(String string, Icon icon) {
            super(string, icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractDependencyTableModel abstractDependencyTableModel;
            int n;
            if (JDependencyTable.this.getSelectedRowCount() == 1 && (n = JDependencyTable.this.getSelectedRow()) != (abstractDependencyTableModel = (AbstractDependencyTableModel)JDependencyTable.this.getModel()).getRowCount() - 1) {
                JProject jProject = Common.getApplication().getWorkspace().getJProject();
                if (!jProject.getGanttButton().isSelected()) {
                    jProject.getGanttButton().doClick();
                }
                JAreaView jAreaView = jProject.getAreaView();
                JProjectViewGantt jProjectViewGantt = (JProjectViewGantt)jAreaView.getActiveViewComponent();
                JGanttTreeTable jGanttTreeTable = (JGanttTreeTable)jProjectViewGantt.getGantt().getTreeTable();
                Task task = ((AbstractDependencyTableModel)JDependencyTable.this.getModel()).getDependencies().get(n).getTask();
                Task task2 = jGanttTreeTable.getProject();
                if (!task.getProjectTask().equals(task2) && !task.getProjectTask().isDescendent(task2)) {
                    Common.getApplication().getWorkspace().getJProject().setCurrentProject(task2.getCompany().getRootTask());
                    jGanttTreeTable.revalidate();
                }
                TreePath treePath = new TreePath(task.getPath(task2).toArray());
                jGanttTreeTable.scrollPathToVisible(treePath);
                jGanttTreeTable.getTreeSelectionModel().setSelectionPath(treePath);
            }
        }
    }

    private class LagCellEditor
    extends DefaultCellEditor {
        private JFormattedTextField lagDuration;

        public LagCellEditor(JFormattedTextField jFormattedTextField) {
            super(jFormattedTextField);
            this.lagDuration = jFormattedTextField;
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                public void setValue(Object object) {
                    LagCellEditor.this.lagDuration.setValue(object);
                }

                public Object getCellEditorValue() {
                    return LagCellEditor.this.lagDuration.getValue();
                }

                public boolean stopCellEditing() {
                    try {
                        LagCellEditor.this.lagDuration.commitEdit();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    return super.stopCellEditing();
                }
            };
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object != null) {
                List<AbstractDependencyTableModel.TaskDependencies> list = ((AbstractDependencyTableModel)jTable.getModel()).getDependencies();
                Dependency dependency = list.get(n).getDependencies().get(0);
                LagFormat lagFormat = new LagFormat();
                lagFormat.setDependency(dependency);
                this.lagDuration.setFormatterFactory(new DefaultFormatterFactory(new InternationalFormatter(lagFormat)));
            }
            this.lagDuration.setValue((Long)object);
            return this.lagDuration;
        }
    }

    private class LagCellRenderer
    extends DefaultTableCellRenderer {
        public LagCellRenderer() {
            this.setHorizontalAlignment(4);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return super.getTableCellRendererComponent(jTable, null, bl, bl2, n, n2);
            }
            List<AbstractDependencyTableModel.TaskDependencies> list = ((AbstractDependencyTableModel)jTable.getModel()).getDependencies();
            Dependency dependency = list.get(n).getDependencies().get(0);
            String string = dependency.getUnit();
            String string2 = (Long)object / ((AbstractDependencyTableModel)jTable.getModel()).getTasks().get(0).getProjectTask().getDurationManager().getDuration(string) + string;
            return super.getTableCellRendererComponent(jTable, string2, bl, bl2, n, n2);
        }
    }

    protected class TaskComboCellEditor
    extends ComboBoxCellEditor {
        public TaskComboCellEditor(JComboBox jComboBox) {
            super(jComboBox);
            JComponent jComponent = (JComponent)jComboBox.getEditor().getEditorComponent();
            jComponent.addKeyListener(new KeyHandler());
            jComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getModifiers() == 16) {
                        TaskComboCellEditor.this.stopEditing();
                    }
                }
            });
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            JComboBox jComboBox = (JComboBox)super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            List<Task> list = ((AbstractDependencyTableModel)JDependencyTable.this.dataModel).getTasks();
            if (!list.isEmpty()) {
                boolean bl2 = true;
                for (Task task : list) {
                    if (!task.isEmpty() && (task.getParent() == null || !task.getParent().isSplitted())) continue;
                    bl2 = false;
                }
                if (bl2) {
                    JDependencyTable.this.reloadTasks(list);
                }
            }
            jComboBox.setSelectedItem(object);
            return jComboBox;
        }

        public Object getCellEditorValue() {
            Object object = super.getCellEditorValue();
            if (object instanceof String && object.equals("")) {
                return null;
            }
            return object;
        }

        public void cancelCellEditing() {
            JDependencyTable.this.automaticCompletion.stopEditing();
            this.fireEditingCanceled();
        }

        public void stopEditing() {
            JDependencyTable.this.automaticCompletion.stopEditing();
            super.stopCellEditing();
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject == null) {
                return super.isCellEditable(eventObject);
            }
            JDependencyTable jDependencyTable = (JDependencyTable)((Object)eventObject.getSource());
            if (eventObject instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                if (mouseEvent.getClickCount() > 1) {
                    return true;
                }
                return jDependencyTable.getSelectedRow() == jDependencyTable.rowAtPoint(mouseEvent.getPoint());
            }
            return true;
        }

        private class KeyHandler
        extends KeyAdapter {
            private KeyHandler() {
            }

            public void keyReleased(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 27) {
                    if (JDependencyTable.this.isEditing()) {
                        TaskComboCellEditor.this.cancelCellEditing();
                    } else {
                        JDependencyTable.this.editCellAt(JDependencyTable.this.getSelectedRow(), JDependencyTable.this.getSelectedColumn());
                    }
                }
            }
        }
    }
}

