/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.core.Client;
import com.sbs.jpm.core.Contact;
import com.sbs.jpm.ui.action.ActionMapper;
import com.sbs.jpm.ui.component.model.ContactsTableModel;
import com.sbs.jpm.undo.ClientRemoveContactEdit;
import com.sbs.util.SystemUtilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.JXTable;

public class JContactsTable
extends JXTable {
    private Client client;
    private EventListenerList listeners = new EventListenerList();

    public JContactsTable() {
        super((TableModel)new ContactsTableModel());
        this.setSortable(false);
        if (SystemUtilities.isOSMac()) {
            this.putClientProperty("Quaqua.Table.style", "striped");
            this.setShowHorizontalLines(false);
            this.setShowVerticalLines(true);
        }
        ActionMap actionMap = this.getActionMap();
        actionMap.put("delete", new AbstractAction("delete contact"){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JContactsTable.this.getSelectedRowCount() == 1) {
                    ContactsTableModel contactsTableModel = (ContactsTableModel)JContactsTable.this.getModel();
                    Client client = contactsTableModel.getClient();
                    if (JContactsTable.this.getSelectedRow() != contactsTableModel.getRowCount() - 1) {
                        Contact contact = client.getContactAt(JContactsTable.this.getSelectedRow());
                        ClientRemoveContactEdit clientRemoveContactEdit = new ClientRemoveContactEdit(client, contact, 1);
                        client.removeContact(contact);
                        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, clientRemoveContactEdit);
                        JContactsTable.this.fireUndoableEditHappened(undoableEditEvent);
                    }
                }
            }
        });
        KeyStroke keyStroke = KeyStroke.getKeyStroke(127, 0);
        this.getInputMap(1).put(keyStroke, "delete");
        ActionMapper actionMapper = ActionMapper.getInstance();
        actionMapper.mapActions((JComponent)((Object)this));
        if (SystemUtilities.isOSMac()) {
            this.setSurrendersFocusOnKeystroke(false);
        } else {
            this.setSurrendersFocusOnKeystroke(true);
        }
    }

    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        Component component = super.prepareEditor(tableCellEditor, n, n2);
        if (component instanceof JTextComponent) {
            ((JTextField)component).selectAll();
        }
        return component;
    }

    public void setClient(Client client) {
        this.client = client;
        if (client != null) {
            this.setModel(new ContactsTableModel(client));
        } else {
            this.setModel(new ContactsTableModel());
        }
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    private void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(UndoableEditListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((UndoableEditListener)eventListenerArray[i]).undoableEditHappened(undoableEditEvent);
        }
    }
}

