/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Client;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.field.FieldAdapter;
import com.sbs.jpm.core.field.FieldEvent;
import com.sbs.jpm.core.field.FieldManager;
import com.sbs.jpm.print.CustomPageable;
import com.sbs.jpm.print.PrintManager;
import com.sbs.jpm.ui.action.ActionMapper;
import com.sbs.jpm.ui.component.JEditClientColumnDialog;
import com.sbs.jpm.ui.component.JInsertColumnDialog;
import com.sbs.jpm.ui.component.JRowHeader;
import com.sbs.jpm.ui.component.model.ClientsTableModel;
import com.sbs.jpm.ui.component.view.JProjectViewClients;
import com.sbs.jpm.undo.UndoHandler;
import com.sbs.util.SystemUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.FilterPipeline;

public class JClientsTable
extends JXTable
implements Printable,
CustomPageable {
    private static final long serialVersionUID = 1L;
    private int totalVerticalNumPages;
    private int totalHorizontalNumPages;
    private double pageHeight;
    private double pageWidth;
    private double headerHeightOnPage;
    private double tableWidth;
    protected JPopupMenu headerPopup;
    protected JMenuItem insertItem;
    protected JMenuItem hideItem;
    protected JMenuItem editItem;
    private int popupColumn;
    private Task project;
    private UndoHandler undoHandler;
    private EventListenerList listeners = new EventListenerList();
    private JProjectViewClients projectView;
    private static final JComboBox contactsCombo = new JComboBox();

    public JClientsTable() {
        super((TableModel)new ClientsTableModel());
        this.setColumnControlVisible(true);
        this.setSortable(false);
        if (SystemUtilities.isOSMac()) {
            this.setSurrendersFocusOnKeystroke(false);
        } else {
            this.setSurrendersFocusOnKeystroke(true);
        }
        this.setHeaderWidths();
        this.setRenderersAndEditors();
        this.headerPopup = new JPopupMenu();
        this.hideItem = new JMenuItem(Common.I18N_ACTIONS.getString("hideColumn"));
        this.hideItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JClientsTable.this.getColumnExt(JClientsTable.this.popupColumn).setVisible(false);
            }
        });
        this.insertItem = new JMenuItem(Common.I18N_ACTIONS.getString("insertColumn") + "...");
        this.insertItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                List list = JClientsTable.this.getColumns(true);
                List list2 = JClientsTable.this.getColumns();
                list.removeAll(list2);
                if (!list.isEmpty()) {
                    JInsertColumnDialog jInsertColumnDialog = new JInsertColumnDialog(JClientsTable.this, list, JClientsTable.this.popupColumn);
                    jInsertColumnDialog.pack();
                    jInsertColumnDialog.setLocationRelativeTo(Common.getApplication());
                    jInsertColumnDialog.setVisible(true);
                }
            }
        });
        this.editItem = new JMenuItem(Common.I18N_ACTIONS.getString("editColumn") + "...");
        this.editItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JEditClientColumnDialog jEditClientColumnDialog = new JEditClientColumnDialog(JClientsTable.this, JClientsTable.this.popupColumn);
                jEditClientColumnDialog.pack();
                jEditClientColumnDialog.setLocationRelativeTo(Common.getApplication());
                jEditClientColumnDialog.setVisible(true);
            }
        });
        this.headerPopup.add(this.hideItem);
        this.headerPopup.add(this.insertItem);
        this.headerPopup.add(this.editItem);
        FieldManager.getInstance().addFieldListener(new FieldAdapter(){

            public void clientNameChanged(FieldEvent fieldEvent) {
                int n = fieldEvent.getClientIndex();
                String string = fieldEvent.getName();
                int n2 = JClientsTable.this.getModel().getColumnCount() - 10 + n;
                String string2 = JClientsTable.this.getModel().getColumnName(n2);
                ((ClientsTableModel)JClientsTable.this.getModel()).setColumnName(n2, string);
                JClientsTable.this.getColumnExt(string2).setHeaderValue((Object)string);
                JClientsTable.this.getTableHeader().resizeAndRepaint();
            }
        });
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            private void showPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    JClientsTable.this.popupColumn = JClientsTable.this.getTableHeader().columnAtPoint(mouseEvent.getPoint());
                    if (JClientsTable.this.popupColumn != -1) {
                        List list = JClientsTable.this.getColumns(true);
                        List list2 = JClientsTable.this.getColumns();
                        list.removeAll(list2);
                        JClientsTable.this.insertItem.setEnabled(!list.isEmpty());
                        int n = JClientsTable.this.convertColumnIndexToModel(JClientsTable.this.popupColumn);
                        JClientsTable.this.editItem.setEnabled(n >= JClientsTable.this.getModel().getColumnCount() - 10 && JClientsTable.this.popupColumn != -1);
                        JClientsTable.this.headerPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        });
        if (SystemUtilities.isOSMac()) {
            this.putClientProperty("Quaqua.Table.style", "striped");
            this.setShowHorizontalLines(false);
            this.setShowVerticalLines(true);
        }
        ActionMapper actionMapper = ActionMapper.getInstance();
        actionMapper.mapActions((JComponent)((Object)this));
    }

    public void setAutoResizeMode(int n) {
        super.setAutoResizeMode(0);
    }

    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        Component component = super.prepareEditor(tableCellEditor, n, n2);
        if (component instanceof JTextComponent) {
            ((JTextField)component).selectAll();
        }
        return component;
    }

    public void setFilters(FilterPipeline filterPipeline) {
    }

    private void setHeaderWidths() {
        this.getColumn(ClientsTableModel.NAME).setPreferredWidth(250);
        this.getColumn(ClientsTableModel.MAIN_CONTACT).setPreferredWidth(150);
        this.getColumn(ClientsTableModel.EMAIL).setPreferredWidth(150);
        this.getColumn(ClientsTableModel.PHONE).setPreferredWidth(100);
        this.getColumn(ClientsTableModel.ADDRESS).setPreferredWidth(250);
        this.getColumn(ClientsTableModel.SITE).setPreferredWidth(100);
    }

    private void setRenderersAndEditors() {
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(contactsCombo){

            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                JComboBox jComboBox = (JComboBox)super.getTableCellEditorComponent(jTable, object, bl, n, n2);
                Client client = JClientsTable.this.project.getCompany().getClientAt(n);
                jComboBox.setModel(new DefaultComboBoxModel<Object>(client.getContacts().toArray()));
                jComboBox.setSelectedItem(object);
                return jComboBox;
            }
        };
        this.getColumn(ClientsTableModel.MAIN_CONTACT).setCellEditor(defaultCellEditor);
    }

    public void setProject(Task task) {
        this.project = task;
        this.removeUndoableEditListener(this.undoHandler);
        ((ClientsTableModel)this.getModel()).removeUndoableEditListener(this.undoHandler);
        this.undoHandler = new UndoHandler(task.getCompany().getUndoManager());
        ClientsTableModel clientsTableModel = new ClientsTableModel(this, task.getCompany());
        this.addUndoableEditListener(this.undoHandler);
        clientsTableModel.addUndoableEditListener(this.undoHandler);
        this.setModel(clientsTableModel);
        this.setHeaderWidths();
        this.setRenderersAndEditors();
        for (int i = 1; i <= 10; ++i) {
            this.getColumnExt(FieldManager.CUSTOM_NAME + i).setVisible(false);
        }
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    private void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(UndoableEditListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((UndoableEditListener)eventListenerArray[i]).undoableEditHappened(undoableEditEvent);
        }
    }

    private void computeValues() {
        PageFormat pageFormat = this.getPageFormat(0);
        this.pageHeight = pageFormat.getImageableHeight() * 1.3 / PrintManager.ZOOM - 2.0 - 20.0;
        this.pageWidth = pageFormat.getImageableWidth() * 1.3 / PrintManager.ZOOM - 2.0 - 2.0;
        this.tableWidth = (double)this.getColumnModel().getTotalColumnWidth() + (double)this.projectView.getRowHeader().getWidth();
        this.headerHeightOnPage = this.getTableHeader().getHeight();
        double d = this.getRowHeight();
        if (PrintManager.isShowHeader()) {
            int n = (int)((this.pageHeight - this.headerHeightOnPage) / d);
            this.totalVerticalNumPages = (int)Math.ceil(((double)this.getRowCount() - 50.0) / (double)n);
        } else {
            int n = (int)(this.pageHeight / d);
            int n2 = (int)((this.pageHeight - this.headerHeightOnPage) / d);
            this.totalVerticalNumPages = (int)Math.ceil(((double)this.getRowCount() - 50.0 - (double)n2) / (double)n) + 1;
        }
        this.totalHorizontalNumPages = (int)Math.ceil(this.tableWidth / this.pageWidth);
    }

    public int getNumberOfPages() {
        this.computeValues();
        return this.totalHorizontalNumPages * this.totalVerticalNumPages;
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        return Common.getApplication().getPageFormat();
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        return this;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.clearSelection();
        this.getTableHeader().setBackground(Color.WHITE);
        this.projectView.getRowHeader().setBackground(Color.WHITE);
        this.setBackground(Color.WHITE);
        graphics2D.scale(1.0 / (1.3 / PrintManager.ZOOM), 1.0 / (1.3 / PrintManager.ZOOM));
        graphics2D.setColor(Color.BLACK);
        int n3 = graphics2D.getFontMetrics().getDescent();
        this.computeValues();
        double d = this.getRowHeight();
        int n4 = (int)((this.pageHeight - this.headerHeightOnPage) / d);
        int n5 = (int)(this.pageHeight / d);
        double d2 = d * (double)n4;
        double d3 = d * (double)n5;
        int n6 = this.totalHorizontalNumPages;
        int n7 = this.totalHorizontalNumPages * this.totalVerticalNumPages;
        if (n >= n7) {
            return 1;
        }
        graphics2D.translate(pageFormat.getImageableX() * 1.3 / PrintManager.ZOOM, pageFormat.getImageableY() * 1.3 / PrintManager.ZOOM);
        graphics2D.drawLine(0, 1, 2 + (int)this.pageWidth + 2, 1);
        graphics2D.drawLine(0, (int)(2.0 + this.pageHeight), 2 + (int)this.pageWidth + 1, (int)(2.0 + this.pageHeight));
        graphics2D.drawLine(0, (int)(2.0 + this.pageHeight + 20.0), 2 + (int)this.pageWidth + 2, (int)(2.0 + this.pageHeight + 20.0));
        graphics2D.drawLine(0, 2, 0, (int)(2.0 + this.pageHeight + 20.0));
        graphics2D.drawLine(2 + (int)this.pageWidth + 2, 2, 2 + (int)this.pageWidth + 2, (int)(2.0 + this.pageHeight + 20.0));
        String string = Common.I18N_RP.getString("Project") + ": " + this.project.getName() + "     " + Common.I18N_RP.getString("Manager") + ": " + this.project.getManager();
        graphics2D.drawString(string, 2, (int)(2.0 + this.pageHeight + 20.0 - (double)n3));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd, yyyy");
        string = Common.I18N_RP.getString("Page") + ": " + (n + 1) + "/" + this.getNumberOfPages() + "     " + Common.I18N_RP.getString("date") + ": " + simpleDateFormat.format(new Date());
        int n8 = graphics2D.getFontMetrics().stringWidth(string);
        graphics2D.drawString(string, (int)(2.0 + this.pageWidth - (double)n8), (int)(2.0 + this.pageHeight + 20.0 - (double)n3));
        graphics2D.translate(2, 2);
        int n9 = n / this.totalHorizontalNumPages;
        int n10 = n % this.totalHorizontalNumPages;
        JRowHeader jRowHeader = this.projectView.getRowHeader();
        int n11 = n10 < n6 - 1 ? (n10 == 0 ? (int)Math.ceil(this.pageWidth) - this.projectView.getRowHeader().getWidth() : (int)Math.ceil(this.pageWidth)) : (int)Math.ceil(this.tableWidth - (double)n10 * this.pageWidth);
        if (n9 + 1 == this.totalVerticalNumPages) {
            if (!PrintManager.isShowHeader()) {
                int n12 = n9 == 0 ? 0 : n4 + n5 * (n9 - 1);
                int n13 = this.getRowCount() - 50 - n12;
                n2 = (int)Math.ceil(d * (double)n13);
            } else {
                int n14 = n4 * n9;
                int n15 = this.getRowCount() - 50 - n14;
                n2 = (int)Math.ceil(d * (double)n15);
            }
        } else {
            n2 = !PrintManager.isShowHeader() ? (n9 == 0 ? (int)Math.ceil(d2) : (int)Math.ceil(d3)) : (int)Math.ceil(d2);
        }
        if (n9 == 0 || n9 != 0 && PrintManager.isShowHeader()) {
            graphics2D.translate((double)(-n10) * this.pageWidth + (double)jRowHeader.getWidth(), 0.0);
            if (n10 == 0) {
                graphics2D.setClip((int)((double)n10 * this.pageWidth), 0, n11, (int)Math.ceil(this.headerHeightOnPage));
            } else {
                graphics2D.setClip((int)((double)n10 * this.pageWidth) - jRowHeader.getWidth(), 0, n11, (int)Math.ceil(this.headerHeightOnPage));
            }
            PrintManager.bufferAndPaint(graphics2D, this.getTableHeader());
            graphics2D.translate((double)n10 * this.pageWidth - (double)jRowHeader.getWidth(), this.headerHeightOnPage);
        }
        if (n10 == 0) {
            if (PrintManager.isShowHeader()) {
                graphics2D.translate((double)(-n10) * this.pageWidth, (double)(-((int)(d2 * (double)n9))));
            } else if (n9 == 0) {
                graphics2D.translate((double)(-n10) * this.pageWidth, 0.0);
            } else {
                graphics2D.translate((double)(-n10) * this.pageWidth, (double)(-((int)(d2 + d3 * (double)(n9 - 1)))));
            }
            if (PrintManager.isShowHeader()) {
                graphics2D.setClip((int)((double)n10 * this.pageWidth), (int)(d2 * (double)n9), jRowHeader.getWidth(), n2);
            } else if (n9 == 0) {
                graphics2D.setClip((int)((double)n10 * this.pageWidth), 0, jRowHeader.getWidth(), n2);
            } else {
                graphics2D.setClip((int)((double)n10 * this.pageWidth), (int)(d2 + d3 * (double)(n9 - 1)), jRowHeader.getWidth(), n2);
            }
            PrintManager.bufferAndPaint(graphics2D, jRowHeader);
            if (PrintManager.isShowHeader()) {
                graphics2D.translate((double)n10 * this.pageWidth, (double)((int)(d2 * (double)n9)));
            } else if (n9 == 0) {
                graphics2D.translate((double)n10 * this.pageWidth, 0.0);
            } else {
                graphics2D.translate((double)n10 * this.pageWidth, (double)((int)(d2 + d3 * (double)(n9 - 1))));
            }
        }
        if (PrintManager.isShowHeader()) {
            graphics2D.translate((double)(-n10) * this.pageWidth + (double)jRowHeader.getWidth(), (double)(-((int)(d2 * (double)n9))));
        } else if (n9 == 0) {
            graphics2D.translate((double)(-n10) * this.pageWidth + (double)jRowHeader.getWidth(), 0.0);
        } else {
            graphics2D.translate((double)(-n10) * this.pageWidth + (double)jRowHeader.getWidth(), (double)(-((int)(d2 + d3 * (double)(n9 - 1)))));
        }
        if (PrintManager.isShowHeader()) {
            if (n10 == 0) {
                graphics2D.setClip((int)((double)n10 * this.pageWidth), (int)(d2 * (double)n9), n11, n2);
            } else {
                graphics2D.setClip((int)((double)n10 * this.pageWidth) - jRowHeader.getWidth(), (int)(d2 * (double)n9), n11, n2);
            }
        } else if (n10 == 0) {
            if (n9 == 0) {
                graphics2D.setClip((int)((double)n10 * this.pageWidth), 0, n11, n2);
            } else {
                graphics2D.setClip((int)((double)n10 * this.pageWidth), (int)(d2 + d3 * (double)(n9 - 1)), n11, n2);
            }
        } else if (n9 == 0) {
            graphics2D.setClip((int)((double)n10 * this.pageWidth) - jRowHeader.getWidth(), 0, n11, n2);
        } else {
            graphics2D.setClip((int)((double)n10 * this.pageWidth) - jRowHeader.getWidth(), (int)(d2 + d3 * (double)(n9 - 1)), n11, n2);
        }
        PrintManager.bufferAndPaint(graphics2D, (Component)((Object)this));
        if (PrintManager.isShowHeader()) {
            graphics2D.translate((double)n10 * this.pageWidth - (double)jRowHeader.getWidth(), (double)((int)(d2 * (double)n9)));
        } else if (n9 == 0) {
            graphics2D.translate((double)n10 * this.pageWidth - (double)jRowHeader.getWidth(), (double)((int)(d2 * (double)n9)));
        } else {
            graphics2D.translate((double)n10 * this.pageWidth - (double)jRowHeader.getWidth(), (double)((int)(d2 + d3 * (double)(n9 - 1))));
        }
        if (n9 == 0 || n9 != 0 && PrintManager.isShowHeader()) {
            graphics2D.translate(0.0, -this.headerHeightOnPage);
        }
        graphics2D.translate(-2, -2);
        graphics2D.translate(-pageFormat.getImageableX() * 1.3 / PrintManager.ZOOM, -pageFormat.getImageableY() * 1.3 / PrintManager.ZOOM);
        this.getTableHeader().setBackground((Color)UIManager.get("TableHeader.background"));
        this.setBackground((Color)UIManager.get("Table.background"));
        jRowHeader.setBackground((Color)UIManager.get("TableHeader.background"));
        return 0;
    }

    public int getHorizontalNumberOfPages() {
        this.computeValues();
        return this.totalHorizontalNumPages;
    }

    public int getVerticalNumberOfPages() {
        this.computeValues();
        return this.totalVerticalNumPages;
    }

    public Dimension getPrintSize() {
        Dimension dimension = new Dimension();
        dimension.setSize(this.projectView.getRowHeader().getWidth() + this.getWidth(), this.getHeight() - 50 * this.getRowHeight());
        return dimension;
    }

    public Task getProject() {
        return this.project;
    }

    public JProjectViewClients getProjectView() {
        return this.projectView;
    }

    public void setProjectView(JProjectViewClients jProjectViewClients) {
        this.projectView = jProjectViewClients;
    }

    static {
        contactsCombo.setBorder(BorderFactory.createEmptyBorder(-1, -1, -1, -1));
        contactsCombo.setEditable(true);
    }
}

