/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.calendar.DayWorkingPattern;
import com.sbs.jpm.calendar.event.CalendarManagerEvent;
import com.sbs.jpm.calendar.event.CalendarManagerListener;
import com.sbs.jpm.calendar.event.DayWorkingPatternEvent;
import com.sbs.jpm.calendar.event.DayWorkingPatternListener;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.core.event.CompanyAdapter;
import com.sbs.jpm.core.event.CompanyEvent;
import com.sbs.jpm.core.event.CompanyListener;
import com.sbs.jpm.core.event.TaskAdapter;
import com.sbs.jpm.core.event.TaskEvent;
import com.sbs.jpm.core.event.TaskListener;
import com.sbs.jpm.ui.component.JCalendarPeriodTable;
import com.sbs.jpm.ui.component.JReplaceCalendarDialog;
import com.sbs.jpm.ui.component.JWeekTable;
import com.sbs.jpm.ui.component.model.CalendarPeriodTableModel;
import com.sbs.jpm.ui.component.model.WeekTableModel;
import com.sbs.jpm.ui.component.renderer.CustomSpecialDateRenderer;
import com.sbs.jpm.undo.CalendarManagerInsertEdit;
import com.sbs.jpm.undo.CalendarNameEdit;
import com.sbs.jpm.undo.CalendarSpecialPatternAddEdit;
import com.sbs.jpm.undo.CalendarSpecialPatternEdit;
import com.sbs.jpm.undo.CalendarSpecialPatternRemoveEdit;
import com.sbs.jpm.undo.CalendarWeekPatternEdit;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import com.sbs.jpm.undo.TaskCalendarEdit;
import com.sbs.jpm.undo.UndoHandler;
import com.standbysoft.component.date.event.DateSelectionAdapter;
import com.standbysoft.component.date.event.DateSelectionEvent;
import com.standbysoft.component.date.event.DateSelectionListener;
import com.standbysoft.component.date.swing.DateRenderer;
import com.standbysoft.component.date.swing.JMonthView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.TableModel;
import javax.swing.undo.AbstractUndoableEdit;
import org.jdesktop.swingx.JXTable;

public class JCalendarView
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Company company;
    private Task project;
    private TaskListener taskHandler;
    private CompanyListener companyHandler;
    private CalendarManager currentCalendar;
    private JLabel specialPeriodLabel;
    private JComboBox calendarCombo;
    private JComboBox projectCalendarCombo;
    private JLabel curentProjectLabel = new JLabel();
    private JComboBox companyCalendarCombo;
    private JButton createCopyButton;
    private JButton deleteButton;
    private JTable weekTable;
    private JXTable weekPeriodsTable;
    private JXTable specialPeriodsTable;
    private JMonthView month;
    private JRadioButton nonWorking;
    private JRadioButton working;
    private JRadioButton useDefault;
    private JScrollPane specialPeriodsScrollPane;
    private ItemListener calendarItemListener;
    private ItemListener projectCalendarItemListener;
    private ItemListener companyCalendarItemListener;
    private Map<DayWorkingPattern, Calendar> specialPatternToCalendarMap;
    private Map<DayWorkingPattern, Calendar> weekPatternToCalendarMap;
    private SpecialPatternHandler specialPatternHandler;
    private WeekPatternHandler weekPatternHandler;
    private DateSelectionHandler dateSelectionHandler;
    private CalendarManagerHandler calendarManagerHandler;
    private EventListenerList listeners;
    private UndoHandler undoHandler;

    public JCalendarView() {
        this.setLayout(new BorderLayout());
        this.listeners = new EventListenerList();
        this.specialPatternToCalendarMap = new HashMap<DayWorkingPattern, Calendar>();
        this.weekPatternToCalendarMap = new HashMap<DayWorkingPattern, Calendar>();
        this.specialPatternHandler = new SpecialPatternHandler();
        this.weekPatternHandler = new WeekPatternHandler();
        this.dateSelectionHandler = new DateSelectionHandler();
        this.calendarManagerHandler = new CalendarManagerHandler();
        this.taskHandler = new TaskHandler();
        this.companyHandler = new CompanyHandler();
        this.add((Component)this.createContents(), "Center");
        this.projectCalendarItemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    CalendarManager calendarManager = itemEvent.getItem() instanceof CalendarManager ? (CalendarManager)itemEvent.getItem() : null;
                    TaskCalendarEdit taskCalendarEdit = new TaskCalendarEdit(JCalendarView.this.company.getCurrentTask(), JCalendarView.this.company.getCurrentTask().getCalendar(), calendarManager, "09/11/09 12:53:01");
                    ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createReschedulSingleEdit(JCalendarView.this.company.getRootTask(), taskCalendarEdit);
                    JCalendarView.this.company.getCurrentTask().setCalendar(calendarManager);
                    JCalendarView.this.company.getCurrentTask().setDirty(true, true);
                    TaskPlanner.rescheduleTree(JCalendarView.this.company.getCurrentTask());
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                    JCalendarView.this.fireUndoableEditHappened(undoableEditEvent);
                }
            }
        };
        this.companyCalendarItemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    if (!(itemEvent.getItem() instanceof CalendarManager)) {
                        return;
                    }
                    CalendarManager calendarManager = (CalendarManager)itemEvent.getItem();
                    TaskCalendarEdit taskCalendarEdit = new TaskCalendarEdit(JCalendarView.this.company.getRootTask(), JCalendarView.this.company.getRootTask().getCalendar(), calendarManager, "09/11/09 12:53:02");
                    ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createReschedulSingleEdit(JCalendarView.this.company.getRootTask(), taskCalendarEdit);
                    JCalendarView.this.company.getRootTask().setDirty(true, true);
                    JCalendarView.this.company.setCalendarManager(calendarManager);
                    TaskPlanner.rescheduleTree(JCalendarView.this.company.getRootTask());
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                    JCalendarView.this.fireUndoableEditHappened(undoableEditEvent);
                }
            }
        };
        this.calendarItemListener = new CalendarHandler();
    }

    public JTable getWeekTable() {
        return this.weekTable;
    }

    private void setSelectedCalendar(CalendarManager calendarManager) {
        if (this.currentCalendar != null) {
            this.currentCalendar.removeCalendarManagerListener(this.calendarManagerHandler);
        }
        this.currentCalendar = calendarManager;
        this.weekTable.setModel(new WeekTableModel(this.currentCalendar));
        CustomSpecialDateRenderer customSpecialDateRenderer = new CustomSpecialDateRenderer(this.currentCalendar);
        this.month.setDateRenderer((DateRenderer)customSpecialDateRenderer);
        this.month.setSelectedDate(null);
        this.currentCalendar.addCalendarManagerListener(this.calendarManagerHandler);
    }

    public void setProject(Task task) {
        this.removeUndoableEditListener(this.undoHandler);
        ((WeekTableModel)this.weekTable.getModel()).removeUndoableEditListener(this.undoHandler);
        if (this.project != null) {
            this.project.removeTaskListener(this.taskHandler);
            this.company.removeCompanyListener(this.companyHandler);
        }
        this.project = task;
        this.company = task.getCompany();
        this.undoHandler = new UndoHandler(this.company.getUndoManager());
        this.updateValues();
        this.project.addTaskListener(this.taskHandler);
        this.company.addCompanyListener(this.companyHandler);
        this.addUndoableEditListener(this.undoHandler);
        ((WeekTableModel)this.weekTable.getModel()).addUndoableEditListener(this.undoHandler);
    }

    private void removeListeners() {
        this.calendarCombo.removeItemListener(this.calendarItemListener);
        this.projectCalendarCombo.removeItemListener(this.projectCalendarItemListener);
        this.companyCalendarCombo.removeItemListener(this.companyCalendarItemListener);
    }

    private void addListeners() {
        this.calendarCombo.addItemListener(this.calendarItemListener);
        this.projectCalendarCombo.addItemListener(this.projectCalendarItemListener);
        this.companyCalendarCombo.addItemListener(this.companyCalendarItemListener);
    }

    private void updateValues() {
        this.removeListeners();
        List<CalendarManager> list = this.company.getCalendarList();
        this.deleteButton.setEnabled(list.size() > 1);
        LinkedList<CalendarManager> linkedList = new LinkedList<CalendarManager>(list);
        linkedList.add(0, (CalendarManager)((Object)Common.I18N_RP.getString("useCompanyCalendar")));
        this.projectCalendarCombo.setModel(new DefaultComboBoxModel<Object>(linkedList.toArray()));
        if (this.project.getCalendar() == null) {
            this.projectCalendarCombo.setSelectedIndex(0);
        } else {
            this.projectCalendarCombo.setSelectedItem(this.project.getCalendar());
        }
        this.curentProjectLabel.setText("(" + this.project.getName() + ")");
        this.companyCalendarCombo.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        this.companyCalendarCombo.setSelectedItem(this.company.getCalendarManager());
        this.calendarCombo.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        CalendarManager calendarManager = this.project.getCalendar() != null ? this.project.getCalendar() : this.project.getCompany().getCalendarManager();
        this.calendarCombo.setSelectedItem(calendarManager);
        this.setSelectedCalendar(calendarManager);
        this.addListeners();
    }

    private JPanel createHeader() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 5, 5, 5);
        JLabel jLabel = new JLabel(Common.I18N_RP.getString("calendar.edit") + ":");
        this.calendarCombo = new JComboBox();
        this.calendarCombo.setEditable(true);
        this.calendarCombo.revalidate();
        this.calendarCombo.repaint();
        this.createCopyButton = new JButton(Common.I18N_RP.getString("calendar.new"));
        this.createCopyButton.setToolTipText(Common.I18N_RP.getString("calendar.new.tooltip"));
        this.createCopyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CalendarManager calendarManager = (CalendarManager)JCalendarView.this.currentCalendar.clone();
                calendarManager.setName(Common.I18N_RP.getString("copyOf") + " " + JCalendarView.this.currentCalendar.getName());
                CalendarManagerInsertEdit calendarManagerInsertEdit = new CalendarManagerInsertEdit(JCalendarView.this.company, calendarManager, "28-09-2009 12:14:00");
                JCalendarView.this.company.addCalendarManager(calendarManager);
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, calendarManagerInsertEdit);
                JCalendarView.this.fireUndoableEditHappened(undoableEditEvent);
                JCalendarView.this.calendarCombo.setModel(new DefaultComboBoxModel<Object>(JCalendarView.this.company.getCalendarList().toArray()));
                JCalendarView.this.calendarCombo.setSelectedItem(calendarManager);
                JCalendarView.this.deleteButton.setEnabled(true);
            }
        });
        this.deleteButton = new JButton(Common.I18N_RP.getString("calendar.delete"));
        this.deleteButton.setToolTipText(Common.I18N_RP.getString("calendar.delete.tooltip"));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JCalendarView.this.currentCalendar.isUsed()) {
                    LinkedList<CalendarManager> linkedList = new LinkedList<CalendarManager>();
                    linkedList.addAll(JCalendarView.this.company.getCalendarList());
                    linkedList.remove(JCalendarView.this.currentCalendar);
                    JReplaceCalendarDialog jReplaceCalendarDialog = new JReplaceCalendarDialog(Common.getApplication(), JCalendarView.this.currentCalendar, linkedList.toArray(new CalendarManager[0]));
                    jReplaceCalendarDialog.setVisible(true);
                    if (!JCalendarView.this.currentCalendar.isUsed()) {
                        JCalendarView.this.company.removeCalendarManager(JCalendarView.this.currentCalendar);
                        JCalendarView.this.calendarCombo.setSelectedItem(JCalendarView.this.company.getCalendarList().get(0));
                        JCalendarView.this.calendarCombo.setModel(new DefaultComboBoxModel<Object>(JCalendarView.this.company.getCalendarList().toArray()));
                        JCalendarView.this.setSelectedCalendar(JCalendarView.this.company.getCalendarList().get(0));
                    }
                } else {
                    JCalendarView.this.company.removeCalendarManager(JCalendarView.this.currentCalendar);
                    JCalendarView.this.calendarCombo.setSelectedItem(JCalendarView.this.company.getCalendarList().get(0));
                    JCalendarView.this.calendarCombo.setModel(new DefaultComboBoxModel<Object>(JCalendarView.this.company.getCalendarList().toArray()));
                    JCalendarView.this.setSelectedCalendar(JCalendarView.this.company.getCalendarList().get(0));
                }
                if (JCalendarView.this.company.getCalendarList().size() == 1) {
                    JCalendarView.this.deleteButton.setEnabled(false);
                }
            }
        });
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.calendarCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.createCopyButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.deleteButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)new JPanel(), new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        return jPanel;
    }

    private JPanel createProjectPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ""));
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 5, 2, 5);
        JLabel jLabel = new JLabel(Common.I18N_RP.getString("projectCalendar") + ":");
        this.projectCalendarCombo = new JComboBox();
        this.curentProjectLabel.setVisible(false);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.projectCalendarCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.curentProjectLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)new JPanel(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 21, 0, insets, 0, 0));
        this.curentProjectLabel.setForeground(Color.GRAY);
        this.curentProjectLabel.setFont(this.curentProjectLabel.getFont().deriveFont(1));
        return jPanel;
    }

    private JPanel createCompanyPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ""));
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 5, 2, 5);
        JLabel jLabel = new JLabel(Common.I18N_RP.getString("companyCalendar") + ":");
        this.companyCalendarCombo = new JComboBox();
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.companyCalendarCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 0, insets, 0, 0));
        return jPanel;
    }

    private JPanel createContents() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        JPanel jPanel2 = this.createProjectPanel();
        JPanel jPanel3 = this.createCompanyPanel();
        JPanel jPanel4 = this.createCalendarContents();
        jPanel.add((Component)jPanel3, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        jPanel.add((Component)jPanel4, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 21, 1, insets, 0, 0));
        return jPanel;
    }

    private JPanel createCalendarContents() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Common.I18N_RP.getString("calendarEditor")));
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(5, 5, 5, 5);
        JPanel jPanel2 = this.createHeader();
        this.weekTable = new JWeekTable();
        this.weekTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    if (JCalendarView.this.weekTable.getSelectedRowCount() != 0) {
                        JCalendarView.this.weekPeriodsTable.setEnabled(true);
                    } else {
                        JCalendarView.this.weekPeriodsTable.setEnabled(false);
                    }
                    JCalendarView.this.setWeekPeriodTableModel();
                }
            }
        });
        this.weekPeriodsTable = new JCalendarPeriodTable();
        this.weekPeriodsTable.setEnabled(false);
        this.specialPeriodsTable = new JCalendarPeriodTable();
        this.specialPeriodsTable.setEnabled(false);
        this.month = new JMonthView();
        this.month.setNoneButtonVisible(false);
        this.month.setWeekNumbersVisible(false);
        this.month.addDateSelectionListener((DateSelectionListener)this.dateSelectionHandler);
        this.nonWorking = new JRadioButton(Common.I18N_RP.getString("nonworkingDay"));
        this.nonWorking.setEnabled(false);
        this.nonWorking.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCalendarView.this.selectButtons(true, false, false);
                Date[] dateArray = JCalendarView.this.month.getSelectedDates();
                Calendar calendar = Calendar.getInstance();
                Task task = JCalendarView.this.project.getCompany().getRootTask();
                ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(task);
                for (int i = 0; i < dateArray.length; ++i) {
                    calendar.setTime(dateArray[i]);
                    DayWorkingPattern dayWorkingPattern = JCalendarView.this.currentCalendar.getSpecialDayPattern(calendar);
                    if (dayWorkingPattern == null) {
                        DayWorkingPattern dayWorkingPattern2 = JCalendarView.this.currentCalendar.getDayPattern(calendar.get(7));
                        if (!dayWorkingPattern2.isWorking()) continue;
                        DayWorkingPattern dayWorkingPattern3 = (DayWorkingPattern)dayWorkingPattern2.clone();
                        CalendarSpecialPatternAddEdit calendarSpecialPatternAddEdit = new CalendarSpecialPatternAddEdit(JCalendarView.this.currentCalendar, dayWorkingPattern3, calendar, "28/11/09 13:48:00");
                        JCalendarView.this.currentCalendar.beginTransaction();
                        JCalendarView.this.currentCalendar.setDayPattern(calendar, dayWorkingPattern3);
                        dayWorkingPattern3.setWorking(false);
                        JCalendarView.this.currentCalendar.endTransaction();
                        extendedCompoundEdit.addEdit(calendarSpecialPatternAddEdit);
                        continue;
                    }
                    JCalendarView.this.currentCalendar.beginTransaction();
                    dayWorkingPattern.setWorking(false);
                    JCalendarView.this.currentCalendar.endTransaction();
                }
                extendedCompoundEdit.end();
                JCalendarView.this.fireUndoableEditHappened(new UndoableEditEvent(this, extendedCompoundEdit));
                JCalendarView.this.setSpecialPeriodTableModel();
                TaskPlanner.rescheduleTree(task);
            }
        });
        this.working = new JRadioButton(Common.I18N_RP.getString("customProgram"));
        this.working.setEnabled(false);
        this.working.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCalendarView.this.selectButtons(false, true, false);
                Date[] dateArray = JCalendarView.this.month.getSelectedDates();
                Calendar calendar = Calendar.getInstance();
                Task task = JCalendarView.this.project.getCompany().getRootTask();
                ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(task);
                for (int i = 0; i < dateArray.length; ++i) {
                    AbstractUndoableEdit abstractUndoableEdit;
                    DayWorkingPattern dayWorkingPattern;
                    calendar.setTime(dateArray[i]);
                    DayWorkingPattern dayWorkingPattern2 = JCalendarView.this.currentCalendar.getSpecialDayPattern(calendar);
                    if (dayWorkingPattern2 == null) {
                        dayWorkingPattern = (DayWorkingPattern)JCalendarView.this.project.getCustomPattern().clone();
                        abstractUndoableEdit = new CalendarSpecialPatternAddEdit(JCalendarView.this.currentCalendar, dayWorkingPattern, calendar, "28/11/09 14:36:00");
                        JCalendarView.this.currentCalendar.beginTransaction();
                        JCalendarView.this.currentCalendar.setDayPattern(calendar, dayWorkingPattern);
                        JCalendarView.this.currentCalendar.endTransaction();
                        extendedCompoundEdit.addEdit(abstractUndoableEdit);
                        continue;
                    }
                    dayWorkingPattern = (DayWorkingPattern)JCalendarView.this.project.getCustomPattern().clone();
                    abstractUndoableEdit = new CalendarSpecialPatternEdit(JCalendarView.this.currentCalendar, dayWorkingPattern2, dayWorkingPattern, calendar, "28/11/09 14:06:00");
                    JCalendarView.this.currentCalendar.beginTransaction();
                    JCalendarView.this.currentCalendar.setDayPattern(calendar, dayWorkingPattern);
                    JCalendarView.this.currentCalendar.endTransaction();
                    extendedCompoundEdit.addEdit(abstractUndoableEdit);
                }
                extendedCompoundEdit.end();
                JCalendarView.this.fireUndoableEditHappened(new UndoableEditEvent(this, extendedCompoundEdit));
                JCalendarView.this.setSpecialPeriodTableModel();
                TaskPlanner.rescheduleTree(task);
                JCalendarView.this.specialPeriodsTable.requestFocusInWindow();
                JCalendarView.this.specialPeriodsTable.changeSelection(0, 0, true, true);
                JCalendarView.this.specialPeriodsTable.editCellAt(0, 0);
                Component component = JCalendarView.this.specialPeriodsTable.getEditorComponent();
                if (component != null) {
                    component.requestFocus();
                }
            }
        });
        this.useDefault = new JRadioButton(Common.I18N_RP.getString("weekDefinedProgram"));
        this.useDefault.setEnabled(false);
        this.useDefault.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCalendarView.this.selectButtons(false, false, true);
                Date[] dateArray = JCalendarView.this.month.getSelectedDates();
                Calendar calendar = Calendar.getInstance();
                Task task = JCalendarView.this.project.getCompany().getRootTask();
                ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(task);
                for (int i = 0; i < dateArray.length; ++i) {
                    calendar.setTime(dateArray[i]);
                    DayWorkingPattern dayWorkingPattern = JCalendarView.this.currentCalendar.getSpecialDayPattern(calendar);
                    if (dayWorkingPattern == null) continue;
                    CalendarSpecialPatternRemoveEdit calendarSpecialPatternRemoveEdit = new CalendarSpecialPatternRemoveEdit(JCalendarView.this.currentCalendar, dayWorkingPattern, calendar, "25/11/09 17:19:00");
                    extendedCompoundEdit.addEdit(calendarSpecialPatternRemoveEdit);
                    JCalendarView.this.currentCalendar.beginTransaction();
                    JCalendarView.this.currentCalendar.removeDayPattern(calendar);
                    JCalendarView.this.currentCalendar.endTransaction();
                }
                extendedCompoundEdit.end();
                JCalendarView.this.fireUndoableEditHappened(new UndoableEditEvent(this, extendedCompoundEdit));
                JCalendarView.this.setSpecialPeriodTableModel();
                TaskPlanner.rescheduleTree(task);
            }
        });
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 23, 2, new Insets(5, 0, 5, 5), 0, 0));
        JScrollPane jScrollPane = new JScrollPane(this.weekTable);
        int n = 8 * (this.weekTable.getRowHeight() + this.weekTable.getRowMargin());
        jScrollPane.setMinimumSize(new Dimension(this.month.getPreferredSize().width, n));
        jScrollPane.setPreferredSize(new Dimension(this.month.getPreferredSize().width, n));
        JScrollPane jScrollPane2 = new JScrollPane((Component)this.weekPeriodsTable);
        jScrollPane2.setMinimumSize(new Dimension(110, 130));
        jScrollPane2.setPreferredSize(new Dimension(110, 130));
        this.specialPeriodsScrollPane = new JScrollPane((Component)this.specialPeriodsTable);
        this.specialPeriodsScrollPane.setMinimumSize(new Dimension(110, 110));
        this.specialPeriodsScrollPane.setPreferredSize(new Dimension(110, 110));
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEtchedBorder());
        jPanel4.setBorder(BorderFactory.createEtchedBorder());
        Dimension dimension = new Dimension(2, 2);
        jPanel3.setMinimumSize(dimension);
        jPanel3.setMaximumSize(dimension);
        jPanel3.setPreferredSize(dimension);
        jPanel4.setMinimumSize(dimension);
        jPanel4.setMaximumSize(dimension);
        jPanel4.setPreferredSize(dimension);
        jPanel.add((Component)jPanel3, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 23, 2, insets, 0, 0));
        JLabel jLabel = new JLabel(Common.I18N_RP.getString("setWorkingDays") + ":");
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 2, insets, 0, 0));
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        JLabel jLabel2 = new JLabel(Common.I18N_RP.getString("specialPeriods"));
        jPanel.add((Component)jLabel2, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 23, 2, insets, 0, 0));
        jPanel.add((Component)jScrollPane2, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)jPanel4, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 23, 2, insets, 0, 0));
        jPanel.add((Component)new JCustomLabel(Common.I18N_RP.getString("specialDays")), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 23, 2, new Insets(10, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.month, new GridBagConstraints(0, 6, 1, 4, 0.0, 1.0, 23, 0, insets, 0, 0));
        this.specialPeriodLabel = new JLabel(Common.I18N_RP.getString("specialPeriods"));
        jPanel.add((Component)this.specialPeriodLabel, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 23, 2, new Insets(10, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.specialPeriodsScrollPane, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)this.nonWorking, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.useDefault, new GridBagConstraints(1, 8, 2, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.working, new GridBagConstraints(1, 9, 2, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JPanel(), new GridBagConstraints(0, 10, 1, 1, 0.0, 1.0, 23, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.specialPeriodLabel.setVisible(false);
        this.month.setVisible(false);
        this.specialPeriodsScrollPane.setVisible(false);
        this.working.setVisible(false);
        this.nonWorking.setVisible(false);
        this.useDefault.setVisible(false);
        return jPanel;
    }

    private void selectButtons(boolean bl, boolean bl2, boolean bl3) {
        this.nonWorking.setSelected(bl);
        this.working.setSelected(bl2);
        this.useDefault.setSelected(bl3);
    }

    private void setSpecialPeriodTableModel() {
        for (DayWorkingPattern cloneable2 : this.specialPatternToCalendarMap.keySet()) {
            cloneable2.removeDayWorkingPatternListener(this.specialPatternHandler);
        }
        this.specialPatternToCalendarMap.clear();
        Date[] dateArray = this.month.getSelectedDates();
        LinkedList<DayWorkingPattern> linkedList = new LinkedList<DayWorkingPattern>();
        for (int i = 0; i < dateArray.length; ++i) {
            Date date = dateArray[i];
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            DayWorkingPattern dayWorkingPattern = this.currentCalendar.getSpecialDayPattern(calendar);
            dayWorkingPattern = dayWorkingPattern == null ? (DayWorkingPattern)this.currentCalendar.getDayPattern(calendar.get(7)).clone() : (DayWorkingPattern)dayWorkingPattern.clone();
            this.specialPatternToCalendarMap.put(dayWorkingPattern, calendar);
            dayWorkingPattern.addDayWorkingPatternListener(this.specialPatternHandler);
            linkedList.add(dayWorkingPattern);
        }
        this.specialPeriodsTable.setModel((TableModel)new CalendarPeriodTableModel(linkedList, this.currentCalendar));
    }

    private void setWeekPeriodTableModel() {
        for (DayWorkingPattern cloneable2 : this.weekPatternToCalendarMap.keySet()) {
            cloneable2.removeDayWorkingPatternListener(this.weekPatternHandler);
        }
        this.weekPatternToCalendarMap.clear();
        Object object = this.weekTable.getSelectedRows();
        LinkedList<DayWorkingPattern> linkedList = new LinkedList<DayWorkingPattern>();
        for (int i = 0; i < ((Object)object).length; ++i) {
            Calendar calendar = Calendar.getInstance();
            Integer n = (Integer)WeekTableModel.indexToDay.get((int)object[i]);
            calendar.set(7, n);
            DayWorkingPattern dayWorkingPattern = (DayWorkingPattern)this.currentCalendar.getDayPattern(n).clone();
            this.weekPatternToCalendarMap.put(dayWorkingPattern, calendar);
            dayWorkingPattern.addDayWorkingPatternListener(this.weekPatternHandler);
            linkedList.add(dayWorkingPattern);
        }
        this.weekPeriodsTable.setModel((TableModel)new CalendarPeriodTableModel(linkedList, this.currentCalendar));
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    private void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(UndoableEditListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((UndoableEditListener)eventListenerArray[i]).undoableEditHappened(undoableEditEvent);
        }
    }

    private class JCustomLabel
    extends JLabel {
        private boolean selected;
        private String originalText;

        public JCustomLabel(String string) {
            super("<html>" + string + "</html>");
            this.originalText = string;
            this.setForeground(Color.BLUE);
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    JCustomLabel.this.selected = !JCustomLabel.this.selected;
                    JCalendarView.this.specialPeriodLabel.setVisible(JCustomLabel.this.selected);
                    JCalendarView.this.month.setVisible(JCustomLabel.this.selected);
                    JCalendarView.this.specialPeriodsScrollPane.setVisible(JCustomLabel.this.selected);
                    JCalendarView.this.working.setVisible(JCustomLabel.this.selected);
                    JCalendarView.this.nonWorking.setVisible(JCustomLabel.this.selected);
                    JCalendarView.this.useDefault.setVisible(JCustomLabel.this.selected);
                    if (JCustomLabel.this.selected) {
                        JCustomLabel.this.setForeground(Color.BLACK);
                    } else {
                        JCustomLabel.this.setForeground(Color.BLUE);
                    }
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    JCustomLabel.this.setText("<html><u>" + JCustomLabel.this.originalText + "</u></html>");
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    JCustomLabel.this.setText("<html>" + JCustomLabel.this.originalText + "</html>");
                }
            });
        }
    }

    private class CalendarManagerHandler
    implements CalendarManagerListener {
        private CalendarManagerHandler() {
        }

        public void dayWorkingPatternChanged(CalendarManagerEvent calendarManagerEvent) {
        }

        public void calendarChanged(CalendarManagerEvent calendarManagerEvent) {
            JCalendarView.this.projectCalendarCombo.repaint();
            JCalendarView.this.companyCalendarCombo.repaint();
            JCalendarView.this.month.repaint();
        }

        public void nameChanged(CalendarManagerEvent calendarManagerEvent) {
            JCalendarView.this.projectCalendarCombo.repaint();
            JCalendarView.this.companyCalendarCombo.repaint();
            JCalendarView.this.month.repaint();
        }
    }

    private class DateSelectionHandler
    extends DateSelectionAdapter {
        private DateSelectionHandler() {
        }

        public void dateSelectionChanged(DateSelectionEvent dateSelectionEvent) {
            int n = JCalendarView.this.month.getSelectedDates().length;
            if (n > 1 || n == 0) {
                JCalendarView.this.selectButtons(false, false, false);
            } else {
                Date date = JCalendarView.this.month.getSelectedDate();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                DayWorkingPattern dayWorkingPattern = JCalendarView.this.currentCalendar.getSpecialDayPattern(calendar);
                if (dayWorkingPattern == null) {
                    JCalendarView.this.selectButtons(false, false, true);
                } else if (dayWorkingPattern.isWorking()) {
                    JCalendarView.this.selectButtons(false, true, false);
                } else {
                    JCalendarView.this.selectButtons(true, false, false);
                }
            }
            if (n == 0) {
                JCalendarView.this.selectButtons(false, false, false);
                JCalendarView.this.specialPeriodsTable.setEnabled(false);
            } else {
                JCalendarView.this.nonWorking.setEnabled(true);
                JCalendarView.this.working.setEnabled(true);
                JCalendarView.this.useDefault.setEnabled(true);
                JCalendarView.this.specialPeriodsTable.setEnabled(true);
            }
            JCalendarView.this.setSpecialPeriodTableModel();
        }
    }

    private class WeekPatternHandler
    implements DayWorkingPatternListener {
        private WeekPatternHandler() {
        }

        public void dayWorkingPatternChanged(DayWorkingPatternEvent dayWorkingPatternEvent) {
            DayWorkingPattern dayWorkingPattern = (DayWorkingPattern)dayWorkingPatternEvent.getSource();
            Calendar calendar = (Calendar)JCalendarView.this.weekPatternToCalendarMap.get(dayWorkingPattern);
            int n = calendar.get(7);
            DayWorkingPattern dayWorkingPattern2 = JCalendarView.this.currentCalendar.getDayPattern(n);
            ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(JCalendarView.this.company.getRootTask());
            CalendarWeekPatternEdit calendarWeekPatternEdit = new CalendarWeekPatternEdit(JCalendarView.this.company, JCalendarView.this.currentCalendar, dayWorkingPattern2, dayWorkingPattern, n, "25/11/09 16:37:01");
            extendedCompoundEdit.addEdit(calendarWeekPatternEdit);
            JCalendarView.this.currentCalendar.setDayPattern(n, dayWorkingPattern);
            extendedCompoundEdit.end();
            JCalendarView.this.fireUndoableEditHappened(new UndoableEditEvent(this, extendedCompoundEdit));
            JCalendarView.this.weekPeriodsTable.tableChanged(new TableModelEvent(JCalendarView.this.weekPeriodsTable.getModel()));
            TaskPlanner.rescheduleTree(JCalendarView.this.company.getRootTask());
        }
    }

    private class SpecialPatternHandler
    implements DayWorkingPatternListener {
        private SpecialPatternHandler() {
        }

        public void dayWorkingPatternChanged(DayWorkingPatternEvent dayWorkingPatternEvent) {
            DayWorkingPattern dayWorkingPattern = (DayWorkingPattern)dayWorkingPatternEvent.getSource();
            Calendar calendar = (Calendar)JCalendarView.this.specialPatternToCalendarMap.get(dayWorkingPattern);
            DayWorkingPattern dayWorkingPattern2 = JCalendarView.this.currentCalendar.getSpecialDayPattern(calendar);
            ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(JCalendarView.this.company.getRootTask());
            if (dayWorkingPattern2 == null) {
                CalendarSpecialPatternAddEdit calendarSpecialPatternAddEdit = new CalendarSpecialPatternAddEdit(JCalendarView.this.currentCalendar, dayWorkingPattern, calendar, "25/11/09 17:14:00");
                extendedCompoundEdit.addEdit(calendarSpecialPatternAddEdit);
                JCalendarView.this.currentCalendar.setDayPattern(calendar, dayWorkingPattern);
            } else {
                DayWorkingPattern dayWorkingPattern3 = JCalendarView.this.currentCalendar.getDayPattern(calendar.get(7));
                if (!dayWorkingPattern.equals(dayWorkingPattern3)) {
                    CalendarSpecialPatternEdit calendarSpecialPatternEdit = new CalendarSpecialPatternEdit(JCalendarView.this.currentCalendar, dayWorkingPattern2, dayWorkingPattern, calendar, "28/11/09 14:54:00");
                    extendedCompoundEdit.addEdit(calendarSpecialPatternEdit);
                    JCalendarView.this.currentCalendar.setDayPattern(calendar, dayWorkingPattern);
                } else {
                    CalendarSpecialPatternRemoveEdit calendarSpecialPatternRemoveEdit = new CalendarSpecialPatternRemoveEdit(JCalendarView.this.currentCalendar, dayWorkingPattern2, calendar, "25/11/09 17:19:00");
                    extendedCompoundEdit.addEdit(calendarSpecialPatternRemoveEdit);
                    JCalendarView.this.currentCalendar.removeDayPattern(calendar);
                }
            }
            extendedCompoundEdit.end();
            JCalendarView.this.fireUndoableEditHappened(new UndoableEditEvent(this, extendedCompoundEdit));
            JCalendarView.this.specialPeriodsTable.tableChanged(new TableModelEvent(JCalendarView.this.specialPeriodsTable.getModel()));
            TaskPlanner.rescheduleTree(JCalendarView.this.company.getRootTask());
        }
    }

    private class CalendarHandler
    implements ItemListener {
        private CalendarHandler() {
        }

        private void doIt() {
            Object object = JCalendarView.this.calendarCombo.getSelectedItem();
            if (object instanceof CalendarManager) {
                JCalendarView.this.setSelectedCalendar((CalendarManager)object);
            } else {
                CalendarNameEdit calendarNameEdit = new CalendarNameEdit(JCalendarView.this.currentCalendar, JCalendarView.this.currentCalendar.getName(), object.toString(), "05/10/2009 19:48:00");
                JCalendarView.this.currentCalendar.setName(object.toString());
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, calendarNameEdit);
                JCalendarView.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                this.doIt();
            }
        }
    }

    private class CompanyHandler
    extends CompanyAdapter {
        private CompanyHandler() {
        }

        public void calendarAdded(CompanyEvent companyEvent) {
            JCalendarView.this.updateValues();
        }

        public void calendarRemoved(CompanyEvent companyEvent) {
            JCalendarView.this.updateValues();
        }
    }

    class TaskHandler
    extends TaskAdapter {
        TaskHandler() {
        }

        public void nameChanged(TaskEvent taskEvent) {
            JCalendarView.this.curentProjectLabel.setText("(" + ((Task)taskEvent.getSource()).getName() + ")");
        }
    }
}

