/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.ui.action.ActionMapper;
import com.sbs.jpm.ui.component.model.AssignmentTableModel;
import com.sbs.jpm.ui.component.renderer.CellEditorInvertedColorAndBorderModel;
import com.sbs.jpm.ui.component.renderer.ComboBoxRenderer;
import com.sbs.jpm.ui.component.util.ComboBoxCompletion;
import com.sbs.jpm.ui.component.util.TaskListWorkDurationFormat;
import com.sbs.jpm.ui.component.util.TaskWorkDurationFormat;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import com.sbs.util.SystemUtilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.Comparator;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.InternationalFormatter;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAssignmentTable
extends JXTable {
    private Action deleteAction;
    private JPopupMenu popupMenu;
    private EventListenerList listeners;
    private final JComboBox resourcesCombo;
    private ComboBoxCompletion automaticCompletion;
    protected static final JFormattedTextField formattedTextField = new JFormattedTextField();

    public JAssignmentTable() {
        super((TableModel)new AssignmentTableModel());
        if (SystemUtilities.isOSMac()) {
            this.setSurrendersFocusOnKeystroke(false);
        } else {
            this.setSurrendersFocusOnKeystroke(true);
        }
        this.listeners = new EventListenerList();
        this.resourcesCombo = new JComboBox();
        this.resourcesCombo.setBorder(BorderFactory.createEmptyBorder(-1, 0, -1, -1));
        this.resourcesCombo.setEditable(true);
        this.automaticCompletion = new ComboBoxCompletion(this.resourcesCombo, new Comparator<Resource>(){

            @Override
            public int compare(Resource resource, Resource resource2) {
                if (resource == null) {
                    if (resource2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (resource2 == null) {
                    return 1;
                }
                return resource.getName().compareToIgnoreCase(resource2.getName());
            }
        });
        this.setSelectionMode(0);
        this.setSortable(false);
        if (SystemUtilities.isOSMac()) {
            this.putClientProperty("Quaqua.Table.style", "striped");
            this.setShowHorizontalLines(false);
            this.setShowVerticalLines(true);
        }
        ActionMapper actionMapper = ActionMapper.getInstance();
        actionMapper.mapActions((JComponent)((Object)this));
        KeyStroke keyStroke = KeyStroke.getKeyStroke(127, 0);
        this.deleteAction = new AbstractAction(null, new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/sbs/jpm/ui/images/delete.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JAssignmentTable.this.getSelectedRowCount() == 1) {
                    if (JAssignmentTable.this.getCellEditor() != null) {
                        JAssignmentTable.this.getCellEditor().cancelCellEditing();
                    }
                    AssignmentTableModel assignmentTableModel = (AssignmentTableModel)JAssignmentTable.this.getModel();
                    int n = JAssignmentTable.this.getSelectedRow();
                    if (JAssignmentTable.this.getSelectedRow() != assignmentTableModel.getRowCount() - 1) {
                        Assignment[] assignmentArray = assignmentTableModel.getAssignments().get(n).getAssignments().toArray(new Assignment[0]);
                        ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(assignmentArray[0].getTask());
                        for (int i = 0; i < assignmentArray.length; ++i) {
                            Assignment assignment = assignmentArray[i];
                            assignment.discard(extendedCompoundEdit);
                        }
                        TaskPlanner.rescheduleTree(assignmentArray[0].getTask());
                        extendedCompoundEdit.end();
                        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                        JAssignmentTable.this.fireUndoableEditHappened(undoableEditEvent);
                        JAssignmentTable.this.getSelectionModel().setSelectionInterval(n, n);
                    }
                }
            }
        };
        this.deleteAction.putValue("AcceleratorKey", keyStroke);
        this.deleteAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("assignment.delete"));
        ActionMap actionMap = this.getActionMap();
        actionMap.put("delete", this.deleteAction);
        this.getInputMap(1).put(keyStroke, "delete");
        this.popupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(this.deleteAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("assignment.delete"));
        this.popupMenu.add(jMenuItem);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            private void showPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    int n = JAssignmentTable.this.rowAtPoint(mouseEvent.getPoint());
                    int[] nArray = JAssignmentTable.this.getSelectedRows();
                    boolean bl = false;
                    if (nArray != null) {
                        for (int i = 0; i < nArray.length; ++i) {
                            int n2 = nArray[i];
                            if (n2 != n) continue;
                            bl = true;
                        }
                    }
                    if (!bl) {
                        JAssignmentTable.this.getSelectionModel().setSelectionInterval(n, n);
                    }
                    JAssignmentTable.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    private void setRenderersAndEditors() {
        this.getColumnExt(AssignmentTableModel.ASSIGNMENT_WORK).setCellRenderer((TableCellRenderer)new WorkCellRenderer());
        this.getColumnExt(AssignmentTableModel.ASSIGNMENT_WORK).setCellEditor((TableCellEditor)new WorkCellEditor(formattedTextField));
    }

    public void selected() {
        this.highlightNextInputCell();
    }

    public void highlightNextInputCell() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (JAssignmentTable.this.getModel().getRowCount() > 0) {
                    JAssignmentTable.this.getSelectionModel().setSelectionInterval(JAssignmentTable.this.getModel().getRowCount() - 1, JAssignmentTable.this.getModel().getRowCount() - 1);
                }
            }
        });
    }

    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        Component component = super.prepareEditor(tableCellEditor, n, n2);
        if (component instanceof JTextComponent) {
            ((JTextField)component).selectAll();
        }
        return component;
    }

    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        List<Task> list = ((AssignmentTableModel)tableModel).getTasks();
        if (!list.isEmpty()) {
            this.reloadAssignments(list);
            List<Resource> list2 = list.get(0).getCompany().getNonEmptyResources();
            ResourcesEditor resourcesEditor = new ResourcesEditor(this.resourcesCombo);
            CellEditorInvertedColorAndBorderModel cellEditorInvertedColorAndBorderModel = new CellEditorInvertedColorAndBorderModel();
            this.getColumn(AssignmentTableModel.RESOURCE).setCellRenderer(new ComboBoxRenderer(list2.toArray(), cellEditorInvertedColorAndBorderModel, !SystemUtilities.isOSMac(), true, false));
            this.getColumn(AssignmentTableModel.RESOURCE).setCellEditor((TableCellEditor)((Object)resourcesEditor));
            this.highlightNextInputCell();
        }
        this.setRenderersAndEditors();
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    private void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(UndoableEditListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((UndoableEditListener)eventListenerArray[i]).undoableEditHappened(undoableEditEvent);
        }
    }

    private void reloadAssignments(List<Task> list) {
        List<Resource> list2 = list.get(0).getCompany().getNonEmptyResources();
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(list2.toArray());
        this.automaticCompletion.setModel(defaultComboBoxModel);
    }

    static {
        formattedTextField.setHorizontalAlignment(4);
    }

    private class ResourcesEditor
    extends ComboBoxCellEditor {
        public ResourcesEditor(JComboBox jComboBox) {
            super(jComboBox);
            JComponent jComponent = (JComponent)jComboBox.getEditor().getEditorComponent();
            jComponent.addKeyListener(new KeyHandler());
            jComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getModifiers() == 16) {
                        ResourcesEditor.this.stopEditing();
                    }
                }
            });
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            JComboBox jComboBox = (JComboBox)super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            List<Task> list = ((AssignmentTableModel)JAssignmentTable.this.dataModel).getTasks();
            if (!list.isEmpty()) {
                JAssignmentTable.this.reloadAssignments(list);
            }
            jComboBox.setSelectedItem(object);
            return jComboBox;
        }

        public Object getCellEditorValue() {
            Object object = super.getCellEditorValue();
            if (object instanceof String && object.equals("")) {
                return null;
            }
            return object;
        }

        public void cancelCellEditing() {
            JAssignmentTable.this.automaticCompletion.stopEditing();
            this.fireEditingCanceled();
        }

        public void stopEditing() {
            JAssignmentTable.this.automaticCompletion.stopEditing();
            super.stopCellEditing();
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject == null) {
                return super.isCellEditable(eventObject);
            }
            JAssignmentTable jAssignmentTable = (JAssignmentTable)((Object)eventObject.getSource());
            if (eventObject instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                if (mouseEvent.getClickCount() > 1) {
                    return true;
                }
                return jAssignmentTable.getSelectedRow() == jAssignmentTable.rowAtPoint(mouseEvent.getPoint());
            }
            return true;
        }

        private class KeyHandler
        extends KeyAdapter {
            private KeyHandler() {
            }

            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 27) {
                    if (JAssignmentTable.this.isEditing()) {
                        ResourcesEditor.this.cancelCellEditing();
                    } else {
                        JAssignmentTable.this.editCellAt(JAssignmentTable.this.getSelectedRow(), JAssignmentTable.this.getSelectedColumn());
                    }
                }
            }
        }
    }

    protected class WorkCellRenderer
    extends DefaultTableCellRenderer {
        public WorkCellRenderer() {
            this.setHorizontalAlignment(4);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            List<Task> list = ((AssignmentTableModel)JAssignmentTable.this.dataModel).getTasks();
            String string = TaskWorkDurationFormat.formatWork(list.get(0), (Double)object);
            return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
        }
    }

    protected class WorkCellEditor
    extends DefaultCellEditor {
        private JFormattedTextField taskWorkDuration;
        private TaskListWorkDurationFormat df;

        public WorkCellEditor(JFormattedTextField jFormattedTextField) {
            super(jFormattedTextField);
            this.taskWorkDuration = jFormattedTextField;
            this.df = new TaskListWorkDurationFormat();
            this.delegate = new WorkEditorDelegate();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.df.setTasks(((AssignmentTableModel)JAssignmentTable.this.dataModel).getTasks());
            this.taskWorkDuration.setFormatterFactory(new DefaultFormatterFactory(new InternationalFormatter(this.df)));
            this.taskWorkDuration.setValue(object);
            return this.taskWorkDuration;
        }

        private class WorkEditorDelegate
        extends DefaultCellEditor.EditorDelegate {
            private WorkEditorDelegate() {
                super(WorkCellEditor.this);
            }

            public void setValue(Object object) {
                WorkCellEditor.this.taskWorkDuration.setValue(object);
            }

            public Object getCellEditorValue() {
                return WorkCellEditor.this.taskWorkDuration.getValue();
            }

            public boolean stopCellEditing() {
                try {
                    WorkCellEditor.this.taskWorkDuration.commitEdit();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                return super.stopCellEditing();
            }
        }
    }
}

