/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.Common;
import com.sbs.jpm.Main;
import com.sbs.jpm.configuration.Configuration;
import com.sbs.jpm.configuration.ConfigurationSetting;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.event.CompanyAdapter;
import com.sbs.jpm.core.event.CompanyEvent;
import com.sbs.jpm.ui.JProject;
import com.sbs.jpm.ui.action.ActionManager;
import com.sbs.jpm.ui.component.JProjectView;
import com.sbs.jpm.ui.component.event.JAreaViewEvent;
import com.sbs.jpm.ui.component.event.JAreaViewListener;
import com.sbs.jpm.ui.component.view.JProjectViewAssumptions;
import com.sbs.jpm.ui.component.view.JProjectViewCalendar;
import com.sbs.jpm.ui.component.view.JProjectViewClients;
import com.sbs.jpm.ui.component.view.JProjectViewEmpty;
import com.sbs.jpm.ui.component.view.JProjectViewGantt;
import com.sbs.jpm.ui.component.view.JProjectViewInfo;
import com.sbs.jpm.ui.component.view.JProjectViewNotes;
import com.sbs.jpm.ui.component.view.JProjectViewResourceSheet;
import com.sbs.jpm.ui.component.view.JProjectViewResources;
import com.sbs.jpm.ui.component.view.JProjectViewRisks;
import com.sbs.jpm.ui.component.view.JProjectViewTaskSheet;
import com.sbs.jpm.ui.component.view.JProjectViewTracking;
import com.sbs.jpm.ui.component.view.JProjectViewWBS;
import com.sbs.jpm.ui.treetablechart.JGanttChart;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.EventListenerList;
import javax.swing.tree.TreePath;

public class JAreaView
extends JPanel {
    public static final String PROJECT = Common.I18N_RP.getString("guide.project");
    public static final String PROJECT_INFO = Common.I18N_RP.getString("guide.info");
    public static final String PROJECT_NOTES = Common.I18N_RP.getString("guide.notesAndLinks");
    public static final String CALENDAR = Common.I18N_RP.getString("guide.calendar");
    public static final String PROJECT_ASSUMPTIONS = Common.I18N_RP.getString("guide.assumptionsAndConstraints");
    public static final String PROJECT_RISKS = Common.I18N_RP.getString("guide.risks");
    public static final String PLANNING = Common.I18N_RP.getString("guide.planning");
    public static final String PROJECT_WBS = Common.I18N_RP.getString("guide.createWBS");
    public static final String DEFINE_RESOURCES = Common.I18N_RP.getString("guide.defineResources");
    public static final String PROJECT_UPDATE = Common.I18N_RP.getString("guide.updateTasksCompletion");
    public static final String GANTT = Common.I18N_RP.getString("guide.scheduleTasks");
    public static final String ASSIGN_RESOURCES = Common.I18N_RP.getString("guide.assignResources");
    public static final String TASK_SHEET = Common.I18N_RP.getString("guide.defineAdditionalCosts");
    public static final String HUMAN_RESOURCES = Common.I18N_RP.getString("guide.human");
    public static final String MATERIAL_RESOURCES = Common.I18N_RP.getString("guide.material");
    public static final String CLIENTS = Common.I18N_RP.getString("clients");
    public static final String LEVEL_RESOURCES = Common.I18N_RP.getString("guide.levelResources");
    public static final String RESOURCE_SHEET = Common.I18N_RP.getString("guide.workAndCostTracking");
    public static final String CONTROLING = Common.I18N_RP.getString("guide.controlling");
    private JProjectView projectView;
    private JProjectView projectInfoView;
    private JProjectView projectNotesView;
    private JProjectView projectAssumptionsView;
    private JProjectView projectRisksView;
    private JProjectView projectPlanningView;
    private JProjectView projectWBSView;
    private JProjectView ganttView;
    private JProjectView assignResourcesView;
    private JProjectView taskSheetView;
    private JProjectView projectResourcesView;
    private JProjectView clientsView;
    private JProjectView resourceSheetView;
    private JProjectView calendarView;
    private JProjectView projectControlingView;
    private JProjectView updateView;
    private JProjectView levelingView;
    private String currentViewName;
    private JPanel area;
    private JPanel guideDetailPanel;
    private JPanel bodyPanel;
    private JPanel viewPanel;
    private JSplitPane splitPane;
    private JProject jproject;
    private EventListenerList listeners;

    public JAreaView(JProject jProject) {
        this.jproject = jProject;
        this.listeners = new EventListenerList();
        this.setLayout(new BorderLayout());
        this.add((Component)this.createContents(), "Center");
        this.addJAreaViewListener(ActionManager.getActionManager());
    }

    public void setProject(Company company) {
        if (company != null) {
            company.addCompanyListener(new CompanyAdapter(){

                public void currentProjectChanged(CompanyEvent companyEvent) {
                    JAreaView.this.setProject(companyEvent.getProject());
                }
            });
            this.setProject(company.getCurrentTask());
        }
    }

    private void setProject(Task task) {
        if (task != null) {
            this.projectInfoView.setProject(task);
            this.projectNotesView.setProject(task);
            this.projectAssumptionsView.setProject(task);
            this.projectRisksView.setProject(task);
            this.projectWBSView.setProject(task);
            this.storeExpandedState();
            this.ganttView.setProject(task);
            this.assignResourcesView.setProject(task);
            this.projectResourcesView.setProject(task);
            this.taskSheetView.setProject(task);
            this.clientsView.setProject(task);
            this.calendarView.setProject(task);
            this.updateView.setProject(task);
            this.levelingView.setProject(task);
            this.resourceSheetView.setProject(task);
        }
    }

    private void storeExpandedState() {
        JGanttChart jGanttChart = ((JProjectViewGantt)this.ganttView).getGantt();
        for (int i = 0; i < jGanttChart.getTreeTable().getRowCount(); ++i) {
            TreePath treePath = jGanttChart.getTreeTable().getPathForRow(i);
            Task task = (Task)treePath.getLastPathComponent();
            if (task.isEmpty()) continue;
            task.setExpanded(jGanttChart.getTreeTable().isExpanded(i));
        }
    }

    private JComponent createContents() {
        Dimension dimension;
        this.bodyPanel = new JPanel();
        this.bodyPanel.setLayout(new BorderLayout());
        this.splitPane = new JSplitPane(0);
        this.splitPane.setFocusable(false);
        this.splitPane.setResizeWeight(0.3);
        this.splitPane.setDividerSize(3);
        this.guideDetailPanel = this.jproject.getGuidePanel().createDetailPanel();
        this.splitPane.add(this.guideDetailPanel);
        this.viewPanel = new JPanel();
        this.viewPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        this.projectView = new JProjectViewEmpty();
        this.projectInfoView = new JProjectViewInfo();
        this.projectNotesView = new JProjectViewNotes();
        this.projectAssumptionsView = new JProjectViewAssumptions();
        Main.getInstance();
        Main.splashScreen.increaseStep(5);
        this.projectRisksView = new JProjectViewRisks();
        this.projectPlanningView = new JProjectViewEmpty();
        this.projectWBSView = new JProjectViewWBS();
        this.ganttView = new JProjectViewGantt();
        Main.getInstance();
        Main.splashScreen.increaseStep(5);
        this.assignResourcesView = new JProjectViewGantt();
        this.taskSheetView = new JProjectViewTaskSheet();
        this.projectResourcesView = new JProjectViewResources();
        this.clientsView = new JProjectViewClients();
        Main.getInstance();
        Main.splashScreen.increaseStep(5);
        this.resourceSheetView = new JProjectViewResourceSheet();
        this.calendarView = new JProjectViewCalendar();
        this.projectControlingView = new JProjectViewEmpty();
        this.updateView = new JProjectViewTracking();
        Main.getInstance();
        Main.splashScreen.increaseStep(5);
        this.levelingView = new JProjectViewGantt();
        CardLayout cardLayout = new CardLayout();
        this.area = new JPanel(cardLayout);
        this.area.add((Component)this.projectView, PROJECT);
        this.area.add((Component)this.projectPlanningView, PLANNING);
        this.area.add((Component)this.projectResourcesView, DEFINE_RESOURCES);
        this.area.add((Component)this.projectControlingView, CONTROLING);
        this.area.add((Component)this.calendarView, CALENDAR);
        this.area.add((Component)this.levelingView, LEVEL_RESOURCES);
        this.area.add((Component)this.clientsView, CLIENTS);
        this.area.add((Component)this.taskSheetView, TASK_SHEET);
        this.area.add((Component)this.ganttView, GANTT);
        this.area.add((Component)this.assignResourcesView, ASSIGN_RESOURCES);
        this.area.add((Component)this.projectWBSView, PROJECT_WBS);
        this.area.add((Component)this.projectRisksView, PROJECT_RISKS);
        this.area.add((Component)this.projectAssumptionsView, PROJECT_ASSUMPTIONS);
        this.area.add((Component)this.projectNotesView, PROJECT_NOTES);
        this.area.add((Component)this.projectInfoView, PROJECT_INFO);
        this.area.add((Component)this.updateView, PROJECT_UPDATE);
        this.area.add((Component)this.resourceSheetView, RESOURCE_SHEET);
        this.viewPanel.add((Component)this.area, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, insets, 0, 0));
        this.splitPane.add(this.viewPanel);
        this.bodyPanel.add((Component)this.splitPane, "Center");
        boolean bl = Boolean.valueOf(Configuration.getInstance().getValue(ConfigurationSetting.GUIDE_DETAILS_VISIBLE).toString());
        if (!bl) {
            this.toggleGuide();
        }
        if ((dimension = (Dimension)Configuration.getInstance().getValue(ConfigurationSetting.GUIDE_DETAILS_SIZE)) != null) {
            this.splitPane.setDividerLocation(dimension.height);
        }
        Main.getInstance();
        Main.splashScreen.increaseStep(5);
        return this.bodyPanel;
    }

    public void setActiveView(String string) {
        this.currentViewName = string;
        ((CardLayout)this.area.getLayout()).show(this.area, string);
        JAreaViewEvent jAreaViewEvent = new JAreaViewEvent(this, this.getActiveViewComponent());
        this.fireProjectViewChanged(jAreaViewEvent);
    }

    public String getCurrentViewName() {
        return this.currentViewName;
    }

    public JProjectView getActiveViewComponent() {
        if (this.currentViewName.equals(PROJECT)) {
            return this.projectView;
        }
        if (this.currentViewName.equals(PROJECT_INFO)) {
            return this.projectInfoView;
        }
        if (this.currentViewName.equals(PROJECT_NOTES)) {
            return this.projectNotesView;
        }
        if (this.currentViewName.equals(CALENDAR)) {
            return this.calendarView;
        }
        if (this.currentViewName.equals(PROJECT_ASSUMPTIONS)) {
            return this.projectAssumptionsView;
        }
        if (this.currentViewName.equals(PROJECT_RISKS)) {
            return this.projectRisksView;
        }
        if (this.currentViewName.equals(PLANNING)) {
            return this.projectPlanningView;
        }
        if (this.currentViewName.equals(PROJECT_WBS)) {
            return this.projectWBSView;
        }
        if (this.currentViewName.equals(GANTT)) {
            return this.ganttView;
        }
        if (this.currentViewName.equals(ASSIGN_RESOURCES)) {
            return this.assignResourcesView;
        }
        if (this.currentViewName.equals(LEVEL_RESOURCES)) {
            return this.levelingView;
        }
        if (this.currentViewName.equals(TASK_SHEET)) {
            return this.taskSheetView;
        }
        if (this.currentViewName.equals(DEFINE_RESOURCES)) {
            return this.projectResourcesView;
        }
        if (this.currentViewName.equals(CLIENTS)) {
            return this.clientsView;
        }
        if (this.currentViewName.equals(RESOURCE_SHEET)) {
            return this.resourceSheetView;
        }
        if (this.currentViewName.equals(CONTROLING)) {
            return this.projectControlingView;
        }
        if (this.currentViewName.equals(PROJECT_UPDATE)) {
            return this.updateView;
        }
        return null;
    }

    public JProjectView getViewComponent(String string) {
        if (string.equals(PROJECT)) {
            return this.projectView;
        }
        if (string.equals(PROJECT_INFO)) {
            return this.projectInfoView;
        }
        if (string.equals(PROJECT_NOTES)) {
            return this.projectNotesView;
        }
        if (string.equals(CALENDAR)) {
            return this.calendarView;
        }
        if (string.equals(PROJECT_ASSUMPTIONS)) {
            return this.projectAssumptionsView;
        }
        if (string.equals(PROJECT_RISKS)) {
            return this.projectRisksView;
        }
        if (string.equals(PLANNING)) {
            return this.projectPlanningView;
        }
        if (string.equals(PROJECT_WBS)) {
            return this.projectWBSView;
        }
        if (string.equals(GANTT)) {
            return this.ganttView;
        }
        if (string.equals(ASSIGN_RESOURCES)) {
            return this.assignResourcesView;
        }
        if (string.equals(TASK_SHEET)) {
            return this.taskSheetView;
        }
        if (string.equals(DEFINE_RESOURCES)) {
            return this.projectResourcesView;
        }
        if (string.equals(CLIENTS)) {
            return this.clientsView;
        }
        if (string.equals(RESOURCE_SHEET)) {
            return this.resourceSheetView;
        }
        if (string.equals(LEVEL_RESOURCES)) {
            return this.levelingView;
        }
        if (string.equals(CONTROLING)) {
            return this.projectControlingView;
        }
        if (string.equals(PROJECT_UPDATE)) {
            return this.updateView;
        }
        return null;
    }

    public void toggleGuide() {
        boolean bl = this.guideDetailPanel.isVisible();
        this.guideDetailPanel.setVisible(!bl);
        Configuration.getInstance().setValue(ConfigurationSetting.GUIDE_DETAILS_VISIBLE, !bl);
        if (!bl) {
            this.bodyPanel.remove(this.viewPanel);
            this.splitPane.add(this.viewPanel);
            this.bodyPanel.add((Component)this.splitPane, "Center");
            this.splitPane.setDividerLocation(-1);
        } else {
            this.bodyPanel.remove(this.splitPane);
            this.bodyPanel.add((Component)this.viewPanel, "Center");
        }
        this.bodyPanel.revalidate();
    }

    public void addJAreaViewListener(JAreaViewListener jAreaViewListener) {
        this.listeners.add(JAreaViewListener.class, jAreaViewListener);
    }

    public void removeJAreaViewListener(JAreaViewListener jAreaViewListener) {
        this.listeners.remove(JAreaViewListener.class, jAreaViewListener);
    }

    private void fireProjectViewChanged(JAreaViewEvent jAreaViewEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(JAreaViewListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((JAreaViewListener)eventListenerArray[i]).projectViewChanged(jAreaViewEvent);
        }
    }

    public JPanel getGuideDetailPanel() {
        return this.guideDetailPanel;
    }
}

