/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.calendar.DayWorkingPattern;
import com.sbs.jpm.calendar.PeriodInDay;
import com.sbs.jpm.ui.action.ActionMapper;
import com.sbs.jpm.ui.component.model.AbstractPeriodTableModel;
import com.sbs.jpm.ui.component.model.PeriodTableModel;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import com.sbs.jpm.undo.UndoHandler;
import com.sbs.util.SystemUtilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.EventListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.InternationalFormatter;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CompoundEdit;
import org.jdesktop.swingx.JXTable;

public abstract class JAbstractPeriodTable
extends JXTable {
    protected UndoHandler undoHandler;
    protected EventListenerList listeners = new EventListenerList();
    private static final JFormattedTextField formattedTextField = new JFormattedTextField();

    public JAbstractPeriodTable() {
        super((TableModel)new PeriodTableModel());
        this.setSortable(false);
        if (SystemUtilities.isOSMac()) {
            this.putClientProperty("Quaqua.Table.style", "striped");
            this.setShowHorizontalLines(false);
            this.setShowVerticalLines(true);
        }
        ActionMapper actionMapper = ActionMapper.getInstance();
        actionMapper.mapActions((JComponent)((Object)this));
        ActionMap actionMap = this.getActionMap();
        actionMap.put("delete", new AbstractAction("delete period"){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JAbstractPeriodTable.this.getSelectedRowCount() == 1) {
                    int n = JAbstractPeriodTable.this.getSelectedRow();
                    AbstractPeriodTableModel abstractPeriodTableModel = (AbstractPeriodTableModel)JAbstractPeriodTable.this.getModel();
                    List list = abstractPeriodTableModel.getDayPatterns();
                    if (abstractPeriodTableModel.getRowCount() != 1) {
                        DayWorkingPattern dayWorkingPattern;
                        int n2;
                        ExtendedCompoundEdit extendedCompoundEdit = JAbstractPeriodTable.this.createUndoableEdit();
                        CalendarManager calendarManager = ((DayWorkingPattern)list.get(0)).getOwner();
                        DayWorkingPattern[] dayWorkingPatternArray = new DayWorkingPattern[list.size()];
                        for (n2 = 0; n2 < list.size(); ++n2) {
                            dayWorkingPattern = (DayWorkingPattern)list.get(n2);
                            dayWorkingPatternArray[n2] = (DayWorkingPattern)dayWorkingPattern.clone();
                        }
                        if (calendarManager != null) {
                            calendarManager.beginTransaction();
                        }
                        if (n < abstractPeriodTableModel.getRowCount() - 1) {
                            for (n2 = 0; n2 < list.size(); ++n2) {
                                dayWorkingPattern = (DayWorkingPattern)list.get(n2);
                                int n3 = JAbstractPeriodTable.this.rowIndexToModel(n);
                                PeriodInDay periodInDay = dayWorkingPattern.getPeriodInDayAt(n3);
                                dayWorkingPattern.removeAlternance(periodInDay);
                            }
                        }
                        if (calendarManager != null) {
                            calendarManager.endTransaction();
                        }
                        JAbstractPeriodTable.this.fireUndoableEdit(extendedCompoundEdit);
                    }
                }
            }
        });
        KeyStroke keyStroke = KeyStroke.getKeyStroke(127, 0);
        this.getInputMap(1).put(keyStroke, "delete");
        if (SystemUtilities.isOSMac()) {
            this.setSurrendersFocusOnKeystroke(false);
        } else {
            this.setSurrendersFocusOnKeystroke(true);
        }
    }

    protected abstract ExtendedCompoundEdit createUndoableEdit();

    protected abstract void fireUndoableEdit(CompoundEdit var1);

    private int rowIndexToModel(int n) {
        AbstractPeriodTableModel abstractPeriodTableModel = (AbstractPeriodTableModel)this.getModel();
        return abstractPeriodTableModel.convertRowIndexToModel(n);
    }

    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        Component component = super.prepareEditor(tableCellEditor, n, n2);
        if (component instanceof JTextComponent) {
            ((JTextField)component).selectAll();
        }
        return component;
    }

    protected abstract void createUndoHandler();

    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        TableColumnModel tableColumnModel = this.getColumnModel();
        tableColumnModel.getColumn(0).setMinWidth(50);
        tableColumnModel.getColumn(1).setMinWidth(50);
        this.getColumn(AbstractPeriodTableModel.FROM).setCellRenderer(new PeriodRenderer());
        this.getColumn(AbstractPeriodTableModel.TO).setCellRenderer(new PeriodRenderer());
        this.getColumn(AbstractPeriodTableModel.FROM).setCellEditor(new PeriodEditor(formattedTextField));
        this.getColumn(AbstractPeriodTableModel.TO).setCellEditor(new PeriodEditor(formattedTextField));
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    protected void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(UndoableEditListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((UndoableEditListener)eventListenerArray[i]).undoableEditHappened(undoableEditEvent);
        }
    }

    private class PeriodEditor
    extends DefaultCellEditor {
        private JFormattedTextField periodTime;

        public PeriodEditor(JFormattedTextField jFormattedTextField) {
            super(jFormattedTextField);
            this.periodTime = jFormattedTextField;
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                public void setValue(Object object) {
                    PeriodEditor.this.periodTime.setValue(object);
                }

                public Object getCellEditorValue() {
                    try {
                        PeriodEditor.this.periodTime.commitEdit();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    return PeriodEditor.this.periodTime.getValue();
                }
            };
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            PeriodFormat periodFormat = n2 == 0 ? new PeriodFormat(true) : new PeriodFormat(false);
            this.periodTime.setValue(object);
            this.periodTime.setFormatterFactory(new DefaultFormatterFactory(new InternationalFormatter(periodFormat)));
            return this.periodTime;
        }

        private class PeriodFormat
        extends Format {
            private int hourAddition;

            public PeriodFormat(boolean bl) {
                this.hourAddition = bl ? 0 : 24;
            }

            public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
                if (object != null && object instanceof Long) {
                    Long l = (Long)object;
                    DecimalFormat decimalFormat = new DecimalFormat("00");
                    String string = decimalFormat.format((Object)(l % 3600000L / 60000L));
                    String string2 = l / 3600000L == 24L ? "0:" + string : l / 3600000L + ":" + string;
                    stringBuffer.append(string2);
                }
                return stringBuffer;
            }

            public Object parseObject(String string, ParsePosition parsePosition) {
                long l;
                long l2;
                int n;
                int n2 = string.length();
                for (n = 0; n < n2 && string.charAt(n) != ':'; ++n) {
                }
                if (n == 0) {
                    parsePosition.setErrorIndex(n);
                    return null;
                }
                if (n == string.length()) {
                    long l3;
                    String string2 = string;
                    try {
                        l3 = Long.parseLong(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        parsePosition.setErrorIndex(0);
                        return null;
                    }
                    if (l3 < 0L || l3 > 23L) {
                        parsePosition.setErrorIndex(0);
                        return null;
                    }
                    Long l4 = l3 == 0L ? Long.valueOf((l3 + (long)this.hourAddition) * 3600000L) : Long.valueOf(l3 * 3600000L);
                    parsePosition.setIndex(string.length());
                    return l4;
                }
                String string3 = string.substring(0, n);
                String string4 = string.substring(n + 1);
                try {
                    l2 = Long.parseLong(string3);
                    l = Long.parseLong(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    parsePosition.setErrorIndex(0);
                    return null;
                }
                if (l2 < 0L || l2 > 23L || l < 0L || l > 59L) {
                    parsePosition.setErrorIndex(0);
                    return null;
                }
                Long l5 = l2 == 0L ? (l == 0L ? Long.valueOf((l2 + (long)this.hourAddition) * 3600000L) : Long.valueOf(l2 * 3600000L + l * 60000L)) : Long.valueOf(l2 * 3600000L + l * 60000L);
                parsePosition.setIndex(string.length());
                return l5;
            }
        }
    }

    private class PeriodRenderer
    extends DefaultTableCellRenderer {
        public PeriodRenderer() {
            this.setHorizontalAlignment(4);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            AbstractPeriodTableModel abstractPeriodTableModel = (AbstractPeriodTableModel)JAbstractPeriodTable.this.getModel();
            if (abstractPeriodTableModel.getRowCount() != 1 && object != null) {
                Long l = (Long)object;
                DecimalFormat decimalFormat = new DecimalFormat("00");
                String string = decimalFormat.format((Object)(l % 3600000L / 60000L));
                jLabel.setText(l / 3600000L % 24L + ":" + string);
            }
            return jLabel;
        }
    }
}

