/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.util.SystemUtilities;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class DropDownButton
implements ChangeListener,
PopupMenuListener,
ActionListener,
PropertyChangeListener {
    protected AbstractButton mainButton;
    protected AbstractButton arrowButton;
    protected boolean popupVisible = false;

    public DropDownButton(AbstractButton abstractButton) {
        this.mainButton = abstractButton;
        this.arrowButton = new JButton(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/dropdown.png")));
        if (this.mainButton instanceof JToggleButton) {
            this.arrowButton.putClientProperty("Quaqua.Button.style", "toggleCenter");
        }
        this.mainButton.getModel().addChangeListener(this);
        this.arrowButton.getModel().addChangeListener(this);
        this.arrowButton.addActionListener(this);
        if (!SystemUtilities.isOSMac()) {
            this.arrowButton.setMargin(new Insets(2, 0, 2, 0));
        }
        this.mainButton.addPropertyChangeListener("enabled", this);
    }

    public void setBackground(Color color) {
        this.mainButton.setBackground(color);
        this.arrowButton.setBackground(color);
    }

    public void setEnabled(boolean bl) {
        this.mainButton.setEnabled(bl);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.arrowButton.setEnabled(this.mainButton.isEnabled());
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.mainButton.getModel()) {
            if (this.popupVisible && !this.mainButton.getModel().isRollover()) {
                this.mainButton.getModel().setRollover(true);
                return;
            }
            this.arrowButton.getModel().setRollover(this.mainButton.getModel().isRollover());
            this.arrowButton.setSelected(this.mainButton.getModel().isArmed() && this.mainButton.getModel().isPressed());
        } else {
            if (this.popupVisible && !this.arrowButton.getModel().isSelected()) {
                this.arrowButton.getModel().setSelected(true);
                return;
            }
            this.mainButton.getModel().setRollover(this.arrowButton.getModel().isRollover());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mainButton instanceof JToggleButton) {
            this.mainButton.doClick();
        }
        JPopupMenu jPopupMenu = this.getPopupMenu();
        jPopupMenu.addPopupMenuListener(this);
        jPopupMenu.show(this.mainButton, 0, this.mainButton.getHeight());
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        this.popupVisible = true;
        this.mainButton.getModel().setRollover(true);
        this.arrowButton.getModel().setSelected(true);
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.popupVisible = false;
        this.mainButton.getModel().setRollover(false);
        this.arrowButton.getModel().setSelected(false);
        ((JPopupMenu)popupMenuEvent.getSource()).removePopupMenuListener(this);
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        this.popupVisible = false;
    }

    protected abstract JPopupMenu getPopupMenu();

    public AbstractButton addToToolBar(JToolBar jToolBar) {
        JToolBar jToolBar2 = new JToolBar();
        jToolBar2.setBorder(new EmptyBorder(0, 0, 0, 0));
        jToolBar2.setAlignmentX(0.5f);
        jToolBar2.setRollover(jToolBar.isRollover());
        jToolBar2.add(this.mainButton);
        jToolBar2.add(this.arrowButton);
        jToolBar2.setFloatable(false);
        jToolBar.add(jToolBar2);
        return this.mainButton;
    }
}

