/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.CircularRelationshipException;
import com.sbs.jpm.core.Dependency;
import com.sbs.jpm.core.DependencyManager;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.ui.component.DropDownButton;
import com.sbs.jpm.ui.component.JProjectView;
import com.sbs.jpm.ui.component.view.JProjectViewGantt;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import com.sbs.jpm.undo.TaskAddDependencyEdit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.UndoableEditEvent;

public class DependencyDropDownButton
extends DropDownButton {
    private JPopupMenu popup;
    private JProjectViewGantt view;

    public DependencyDropDownButton(JButton jButton, JProjectViewGantt jProjectViewGantt) {
        super(jButton);
        this.view = jProjectViewGantt;
        this.popup = new JPopupMenu();
        for (int i = 0; i < DependencyManager.getDependencyList().length; ++i) {
            String string = DependencyManager.getDependencyList()[i];
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(new DependencyAction(DependencyManager.getDependencyType(string)));
            this.popup.add(jMenuItem);
        }
    }

    protected JPopupMenu getPopupMenu() {
        return this.popup;
    }

    class DependencyAction
    implements ActionListener {
        private int type;

        public DependencyAction(int n) {
            this.type = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            JProjectView.BLOCK_UPDATE = true;
            try {
                Cloneable cloneable;
                int[] nArray = DependencyDropDownButton.this.view.getGantt().getTreeTable().getSelectedRows();
                LinkedList<Cloneable> linkedList = new LinkedList<Cloneable>();
                for (int i = 0; i < nArray.length; ++i) {
                    cloneable = (Task)DependencyDropDownButton.this.view.getGantt().getTreeTable().getPathForRow(nArray[i]).getLastPathComponent();
                    if (((Task)cloneable).isEmpty()) continue;
                    linkedList.add(cloneable);
                }
                if (linkedList.size() > 0) {
                    ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit((Task)linkedList.get(0));
                    cloneable = new LinkedList();
                    for (int i = 0; i < linkedList.size() - 1; ++i) {
                        Task task = (Task)linkedList.get(i);
                        Task task2 = (Task)linkedList.get(i + 1);
                        Dependency dependency = new Dependency(Common.getIdGenerator().getNewId(), this.type);
                        dependency.setPredecessor(task);
                        dependency.setSuccessor(task2);
                        dependency.adjustDependencyForSplit();
                        try {
                            if (!Task.addDependency(dependency, true)) continue;
                            TaskAddDependencyEdit taskAddDependencyEdit = new TaskAddDependencyEdit(dependency, "09/11/09 13:02:00");
                            cloneable.add(dependency);
                            extendedCompoundEdit.addEdit(taskAddDependencyEdit);
                            continue;
                        }
                        catch (CircularRelationshipException circularRelationshipException) {
                            Common.logException("Error:", circularRelationshipException);
                            JOptionPane.showMessageDialog(Common.getApplication(), circularRelationshipException.getLocalizedMessage(), Common.I18N_MESSAGES.getString("task.schedulingConflict"), 0);
                            Iterator iterator = cloneable.iterator();
                            while (iterator.hasNext()) {
                                Dependency dependency2 = (Dependency)iterator.next();
                                Task.removeDependency(dependency2);
                            }
                            TaskPlanner.rescheduleTree((Task)linkedList.get(0));
                            JProjectView.BLOCK_UPDATE = false;
                            DependencyDropDownButton.this.view.updateToolbar();
                            return;
                        }
                    }
                    if (cloneable.size() > 0) {
                        extendedCompoundEdit.end();
                        TaskPlanner.rescheduleTree((Task)linkedList.get(0));
                        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                        DependencyDropDownButton.this.view.fireUndoableEditHappened(undoableEditEvent);
                    }
                }
            }
            finally {
                JProjectView.BLOCK_UPDATE = false;
                DependencyDropDownButton.this.view.updateToolbar();
            }
        }
    }
}

